/***************************************************************************
 *                                                                         *
 * Project:  norGIS ALKIS Import                                           *
 * Purpose:  Aus dem ALKIS-Signaturkatalog geparste Darstellungs-          *
 *           informationen                                                 *
 * Author:   Jürgen E. Fischer <jef@norbit.de>                             *
 *                                                                         *
 ***************************************************************************
 * Copyright (c) 2012-2023, Jürgen E. Fischer <jef@norbit.de>              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

-- Automatisch erzeugt mit alkis-parse-sigs.pl
-- Änderungen werden überschrieben
--
SET search_path = :"alkis_schema", :"postgis_schema", public;

SELECT 'Lade Signaturen...';

DELETE FROM alkis_flaechen;
DELETE FROM alkis_linie;
DELETE FROM alkis_linien;
DELETE FROM alkis_schriften;
DELETE FROM alkis_randlinie;
DELETE FROM alkis_stricharten_i;
DELETE FROM alkis_stricharten;
DELETE FROM alkis_strichart;
DELETE FROM alkis_farben;
DELETE FROM alkis_punkte;
DELETE FROM alkis_signaturkataloge;

INSERT INTO alkis_signaturkataloge(id,name) VALUES (1, 'Farbe');
INSERT INTO alkis_signaturkataloge(id,name) VALUES (2, 'S/W');

INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (1, 'Weiß', '0', '0', '0', '0', '255', '255', '255', '255 255 255');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1003', '110', '{"Flurstück, abweichender Rechtszustand"}', '3', '1', NULL);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (2, 'Grau', '0', '0', '0', '40', '153', '153', '153', '153 153 153');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1301', '290', '{"Wohngebäude","Wohngebäude, aufgeständert","Wohngebäude, Hochhaus","Wohngebäude, Hochhaus, aufgeständert"}', '3', '2', NULL);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (3, 'Grau', '0', '0', '0', '20', '204', '204', '204', '204 204 204');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1304', '290', '{"Carport","Gebäude, nach Quellenlage nicht zu spezifizieren","Gebäude, nach Quellenlage nicht zu spezifizieren, aufgeständert","Gebäude, nach Quellenlage nicht zu spezifizieren, Hochhaus","Gebäude, nach Quellenlage nicht zu spezifizieren, Hochhaus, aufgeständert","Gebäude für Wirtschaft oder Gewerbe","Gebäude für Wirtschaft oder Gewerbe, aufgeständert","Gebäude für Wirtschaft oder Gewerbe, Hochhaus","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, aufgeständert","Gebäude für Wirtschaft oder Gewerbe, offene Halle","Überdachung","Vorratsbehälter, Speicherbauwerk, aufgeständert"}', '4', '3', NULL);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (4, 'Schwarz', '0', '0', '0', '100', '0', '0', '0', '0 0 0');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (1,4, NULL, 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1305', '300', '{"Antenne","Brückenlaufkran","Drehkran","Einsteigeschacht","Freitreppe","Funkmast","Historische Mauer","Hochofen","Kran","Laufkran","Mauer","Portalkran","Radioteleskop","Rampe","Rolltreppe","Schachtöffnung","Schöpfwerk","Solarzellen","Sonstige historische Mauer","Sonstiges Bauwerk oder sonstige Anlage für Industrie und Gewerbe","Stadtmauer","Staumauer","Staumauer, außer Betrieb","Stützmauer","Terrasse","Treppe","Trockendock","Vorratsbehälter, Speicherbauwerk","Wasserrad","Windrad"}', '4', '3', '1');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1306', '365', '{"Mast"}', '5', '3', '1');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1308', '120', '{"Hafendamm, Mole","Wellenbrecher, Buhne"}', '5', '3', '1');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (5, 'Rot', '0', '50', '50', '0', '255', '127', '127', '255 127 127');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1309', '290', '{"Gebäude für öffentliche Zwecke","Gebäude für öffentliche Zwecke, aufgeständert","Gebäude für öffentliche Zwecke, Hochhaus","Gebäude für öffentliche Zwecke, Hochhaus, aufgeständert","Gebäude für öffentliche Zwecke, offene Halle"}', '6', '5', NULL);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (1, '200', '50', '{"100"}');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (2,2, '1', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1317', '300', '{"Befestigung (Burgruine)","Burg (Fliehburg, Ringwall)","Lager","Schanze"}', '6', NULL, '2');
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (2, '35', '0', '{"35"}');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (3,2, '2', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1320', '340', '{"Furt"}', '7', NULL, '3');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (4,4, '2', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1321', '280', '{"Vorratsbehälter, Speicherbauwerk, unter der Erdoberfläche"}', '7', NULL, '4');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (5,2, NULL, 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1330', '250', '{"Aquädukt","Befestigung (Wall, Graben)","Denkmal, Denkstein, Standbild","Fernsprechhäuschen","Grab","Grabhügel (Hügelgrab)","Großsteingrab (Dolmen), Hünenbett","Müllbox","Sonstige Einrichtung in öffentlichen Bereichen","Sonstiges Bauwerk oder sonstige Einrichtung, Sonstiges","Sonstiges historisches Bauwerk oder sonstige historische Einrichtung","Wachturm (römisch), Warte","Wasserleitung"}', '7', NULL, '5');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (6, 'Rot', '0', '8', '4', '0', '255', '234', '244', '255 234 244');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1401', '100', '{"Fläche besonderer funktionaler Prägung","Fläche gemischter Nutzung","Wohnbaufläche"}', '8', '6', NULL);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (7, 'Grau', '0', '0', '0', '7', '237', '237', '237', '237 237 237');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1403', '100', '{"Abfallbehandlungsanlage","Betriebsfläche Versorgungsanlage, Abfallbeseitigung","Bergbaubetrieb","Bergbaubetrieb, außer Betrieb, stillgelegt, verlassen","Deponie (oberirdisch)","Deponie (untertägig)","Förderanlage","Funk- und Fernmeldeanlage","Betriebsfläche Versorgungsanlage, Funk- und Fernmeldewesen","Gaswerk","Betriebsfläche Versorgungsanlage, Gas","Halde","Heizwerk","Betriebsfläche Versorgungsanlage, Wärme","Industrie- und Gewerbefläche","Kläranlage, Klärwerk","Betriebsfläche Versorgungsanlage, Abwasserbeseitigung","Kraftwerk","Betriebsfläche Versorgungsanlage, Elektrizität","Lagerplatz","Raffinerie","Betriebsfläche Versorgungsanlage, Öl","Tagebau, Grube, Steinbruch","Tankstelle","Umspannstation","Wasserwerk","Betriebsfläche Versorgungsanlage, Wasser"}', '9', '7', NULL);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (8, 'Braun', '5', '8', '9', '0', '242', '234', '232', '242 234 232');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1404', '100', '{"Brachland","Heide","Moor","Sumpf","Torf"}', '9', '8', NULL);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (9, 'Grün', '12', '0', '15', '0', '224', '255', '216', '224 255 216');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1405', '100', '{"Autokino, Freilichtkino","Botanischer Garten","Campingplatz","Erholungsfläche","Freilichtmuseum","Freilichttheater","Freizeitanlage","Freizeitpark","Friedhof","Garten","Grünanlage","Grünfläche","Hundeübungsplatz","Kleingarten","Modellflugplatz","Park","Safaripark, Wildpark","Schwimmbad, Freibad","Spielplatz, Bolzplatz","Sport-, Freizeit- und Erholungsfläche","Sportanlage","Sportanlage: Ballsport","Sportanlage: Fußball","Sportanlage: Leichtathletik","Sportanlage: Eislaufen, Rollschuhlaufen","Sportanlage: Golf","Sportanlage: Hunderennsport","Sportanlage: Motorrennsport","Sportanlage: Pferderennsport","Sportanlage: Radsport","Sportanlage: Reiten","Sportanlage: Schießen","Sportanlage: Skating","Sportanlage: Skisport","Sportanlage: Tennis","Verkehrsübungsplatz","Wochenend und Ferienhausfläche","Wochenendplatz","Zoo"}', '10', '9', NULL);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (10, 'Grün', '8', '0', '17', '0', '234', '255', '211', '234 255 211');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1406', '100', '{"Baumschule","Bebaute Gewässerbegleitfläche","Flughafen","Flugverkehr","Gartenland","Gewässerbegleitfläche","Grünland","Hubschrauberflugplatz","Internationaler Flughafen","Landeplatz, Sonderlandeplatz","Obstbaumplantage","Obstplantage","Obststrauchplantage","Regionalflughafen","Segelfluggelände","Straßenentwässerungsanlage","Streuobstwiese","Sukzessionsfläche","Unbebaute Gewässerbegleitfläche","Verkehrsbegleitfläche Bahnverkehr","Verkehrsbegleitfläche Straße","Verkehrslandeplatz","Weingarten"}', '10', '10', NULL);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (11, 'Ocker', '0', '3', '25', '0', '255', '247', '191', '255 247 191');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1409', '100', '{"Ackerland","Hopfen","Landwirtschaft","Spargel","Streuobstacker"}', '11', '11', NULL);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (12, 'Blau', '11', '0', '0', '0', '226', '255', '255', '226 255 255');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1410', '100', '{"Fließgewässer","Hafenbecken","Meer","Stehendes Gewässer","Stehendes Gewässer, nicht ständig Wasser führend"}', '11', '12', NULL);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (13, 'Grün', '15', '0', '15', '0', '216', '255', '216', '216 255 216');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1414', '100', '{"Fußgängerzone (Platz)","Fußgängerzone (Straßenverkehr)","Gehölz","Latschenkiefer","Laubwald mit Nadelholz","Nadelwald mit Laubholz","Wald","Wald, Laub- und Nadelholz","Wald, Laubholz","Wald, Nadelholz"}', '12', '13', NULL);
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (6,4, NULL, 35, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1501', '300', '{"Aussichtsturm","Aussichtsturm, außer Betrieb, stillgelegt, verlassen","Bohrturm","Bohrturm, außer Betrieb, stillgelegt, verlassen","Feuerwachturm","Feuerwachturm, außer Betrieb, stillgelegt, verlassen","Förderturm","Förderturm, außer Betrieb, stillgelegt, verlassen","Kirchturm, Glockenturm","Kirchturm, Glockenturm, außer Betrieb, stillgelegt, verlassen","Kontrollturm","Kontrollturm, außer Betrieb, stillgelegt, verlassen","Kühlturm","Kühlturm, außer Betrieb, stillgelegt, verlassen","Leuchtturm","Leuchtturm, außer Betrieb, stillgelegt, verlassen","Schloß-, Burgturm","Schloß-, Burgturm, außer Betrieb, stillgelegt, verlassen","Schornstein, Schlot, Esse","Sende-, Funkturm, Fernmeldeturm","Sende-, Funkturm, Fernmeldeturm, außer Betrieb, stillgelegt, verlassen","Sonstiger Turm","Sonstiger Turm, außer Betrieb, stillgelegt, verlassen","Stadt-, Torturm","Stadt-, Torturm, außer Betrieb, stillgelegt, verlassen","Turm, nach Quellenlage nicht zu spezifizieren","Turm, nach Quellenlage nicht zu spezifizieren, außer Betrieb, stillgelegt, verlassen","Wasserturm","Wasserturm, außer Betrieb, stillgelegt, verlassen"}', '12', '3', '6');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (7,4, '1', 35, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1502', '310', '{"Aussichtsturm, verfallen, zerstört","Bohrturm, verfallen, zerstört","Feuerwachturm, verfallen, zerstört","Förderturm, verfallen, zerstört","Kirchturm, Glockenturm, verfallen, zestört","Kontrollturm, verfallen, zerstört","Kühlturm, verfallen, zerstört","Leuchtturm, verfallen, zerstört","Schloß-, Burgturm, verfallen, zerstört","Sende-, Funkturm, Fernmeldeturm, verfallen, zerstört","Sonstiger Turm, verfallen, zerstört","Stadt-, Torturm, verfallen, zerstört","Turm, nach Quellenlage nicht zu spezifizieren, verfallen, zerstört","Wasserturm, verfallen, zerstört"}', '13', NULL, '7');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (14, 'Blau', '100', '0', '0', '20', '0', '204', '204', '0 204 204');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (8,14, NULL, 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1510', '130', '{"Klärbecken"}', '14', '8', '8');
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (3, '200', '100', '{"100"}');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (15, 'Braun', '60', '100', '100', '20', '81', '0', '0', '81 0 0');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (9,15, '3', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1519', '130', '{"Zuschauertribüne überdacht"}', '14', '5', '9');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (10,15, NULL, 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1520', '130', '{"Hartplatz","Rasenplatz","Spielfeld"}', '15', '13', '10');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1521', '200', '{"Rennbahn, Laufbahn, Geläuf"}', '15', '6', '10');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (11,15, NULL, 50, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1522', '120', '{"Stadion"}', '15', '1', '11');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1523', '130', '{"Bach","Fleet","Graben","Priel","Teich","Untergeordnetes Gewässer"}', '16', '12', '8');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1524', '130', '{"Gradierwerk","Liegewiese","Schießanlage","Sonstiges Bauwerk oder sonstige Anlage für Sport, Freizeit und Erholung","Sprungschanze (Anlauf)","Wildgehege","Zuschauertribüne","Zuschauertribüne nicht überdacht"}', '16', NULL, '10');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1525', '350', '{"Brunnen","Springbrunnen, Zierbrunnen"}', '17', '12', '8');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1526', '130', '{"Schwimmbecken"}', '17', '12', '8');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (16, 'Grau', '0', '0', '0', '50', '127', '127', '127', '127 127 127');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (12,16, '1', 50, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1530', '400', '{"Brücke","Landebrücke","Hochbahn, Hochstraße"}', '17', '1', '12');
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (4, '100', '50', '{"50"}');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (13,16, '4', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1531', '410', '{"Brückenpfeiler"}', '18', NULL, '13');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (14,16, NULL, 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1532', '300', '{"Brückenjoch"}', '18', '3', '14');
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (5, '50', '0', '{"150"}');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (15,16, '5', 50, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1533', '500', '{"Tunnel, Unterführung"}', '19', NULL, '15');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (16,4, '1', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1534', '350', '{"Schutzgalerie"}', '19', '3', '16');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (17,16, NULL, 50, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1535', '250', '{"Schleusenkammer"}', '20', NULL, '17');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1536', '250', '{"Sonstiges Bauwerk im Verkehrsbereich"}', '20', NULL, '14');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (17, 'Grau', '0', '0', '3', '3', '247', '247', '239', '247 247 239');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1540', '200', '{"Fahrbahn"}', '20', '17', '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1541', '130', '{"Bahnhof, Bahn im Freizeitpark","Bahnhof, Bergbahn, Seilbahn","Bahnhof, Eisenbahn","Bahnhof, Güterverkehr","Bahnhof, Magnetschwebebahn","Bahnhof, Museumsbahn","Bahnhof, S-Bahn","Bahnhof, sonstige Bahnkategorie","Bahnhof, Stadtbahn","Bahnhof, Standseilbahn","Bahnhof, Straßenbahn","Bahnhof, U-Bahn","Bahnhof, Zahnradbahn","Drehscheibe","Haltestelle, Haltepunkt, Bahn im Freizeitpark","Haltestelle, Haltepunkt, Bergbahn, Seilbahn","Haltestelle, Haltepunkt, Eisenbahn","Haltestelle, Haltepunkt, Güterverkehr","Haltestelle, Haltepunkt, Magnetschwebebahn","Haltestelle, Haltepunkt, Museumsbahn","Haltestelle, Haltepunkt, S-Bahn","Haltestelle, Haltepunkt, sonstige Bahnkategorie","Haltestelle, Haltepunkt, Stadtbahn","Haltestelle, Haltepunkt, Standseilbahn","Haltestelle, Haltepunkt, Straßenbahn","Haltestelle, Haltepunkt, U-Bahn","Haltestelle, Haltepunkt, Zahnradbahn"}', '21', NULL, '1');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1542', '130', '{"Fußweg","Karren- und Ziehweg","Rad- und Fußweg (Weg, Pfad, Steig)","Radweg (Weg, Pfad, Steig)","Reitweg (Weg, Pfad, Steig)","Skaterstrecke","Weg, Pfad, Steig"}', '21', '17', '10');
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (6, '300', '50', '{"100"}');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (18,15, '6', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1543', '130', '{"Wattenweg"}', '22', '17', '18');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1544', '130', '{"Anleger","Sonstige Einrichtung für den Schiffsverkehr"}', '22', '1', '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1548', '130', '{"Fischtreppe","Sicherheitstor","Sperrwerk","Sonstiges Bauwerk im Gewässerbereich","Sonstige Straßenverkehrsanlage","Wehr"}', '23', NULL, '5');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (19,14, '2', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1550', '340', '{"Bach, verdolt","Bach, verrohrt, unterirdisch, bedeckt","Durchlass","Fleet, verdolt","Fleet, verrohrt, unterirdisch, bedeckt","Graben, verdolt","Graben, verrohrt, unterirdisch, bedeckt","Rohrdurchlass","Siel","Untergeordnetes Gewässer, verdolt","Untergeordnetes Gewässer, verrohrt, unterirdisch, bedeckt"}', '23', NULL, '19');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1551', '103', '{"Damm, Wall, Deich","Felsen, Felsblock, Felsnadel","Rückhaltebecken","Sonstiges Gewässermerkmal","Staudamm","Staudamm, außer Betrieb"}', '24', NULL, '10');
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (7, '700', '50', '{"100"}');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (18, 'Grau', '0', '0', '0', '30', '178', '178', '178', '178 178 178');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (20,18, '7', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1552', '140', '{"Staudamm, im Bau","Staumauer, im Bau"}', '24', NULL, '20');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (19, 'Grün', '100', '0', '100', '0', '0', '255', '0', '0 255 0');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (21,19, NULL, 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1560', '104', '{"Baumbestand, Laub- und Nadelholz","Baumbestand, Laubholz","Baumbestand, Nadelholz","Gebüsch","Gehölz (Vegetationsmerkmal)","Gras","Korbweide","Reet","Röhricht, Schilf","Zierfläche"}', '25', NULL, '21');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1561', '104', '{"Rain","Schneise"}', '25', '10', '21');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1562', '130', '{"Quelle","Stromschnelle","Wasserfall"}', '26', NULL, '8');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1563', '105', '{"Vegetationsmerkmal, Zustand nass"}', '26', NULL, '8');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1570', '103', '{"Düne","Sandbank"}', '27', '11', '10');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (20, 'Braun', '8', '6', '6', '0', '234', '239', '239', '234 239 239');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1571', '120', '{"Watt"}', '27', '20', NULL);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (8, '400', '50', '{"200"}');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (22,14, '8', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1572', '130', '{"Bach, nicht ständig Wasser führend","Fleet, nicht ständig Wasser führend","Graben, nicht ständig Wasser führend","Teich, nicht ständig Wasser führend","Untergeordnetes Gewässer, nicht ständig Wasser führend"}', '27', '12', '22');
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (9, '100', '50', '{"200"}');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (23,14, '9', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1573', '130', '{"Bach, trocken, versiegt","Fleet, trocken, versiegt","Graben, trocken, versiegt","Teich, trocken, versiegt","Untergeordnetes Gewässer, trocken, versiegt"}', '28', NULL, '23');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (21, 'Orange', '0', '10', '50', '0', '255', '229', '127', '255 229 127');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1701', '210', '{"Bundesautobahn,","Bundesstraße"}', '28', '21', '5');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (22, 'Gelb', '0', '0', '30', '0', '255', '255', '178', '255 255 178');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1702', '210', '{"Landes- oder Staatsstraße"}', '29', '22', '5');
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (10, '400', '50', '{"100"}');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (23, 'Grün', '50', '0', '50', '0', '127', '255', '127', '127 255 127');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (24,23, '10', 100, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1703', '340', '{"Nationalpark","Naturschutzgebiet","Natur-, Umwelt- oder Bodenschutzrecht","Schutzgebiet nach Natur-, Umwelt- oder Bodenschutzrecht"}', '29', NULL, '24');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (25,5, '10', 100, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1704', '430', '{"Bau-, Raum- oder Bodenordnungsrecht","Flurbereinigung","Sanierung","Truppenübungsplatz, Standortübungsplatz","Umlegung"}', '30', NULL, '25');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (24, 'Blau', '30', '0', '0', '0', '178', '255', '255', '178 255 255');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (26,24, '10', 100, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1705', '340', '{"Andere Festlegung nach Wasserrecht","Schutzgebiet nach Wasserrecht"}', '30', NULL, '26');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (27,5, NULL, 100, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1740', '600', '{"Musterstück","Landesmusterstück"}', '31', NULL, '27');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '1808', '130', '{"Hubschrauberlandeplatz","Startbahn, Landebahn","Vorfeld","Zurollbahn, Taxiway"}', '31', '17', '10');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2001, '360', '{"Ausgabekopf - Trennlinie","Kabinenbahn, Umlaufseilbahn","Luftseilbahn, Großkabinenbahn","Materialseilbahn","Schwebebahn","Sessellift","Skilift, Schlepplift"}', 32);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (1, 0, 1, 2001, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2002, '270', '{"Bahnübergang, Schranke","Hängende Lampe","Höckerlinie","Rohrleitung, Pipeline","Zaun"}', 32);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (2, 0, 1, 2002, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2003, '130', '{"Lahnung","Schöpfwerk","Sonstiges Bauwerk im Gewässerbereich","Sperrwerk","Wehr"}', 32);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (3, 0, 1, 2003, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2004, '700', '{"Zuordnungspfeil"}', 33);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (4, 0, 1, 2004, NULL, 'Pfeil', NULL, '18', '120', '150', '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2005, '690', '{"Zuordnungspfeil, abweichender Rechtszustand"}', 33);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (5, 0, 1, 2005, NULL, 'Pfeil', NULL, '18', '120', '150', '3', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2006, '705', '{"Strittige Grenze"}', 34);
INSERT INTO alkis_stricharten(id) VALUES (1);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (11, '600', '100', '{"100"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (1, 1, 0, 11);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (6, 0, 1, 2006, '1', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2007, '692', '{"Strittige Grenze, abweichender Rechtszustand"}', 34);
INSERT INTO alkis_stricharten(id) VALUES (2);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (2, 2, 0, 11);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (7, 0, 1, 2007, '2', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '3', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2008, '720', '{"Flurstücksgrenze nicht feststellbar","Mittellinie in Gewässern","Nicht festgestellte Grenze"}', 35);
INSERT INTO alkis_stricharten(id) VALUES (3);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (3, 3, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (8, 0, 1, 2008, '3', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2009, '710', '{"Flurstücksgrenze nicht feststellbar, abweichender Rechtszustand","Mittellinie in Gewässern, abweichender Rechtszustand","Nicht festgestellte Grenze, abweichender Rechtszustand"}', 35);
INSERT INTO alkis_stricharten(id) VALUES (4);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (4, 4, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (9, 0, 1, 2009, '4', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '3', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2010, '455', '{"Grenze des Landkreises","Grenze der Region"}', 36);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (25, 'Violett', '5', '50', '0', '0', '242', '127', '255', '242 127 255');
INSERT INTO alkis_stricharten(id) VALUES (5);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (12, '700', '1200', '{"1200"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (5, 5, 0, 12);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (10, 0, 1, 2010, '5', 'Abgeschnitten', 'Spitz', '150', NULL, NULL, '25', NULL);
INSERT INTO alkis_stricharten(id) VALUES (6);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (13, '0', '375', '{"450","1450"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (6, 6, 0, 13);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (11, 1, 1, 2010, '6', 'Rund', 'Rund', '150', NULL, NULL, '25', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2012, '450', '{"Grenze der Flur"}', 36);
INSERT INTO alkis_stricharten(id) VALUES (7);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (14, '500', '250', '{"1100"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (7, 7, 0, 14);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (12, 0, 1, 2012, '7', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '25', NULL);
INSERT INTO alkis_stricharten(id) VALUES (8);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (15, '0', '1000', '{"300","300","1000"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (8, 8, 0, 15);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (13, 1, 1, 2012, '8', 'Rund', 'Rund', '100', NULL, NULL, '25', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2014, '451', '{"Grenze der Gemarkung"}', 37);
INSERT INTO alkis_stricharten(id) VALUES (9);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (16, '500', '250', '{"800"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (9, 9, 0, 16);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (14, 0, 1, 2014, '9', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '25', NULL);
INSERT INTO alkis_stricharten(id) VALUES (10);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (17, '0', '1000', '{"300","1000"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (10, 10, 0, 17);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (15, 1, 1, 2014, '10', 'Rund', 'Rund', '100', NULL, NULL, '25', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2016, '458', '{"Grenze der Bundesrepublik Deutschland"}', 38);
INSERT INTO alkis_stricharten(id) VALUES (11);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (18, '900', '1050', '{"1050"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (11, 11, 0, 18);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (16, 0, 1, 2016, '11', 'Abgeschnitten', 'Spitz', '250', NULL, NULL, '25', NULL);
INSERT INTO alkis_stricharten(id) VALUES (12);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (19, '0', '525', '{"1950"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (12, 12, 0, 19);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (17, 1, 1, 2016, '12', 'Rund', 'Rund', '250', NULL, NULL, '25', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2018, '457', '{"Grenze des Bundeslandes"}', 38);
INSERT INTO alkis_stricharten(id) VALUES (13);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (20, '800', '900', '{"350","900"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (13, 13, 0, 20);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (18, 0, 1, 2018, '13', 'Abgeschnitten', 'Spitz', '200', NULL, NULL, '25', NULL);
INSERT INTO alkis_stricharten(id) VALUES (14);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (21, '0', '450', '{"2850"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (14, 14, 0, 21);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (19, 1, 1, 2018, '14', 'Rund', 'Rund', '200', NULL, NULL, '25', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2020, '456', '{"Grenze des Regierungsbezirkes"}', 39);
INSERT INTO alkis_stricharten(id) VALUES (15);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (22, '700', '1200', '{"300","1200"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (15, 15, 0, 22);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (20, 0, 1, 2020, '15', 'Abgeschnitten', 'Spitz', '150', NULL, NULL, '25', NULL);
INSERT INTO alkis_stricharten(id) VALUES (16);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (23, '0', '375', '{"450","2450"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (16, 16, 0, 23);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (21, 1, 1, 2020, '16', 'Rund', 'Rund', '150', NULL, NULL, '25', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2022, '453', '{"Grenze der Gemeinde"}', 40);
INSERT INTO alkis_stricharten(id) VALUES (17);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (24, '500', '500', '{"500"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (17, 17, 0, 24);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (22, 0, 1, 2022, '17', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '25', NULL);
INSERT INTO alkis_stricharten(id) VALUES (18);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (25, '0', '250', '{"1000"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (18, 18, 0, 25);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (23, 1, 1, 2022, '18', 'Rund', 'Rund', '100', NULL, NULL, '25', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2024, '452', '{"Grenze des Gemeindeteils"}', 40);
INSERT INTO alkis_stricharten(id) VALUES (19);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (26, '500', '800', '{"800"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (19, 19, 0, 26);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (24, 0, 1, 2024, '19', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '25', NULL);
INSERT INTO alkis_stricharten(id) VALUES (20);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (27, '100', '200', '{"200","900"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (20, 20, 0, 27);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (25, 1, 1, 2024, '20', 'Abgeschnitten', 'Spitz', '160', NULL, NULL, '25', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2026, '454', '{"Grenze der Verwaltungsgemeinschaft"}', 41);
INSERT INTO alkis_stricharten(id) VALUES (21);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (28, '700', '1650', '{"300","1650"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (21, 21, 0, 28);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (26, 0, 1, 2026, '21', 'Abgeschnitten', 'Spitz', '150', NULL, NULL, '25', NULL);
INSERT INTO alkis_stricharten(id) VALUES (22);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (29, '0', '375', '{"450","450","2450"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (22, 22, 0, 29);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (27, 1, 1, 2026, '22', 'Rund', 'Rund', '150', NULL, NULL, '25', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2028, '700', '{"Flurstück"}', 42);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (28, 0, 1, 2028, NULL, 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2029, '690', '{"Flurstück, abweichender Rechtszustand"}', 42);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (29, 0, 1, 2029, NULL, 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '3', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2030, '300', '{"Gebäude, nach Quellenlage nicht zu spezifizieren,","Hochhaus, aufgeständert","Gebäude, nach Quellenlage nicht zu spezifizieren, Hochhaus, verfallen, zerstört oder teilweise","zerstört oder geplant oder im Bau","Gebäude, nach Quellenlage nicht zu spezifizieren, Hochhaus, verfallen, zerstört oder teilweise","zerstört oder geplant oder im Bau und aufgeständert","Gebäude für öffentliche Zwecke, Hochhaus, aufgeständert","Gebäude für öffentliche Zwecke, Hochhaus, verfallen, zerstört oder teilweise zerstört oder geplant","oder im Bau","Gebäude für öffentliche Zwecke, Hochhaus, verfallen, zerstört oder teilweise zerstört oder geplant","oder im Bau und aufgeständert","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, aufgeständert","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, verfallen, zerstört oder teilweise zerstört oder","geplant oder im Bau","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, verfallen, zerstört oder teilweise zerstört oder","geplant oder im Bau und aufgeständert","Wohngebäude, Hochhaus, aufgeständert","Wohngebäude, Hochhaus, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau","Wohngebäude, Hochhaus, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau und","aufgeständert"}', 42);
INSERT INTO alkis_stricharten(id) VALUES (23);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (23, 23, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (30, 0, 1, 2030, '23', 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2031, '300', '{"Carport","Gebäude, nach Quellenlage nicht zu spezifizieren, aufgeständert","Gebäude, nach Quellenlage nicht zu spezifizieren, verfallen, zerstört oder teilweise zerstört oder","geplant oder im Bau","Gebäude, nach Quellenlage nicht zu spezifizieren, verfallen, zerstört oder teilweise zerstört oder","geplant oder im Bau und aufgeständert","Gebäude für öffentliche Zwecke, aufgeständert","Gebäude für öffentliche Zwecke, offene Halle","Gebäude für öffentliche Zwecke, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau","Gebäude für öffentliche Zwecke, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau","und aufgeständert","Gebäude für Wirtschaft oder Gewerbe, aufgeständert","Gebäude für Wirtschaft oder Gewerbe, offene Halle","Gebäude für Wirtschaft oder Gewerbe, verfallen, zerstört oder teilweise zerstört oder geplant oder im","Bau","Gebäude für Wirtschaft oder Gewerbe, verfallen, zerstört oder teilweise zerstört oder geplant oder im","Bau und aufgeständert","Überdachung","Vorratsbehälter, Speicherbauwerk, aufgeständert","Wohngebäude, aufgeständert","Wohngebäude, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau","Wohngebäude, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau und aufgeständert"}', 43);
INSERT INTO alkis_stricharten(id) VALUES (24);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (24, 24, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (31, 0, 1, 2031, '24', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2032, '280', '{"Gebäude, nach Quellenlage nicht zu spezifizieren,","unter der Erdoberfläche","Gebäude für öffentliche Zwecke, unter der Erdoberfläche","Wohngebäude, unter der Erdoberfläche","Gebäude für Wirtschaft oder Gewerbe, unter der Erdoberfläche"}', 44);
INSERT INTO alkis_stricharten(id) VALUES (25);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (30, '35', '35', '{"35"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (25, 25, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (32, 0, 1, 2032, '25', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2300, '310', '{"Bahn im Freizeitpark, Gleis, unter der Erdoberfläche","Bergbahn, Seilbahn, Gleis,unter der Erdoberfläche","Eisenbahn, Gleis, unter der Erdoberfläche","Güterverkehr, Gleis, unter der Erdoberfläche","Magnetschwebebahn, Gleis, unter der Erdoberfläche","Museumsbahn, Gleis, unter der Erdoberfläche","S-Bahn, Gleis, unter der Erdoberfläche","Sonstige Bahnkategorie, Gleis, unter der Erdoberfläche","Stadtbahn, Gleis, unter der Erdoberfläche","Standseilbahn, Gleis, unter der Erdoberfläche","Straßenbahn, Gleis, unter der Erdoberfläche","U-Bahn, Gleis, unter der Erdoberfläche","Zahnradbahn, Gleis, unter der Erdoberfläche"}', 44);
INSERT INTO alkis_stricharten(id) VALUES (26);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (26, 26, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (33, 0, 1, 2300, '26', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2301, '310', '{"Bahn im Freizeitpark, Gleis, aufgeständert","Bergbahn, Seilbahn, Gleis, aufgeständert","Eisenbahn, Gleis, aufgeständert","Güterverkehr, Gleis, aufgeständert","Magnetschwebebahn, Gleis, aufgeständert","Museumsbahn, Gleis, aufgeständert","S-Bahn, Gleis, aufgeständert","Sonstige Bahnkategorie, Gleis, aufgeständert","Stadtbahn, Gleis, aufgeständert","Standseilbahn, Gleis, aufgeständert","Straßenbahn, Gleis, aufgeständert","U-Bahn, Gleis, aufgeständert","Zahnradbahn, Gleis, aufgeständert"}', 45);
INSERT INTO alkis_stricharten(id) VALUES (27);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (27, 27, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (34, 0, 1, 2301, '27', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2302, '330', '{"Besondere Gebäudelinie, Trennlinie nicht eindeutig festgelegt"}', 46);
INSERT INTO alkis_stricharten(id) VALUES (28);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (31, '200', '100', '{"300"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (28, 28, 0, 31);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (35, 0, 1, 2302, '28', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_stricharten(id) VALUES (29);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (32, '100', '400', '{"400"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (29, 29, 0, 32);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (36, 1, 1, 2302, '29', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2303, '340', '{"Firstlinie"}', 46);
INSERT INTO alkis_stricharten(id) VALUES (30);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (33, '100', '100', '{"100"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (30, 30, 0, 33);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (37, 0, 1, 2303, '30', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2305, '330', '{"Besondere Gebäudelinie, offene Gebäudelinie","Durchfahrt, Bauwerk"}', 47);
INSERT INTO alkis_stricharten(id) VALUES (31);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (31, 31, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (38, 0, 1, 2305, '31', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (28,4, '30', 18, NULL, NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '2504', '270', '{"Bandstraße, unter der Erdoberfläche","Bandstraße, unter der Wasseroberfläche","Förderband, unter der Erdoberfläche","Förderband, unter der Wasseroberfläche"}', '47', NULL, '28');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2505, '300', '{"Gebäude, nach Quellenlage nicht zu spezifizieren","Gebäude für öffentliche Zwecke","Gebäude für Wirtschaft oder Gewerbe","Wohngebäude"}', 48);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (39, 0, 1, 2505, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2506, '340', '{"Fahrbahnbegrenzungslinie, überdeckt"}', 48);
INSERT INTO alkis_stricharten(id) VALUES (32);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (32, 32, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (40, 0, 1, 2506, '32', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2507, '310', '{"Arkade","Auskragende Geschosse","Auskragende/zurückspringende Geschosse","Durchfahrt an überbauter Verkehrsstraße","Durchfahrt im Gebäude","Gebäudeteil - abweichende Geschosshöhe","Geringergeschossiger Gebäudeteil","Höhergeschossiger Gebäudeteil (nicht Hochhaus)","Keller","Loggia","Sonstiger Gebäudeteil","Tiefgarage (Bauteil)","Treppenunterkante","Zurückspringende Geschosse"}', 48);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (41, 0, 1, 2507, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2508, '310', '{"Gebäudeteil - abweichende Geschosshöhe, aufgeständert","Geringergeschossiger Gebäudeteil, aufgeständert","Höhergeschossiger Gebäudeteil (nicht Hochhaus) aufgeständert","Sonstiger Gebäudeteil, aufgeständert"}', 49);
INSERT INTO alkis_stricharten(id) VALUES (33);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (33, 33, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (42, 0, 1, 2508, '33', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2509, '310', '{"Hochhausgebäudeteil"}', 49);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (43, 0, 1, 2509, NULL, 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (29,4, NULL, 18, NULL, NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '2510', '300', '{"Historische Mauer","Mauerkante links,","Mauerkante rechts,","Mauermitte,","Sonstige historische Mauer","Stadtmauer","Stützmauer links","Stützmauermitte","Stützmauer rechts","Ufermauer, Kaimauer"}', '50', '3', '29');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2511, '310', '{"Hochhausgebäudeteil, aufgeständert"}', 50);
INSERT INTO alkis_stricharten(id) VALUES (34);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (34, 34, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (44, 0, 1, 2511, '34', 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2512, '280', '{"Keller, unter der Erdoberfläche","Tiefgarage, unter der Erdoberfläche (Bauteil)"}', 51);
INSERT INTO alkis_stricharten(id) VALUES (35);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (35, 35, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (45, 0, 1, 2512, '35', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2513, '310', '{"Schornstein im Gebäude"}', 51);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (46, 0, 1, 2513, NULL, 'Abgeschnitten', 'Rund', '25', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2514, '310', '{"Turm im Gebäude"}', 52);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (47, 0, 1, 2514, NULL, 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2515, '106', '{"Abfallbehandlungsanlage","Ackerland","Autokino, Freilichtkino","Bahnverkehr","Baumschule","Bebaute Gewässerbegleitfläche","Bergbaubetrieb","Bergbaubetrieb, außer Betrieb, stillgelegt, verlassen","Botanischer Garten","Brachland","Campingplatz","Deponie (oberirdisch)","Deponie (untertägig)","Erholungsfläche","Fahrweg","Fels","Festplatz","Fläche besonderer funktionaler Prägung","Fläche gemischter Nutzung","Flughafen","Flugverkehr","Förderanlage","Freilichtmuseum","Freilichttheater","Freizeitanlage","Freizeitpark","Friedhof","Funk- und Fernmeldeanlage","Fußgängerzone (Platz)","Fußgängerzone (Straßenverkehr)","Fußweg","Gang","Garten","Gartenland","Gaswerk","Geröll","Gewässerbegleitfläche","Golfplatz","Grünanlage","Grünfläche","Grünland","Halde","Hauptwirtschaftsweg","Heide","Heizwerk","Hopfen","Hubschrauberflugplatz","Hundeübungsplatz","Industrie- und Gewerbefläche","Internationaler Flughafen","Kläranlage, Klärwerk","Kleingarten","Kraftwerk","Lagerplatz","Landeplatz, Sonderlandeplatz","Landwirtschaft","Marktplatz","Modellflugplatz","Moor","Obstbaumplantage","Obstplantage","Obststrauchplantage","Park","Parkplatz","Platz","Rad- und Fußweg","Radweg","Raffinerie","Rastplatz","Raststätte","Regionalflughafen","Reitweg","Safaripark, Wildpark","Sand","Schiffsverkehr","Schwimmbad, Freibad","Segelfluggelände","Sonstiger Weg","Spargel","Spielplatz, Bolzplatz","Sport-, Freizeit- und Erholungsfläche","Sportanlage","Sportanlage: Ballsport","Sportanlage: Eislaufen, Rollschuhlaufen","Sportanlage: Fußball","Sportanlage: Golf","Sportanlage: Hunderennsport","Sportanlage: Leichtathletik","Sportanlage: Motorrennsport","Sportanlage: Pferderennsport","Sportanlage: Radsport","Sportanlage: Reiten","Sportanlage: Schießen","Sportanlage: Skating","Sportanlage: Skisport","Sportanlage: Tennis","Steine, Schotter","Straßenentwässerungsanlage","Straßenverkehr","Streuobstacker","Streuobstwiese","Sukzessionsfläche","Sumpf","Tagebau, Grube, Steinbruch","Tankstelle","Umspannstation","Unbebaute Gewässerbegleitfläche","Unland/Vegetationslose Fläche","Vegetationslose Fläche","Vegetationslose Fläche, sonstiges Oberflächenmaterial","Verkehrsbegleitfläche Bahnverkehr","Verkehrsbegleitfläche Straße","Verkehrslandeplatz","Verkehrsübungsplatz","Wasserwerk","Weg","Weingarten","Wirtschaftsweg","Wochenend und Ferienhausfläche","Wochenendplatz","Wohnbaufläche","Zoo"}', 52);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (48, 0, 1, 2515, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2516, '101', '{"Bahnverkehr, im Bau","Flughafen, im Bau","Flugverkehr, im Bau","Hubschrauberflugplatz, im Bau","Internationaler Flughafen, im Bau","Landeplatz, Sonderlandeplatz im Bau","Regionalflughafen, im Bau","Schiffsverkehr, im Bau","Segelfluggelände, im Bau","Straßenverkehr, im Bau","Verkehrslandeplatz, im Bau"}', 54);
INSERT INTO alkis_stricharten(id) VALUES (36);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (34, '700', '100', '{"100"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (36, 36, 0, 34);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (49, 0, 1, 2516, '36', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '18', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2517, '107', '{"Gehölz","Latschenkiefer","Laubwald mit Nadelholz","Nadelwald mit Laubholz","Wald","Wald Laub und Nadelholz","Wald, Laubholz","Wald, Nadelholz"}', 55);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (50, 0, 1, 2517, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '19', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2518, '108', '{"Eis, Firn","Fließgewässer","Hafenbecken","Meer","Schnee","Stehendes Gewässer"}', 55);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (51, 0, 1, 2518, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '14', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2519, '101', '{"Kanal, im Bau"}', 56);
INSERT INTO alkis_stricharten(id) VALUES (37);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (37, 37, 0, 34);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (52, 0, 1, 2519, '37', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '14', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2520, '103', '{"Stehendes Gewässer, nicht ständig Wasser führend"}', 56);
INSERT INTO alkis_stricharten(id) VALUES (38);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (35, '400', '200', '{"200"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (38, 38, 0, 35);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (53, 0, 1, 2520, '38', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '14', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '2521', '270', '{"Förderband, Bandstraße","Tor"}', '57', NULL, '29');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2523, '270', '{"Erdkabel","Rohrleitung, Pipeline, unter der Erdoberfläche","Rohrleitung, Pipeline, unter der Wasseroberfläche"}', 57);
INSERT INTO alkis_stricharten(id) VALUES (39);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (39, 39, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (54, 0, 1, 2523, '39', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2524, '360', '{"Freileitung"}', 58);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (55, 0, 1, 2524, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2525, '250', '{"Bahn im Freizeitpark, Gleis","Bergbahn, Seilbahn, Gleis","Eisenbahn, Gleis","Güterverkehr, Gleis","Magnetschwebebahn, Gleis","Museumsbahn, Gleis","S-Bahn, Gleis","Sonstige Bahnkategorie, Gleis","Stadtbahn, Gleis","Standseilbahn, Gleis","Straßenbahn, Gleis","U-Bahn, Gleis","Zahnradbahn, Gleis"}', 58);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (56, 0, 1, 2525, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '2526', '130', '{"Sicherheitstor"}', '59', NULL, '29');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2527, '250', '{"Fahrbahnbegrenzungslinie"}', 59);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (57, 0, 1, 2527, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2530, '300', '{"Steg"}', 59);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (58, 0, 1, 2530, NULL, 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '16', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2531, '211', '{"Böschung, Kliff","Geländekante, Böschungsoberkante","Geländekante, Böschungsunterkante","Geländekante, Allgemeine Geländekante (z.B. Trennschraffe)"}', 60);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (59, 0, 1, 2531, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '15', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2533, '410', '{"Widerlager"}', 60);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (60, 0, 1, 2533, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '16', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2535, '130', '{"Fußweg (Weg, Pfad, Steig)","Karren- und Ziehweg","Rad- und Fußweg (Weg, Pfad, Steig)","Radweg (Weg, Pfad, Steig)","Reitweg (Weg, Pfad, Steig)","Skaterstrecke","Weg, Pfad, Steig"}', 60);
INSERT INTO alkis_stricharten(id) VALUES (40);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (36, '200', '320', '{"320"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (40, 40, 0, 36);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (61, 0, 1, 2535, '40', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '15', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2537, '130', '{"Wattenweg"}', 61);
INSERT INTO alkis_stricharten(id) VALUES (41);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (37, '300', '100', '{"100"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (41, 41, 0, 37);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (62, 0, 1, 2537, '41', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '15', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2539, '130', '{"(Kletter-) Steig im Gebirge"}', 61);
INSERT INTO alkis_stricharten(id) VALUES (42);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (38, '0', '100', '{"100"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (42, 42, 0, 38);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (63, 0, 1, 2539, '42', 'Rund', 'Rund', '70', NULL, NULL, '15', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2560, '340', '{"Bach, verdolt","Bach, verrohrt, unterirdisch, bedeckt","Durchlass","Fleet, verdolt","Fleet, verrohrt, unterirdisch, bedeckt","Graben, verdolt","Graben, verrohrt, unterirdisch, bedeckt","Rohrdurchlass","Siel","Untergeordnetes Gewässer, verdolt","Untergeordnetes Gewässer, verrohrt, unterirdisch, bedeckt"}', 62);
INSERT INTO alkis_stricharten(id) VALUES (43);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (43, 43, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (64, 0, 1, 2560, '43', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '14', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2561, '340', '{"Düker"}', 62);
INSERT INTO alkis_stricharten(id) VALUES (44);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (39, '0', '360', '{"360"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (44, 44, 0, 39);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (65, 0, 1, 2561, '44', 'Rund', 'Rund', '100', NULL, NULL, '14', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2592, '130', '{"Bach","Fleet","Graben","Grabenkante links","Grabenkante rechts","Grabenmitte","Linienverkehr","Untergeordnetes Gewässer"}', 63);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (66, 0, 1, 2592, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '14', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2593, '130', '{"Bach, nicht ständig Wasser führend","Fleet, nicht ständig Wasser führend","Graben, nicht ständig Wasser führend","Grabenkante links, nicht ständig Wasser führend","Grabenkante rechts, nicht ständig Wasser führend","Grabenmitte, nicht ständig Wasser führend","Untergeordnetes Gewässer, nicht ständig Wasser führend"}', 63);
INSERT INTO alkis_stricharten(id) VALUES (45);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (45, 45, 0, 35);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (67, 0, 1, 2593, '45', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '14', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2595, '130', '{"Bach, trocken, versiegt","Fleet, trocken, versiegt","Graben, trocken, versiegt","Grabenkante links, trocken versiegt","Grabenkante rechts, trocken versiegt","Grabenmitte, trocken versiegt","Untergeordnetes Gewässer, trocken, versiegt"}', 64);
INSERT INTO alkis_stricharten(id) VALUES (46);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (40, '100', '200', '{"200"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (46, 46, 0, 40);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (68, 0, 1, 2595, '46', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '14', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2609, '140', '{"Autofährverkehr","Autofährverkehr, Eisenbahnfährverkehr","Eisenbahnfährverkehr","Personenfährverkehr","Schifffahrtslinie, Fährverkehr"}', 64);
INSERT INTO alkis_stricharten(id) VALUES (47);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (47, 47, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (69, 0, 1, 2609, '47', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '14', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2620, '101', '{"Damm, Wall, Deich","Graben mit Knick links","Graben mit Knick rechts","Graben mit Wall links","Graben mit Wall rechts","Knick","Knickkante links","Knickkante rechts","Knickmitte","Wallkante links","Wallkante rechts","Wallmitte"}', 66);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (70, 0, 1, 2620, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '15', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2622, '101', '{"Steilrand, Kliff"}', 66);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (71, 0, 1, 2622, NULL, 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '15', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2623, '300', '{"Gebäude, nach Quellenlage nicht zu spezifizieren, Hochhaus","Gebäude für öffentliche Zwecke, Hochhaus","Gebäude für Wirtschaft oder Gewerbe, Hochhaus","Wohngebäude, Hochhaus"}', 67);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (72, 0, 1, 2623, NULL, 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2670, '120', '{"Höhenlinie 20m"}', 67);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (26, 'Braun', '10', '30', '30', '0', '229', '178', '178', '229 178 178');
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (73, 0, 1, 2670, NULL, 'Abgeschnitten', 'Rund', '25', NULL, NULL, '26', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2672, '120', '{"Höhenlinie 10m"}', 67);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (74, 0, 1, 2672, NULL, 'Abgeschnitten', 'Rund', '18', NULL, NULL, '26', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2674, '120', '{"Höhenlinie 5m"}', 68);
INSERT INTO alkis_stricharten(id) VALUES (48);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (41, '1000', '0', '{"200"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (48, 48, 0, 41);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (75, 0, 1, 2674, '48', 'Abgeschnitten', 'Rund', '18', NULL, NULL, '26', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2676, '120', '{"Höhenlinie 2,5m"}', 68);
INSERT INTO alkis_stricharten(id) VALUES (49);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (42, '600', '0', '{"120"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (49, 49, 0, 42);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (76, 0, 1, 2676, '49', 'Abgeschnitten', 'Rund', '18', NULL, NULL, '26', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2678, '120', '{"Höhenlinie 1m"}', 69);
INSERT INTO alkis_stricharten(id) VALUES (50);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (43, '400', '0', '{"120"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (50, 50, 0, 43);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (77, 0, 1, 2678, '50', 'Abgeschnitten', 'Rund', '18', NULL, NULL, '26', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2680, '120', '{"Höhenlinie 0,5m","Höhenlinie 0,25m"}', 69);
INSERT INTO alkis_stricharten(id) VALUES (51);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (44, '270', '0', '{"80"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (51, 51, 0, 44);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (78, 0, 1, 2680, '51', 'Abgeschnitten', 'Rund', '18', NULL, NULL, '26', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2701, '600', '{"Zuordnungspfeil der Bodenschätzung"}', 69);
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (27, 'Grün', '30', '0', '42', '0', '178', '255', '147', '178 255 147');
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (79, 0, 1, 2701, NULL, 'Pfeil', 'Spitz', '25', '120', '150', '27', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2703, '600', '{"Klassenflächengrenze"}', 70);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (80, 0, 1, 2703, NULL, 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '27', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2705, '600', '{"Klassenabschnittsgrenze"}', 70);
INSERT INTO alkis_stricharten(id) VALUES (52);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (52, 52, 0, 35);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (81, 0, 1, 2705, '52', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '27', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 2707, '600', '{"Sonderflächengrenze"}', 71);
INSERT INTO alkis_stricharten(id) VALUES (53);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (45, '400', '250', '{"500"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (53, 53, 0, 45);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (82, 0, 1, 2707, '53', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '27', NULL);
INSERT INTO alkis_stricharten(id) VALUES (54);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (46, '0', '900', '{"900"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (54, 54, 0, 46);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (83, 1, 1, 2707, '54', 'Rund', 'Rund', '100', NULL, NULL, '27', NULL);
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (30,4, NULL, 18, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (31,3, NULL, 18, 'Rund', 'Rund');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (28, 'Gelb', '0', '10', '100', '0', '255', '229', '0', '255 229 0');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (29, 'Blau', '50', '0', '0', '0', '127', '255', '255', '127 255 255');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (30, 'Blau', '100', '0', '0', '0', '0', '255', '255', '0 255 255');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (32,4, NULL, 25, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (31, 'Rot', '0', '100', '100', '0', '255', '0', '0', '255 0 0');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (32, 'Grün', '30', '0', '50', '0', '178', '255', '127', '178 255 127');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (33,16, NULL, 18, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (34,19, NULL, 70, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (35,1, NULL, 18, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (36,4, NULL, 35, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (37,4, NULL, 70, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (38,19, NULL, 35, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (39,1, NULL, 10, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (40,4, NULL, 50, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (41,19, NULL, 18, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (42,2, NULL, 18, 'Rund', 'Rund');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (33, 'Ocker', '0', '30', '100', '0', '255', '178', '0', '255 178 0');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (43,14, NULL, 35, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (44,4, NULL, 40, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (45,4, NULL, 35, 'Abgeschnitten', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (46,4, NULL, 25, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (47,14, NULL, 18, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (48,4, NULL, 18, 'Abgeschnitten', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (49,16, NULL, 18, 'Abgeschnitten', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (50,19, NULL, 25, 'Abgeschnitten', NULL);
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (51,15, NULL, 35, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (52,5, NULL, 35, 'Rund', 'Rund');
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4052', '381', '{"Schriftformat N 5 381 weiß"}', '286', 'Arial', 'Normal', '5', NULL, NULL, '1', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4060', '380', '{"Schriftformat N 6 380"}', '286', 'Arial', 'Normal', '6', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4070', '380', '{"Schriftformat N 7 380"}', '287', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4071', '700', '{"Schriftformat N 7 700 liB"}', '287', 'Arial', 'Normal', '7', 'Basis', 'linksbündig', '4', 'LL', '7', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4072', '690', '{"Schriftformat N 7 690 grau liB"}', '287', 'Arial', 'Normal', '7', 'Basis', 'linksbündig', '3', 'LL', '7', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4073', '380', '{"Schriftformat N 7 380 blau"}', '288', 'Arial', 'Normal', '7', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4074', '380', '{"Schriftformat F 7 380"}', '288', 'Arial', 'Fett', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4080', '380', '{"Schriftformat N 8"}', '288', 'Arial', 'Normal', '8', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4081', '380', '{"Schriftformat F 8"}', '289', 'Arial', 'Fett', '8', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4082', '380', '{"Schriftformat N 8"}', '289', 'Arial', 'Normal', '8', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4100', '380', '{"Schriftformat N 10"}', '289', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4101', '380', '{"Schriftformat N 10 liM"}', '290', 'Arial', 'Normal', '10', 'Mitte', 'linksbündig', '4', 'CL', '4', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4102', '380', '{"Schriftformat N 10 blau reM"}', '290', 'Arial', 'Normal', '10', 'Mitte', 'rechtsbündig', '14', 'CR', '6', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4103', '380', '{"Schriftformat N 10 blau"}', '291', 'Arial', 'Normal', '10', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4104', '380', '{"Schriftformat N 6 hellbraun"}', '291', 'Arial', 'Normal', '6', NULL, NULL, '26', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4105', '380', '{"Schriftformat N 10 braun"}', '291', 'Arial', 'Normal', '10', NULL, NULL, '15', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4106', '600', '{"Schriftformat N 10 rot"}', '292', 'Times New Roman', 'Normal', '10', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4107', '420', '{"Schriftformat F 10"}', '293', 'Arial', 'Fett', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4108', '380', '{"Schriftformat F 7 blau"}', '293', 'Arial', 'Fett', '7', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4109', '380', '{"Schriftformat F 10 braun"}', '293', 'Arial', 'Fett', '10', NULL, NULL, '15', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4111', '700', '{"Schriftformat K 10 700"}', '294', 'Arial', 'Kursiv', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4112', '690', '{"Schriftformat K 10 grau"}', '294', 'Arial', 'Kursiv', '10', NULL, NULL, '3', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4113', '700', '{"Schriftformat K 10 700"}', '294', 'Arial', 'Kursiv', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4114', '600', '{"Schriftformat N 10 rot unterstrichen"}', '295', 'Times New Roman', 'Unterstrichen', '10', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4115', '700', '{"Schriftformat K 10 700"}', '295', 'Arial', 'Kursiv', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4116', '380', '{"Schriftformat F K 10"}', '295', 'Arial', 'Fett, Kursiv', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4117', '380', '{"Schriftformat F K 10 blau"}', '296', 'Arial', 'Fett, Kursiv', '10', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4118', '380', '{"Schriftformat F K 7 braun"}', '296', 'Arial', 'Fett, Kursiv', '7', NULL, NULL, '15', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4119', '600', '{"Schriftformat N 10 schwarz"}', '296', 'Times New Roman', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4120', '380', '{"Schriftformat F 12"}', '297', 'Arial', 'Fett', '12', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4121', '380', '{"Schriftformat TNR hellgrün","Legende (Bodenschätzung)"}', '296', 'Times New Roman', 'Normal', '12', NULL, NULL, '27', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4122', '690', '{"Schriftformat K 10 grau"}', '297', 'Arial', 'Kursiv', '10', NULL, NULL, '3', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4123', '690', '{"Schriftformat K 10 grau"}', '297', 'Arial', 'Kursiv', '10', NULL, NULL, '3', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4140', '380', '{"Schriftformat N 14"}', '298', 'Arial', 'Normal', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4141', '380', '{"Schriftformat F 14"}', '298', 'Arial', 'Fett', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4143', '380', '{"Schriftformat F 14 grün"}', '298', 'Arial', 'Fett', '14', NULL, NULL, '23', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4144', '380', '{"Schriftformat F 14 rot"}', '299', 'Arial', 'Fett', '14', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4147', '600', '{"Schriftformat N 14 TNR hellgrün"}', '299', 'Times New Roman', 'Normal', '14', NULL, NULL, '27', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4148', '600', '{"Schriftformat N 14 TNR hellbraun"}', '299', 'Times New Roman', 'Normal', '14', NULL, NULL, '26', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4149', '600', '{"Schriftformat N 14 TNR rot"}', '300', 'Times New Roman', 'Normal', '14', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4150', '380', '{"Schriftformat F K 14"}', '300', 'Arial', 'Fett, Kursiv', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4151', '380', '{"Schriftformat F K 14 blau"}', '300', 'Arial', 'Fett, Kursiv', '14', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4160', '380', '{"Schriftformat F 16"}', '301', 'Arial', 'Fett', '16', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4200', '380', '{"Schriftformat F 20"}', '301', 'Arial', 'Fett', '20', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4206', '380', '{"Schriftformat F K 20 braun"}', '301', 'Arial', 'Fett, Kursiv', '20', NULL, NULL, '15', NULL, NULL, '10', NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4208', '380', '{"Schriftformat F K 20"}', '302', 'Arial', 'Fett, Kursiv', '20', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4209', '380', '{"Schriftformat F K 20 grün"}', '302', 'Arial', 'Fett, Kursiv', '20', NULL, NULL, '19', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4211', '380', '{"Schriftformat F K 20 blau"}', '302', 'Arial', 'Fett, Kursiv', '20', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4243', '380', '{"Schriftformat F K 24 blau"}', '303', 'Arial', 'Fett, Kursiv', '24', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '4286', '380', '{"Schriftformat F K 28 blau"}', '303', 'Arial', 'Fett, Kursiv', '28', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7800', '350', '{"Gebäudefunktion (Schriftformat N 7)"}', '336', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7801', '380', '{"Stadt - Gemeindename"}', '336', 'Arial', 'Fett', '28', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7852', '380', '{"Bundeswasserstraße (Schriftzusatz)"}', '337', 'Arial', 'Fett, Kursiv', '14', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7854', '380', '{"Gewässer I. Ordnung - nach Landesrecht (Schriftzusatz)"}', '337', 'Arial', 'Fett, Kursiv', '14', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7856', '380', '{"Gewässer II. Ordnung (Schriftzusatz)"}', '337', 'Arial', 'Fett, Kursiv', '14', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7858', '380', '{"Gemeindeverbindungsstraße (Schriftzusatz)"}', '338', 'Arial', 'Normal', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7859', '380', '{"Festgesetztes Überschwemmungsgebiet (Schriftzusatz)"}', '338', 'Arial', 'Fett', '14', NULL, NULL, '24', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7861', '380', '{"Wasserschutzgebiet (Schriftzusatz)"}', '339', 'Arial', 'Fett', '14', NULL, NULL, '24', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7863', '380', '{"Veränderungssperre nach Baugesetzbuch (Schriftzusatz)"}', '339', 'Arial', 'Fett', '14', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7865', '380', '{"Baulast (Schriftzusatz)"}', '339', 'Arial', 'Fett', '14', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7867', '380', '{"Landschaftsschutzgebiet (Schriftzusatz)"}', '340', 'Arial', 'Fett', '14', NULL, NULL, '23', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7869', '380', '{"Naturpark (Schriftzusatz)"}', '340', 'Arial', 'Fett', '14', NULL, NULL, '23', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7871', '380', '{"Naturdenkmal (Schriftzusatz)"}', '340', 'Arial', 'Fett', '14', NULL, NULL, '23', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7873', '380', '{"Belastungsgebiet (Schriftzusatz)"}', '341', 'Arial', 'Fett', '14', NULL, NULL, '23', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7875', '380', '{"Lärmschutzbereich (Schriftzusatz)"}', '341', 'Arial', 'Fett', '14', NULL, NULL, '23', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7877', '380', '{"Übergabebescheidverfahren (Schriftzusatz)"}', '342', 'Arial', 'Fett', '14', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7879', '380', '{"Jagdkataster (Schriftzusatz)"}', '342', 'Arial', 'Fett', '14', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7881', '380', '{"Truppenübungsplatz, Standortübungsplatz (Schriftzusatz)"}', '343', 'Arial', 'Fett', '14', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7900', '380', '{"Schriftformat N 10"}', '629', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7930', '700', '{"Schriftformat N 10"}', '629', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7931', '700', '{"Schriftformat N 10"}', '629', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '7932', '700', '{"Schriftformat N 7"}', '629', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '8002', '350', '{"Schriftformat N 7"}', '629', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '8111', '380', '{"Schriftformat F 11"}', '301', 'Arial', 'Fett', '11', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '8112', '699', '{"Schriftformat N 7 380 liM"}', '301', 'Arial', 'Unterstrichen', '7', 'Mitte', 'linksbündig', '4', 'CL', '4', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '8118', '380', '{"Schriftformat TNR hellbraun","Legende (Bodenschätzung)"}', '303', 'Times New Roman', 'Normal', '12', NULL, NULL, '26', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '8120', '380', '{"Schriftformat N 6 hellbraun liM"}', '303', 'Arial', 'Normal', '6', 'Mitte', 'linksbündig', '26', 'CL', '4', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '8121', '380', '{"Schriftformat F 24"}', '303', 'Arial', 'Fett', '24', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', '8124', '420', '{"Schriftformat N 7 380 freigestellt"}', '304', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 8201, '304', '{"Carport, in ihrer Lage nur ungefähr bekannt","Gebäude für öffentliche Zwecke, aufgeständert, in ihrer Lage nur ungefähr bekannt","Gebäude für öffentliche Zwecke, in ihrer Lage nur ungefähr bekannt","Gebäude für Wirtschaft oder Gewerbe, aufgeständert, in ihrer Lage nur ungefähr bekannt","Gebäude für Wirtschaft oder Gewerbe, in ihrer Lage nur ungefähr bekannt","Gebäude - Nach Quellenlage nicht zu spezifizieren, aufgeständert, in ihrer Lage nur ungefähr bekannt","Gebäude - Nach Quellenlage nicht zu spezifizieren, in ihrer Lage nur ungefähr bekannt","Wohngebäude, aufgeständert, in ihrer Lage nur ungefähr bekannt","Wohngebäude, in ihrer Lage nur ungefähr bekannt","Legende (Gebäude)"}', 68);
INSERT INTO alkis_stricharten(id) VALUES (55);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (47, '100', '0', '{"100"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (55, 55, 0, 47);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (84, 0, 1, 8201, '55', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_stricharten(id) VALUES (56);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (48, '0', '150', '{"200"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (56, 56, 0, 48);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (85, 1, 1, 8201, '56', 'Rund', 'Rund', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 8205, '305', '{"Gebäude für öffentliche Zwecke, Hochhaus, aufgeständert,","in ihrer Lage nur ungefähr bekannt","Gebäude für öffentliche Zwecke, Hochhaus, in ihrer Lage nur ungefähr bekannt","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, aufgeständert, in ihrer Lage nur ungefähr bekannt","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, in ihrer Lage nur ungefähr bekannt","Gebäude - Nach Quellenlage nicht zu spezifizieren, Hochhaus, aufgeständert,","in ihrer Lage nur ungefähr bekannt","Gebäude - Nach Quellenlage nicht zu spezifizieren, Hochhaus, in ihrer Lage nur ungefähr bekannt","Wohngebäude, Hochhaus, aufgeständert, in ihrer Lage nur ungefähr bekannt","Wohngebäude, Hochhaus, in ihrer Lage nur ungefähr bekannt"}', 68);
INSERT INTO alkis_stricharten(id) VALUES (57);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (57, 57, 0, 47);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (86, 0, 1, 8205, '57', 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_stricharten(id) VALUES (58);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (58, 58, 0, 48);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (87, 1, 1, 8205, '58', 'Rund', 'Rund', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '8207', '103', '{"Sonstiges Gewässermerkmal"}', '23', NULL, '8');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 8208, '270', '{"Hecke"}', 69);
INSERT INTO alkis_stricharten(id) VALUES (59);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (49, '100', '0', '{"30"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (59, 59, 0, 49);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (88, 0, 1, 8208, '59', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '19', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 8223, '211', '{"Geländekante, Böschungsoberkante, unsicher","Geländekante, Böschungsunterkante, unsicher","Geländekante, Sonstige Begrenzungskante (z.B. Trennschraffe), unsicher"}', 57);
INSERT INTO alkis_stricharten(id) VALUES (60);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (60, 60, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (89, 0, 1, 8223, '60', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '15', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (1, 8225, '250', '{"Durchlass","Rohrdurchlass","Siel"}', 57);
INSERT INTO alkis_stricharten(id) VALUES (61);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (61, 61, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (90, 0, 1, 8225, '61', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '14', NULL);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (50, '200', '0', '{"100"}');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', '8515', '250', '{"Durchlass","Rohrdurchlass","Siel"}', '22', NULL, '19');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', 'RP1703', '340', '{"Natur-, Umwelt- oder Bodenschutzrecht"}', '684', NULL, '24');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', 'RP1704', '430', '{"Bau-, Raum- oder Bodenordnungsrecht","Denkmalschutzrecht","Natur-, Umwelt- oder Bodenschutzrecht","Sonstiges Recht"}', '684', NULL, '25');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', 'RP1705', '340', '{"Wasserrecht"}', '2', NULL, '26');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('1', 'RP1740', '600', '{"Musterstück"}', '3', NULL, '27');
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4070', '380', '{"Schriftformat N 7"}', '22', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4075', '380', '{"Schriftformat F 7 rot"}', '22', 'Arial', 'Fett', '7', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4076', '380', '{"Schriftformat F 7 grün"}', '23', 'Arial', 'Fett', '7', NULL, NULL, '23', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4082', '380', '{"Schriftformat N 8"}', '23', 'Arial', 'Normal', '8', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (34, 'HKS17', '30', '100', '70', '0', '178', '0', '76', '178 0 76');
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4083', '420', '{"Schriftformat N 8 BLISS 2 HKS17"}', '24', 'BLISS 2 regular', 'Normal', '8', NULL, NULL, '34', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4100', '380', '{"Schriftformat N 10"}', '24', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4107', '420', '{"Schriftformat F 10"}', '25', 'Arial', 'Fett', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4117', '420', '{"Schriftformat F K 10 blau"}', '25', 'Arial', 'Fett, Kursiv', '10', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4140', '380', '{"Schriftformat N 14"}', '26', 'Arial', 'Normal', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4143', '380', '{"Schriftformat F 14 grün"}', '26', 'Arial', 'Fett', '14', NULL, NULL, '23', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4144', '380', '{"Schriftformat F 14 rot"}', '27', 'Arial', 'Fett', '14', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4145', '380', '{"Schriftformat F 14 blau"}', '27', 'Arial', 'Fett', '14', NULL, NULL, '24', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4147', '600', '{"Schriftformat N 14 TNR grün"}', '28', 'Times New Roman', 'Normal', '14', NULL, NULL, '27', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4148', '600', '{"Schriftformat N 14 TNR braun"}', '29', 'Times New Roman', 'Normal', '14', NULL, NULL, '26', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4149', '600', '{"Schriftformat N 14 TNR rot"}', '29', 'Times New Roman', 'Normal', '14', NULL, NULL, '5', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4200', '380', '{"Schriftformat F 20"}', '30', 'Arial', 'Fett', '20', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4243', '380', '{"Schriftformat F K 24 blau"}', '30', 'Arial', 'Fett, Kursiv', '24', NULL, NULL, '14', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4310', '380', '{"Schriftformat N 20"}', '31', 'Arial', 'Normal', '20', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4320', '380', '{"Schriftformat N 28"}', '31', 'Arial', 'Normal', '28', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('1', 'RP4330', '380', '{"Schriftformat N 40"}', '32', 'Arial', 'Normal', '40', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1003', '110', '{"Flurstück, abweichender Rechtszustand"}', '344', '1', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1301', '290', '{"Wohngebäude","Wohngebäude, aufgeständert","Wohngebäude, Hochhaus","Wohngebäude, Hochhaus, aufgeständert"}', '344', '2', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1304', '290', '{"Carport","Gebäude, nach Quellenlage nicht zu spezifizieren","Gebäude, nach Quellenlage nicht zu spezifizieren, aufgeständert","Gebäude, nach Quellenlage nicht zu spezifizieren, Hochhaus","Gebäude, nach Quellenlage nicht zu spezifizieren, Hochhaus, aufgeständert","Gebäude für Wirtschaft oder Gewerbe","Gebäude für Wirtschaft oder Gewerbe, aufgeständert","Gebäude für Wirtschaft oder Gewerbe, Hochhaus","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, aufgeständert","Gebäude für Wirtschaft oder Gewerbe, offene Halle","Überdachung","Vorratsbehälter, Speicherbauwerk, aufgeständert"}', '344', '3', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1305', '300', '{"Antenne","Brückenlaufkran","Drehkran","Einsteigeschacht","Freitreppe","Funkmast","Historische Mauer","Hochofen","Kran","Laufkran","Mauer","Portalkran","Radioteleskop","Rampe","Rolltreppe","Schachtöffnung","Schöpfwerk","Solarzellen","Sonstige historische Mauer","Sonstiges Bauwerk oder sonstige Anlage für Industrie und Gewerbe","Stadtmauer","Staumauer","Staumauer, außer Betrieb","Stützmauer","Terrasse","Treppe","Trockendock","Vorratsbehälter, Speicherbauwerk","Wasserrad","Windrad"}', '345', '3', '1');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1306', '365', '{"Mast"}', '346', '3', '1');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1307', '301', '{"Carport","Überdachung"}', '315', '3', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1308', '120', '{"Hafendamm, Mole","Wellenbrecher, Buhne"}', '346', '3', '1');
INSERT INTO alkis_farben(id,name,c,y,m,k,r,g,b,umn) VALUES (35, 'Grau', '0', '0', '0', '60', '102', '102', '102', '102 102 102');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1309', '290', '{"Gebäude für öffentliche Zwecke","Gebäude für öffentliche Zwecke, aufgeständert","Gebäude für öffentliche Zwecke, Hochhaus","Gebäude für öffentliche Zwecke, Hochhaus, aufgeständert","Gebäude für öffentliche Zwecke, offene Halle"}', '346', '35', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1317', '300', '{"Befestigung (Burgruine)","Burg (Fliehburg, Ringwall)","Lager","Schanze"}', '347', NULL, '2');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1320', '340', '{"Furt"}', '347', NULL, '3');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1321', '280', '{"Vorratsbehälter, Speicherbauwerk, unter der Erdoberfläche"}', '348', NULL, '4');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1330', '250', '{"Aquädukt","Befestigung (Wall, Graben)","Denkmal, Denkstein, Standbild","Fernsprechhäuschen","Grab","Grabhügel (Hügelgrab)","Großsteingrab (Dolmen), Hünenbett","Müllbox","Sonstige Einrichtung in öffentlichen Bereichen","Sonstiges Bauwerk oder sonstige Einrichtung, Sonstiges","Sonstiges historisches Bauwerk oder sonstige historische Einrichtung","Wachturm (römisch), Warte","Wasserleitung"}', '348', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1401', '100', '{"Fläche besonderer funktionaler Prägung","Fläche gemischter Nutzung","Wohnbaufläche"}', '349', NULL, NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1403', '100', '{"Abfallbehandlungsanlage","Betriebsfläche Versorgungsanlage, Abfallbeseitigung","Bergbaubetrieb","Bergbaubetrieb, außer Betrieb, stillgelegt, verlassen","Deponie (oberirdisch)","Deponie (untertägig)","Förderanlage","Funk- und Fernmeldeanlage","Betriebsfläche Versorgungsanlage, Funk- und Fernmeldewesen","Gaswerk","Betriebsfläche Versorgungsanlage, Gas","Halde","Heizwerk","Betriebsfläche Versorgungsanlage, Wärme","Industrie- und Gewerbefläche","Kläranlage, Klärwerk","Betriebsfläche Versorgungsanlage, Abwasserbeseitigung","Kraftwerk","Betriebsfläche Versorgungsanlage, Elektrizität","Lagerplatz","Raffinerie","Betriebsfläche Versorgungsanlage, Öl","Tagebau, Grube, Steinbruch","Tankstelle","Umspannstation","Wasserwerk","Betriebsfläche Versorgungsanlage, Wasser"}', '349', '7', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1404', '100', '{"Brachland","Heide","Moor","Sumpf","Torf"}', '350', NULL, NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1405', '100', '{"Autokino, Freilichtkino","Botanischer Garten","Campingplatz","Erholungsfläche","Freilichtmuseum","Freilichttheater","Freizeitanlage","Freizeitpark","Friedhof","Garten","Grünanlage","Grünfläche","Hundeübungsplatz","Kleingarten","Modellflugplatz","Park","Safaripark, Wildpark","Schwimmbad, Freibad","Spielplatz, Bolzplatz","Sport-, Freizeit- und Erholungsfläche","Sportanlage","Sportanlage: Ballsport","Sportanlage: Fußball","Sportanlage: Leichtathletik","Sportanlage: Eislaufen, Rollschuhlaufen","Sportanlage: Golf","Sportanlage: Hunderennsport","Sportanlage: Motorrennsport","Sportanlage: Pferderennsport","Sportanlage: Radsport","Sportanlage: Reiten","Sportanlage: Schießen","Sportanlage: Skating","Sportanlage: Skisport","Sportanlage: Tennis","Verkehrsübungsplatz","Wochenend und Ferienhausfläche","Wochenendplatz","Zoo"}', '350', NULL, NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1406', '100', '{"Baumschule","Bebaute Gewässerbegleitfläche","Flughafen","Flugverkehr","Gartenland","Gewässerbegleitfläche","Grünland","Hubschrauberflugplatz","Internationaler Flughafen","Landeplatz, Sonderlandeplatz","Obstbaumplantage","Obstplantage","Obststrauchplantage","Regionalflughafen","Segelfluggelände","Straßenentwässerungsanlage","Streuobstwiese","Sukzessionsfläche","Unbebaute Gewässerbegleitfläche","Verkehrsbegleitfläche Bahnverkehr","Verkehrsbegleitfläche Straße","Verkehrslandeplatz","Weingarten"}', '351', NULL, NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1409', '100', '{"Ackerland","Hopfen","Landwirtschaft","Spargel","Streuobstacker"}', '352', NULL, NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1410', '100', '{"Fließgewässer","Hafenbecken","Meer","Stehendes Gewässer","Stehendes Gewässer, nicht ständig Wasser führend"}', '352', NULL, NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1414', '100', '{"Fußgängerzone (Platz)","Fußgängerzone (Straßenverkehr)","Gehölz","Latschenkiefer","Laubwald mit Nadelholz","Nadelwald mit Laubholz","Wald","Wald, Laub- und Nadelholz","Wald, Laubholz","Wald, Nadelholz"}', '352', NULL, NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1501', '300', '{"Aussichtsturm","Aussichtsturm, außer Betrieb, stillgelegt, verlassen","Bohrturm","Bohrturm, außer Betrieb, stillgelegt, verlassen","Feuerwachturm","Feuerwachturm, außer Betrieb, stillgelegt, verlassen","Förderturm","Förderturm, außer Betrieb, stillgelegt, verlassen","Kirchturm, Glockenturm","Kirchturm, Glockenturm, außer Betrieb, stillgelegt, verlassen","Kontrollturm","Kontrollturm, außer Betrieb, stillgelegt, verlassen","Kühlturm","Kühlturm, außer Betrieb, stillgelegt, verlassen","Leuchtturm","Leuchtturm, außer Betrieb, stillgelegt, verlassen","Schloß-, Burgturm","Schloß-, Burgturm, außer Betrieb, stillgelegt, verlassen","Schornstein, Schlot, Esse","Sende-, Funkturm, Fernmeldeturm","Sende-, Funkturm, Fernmeldeturm, außer Betrieb, stillgelegt, verlassen","Sonstiger Turm","Sonstiger Turm, außer Betrieb, stillgelegt, verlassen","Stadt-, Torturm","Stadt-, Torturm, außer Betrieb, stillgelegt, verlassen","Turm, nach Quellenlage nicht zu spezifizieren","Turm, nach Quellenlage nicht zu spezifizieren, außer Betrieb, stillgelegt, verlassen","Wasserturm","Wasserturm, außer Betrieb, stillgelegt, verlassen"}', '353', '3', '6');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1502', '310', '{"Aussichtsturm, verfallen, zerstört","Bohrturm, verfallen, zerstört","Feuerwachturm, verfallen, zerstört","Förderturm, verfallen, zerstört","Kirchturm, Glockenturm, verfallen, zestört","Kontrollturm, verfallen, zerstört","Kühlturm, verfallen, zerstört","Leuchtturm, verfallen, zerstört","Schloß-, Burgturm, verfallen, zerstört","Sende-, Funkturm, Fernmeldeturm, verfallen, zerstört","Sonstiger Turm, verfallen, zerstört","Stadt-, Torturm, verfallen, zerstört","Turm, nach Quellenlage nicht zu spezifizieren, verfallen, zerstört","Wasserturm, verfallen, zerstört"}', '354', NULL, '7');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1510', '130', '{"Klärbecken"}', '354', NULL, '5');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (53,2, '3', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1519', '130', '{"Zuschauertribüne überdacht"}', '355', NULL, '53');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1520', '130', '{"Hartplatz","Rasenplatz","Spielfeld"}', '355', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1521', '200', '{"Rennbahn, Laufbahn, Geläuf"}', '356', NULL, '5');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (54,2, NULL, 50, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1522', '120', '{"Stadion"}', '356', NULL, '54');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1523', '130', '{"Bach","Fleet","Graben","Priel","Teich","Untergeordnetes Gewässer"}', '356', '1', '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1524', '130', '{"Gradierwerk","Liegewiese","Schießanlage","Sonstiges Bauwerk oder sonstige Anlage für Sport, Freizeit und Erholung","Sprungschanze (Anlauf)","Wildgehege","Zuschauertribüne","Zuschauertribüne nicht überdacht"}', '357', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1525', '350', '{"Brunnen","Springbrunnen, Zierbrunnen"}', '357', '3', '1');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1526', '130', '{"Schwimmbecken"}', '358', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1530', '400', '{"Brücke","Landebrücke","Hochbahn, Hochstraße"}', '358', '1', '12');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1531', '410', '{"Brückenpfeiler"}', '359', NULL, '13');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1532', '300', '{"Brückenjoch"}', '359', '3', '14');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1533', '500', '{"Tunnel, Unterführung"}', '359', NULL, '15');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1534', '350', '{"Schutzgalerie"}', '360', '3', '16');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1535', '250', '{"Schleusenkammer"}', '360', NULL, '17');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1536', '250', '{"Sonstiges Bauwerk im Verkehrsbereich"}', '361', NULL, '14');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1540', '200', '{"Fahrbahn"}', '361', '1', '14');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1541', '130', '{"Bahnhof, Bahn im Freizeitpark","Bahnhof, Bergbahn, Seilbahn","Bahnhof, Eisenbahn","Bahnhof, Güterverkehr","Bahnhof, Magnetschwebebahn","Bahnhof, Museumsbahn","Bahnhof, S-Bahn","Bahnhof, sonstige Bahnkategorie","Bahnhof, Stadtbahn","Bahnhof, Standseilbahn","Bahnhof, Straßenbahn","Bahnhof, U-Bahn","Bahnhof, Zahnradbahn","Drehscheibe","Haltestelle, Haltepunkt, Bahn im Freizeitpark","Haltestelle, Haltepunkt, Bergbahn, Seilbahn","Haltestelle, Haltepunkt, Eisenbahn","Haltestelle, Haltepunkt, Güterverkehr","Haltestelle, Haltepunkt, Magnetschwebebahn","Haltestelle, Haltepunkt, Museumsbahn","Haltestelle, Haltepunkt, S-Bahn","Haltestelle, Haltepunkt, sonstige Bahnkategorie","Haltestelle, Haltepunkt, Stadtbahn","Haltestelle, Haltepunkt, Standseilbahn","Haltestelle, Haltepunkt, Straßenbahn","Haltestelle, Haltepunkt, U-Bahn","Haltestelle, Haltepunkt, Zahnradbahn"}', '361', NULL, '1');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1542', '130', '{"Fußweg","Karren- und Ziehweg","Rad- und Fußweg (Weg, Pfad, Steig)","Radweg (Weg, Pfad, Steig)","Reitweg (Weg, Pfad, Steig)","Skaterstrecke","Weg, Pfad, Steig"}', '362', '1', '5');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (55,2, '6', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1543', '130', '{"Wattenweg"}', '363', NULL, '55');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1544', '130', '{"Anleger","Sonstige Einrichtung für den Schiffsverkehr"}', '363', '1', '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1548', '130', '{"Fischtreppe","Sicherheitstor","Sperrwerk","Sonstiges Bauwerk im Gewässerbereich","Sonstige Straßenverkehrsanlage","Wehr"}', '363', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1550', '340', '{"Bach, verdolt","Bach, verrohrt, unterirdisch, bedeckt","Durchlass","Fleet, verdolt","Fleet, verrohrt, unterirdisch, bedeckt","Graben, verdolt","Graben, verrohrt, unterirdisch, bedeckt","Rohrdurchlass","Siel","Untergeordnetes Gewässer, verdolt","Untergeordnetes Gewässer, verrohrt, unterirdisch, bedeckt"}', '364', NULL, '3');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1551', '130', '{"Damm, Wall, Deich","Felsen, Felsblock, Felsnadel","Rückhaltebecken","Sonstiges Gewässermerkmal","Staudamm","Staudamm, außer Betrieb"}', '365', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1552', '140', '{"Staudamm, im Bau","Staumauer, im Bau"}', '365', NULL, '20');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1560', '180', '{"Baumbestand, Laub- und Nadelholz","Baumbestand, Laubholz","Baumbestand, Nadelholz","Gebüsch","Gehölz (Vegetationsmerkmal)","Gras","Korbweide","Reet","Röhricht, Schilf","Zierfläche"}', '365', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1561', '180', '{"Rain","Schneise"}', '366', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1562', '130', '{"Quelle","Stromschnelle","Wasserfall"}', '366', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1563', '180', '{"Vegetationsmerkmal, Zustand nass"}', '367', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1570', '130', '{"Düne","Sandbank"}', '367', NULL, '5');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1571', '120', '{"Watt"}', '368', '7', NULL);
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (56,2, '8', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1572', '130', '{"Bach, nicht ständig Wasser führend","Fleet, nicht ständig Wasser führend","Graben, nicht ständig Wasser führend","Teich, nicht ständig Wasser führend","Untergeordnetes Gewässer, nicht ständig Wasser führend"}', '368', '1', '56');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (57,2, '9', 18, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1573', '130', '{"Bach, trocken, versiegt","Fleet, trocken, versiegt","Graben, trocken, versiegt","Teich, trocken, versiegt","Untergeordnetes Gewässer, trocken, versiegt"}', '368', NULL, '57');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1701', '100', '{"Bundesautobahn,","Bundesstraße"}', '369', NULL, NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1702', '100', '{"Landes- oder Staatsstraße"}', '369', NULL, NULL);
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (58,2, '10', 100, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1703', '340', '{"Nationalpark","Naturschutzgebiet","Natur-, Umwelt- oder Bodenschutzrecht","Schutzgebiet nach Natur-, Umwelt- oder Bodenschutzrecht"}', '369', NULL, '58');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1704', '430', '{"Bau-, Raum- oder Bodenordnungsrecht","Flurbereinigung","Sanierung","Truppenübungsplatz, Standortübungsplatz","Umlegung"}', '370', NULL, '58');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1705', '340', '{"Andere Festlegung nach Wasserrecht","Schutzgebiet nach Wasserrecht"}', '370', NULL, '58');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (59,35, NULL, 100, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1740', '600', '{"Musterstück","Landesmusterstück"}', '371', NULL, '59');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '1808', '130', '{"Hubschrauberlandeplatz","Startbahn, Landebahn","Vorfeld","Zurollbahn, Taxiway"}', '371', NULL, '5');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2001, '360', '{"Ausgabekopf - Trennlinie","Kabinenbahn, Umlaufseilbahn","Luftseilbahn, Großkabinenbahn","Materialseilbahn","Schwebebahn","Sessellift","Skilift, Schlepplift"}', 373);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (91, 0, 2, 2001, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2002, '270', '{"Bahnübergang, Schranke","Hängende Lampe","Höckerlinie","Rohrleitung, Pipeline","Zaun"}', 373);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (92, 0, 2, 2002, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2003, '130', '{"Lahnung","Schöpfwerk","Sonstiges Bauwerk im Gewässerbereich","Sperrwerk","Wehr"}', 374);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (93, 0, 2, 2003, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2004, '700', '{"Zuordnungspfeil"}', 374);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (94, 0, 2, 2004, NULL, 'Pfeil', NULL, '18', '120', '150', '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2005, '690', '{"Zuordnungspfeil, abweichender Rechtszustand"}', 374);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (95, 0, 2, 2005, NULL, 'Pfeil', NULL, '18', '120', '150', '3', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2006, '705', '{"Strittige Grenze"}', 375);
INSERT INTO alkis_stricharten(id) VALUES (62);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (62, 62, 0, 11);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (96, 0, 2, 2006, '62', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2007, '692', '{"Strittige Grenze, abweichender Rechtszustand"}', 375);
INSERT INTO alkis_stricharten(id) VALUES (63);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (63, 63, 0, 11);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (97, 0, 2, 2007, '63', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '3', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2008, '720', '{"Flurstücksgrenze nicht feststellbar","Mittellinie in Gewässern","Nicht festgestellte Grenze"}', 376);
INSERT INTO alkis_stricharten(id) VALUES (64);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (64, 64, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (98, 0, 2, 2008, '64', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2009, '710', '{"Flurstücksgrenze nicht feststellbar, abweichender Rechtszustand","Mittellinie in Gewässern, abweichender Rechtszustand","Nicht festgestellte Grenze, abweichender Rechtszustand"}', 376);
INSERT INTO alkis_stricharten(id) VALUES (65);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (65, 65, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (99, 0, 2, 2009, '65', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '3', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2010, '455', '{"Grenze des Landkreises","Grenze der Region"}', 377);
INSERT INTO alkis_stricharten(id) VALUES (66);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (66, 66, 0, 12);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (100, 0, 2, 2010, '66', 'Abgeschnitten', 'Spitz', '150', NULL, NULL, '35', NULL);
INSERT INTO alkis_stricharten(id) VALUES (67);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (67, 67, 0, 13);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (101, 1, 2, 2010, '67', 'Rund', 'Rund', '150', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2012, '450', '{"Grenze der Flur"}', 377);
INSERT INTO alkis_stricharten(id) VALUES (68);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (68, 68, 0, 14);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (102, 0, 2, 2012, '68', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_stricharten(id) VALUES (69);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (69, 69, 0, 15);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (103, 1, 2, 2012, '69', 'Rund', 'Rund', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2014, '451', '{"Grenze der Gemarkung"}', 378);
INSERT INTO alkis_stricharten(id) VALUES (70);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (70, 70, 0, 16);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (104, 0, 2, 2014, '70', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_stricharten(id) VALUES (71);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (71, 71, 0, 17);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (105, 1, 2, 2014, '71', 'Rund', 'Rund', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2016, '458', '{"Grenze der Bundesrepublik Deutschland"}', 379);
INSERT INTO alkis_stricharten(id) VALUES (72);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (72, 72, 0, 18);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (106, 0, 2, 2016, '72', 'Abgeschnitten', 'Spitz', '250', NULL, NULL, '35', NULL);
INSERT INTO alkis_stricharten(id) VALUES (73);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (73, 73, 0, 19);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (107, 1, 2, 2016, '73', 'Rund', 'Rund', '250', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2018, '457', '{"Grenze des Bundeslandes"}', 379);
INSERT INTO alkis_stricharten(id) VALUES (74);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (74, 74, 0, 20);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (108, 0, 2, 2018, '74', 'Abgeschnitten', 'Spitz', '200', NULL, NULL, '35', NULL);
INSERT INTO alkis_stricharten(id) VALUES (75);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (75, 75, 0, 21);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (109, 1, 2, 2018, '75', 'Rund', 'Rund', '200', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2020, '456', '{"Grenze des Regierungsbezirkes"}', 380);
INSERT INTO alkis_stricharten(id) VALUES (76);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (76, 76, 0, 22);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (110, 0, 2, 2020, '76', 'Abgeschnitten', 'Spitz', '150', NULL, NULL, '35', NULL);
INSERT INTO alkis_stricharten(id) VALUES (77);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (77, 77, 0, 23);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (111, 1, 2, 2020, '77', 'Rund', 'Rund', '150', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2022, '453', '{"Grenze der Gemeinde"}', 381);
INSERT INTO alkis_stricharten(id) VALUES (78);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (78, 78, 0, 24);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (112, 0, 2, 2022, '78', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_stricharten(id) VALUES (79);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (79, 79, 0, 25);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (113, 1, 2, 2022, '79', 'Rund', 'Rund', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2024, '452', '{"Grenze des Gemeindeteils"}', 381);
INSERT INTO alkis_stricharten(id) VALUES (80);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (80, 80, 0, 26);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (114, 0, 2, 2024, '80', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_stricharten(id) VALUES (81);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (81, 81, 0, 27);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (115, 1, 2, 2024, '81', 'Abgeschnitten', 'Spitz', '160', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2026, '454', '{"Grenze der Verwaltungsgemeinschaft"}', 382);
INSERT INTO alkis_stricharten(id) VALUES (82);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (82, 82, 0, 28);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (116, 0, 2, 2026, '82', 'Abgeschnitten', 'Spitz', '150', NULL, NULL, '35', NULL);
INSERT INTO alkis_stricharten(id) VALUES (83);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (83, 83, 0, 29);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (117, 1, 2, 2026, '83', 'Rund', 'Rund', '150', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2028, '700', '{"Flurstück"}', 383);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (118, 0, 2, 2028, NULL, 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2029, '690', '{"Flurstück, abweichender Rechtszustand"}', 383);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (119, 0, 2, 2029, NULL, 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '3', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2030, '300', '{"Gebäude, nach Quellenlage nicht zu spezifizieren,","Hochhaus, aufgeständert","Gebäude, nach Quellenlage nicht zu spezifizieren, Hochhaus, verfallen, zerstört oder teilweise","zerstört oder geplant oder im Bau","Gebäude, nach Quellenlage nicht zu spezifizieren, Hochhaus, verfallen, zerstört oder teilweise","zerstört oder geplant oder im Bau und aufgeständert","Gebäude für öffentliche Zwecke, Hochhaus, aufgeständert","Gebäude für öffentliche Zwecke, Hochhaus, verfallen, zerstört oder teilweise zerstört oder geplant","oder im Bau","Gebäude für öffentliche Zwecke, Hochhaus, verfallen, zerstört oder teilweise zerstört oder geplant","oder im Bau und aufgeständert","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, aufgeständert","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, verfallen, zerstört oder teilweise zerstört oder","geplant oder im Bau","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, verfallen, zerstört oder teilweise zerstört oder","geplant oder im Bau und aufgeständert","Wohngebäude, Hochhaus, aufgeständert","Wohngebäude, Hochhaus, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau","Wohngebäude, Hochhaus, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau und","aufgeständert"}', 383);
INSERT INTO alkis_stricharten(id) VALUES (84);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (84, 84, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (120, 0, 2, 2030, '84', 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2031, '300', '{"Carport","Gebäude, nach Quellenlage nicht zu spezifizieren, aufgeständert","Gebäude, nach Quellenlage nicht zu spezifizieren, verfallen, zerstört oder teilweise zerstört oder","geplant oder im Bau","Gebäude, nach Quellenlage nicht zu spezifizieren, verfallen, zerstört oder teilweise zerstört oder","geplant oder im Bau und aufgeständert","Gebäude für öffentliche Zwecke, aufgeständert","Gebäude für öffentliche Zwecke, offene Halle","Gebäude für öffentliche Zwecke, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau","Gebäude für öffentliche Zwecke, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau","und aufgeständert","Gebäude für Wirtschaft oder Gewerbe, aufgeständert","Gebäude für Wirtschaft oder Gewerbe, offene Halle","Gebäude für Wirtschaft oder Gewerbe, verfallen, zerstört oder teilweise zerstört oder geplant oder im","Bau","Gebäude für Wirtschaft oder Gewerbe, verfallen, zerstört oder teilweise zerstört oder geplant oder im","Bau und aufgeständert","Überdachung","Vorratsbehälter, Speicherbauwerk, aufgeständert","Wohngebäude, aufgeständert","Wohngebäude, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau","Wohngebäude, verfallen, zerstört oder teilweise zerstört oder geplant oder im Bau und aufgeständert"}', 384);
INSERT INTO alkis_stricharten(id) VALUES (85);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (85, 85, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (121, 0, 2, 2031, '85', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2032, '280', '{"Gebäude, nach Quellenlage nicht zu spezifizieren,","unter der Erdoberfläche","Gebäude für öffentliche Zwecke, unter der Erdoberfläche","Wohngebäude, unter der Erdoberfläche","Gebäude für Wirtschaft oder Gewerbe, unter der Erdoberfläche"}', 385);
INSERT INTO alkis_stricharten(id) VALUES (86);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (86, 86, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (122, 0, 2, 2032, '86', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2300, '310', '{"Bahn im Freizeitpark, Gleis, unter der Erdoberfläche","Bergbahn, Seilbahn, Gleis,unter der Erdoberfläche","Eisenbahn, Gleis, unter der Erdoberfläche","Güterverkehr, Gleis, unter der Erdoberfläche","Magnetschwebebahn, Gleis, unter der Erdoberfläche","Museumsbahn, Gleis, unter der Erdoberfläche","S-Bahn, Gleis, unter der Erdoberfläche","Sonstige Bahnkategorie, Gleis, unter der Erdoberfläche","Stadtbahn, Gleis, unter der Erdoberfläche","Standseilbahn, Gleis, unter der Erdoberfläche","Straßenbahn, Gleis, unter der Erdoberfläche","U-Bahn, Gleis, unter der Erdoberfläche","Zahnradbahn, Gleis, unter der Erdoberfläche"}', 385);
INSERT INTO alkis_stricharten(id) VALUES (87);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (87, 87, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (123, 0, 2, 2300, '87', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2301, '310', '{"Bahn im Freizeitpark, Gleis, aufgeständert","Bergbahn, Seilbahn, Gleis, aufgeständert","Eisenbahn, Gleis, aufgeständert","Güterverkehr, Gleis, aufgeständert","Magnetschwebebahn, Gleis, aufgeständert","Museumsbahn, Gleis, aufgeständert","S-Bahn, Gleis, aufgeständert","Sonstige Bahnkategorie, Gleis, aufgeständert","Stadtbahn, Gleis, aufgeständert","Standseilbahn, Gleis, aufgeständert","Straßenbahn, Gleis, aufgeständert","U-Bahn, Gleis, aufgeständert","Zahnradbahn, Gleis, aufgeständert"}', 386);
INSERT INTO alkis_stricharten(id) VALUES (88);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (88, 88, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (124, 0, 2, 2301, '88', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2302, '330', '{"Besondere Gebäudelinie, Trennlinie nicht eindeutig festgelegt"}', 387);
INSERT INTO alkis_stricharten(id) VALUES (89);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (89, 89, 0, 31);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (125, 0, 2, 2302, '89', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_stricharten(id) VALUES (90);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (90, 90, 0, 32);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (126, 1, 2, 2302, '90', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2303, '340', '{"Firstlinie"}', 387);
INSERT INTO alkis_stricharten(id) VALUES (91);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (91, 91, 0, 33);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (127, 0, 2, 2303, '91', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2305, '330', '{"Besondere Gebäudelinie, offene Gebäudelinie","Durchfahrt, Bauwerk"}', 388);
INSERT INTO alkis_stricharten(id) VALUES (92);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (92, 92, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (128, 0, 2, 2305, '92', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '2504', '270', '{"Bandstraße, unter der Erdoberfläche","Bandstraße, unter der Wasseroberfläche","Förderband, unter der Erdoberfläche","Förderband, unter der Wasseroberfläche"}', '388', NULL, '28');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2505, '300', '{"Gebäude, nach Quellenlage nicht zu spezifizieren","Gebäude für öffentliche Zwecke","Gebäude für Wirtschaft oder Gewerbe","Wohngebäude"}', 389);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (129, 0, 2, 2505, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2506, '340', '{"Fahrbahnbegrenzungslinie, überdeckt"}', 389);
INSERT INTO alkis_stricharten(id) VALUES (93);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (93, 93, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (130, 0, 2, 2506, '93', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2507, '310', '{"Arkade","Auskragende Geschosse","Auskragende/zurückspringende Geschosse","Durchfahrt an überbauter Verkehrsstraße","Durchfahrt im Gebäude","Gebäudeteil - abweichende Geschosshöhe","Geringergeschossiger Gebäudeteil","Höhergeschossiger Gebäudeteil (nicht Hochhaus)","Keller","Loggia","Sonstiger Gebäudeteil","Tiefgarage (Bauteil)","Treppenunterkante","Zurückspringende Geschosse"}', 389);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (131, 0, 2, 2507, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2508, '310', '{"Gebäudeteil - abweichende Geschosshöhe, aufgeständert","Geringergeschossiger Gebäudeteil, aufgeständert","Höhergeschossiger Gebäudeteil (nicht Hochhaus) aufgeständert","Sonstiger Gebäudeteil, aufgeständert"}', 390);
INSERT INTO alkis_stricharten(id) VALUES (94);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (94, 94, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (132, 0, 2, 2508, '94', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2509, '310', '{"Hochhausgebäudeteil"}', 390);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (133, 0, 2, 2509, NULL, 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '2510', '300', '{"Historische Mauer","Mauerkante links,","Mauerkante rechts,","Mauermitte,","Sonstige historische Mauer","Stadtmauer","Stützmauer links","Stützmauermitte","Stützmauer rechts","Ufermauer, Kaimauer"}', '391', '3', '29');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2511, '310', '{"Hochhausgebäudeteil, aufgeständert"}', 391);
INSERT INTO alkis_stricharten(id) VALUES (95);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (95, 95, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (134, 0, 2, 2511, '95', 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2512, '280', '{"Keller, unter der Erdoberfläche","Tiefgarage, unter der Erdoberfläche (Bauteil)"}', 392);
INSERT INTO alkis_stricharten(id) VALUES (96);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (96, 96, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (135, 0, 2, 2512, '96', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2513, '310', '{"Schornstein im Gebäude"}', 392);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (136, 0, 2, 2513, NULL, 'Abgeschnitten', 'Rund', '25', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2514, '310', '{"Turm im Gebäude"}', 393);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (137, 0, 2, 2514, NULL, 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2515, '106', '{"Abfallbehandlungsanlage","Ackerland","Autokino, Freilichtkino","Bahnverkehr","Baumschule","Bebaute Gewässerbegleitfläche","Bergbaubetrieb","Bergbaubetrieb, außer Betrieb, stillgelegt, verlassen","Botanischer Garten","Brachland","Campingplatz","Deponie (oberirdisch)","Deponie (untertägig)","Erholungsfläche","Fahrweg","Fels","Festplatz","Fläche besonderer funktionaler Prägung","Fläche gemischter Nutzung","Flughafen","Flugverkehr","Förderanlage","Freilichtmuseum","Freilichttheater","Freizeitanlage","Freizeitpark","Friedhof","Funk- und Fernmeldeanlage","Fußgängerzone (Platz)","Fußgängerzone (Straßenverkehr)","Fußweg","Gang","Garten","Gartenland","Gaswerk","Geröll","Gewässerbegleitfläche","Golfplatz","Grünanlage","Grünfläche","Grünland","Halde","Hauptwirtschaftsweg","Heide","Heizwerk","Hopfen","Hubschrauberflugplatz","Hundeübungsplatz","Industrie- und Gewerbefläche","Internationaler Flughafen","Kläranlage, Klärwerk","Kleingarten","Kraftwerk","Lagerplatz","Landeplatz, Sonderlandeplatz","Landwirtschaft","Marktplatz","Modellflugplatz","Moor","Obstbaumplantage","Obstplantage","Obststrauchplantage","Park","Parkplatz","Platz","Rad- und Fußweg","Radweg","Raffinerie","Rastplatz","Raststätte","Regionalflughafen","Reitweg","Safaripark, Wildpark","Sand","Schiffsverkehr","Schwimmbad, Freibad","Segelfluggelände","Sonstiger Weg","Spargel","Spielplatz, Bolzplatz","Sport-, Freizeit- und Erholungsfläche","Sportanlage","Sportanlage: Ballsport","Sportanlage: Eislaufen, Rollschuhlaufen","Sportanlage: Fußball","Sportanlage: Golf","Sportanlage: Hunderennsport","Sportanlage: Leichtathletik","Sportanlage: Motorrennsport","Sportanlage: Pferderennsport","Sportanlage: Radsport","Sportanlage: Reiten","Sportanlage: Schießen","Sportanlage: Skating","Sportanlage: Skisport","Sportanlage: Tennis","Steine, Schotter","Straßenentwässerungsanlage","Straßenverkehr","Streuobstacker","Streuobstwiese","Sukzessionsfläche","Sumpf","Tagebau, Grube, Steinbruch","Tankstelle","Umspannstation","Unbebaute Gewässerbegleitfläche","Unland/Vegetationslose Fläche","Vegetationslose Fläche","Vegetationslose Fläche, sonstiges Oberflächenmaterial","Verkehrsbegleitfläche Bahnverkehr","Verkehrsbegleitfläche Straße","Verkehrslandeplatz","Verkehrsübungsplatz","Wasserwerk","Weg","Weingarten","Wirtschaftsweg","Wochenend und Ferienhausfläche","Wochenendplatz","Wohnbaufläche","Zoo"}', 393);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (138, 0, 2, 2515, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2516, '101', '{"Bahnverkehr, im Bau","Flughafen, im Bau","Flugverkehr, im Bau","Hubschrauberflugplatz, im Bau","Internationaler Flughafen, im Bau","Landeplatz, Sonderlandeplatz im Bau","Regionalflughafen, im Bau","Schiffsverkehr, im Bau","Segelfluggelände, im Bau","Straßenverkehr, im Bau","Verkehrslandeplatz, im Bau"}', 396);
INSERT INTO alkis_stricharten(id) VALUES (97);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (97, 97, 0, 34);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (139, 0, 2, 2516, '97', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '18', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2517, '106', '{"Gehölz","Latschenkiefer","Laubwald mit Nadelholz","Nadelwald mit Laubholz","Wald","Wald Laub und Nadelholz","Wald, Laubholz","Wald, Nadelholz"}', 396);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (140, 0, 2, 2517, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2518, '108', '{"Eis, Firn","Fließgewässer","Hafenbecken","Meer","Schnee","Stehendes Gewässer"}', 397);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (141, 0, 2, 2518, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2519, '101', '{"Kanal, im Bau"}', 397);
INSERT INTO alkis_stricharten(id) VALUES (98);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (98, 98, 0, 34);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (142, 0, 2, 2519, '98', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '18', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2520, '103', '{"Stehendes Gewässer, nicht ständig Wasser führend"}', 398);
INSERT INTO alkis_stricharten(id) VALUES (99);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (99, 99, 0, 35);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (143, 0, 2, 2520, '99', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '2521', '270', '{"Förderband, Bandstraße","Tor"}', '398', NULL, '29');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2523, '270', '{"Erdkabel","Rohrleitung, Pipeline, unter der Erdoberfläche","Rohrleitung, Pipeline, unter der Wasseroberfläche"}', 399);
INSERT INTO alkis_stricharten(id) VALUES (100);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (100, 100, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (144, 0, 2, 2523, '100', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2524, '360', '{"Freileitung"}', 399);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (145, 0, 2, 2524, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2525, '250', '{"Bahn im Freizeitpark, Gleis","Bergbahn, Seilbahn, Gleis","Eisenbahn, Gleis","Güterverkehr, Gleis","Magnetschwebebahn, Gleis","Museumsbahn, Gleis","S-Bahn, Gleis","Sonstige Bahnkategorie, Gleis","Stadtbahn, Gleis","Standseilbahn, Gleis","Straßenbahn, Gleis","U-Bahn, Gleis","Zahnradbahn, Gleis"}', 399);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (146, 0, 2, 2525, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '2526', '130', '{"Sicherheitstor"}', '400', NULL, '29');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2527, '250', '{"Fahrbahnbegrenzungslinie"}', 400);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (147, 0, 2, 2527, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2530, '300', '{"Steg"}', 401);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (148, 0, 2, 2530, NULL, 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '16', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2531, '211', '{"Böschung, Kliff","Geländekante, Böschungsoberkante","Geländekante, Böschungsunterkante","Geländekante, Allgemeine Geländekante (z.B. Trennschraffe)"}', 401);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (149, 0, 2, 2531, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2533, '410', '{"Widerlager"}', 401);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (150, 0, 2, 2533, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '16', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2535, '130', '{"Fußweg (Weg, Pfad, Steig)","Karren- und Ziehweg","Rad- und Fußweg (Weg, Pfad, Steig)","Radweg (Weg, Pfad, Steig)","Reitweg (Weg, Pfad, Steig)","Skaterstrecke","Weg, Pfad, Steig"}', 402);
INSERT INTO alkis_stricharten(id) VALUES (101);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (101, 101, 0, 36);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (151, 0, 2, 2535, '101', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2537, '130', '{"Wattenweg"}', 402);
INSERT INTO alkis_stricharten(id) VALUES (102);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (102, 102, 0, 37);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (152, 0, 2, 2537, '102', 'Abgeschnitten', 'Spitz', '35', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2539, '130', '{"(Kletter-) Steig im Gebirge"}', 403);
INSERT INTO alkis_stricharten(id) VALUES (103);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (103, 103, 0, 38);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (153, 0, 2, 2539, '103', 'Rund', 'Rund', '70', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2560, '340', '{"Bach, verdolt","Bach, verrohrt, unterirdisch, bedeckt","Durchlass","Fleet, verdolt","Fleet, verrohrt, unterirdisch, bedeckt","Graben, verdolt","Graben, verrohrt, unterirdisch, bedeckt","Rohrdurchlass","Siel","Untergeordnetes Gewässer, verdolt","Untergeordnetes Gewässer, verrohrt, unterirdisch, bedeckt"}', 403);
INSERT INTO alkis_stricharten(id) VALUES (104);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (104, 104, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (154, 0, 2, 2560, '104', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2561, '340', '{"Düker"}', 404);
INSERT INTO alkis_stricharten(id) VALUES (105);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (105, 105, 0, 39);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (155, 0, 2, 2561, '105', 'Rund', 'Rund', '100', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2592, '130', '{"Bach","Fleet","Graben","Grabenkante links","Grabenkante rechts","Grabenmitte","Linienverkehr","Untergeordnetes Gewässer"}', 404);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (156, 0, 2, 2592, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2593, '130', '{"Bach, nicht ständig Wasser führend","Fleet, nicht ständig Wasser führend","Graben, nicht ständig Wasser führend","Grabenkante links, nicht ständig Wasser führend","Grabenkante rechts, nicht ständig Wasser führend","Grabenmitte, nicht ständig Wasser führend","Untergeordnetes Gewässer, nicht ständig Wasser führend"}', 405);
INSERT INTO alkis_stricharten(id) VALUES (106);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (106, 106, 0, 35);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (157, 0, 2, 2593, '106', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2595, '130', '{"Bach, trocken, versiegt","Fleet, trocken, versiegt","Graben, trocken, versiegt","Grabenkante links, trocken versiegt","Grabenkante rechts, trocken versiegt","Grabenmitte, trocken versiegt","Untergeordnetes Gewässer, trocken, versiegt"}', 405);
INSERT INTO alkis_stricharten(id) VALUES (107);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (107, 107, 0, 40);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (158, 0, 2, 2595, '107', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2609, '140', '{"Autofährverkehr","Autofährverkehr, Eisenbahnfährverkehr","Eisenbahnfährverkehr","Personenfährverkehr","Schifffahrtslinie, Fährverkehr"}', 406);
INSERT INTO alkis_stricharten(id) VALUES (108);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (108, 108, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (159, 0, 2, 2609, '108', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2620, '130', '{"Damm, Wall, Deich","Graben mit Knick links","Graben mit Knick rechts","Graben mit Wall links","Graben mit Wall rechts","Knick","Knickkante links","Knickkante rechts","Knickmitte","Wallkante links","Wallkante rechts","Wallmitte"}', 407);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (160, 0, 2, 2620, NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2622, '104', '{"Steilrand, Kliff"}', 408);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (161, 0, 2, 2622, NULL, 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2623, '300', '{"Gebäude, nach Quellenlage nicht zu spezifizieren, Hochhaus","Gebäude für öffentliche Zwecke, Hochhaus","Gebäude für Wirtschaft oder Gewerbe, Hochhaus","Wohngebäude, Hochhaus"}', 409);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (162, 0, 2, 2623, NULL, 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2670, '120', '{"Höhenlinie 20m"}', 409);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (163, 0, 2, 2670, NULL, 'Abgeschnitten', 'Rund', '25', NULL, NULL, '18', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2672, '120', '{"Höhenlinie 10m"}', 409);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (164, 0, 2, 2672, NULL, 'Abgeschnitten', 'Rund', '18', NULL, NULL, '18', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2674, '120', '{"Höhenlinie 5m"}', 410);
INSERT INTO alkis_stricharten(id) VALUES (109);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (109, 109, 0, 41);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (165, 0, 2, 2674, '109', 'Abgeschnitten', 'Rund', '18', NULL, NULL, '18', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2676, '120', '{"Höhenlinie 2,5m"}', 410);
INSERT INTO alkis_stricharten(id) VALUES (110);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (110, 110, 0, 42);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (166, 0, 2, 2676, '110', 'Abgeschnitten', 'Rund', '18', NULL, NULL, '18', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2678, '120', '{"Höhenlinie 1m"}', 411);
INSERT INTO alkis_stricharten(id) VALUES (111);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (111, 111, 0, 43);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (167, 0, 2, 2678, '111', 'Abgeschnitten', 'Rund', '18', NULL, NULL, '18', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2680, '120', '{"Höhenlinie 0,5","Höhenlinie 0,25"}', 411);
INSERT INTO alkis_stricharten(id) VALUES (112);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (112, 112, 0, 44);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (168, 0, 2, 2680, '112', 'Abgeschnitten', 'Rund', '18', NULL, NULL, '18', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2701, '600', '{"Zuordnungspfeil der Bodenschätzung"}', 411);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (169, 0, 2, 2701, NULL, 'Pfeil', 'Spitz', '25', '120', '150', '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2703, '600', '{"Klassenflächengrenze"}', 412);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (170, 0, 2, 2703, NULL, 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2705, '600', '{"Klassenabschnittsgrenze"}', 412);
INSERT INTO alkis_stricharten(id) VALUES (113);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (113, 113, 0, 35);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (171, 0, 2, 2705, '113', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 2707, '600', '{"Sonderflächengrenze"}', 413);
INSERT INTO alkis_stricharten(id) VALUES (114);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (114, 114, 0, 45);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (172, 0, 2, 2707, '114', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_stricharten(id) VALUES (115);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (115, 115, 0, 46);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (173, 1, 2, 2707, '115', 'Rund', 'Rund', '100', NULL, NULL, '35', NULL);
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (60,4, NULL, 50, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (61,2, NULL, 35, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (62,4, NULL, 10, 'Rund', 'Rund');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (63,2, NULL, 25, 'Abgeschnitten', NULL);
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (64,35, NULL, 35, 'Rund', 'Rund');
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4052', '381', '{"Schriftformat N 5 381"}', '629', 'Arial', 'Normal', '5', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4060', '380', '{"Schriftformat N 6 380"}', '629', 'Arial', 'Normal', '6', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4070', '380', '{"Schriftformat N 7 380"}', '629', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4071', '700', '{"Schriftformat N 7 700 liB"}', '630', 'Arial', 'Normal', '7', 'Basis', 'linksbündig', '4', 'LL', '7', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4072', '690', '{"Schriftformat N 7 690 grau liB"}', '630', 'Arial', 'Normal', '7', 'Basis', 'linksbündig', '3', 'LL', '7', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4073', '380', '{"Schriftformat N 7 380"}', '630', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4074', '380', '{"Schriftformat F 7 380"}', '631', 'Arial', 'Fett', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4080', '380', '{"Schriftformat N 8"}', '631', 'Arial', 'Normal', '8', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4081', '380', '{"Schriftformat F 8"}', '631', 'Arial', 'Fett', '8', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4100', '380', '{"Schriftformat N 10"}', '632', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4101', '380', '{"Schriftformat N 10 liM"}', '632', 'Arial', 'Normal', '10', 'Mitte', 'linksbündig', '4', 'CL', '4', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4102', '380', '{"Schriftformat N 10 reM"}', '633', 'Arial', 'Normal', '10', 'Mitte', 'rechtsbündig', '4', 'CR', '6', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4103', '380', '{"Schriftformat N 10"}', '633', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4104', '380', '{"Schriftformat N 6 grau 30"}', '633', 'Arial', 'Normal', '6', NULL, NULL, '18', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4105', '380', '{"Schriftformat N 10"}', '634', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4106', '600', '{"Schriftformat N 10 grau 60"}', '634', 'Times New Roman', 'Normal', '10', NULL, NULL, '35', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4107', '420', '{"Schriftformat F 10"}', '634', 'Arial', 'Fett', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4108', '380', '{"Schriftformat F 7 380"}', '635', 'Arial', 'Fett', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4109', '380', '{"Schriftformat F 10"}', '635', 'Arial', 'Fett', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4111', '700', '{"Schriftformat K 10 700"}', '635', 'Arial', 'Kursiv', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4112', '690', '{"Schriftformat K 10 grau"}', '636', 'Arial', 'Kursiv', '10', NULL, NULL, '3', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4113', '700', '{"Schriftformat K 10 700"}', '636', 'Arial', 'Kursiv', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4114', '600', '{"Schriftformat N 10 grau unterstrichen"}', '636', 'Times New Roman', 'Unterstrichen', '10', NULL, NULL, '35', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4115', '700', '{"Schriftformat K 10 700"}', '637', 'Arial', 'Kursiv', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4116', '380', '{"Schriftformat F K 10"}', '637', 'Arial', 'Fett, Kursiv', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4117', '380', '{"Schriftformat F K 10"}', '637', 'Arial', 'Fett, Kursiv', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4118', '380', '{"Schriftformat F K 7 schwarz"}', '638', 'Arial', 'Fett, Kursiv', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4119', '600', '{"Schriftformat N 10 schwarz"}', '638', 'Times New Roman', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4120', '380', '{"Schriftformat F 12"}', '638', 'Arial', 'Fett', '12', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4121', '380', '{"Schriftformat TNR grau","Legende (Bodenschätzung)"}', '611', 'Times New Roman', 'Normal', '12', NULL, NULL, '35', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4122', '690', '{"Schriftformat K 10 grau"}', '639', 'Arial', 'Kursiv', '10', NULL, NULL, '3', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4123', '690', '{"Schriftformat K 10 grau"}', '639', 'Arial', 'Kursiv', '10', NULL, NULL, '3', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4140', '380', '{"Schriftformat N 14"}', '639', 'Arial', 'Normal', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4141', '380', '{"Schriftformat F 14"}', '640', 'Arial', 'Fett', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4143', '380', '{"Schriftformat F 14 grau"}', '640', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4144', '380', '{"Schriftformat F 14 grau"}', '640', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4147', '600', '{"Schriftformat N 14 TNR grau"}', '641', 'Times New Roman', 'Normal', '14', NULL, NULL, '35', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4148', '600', '{"Schriftformat N 14 TNR grau"}', '641', 'Times New Roman', 'Normal', '14', NULL, NULL, '35', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4149', '600', '{"Schriftformat N 14 TNR grau"}', '641', 'Times New Roman', 'Normal', '14', NULL, NULL, '35', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4150', '380', '{"Schriftformat F K 14"}', '642', 'Arial', 'Fett, Kursiv', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4151', '380', '{"Schriftformat F K 14"}', '642', 'Arial', 'Fett, Kursiv', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4160', '380', '{"Schriftformat F 16"}', '642', 'Arial', 'Fett', '16', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4200', '380', '{"Schriftformat F 20"}', '643', 'Arial', 'Fett', '20', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4206', '380', '{"Schriftformat F K 20 gesperrt"}', '643', 'Arial', 'Fett, Kursiv', '20', NULL, NULL, '4', NULL, NULL, '10', NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4208', '380', '{"Schriftformat F K 20"}', '643', 'Arial', 'Fett, Kursiv', '20', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4209', '380', '{"Schriftformat F K 20"}', '644', 'Arial', 'Fett, Kursiv', '20', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4211', '380', '{"Schriftformat F K 20"}', '644', 'Arial', 'Fett, Kursiv', '20', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4243', '380', '{"Schriftformat F K 24"}', '644', 'Arial', 'Fett, Kursiv', '24', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '4286', '380', '{"Schriftformat F K 28"}', '646', 'Arial', 'Fett, Kursiv', '28', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7800', '350', '{"Gebäudefunktion"}', '676', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7801', '380', '{"Stadt - Gemeindename"}', '676', 'Arial', 'Fett', '28', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7852', '380', '{"Bundeswasserstraße (Schriftzusatz)"}', '677', 'Arial', 'Fett, Kursiv', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7854', '380', '{"Gewässer I. Ordnung - nach Landesrecht (Schriftzusatz)"}', '677', 'Arial', 'Fett, Kursiv', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7856', '380', '{"Gewässer II. Ordnung (Schriftzusatz)"}', '677', 'Arial', 'Fett, Kursiv', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7858', '380', '{"Gemeindeverbindungsstraße (Schriftzusatz)"}', '678', 'Arial', 'Normal', '14', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7859', '380', '{"Festgesetztes Überschwemmungsgebiet (Schriftzusatz)"}', '678', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7861', '380', '{"Wasserschutzgebiet (Schriftzusatz)"}', '679', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7863', '380', '{"Veränderungssperre nach Baugesetzbuch (Schriftzusatz)"}', '679', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7865', '380', '{"Baulast (Schriftzusatz)"}', '679', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7867', '380', '{"Landschaftsschutzgebiet (Schriftzusatz)"}', '680', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7869', '380', '{"Naturpark (Schriftzusatz)"}', '680', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7871', '380', '{"Naturdenkmal (Schriftzusatz)"}', '681', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7873', '380', '{"Belastungsgebiet (Schriftzusatz)"}', '681', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7875', '380', '{"Lärmschutz (Schriftzusatz)"}', '681', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7877', '380', '{"Übergabebescheidverfahren (Schriftzusatz)"}', '682', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7879', '380', '{"Jagdkataster (Schriftzusatz)"}', '682', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7881', '380', '{"Truppenübungsplatz, Standortübungsplatz (Schriftzusatz)"}', '683', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext('POINT(0 0)'::text,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7900', '380', '{"Schriftformat N 10"}', '629', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7930', '700', '{"Schriftformat N 10"}', '629', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7931', '700', '{"Schriftformat N 10"}', '629', 'Arial', 'Normal', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '7932', '700', '{"Schriftformat N 7"}', '629', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '8002', '350', '{"Schriftformat N 7"}', '629', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '8111', '380', '{"Schriftformat F 11"}', '616', 'Arial', 'Fett', '11', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '8112', '699', '{"Schriftformat N 7 380 liM"}', '616', 'Arial', 'Unterstrichen', '7', 'Mitte', 'linksbündig', '4', 'CL', '4', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '8118', '380', '{"Schriftformat TNR grau","Legende (Bodenschätzung)"}', '619', 'Times New Roman', 'Normal', '12', NULL, NULL, '35', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '8120', '380', '{"Schriftformat N 6 grau 30 liM"}', '619', 'Arial', 'Normal', '6', 'Mitte', 'linksbündig', '18', 'CL', '4', NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '8121', '380', '{"Schriftformat F 24"}', '619', 'Arial', 'Fett', '24', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', '8124', '420', '{"Schriftformat N 7 380 freigestellt"}', '620', 'Arial', 'Normal', '7', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 8201, '304', '{"Carport, in ihrer Lage nur ungefähr bekannt","Gebäude für öffentliche Zwecke, aufgeständert,","in ihrer Lage nur ungefähr bekannt","Gebäude für öffentliche Zwecke, in ihrer Lage nur ungefähr bekannt","Gebäude für Wirtschaft oder Gewerbe, aufgeständert, in ihrer Lage nur ungefähr bekannt","Gebäude für Wirtschaft oder Gewerbe, in ihrer Lage nur ungefähr bekannt","Gebäude - Nach Quellenlage nicht zu spezifizieren, aufgeständert,","in ihrer Lage nur ungefähr bekannt","Gebäude - Nach Quellenlage nicht zu spezifizieren, in ihrer Lage nur ungefähr bekannt","Überdachung, in ihrer Lage nur ungefähr bekannt","Wohngebäude, aufgeständert, in ihrer Lage nur ungefähr bekannt","Wohngebäude, in ihrer Lage nur ungefähr bekannt","Legende (Gebäude)"}', 376);
INSERT INTO alkis_stricharten(id) VALUES (116);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (116, 116, 0, 47);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (174, 0, 2, 8201, '116', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_stricharten(id) VALUES (117);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (117, 117, 0, 48);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (175, 1, 2, 8201, '117', 'Rund', 'Rund', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 8205, '305', '{"Gebäude für öffentliche Zwecke, Hochhaus, aufgeständert,","in ihrer Lage nur ungefähr bekannt","Gebäude für öffentliche Zwecke, Hochhaus, in ihrer Lage nur ungefähr bekannt","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, aufgeständert, in ihrer Lage nur ungefähr bekannt","Gebäude für Wirtschaft oder Gewerbe, Hochhaus, in ihrer Lage nur ungefähr bekannt","Gebäude - Nach Quellenlage nicht zu spezifizieren, Hochhaus, aufgeständert,","in ihrer Lage nur ungefähr bekannt","Gebäude - Nach Quellenlage nicht zu spezifizieren, Hochhaus, in ihrer Lage nur ungefähr bekannt","Wohngebäude, Hochhaus, aufgeständert, in ihrer Lage nur ungefähr bekannt","Wohngebäude, Hochhaus, in ihrer Lage nur ungefähr bekannt"}', 377);
INSERT INTO alkis_stricharten(id) VALUES (118);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (118, 118, 0, 47);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (176, 0, 2, 8205, '118', 'Abgeschnitten', 'Spitz', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_stricharten(id) VALUES (119);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (119, 119, 0, 48);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (177, 1, 2, 8205, '119', 'Rund', 'Rund', '50', NULL, NULL, '4', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '8207', '103', '{"Sonstiges Gewässermerkmal"}', '332', NULL, '5');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 8208, '270', '{"Hecke"}', 378);
INSERT INTO alkis_stricharten(id) VALUES (120);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (120, 120, 0, 49);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (178, 0, 2, 8208, '120', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '18', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 8223, '211', '{"Geländekante, Böschungsoberkante, unsicher","Geländekante, Böschungsunterkante, unsicher","Geländekante, Sonstige Begrenzungskante (z.B. Trennschraffe), unsicher"}', 363);
INSERT INTO alkis_stricharten(id) VALUES (121);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (121, 121, 0, 3);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (179, 0, 2, 8223, '121', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 8225, '250', '{"Durchlass","Rohrdurchlass","Siel"}', 366);
INSERT INTO alkis_stricharten(id) VALUES (122);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (122, 122, 0, 30);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (180, 0, 2, 8225, '122', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '2', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', '8515', '250', '{"Durchlass","Rohrdurchlass","Siel"}', '332', NULL, '3');
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 'KS_2001', '340', '{"Linie (Voreinstellung)","Fahrradständer","Zaun"}', 40);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (181, 0, 2, 'KS_2001', NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 'KS_2002', '340', '{"städtischer Entwässerungsgraben","Rinne","Leitmarkierung unterbrochen","Rohrdurchlass"}', 40);
INSERT INTO alkis_stricharten(id) VALUES (123);
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (123, 123, 0, 35);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (182, 0, 2, 'KS_2002', '123', 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 'KS_2003', '340', '{"Barriere","sonstige Absperrung"}', 41);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (183, 0, 2, 'KS_2003', NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_stricharten(id) VALUES (124);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (51, '100', '200', '{"400"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (124, 124, 0, 51);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (184, 1, 2, 'KS_2003', '124', 'Abgeschnitten', 'Spitz', '100', NULL, NULL, '4', NULL);
INSERT INTO alkis_linien(katalog,signaturnummer,darstellungsprioritaet,name,seite) VALUES (2, 'KS_2004', '340', '{"Leitplanke"}', 42);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (185, 0, 2, 'KS_2004', NULL, 'Abgeschnitten', 'Spitz', '18', NULL, NULL, '4', NULL);
INSERT INTO alkis_stricharten(id) VALUES (125);
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (52, '0', '200', '{"400"}');
INSERT INTO alkis_stricharten_i(id,stricharten,i,strichart) VALUES (125, 125, 0, 52);
INSERT INTO alkis_linie(id,i,katalog,signaturnummer,strichart,abschluss,scheitel,strichstaerke,pfeilhoehe,pfeillaenge,farbe,position) VALUES (186, 1, 2, 'KS_2004', '125', 'Rund', 'Rund', '100', NULL, NULL, '4', NULL);
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', 'KS_3001', '300', '{"Fläche (Voreinstellung)"}', '43', '3', '1');
INSERT INTO alkis_strichart(id,laenge,einzug,abstand) VALUES (53, '300', '50', '{"300"}');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (65,4, '53', 100, 'Rund', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', 'KS_3002', '400', '{"KS_BauRaumOderBauordnungsrecht"}', '43', NULL, '65');
INSERT INTO alkis_randlinie(id,farbe,strichart,strichstaerke,abschluss,scheitel) VALUES (66,4, '53', 100, 'Abgeschnitten', 'Spitz');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', 'KS_3003', '400', '{"KS_KommunalerBesitz"}', '44', NULL, '66');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', 'RP1703', '340', '{"Natur-, Umwelt- oder Bodenschutzrecht"}', '684', NULL, '58');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', 'RP1704', '430', '{"Bau-, Raum- oder Bodenordnungsrecht","Denkmalschutzrecht","Natur-, Umwelt- oder Bodenschutzrecht","Sonstiges Recht"}', '2', NULL, '58');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', 'RP1705', '340', '{"Wasserrecht"}', '3', NULL, '58');
INSERT INTO alkis_flaechen(katalog,signaturnummer,darstellungsprioritaet,name,seite,farbe,randlinie) VALUES ('2', 'RP1740', '600', '{"Musterstück"}', '3', NULL, '59');
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4075', '380', '{"Schriftformat F 7 grau"}', '22', 'Arial', 'Fett', '7', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4076', '380', '{"Schriftformat F 7 grau"}', '23', 'Arial', 'Fett', '7', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4083', '420', '{"Schriftformat N 8 BLISS 2"}', '24', 'BLISS 2 regular', 'Normal', '8', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4117', '420', '{"Schriftformat F K 10"}', '25', 'Arial', 'Fett, Kursiv', '10', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4143', '380', '{"Schriftformat F 14 grau"}', '26', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4144', '380', '{"Schriftformat F 14 grau"}', '27', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4145', '380', '{"Schriftformat F 14 grau"}', '28', 'Arial', 'Fett', '14', NULL, NULL, '2', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4147', '600', '{"Schriftformat N 14 TNR grau"}', '28', 'Times New Roman', 'Normal', '14', NULL, NULL, '35', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4148', '600', '{"Schriftformat N 14 TNR grau"}', '29', 'Times New Roman', 'Normal', '14', NULL, NULL, '35', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4149', '600', '{"Schriftformat N 14 TNR grau"}', '30', 'Times New Roman', 'Normal', '14', NULL, NULL, '35', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));
INSERT INTO alkis_schriften(katalog,signaturnummer,darstellungsprioritaet,name,seite,art,stil,grad_pt,horizontaleausrichtung,vertikaleausrichtung,farbe,alignment_umn,alignment_dxf,sperrung_pt,effekt,position) VALUES ('2', 'RP4243', '380', '{"Schriftformat F K 24"}', '31', 'Arial', 'Fett, Kursiv', '24', NULL, NULL, '4', NULL, NULL, NULL, NULL,st_geomfromtext(NULL,0));

\i alkis-punktsignaturen.sql;
