/***************************************************************************
 *                                                                         *
 * Project:  norGIS ALKIS Import                                           *
 * Purpose:  Aus der GeoInfoDok geparste Kataloge                          *
 * Author:   Jürgen E. Fischer <jef@norbit.de>                             *
 *                                                                         *
 ***************************************************************************
 * Copyright (c) 2012-2018, Jürgen E. Fischer <jef@norbit.de>              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

BEGIN;
SELECT alkis_dropobject('alkis_methode');
SELECT alkis_dropobject('alkis_attributart');
SELECT alkis_dropobject('alkis_relationsart');
SELECT alkis_dropobject('alkis_elemente');
CREATE TABLE alkis_elemente(objekttyp varchar,abgeleitet_aus varchar[],erfassungskriterien text,lebenszeitintervall text,konsistenzbedingungen text,bildungsregeln text,definition text,name varchar,modellart varchar,grunddatenbestand varchar,type varchar,kennung varchar,PRIMARY KEY (name));
CREATE TABLE alkis_relationsart(definition varchar,grunddatenbestand varchar,zielobjektart varchar,inv__relation varchar,Kennung varchar,anmerkung varchar,bezeichnung varchar not null,modellart varchar,kardinalitaet varchar,element varchar NOT NULL,PRIMARY KEY (element,kennung,bezeichnung),FOREIGN KEY (element) REFERENCES alkis_elemente(name));
CREATE TABLE alkis_attributart(grunddatenbestand varchar,definition varchar,datentyp varchar,bezeichnung varchar NOT NULL,modellart varchar,kardinalitaet varchar,kennung varchar,element varchar NOT NULL,PRIMARY KEY (element,bezeichnung),FOREIGN KEY (element) REFERENCES alkis_elemente(name));
CREATE TABLE alkis_methode(definition varchar,bezeichnung varchar NOT NULL,element varchar NOT NULL,PRIMARY KEY (element,bezeichnung),FOREIGN KEY (element) REFERENCES alkis_elemente(name));
INSERT INTO alkis_elemente(abgeleitet_aus,modellart,name,type,kennung,objekttyp,definition,bildungsregeln) VALUES ('{"ax_netzpunkt"}','DLKM','ax_sonstigervermessungspunkt','Objektart','13003','ZUSO','[E] ''Sonstiger Vermessungspunkt'' ist ein Punkt des Aufnahmepunktfeldes, der weder Aufnahmepunkt noch Sicherungspunkt ist (z. B. Polygonpunkt, Liniennetzpunkt).','Das ZUSO besteht das aus einem oder mehreren REO ''Punktort''.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','"Sonstiger Vermessungspunkt" hat "Sicherungspunkt"','ax_sicherungspunkt','13003-13002','beziehtSichAuf','ax_sonstigervermessungspunkt','DLKM','hat');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ART','''Art'' beschreibt die Art des sonstigen Vermessungspunktes.','ax_sonstigervermessungspunkt','DLKM','art');
INSERT INTO alkis_elemente(abgeleitet_aus,modellart,name,type,kennung,objekttyp,definition) VALUES ('{"au_punktobjekt","ax_bauwerkeeinrichtungenundsonstigeangaben"}','DLKM','ax_heilquellegasquelle','Objektart','51008','REO','[E] ''Heilquelle, Gasquelle'' ist eine natürliche, örtlich begrenzte Austrittsstelle von Heilwasser oder Gas.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Art_HeilquelleGasquelle','ART','''Art'' charakterisiert die Heilquelle, Gasquelle.','ax_heilquellegasquelle','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_HydrologischesMerkmal_HeilquelleGasquelle','HYD','''Hydrologische Merkmal'' gibt die Schüttungsverhältnisse von Heilquelle, Gasquelle an.','ax_heilquellegasquelle','DLKM','hydrologischesmerkmal');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist die der Objektart zugehörige Bezeichnung oder deren Eigenname.','ax_heilquellegasquelle','DLKM','name');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Die Attributart ''Oberflächenmaterial'' kann nur im Zusammenhang mit der Attributart ''Funktion'' und der Werteart 1000 vorkommen.','ax_unlandvegetationsloseflaeche','DLKM','43007','REO','[E] ''Unland/Vegetationslose Fläche'' ist eine Fläche, die dauerhaft landwirtschaftlich nicht genutzt wird, wie z.B. nicht aus dem Geländerelief herausragende Felspartien, Sand- oder Eisflächen, Uferstreifen längs von Gewässern und Sukzessionsflächen.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_UnlandVegetationsloseFlaeche','FKT','''Funktion ist die erkennbare Art von ''Unland/Vegetationslose Fläche''.','ax_unlandvegetationsloseflaeche','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist die Bezeichnung oder der Eigenname von ''Unland/VegetationsloseFlaeche''.','ax_unlandvegetationsloseflaeche','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Oberflaechenmaterial_UnlandVegetationsloseFlaeche','OFM','''Oberflächenmaterial'' ist die Beschaffenheit des Bodens von ''Unland/Vegetationslose Fläche''.','ax_unlandvegetationsloseflaeche','DLKM','oberflaechenmaterial');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Die ''Besondere Flurstücksgrenze'' ist identisch mit 1 bis n Kanten der Masche, die zur Vermittlung des Raumbezugs des entsprechenden ''Flurstücks'' beiträgt. Bei der Attributart ''Art der Flurstücksgrenze'' ist für die Wertearten 3000, 7003 und 7102 die Übereinstimmung mit den Informationen im Flurstückskennzeichen sicherzustellen. Wird bei der Attributart ''Art der Flurstücksgrenze'' die Werteart 2001 (Nicht festgestellte Grenze) generell nicht erfasst, sind die Grenzen des Flurstücks nur durch den Raumbezug des Flurstücks definiert und es erfolgt grundsätzlich keine Aussage hinsichtlich der Feststellung der Grenze. Gegebenenfalls ist in den länderspezifischen Ausgaben darauf hinzuweisen.','ax_besondereflurstuecksgrenze','DLKM','11002','REO','[E] ''Besondere Flurstücksgrenze'' ist ein Teil der Grenzlinie eines Flurstücks, der von genau zwei benachbarten Grenzpunkten begrenzt wird und für den besondere Informationen vorliegen.','{"ta_curvecomponent"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1..*','AX_ArtDerFlurstuecksgrenze_BesondereFlurstuecksgrenze','DLKM','ARF','''Art der Flurstücksgrenze '' ist die Benennung der besonderen Information zur Flurstücksgrenze. Es sind jeweils alle Funktionen, die eine Flurstücksgrenze in sich vereinigt, auch explizit zu führen.','ax_besondereflurstuecksgrenze','DLKM','artderflurstuecksgrenze');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type) VALUES ('ax_li_processstep_punktort','14009','Die Erhebungsstelle wird in einem AX_LI_ProcessStep mit self.description = ''Erhebung'' und der Erhebungsstelle in self.processor dokumentiert.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..*','AX_LI_Source_Punktort','SRC','ax_li_processstep_punktort','DLKM','source');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','CI_ResponsibleParty','PRO','ax_li_processstep_punktort','DLKM','processor');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','DateTime','DAT','ax_li_processstep_punktort','DLKM','datetime');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,element,modellart,bezeichnung) VALUES ('1','AX_LI_ProcessStep_Punktort_Description','DLKM','DES','ax_li_processstep_punktort','DLKM','description');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_hoehleneingang','61005','REO','[E] ''Höhleneingang'' ist die Öffnung eines unterirdischen Hohlraumes an der Erdoberfläche.','{"au_punktobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Höhleneingang''.','ax_hoehleneingang','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qualitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_hoehleneingang','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Hoehleneingang','ZUS','''Zustand'' ist der Zustand von ''Höhleneingang''.','ax_hoehleneingang','DLKM','zustand');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Der ''Besondere Gebäudepunkt'' und der ihm zugeordnete ''Punktort'' mit der Attributart ''Liegenschaftskarte'' und der Werteart TRUE erhält den Raumbezug durch einen Punkt der Fläche oder der Linie, die zur Vermittlung des Raumbezuges des entsprechenden ''Gebäudes'' oder ''Bauteils'' beiträgt.','ax_besonderergebaeudepunkt','31005','ZUSO','[E] ''Besonderer Gebäudepunkt'' ist ein Punkt eines ''Gebäudes'' oder eines ''Bauteils''.','{"aa_zuso"}','DLKM','Objektart','Das ZUSO besteht aus einem oder mehreren REO ''Punktort''.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Art_Gebaeudepunkt','ART','''Art'' enthält die Art des Gebäudepunktes.','ax_besonderergebaeudepunkt','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','PKN','''Punktkennung'' ist ein von der Katasterbehörde vergebenes Ordnungsmerkmal.','ax_besonderergebaeudepunkt','DLKM','punktkennung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','ZST','''Zuständige Stelle'' enthält den Namen der Stelle, die eine Zuständigkeit besitzt.','ax_besonderergebaeudepunkt','DLKM','zustaendigestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','SOE','''Sonstige Eigenschaft'' sind Informationen zum ''Besonderen Gebäudepunkt''. Sonstige Eigenschaften werden im Rahmen der Migration aus bestehenden Verfahrenslösungen übernommen.','ax_besonderergebaeudepunkt','DLKM','sonstigeeigenschaft');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_meer','DLKM','44007','REO','[E] ''Meer'' ist die das Festland umgebende Wasserfläche.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Meer','FKT','''Funktion'' ist die objektiv erkennbare Art von ''Meer''.','ax_meer','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Tidemerkmal_Meer','TID','''Tidemerkmal'' gibt an, ob ''Meer'' von den periodischen Wasserstandsänderungen beeinflusst wird.','ax_meer','DLKM','tidemerkmal');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagebezeichnung','NAM','''Name'' ist der Eigenname von ''Meer''.','ax_meer','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von der zuständigen Fachbehörde vergebene Verschlüsselung.','ax_meer','DLKM','bezeichnung');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_personengruppe','DLKM','21002','NREO','[E] ''Personengruppe'' ist die Zusammenfassung von Personen unter einem Ordnungsbegriff.','{"aa_nreo"}','DLKM','Objektart');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('2..*','Ein Objekt ''Personengruppe'' besteht aus Objekten ''Person''. Es handelt sich um die inverse Relationsrichtung.','ax_person','DLKM','(INV)21001-21002','gehoertZu','ax_personengruppe','DLKM','bestehtAus');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','PGR','''Name der Personengruppe'' ist ein Ordnungsbegriff, unter dem Personen zusammengefasst sind.','ax_personengruppe','DLKM','namederpersonengruppe');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,definition,abgeleitet_aus,modellart,type) VALUES ('ax_flurstueck_kerndaten','DLKM','11004','''Flurstück_Kerndaten'' enthält Eigenschaften des Flurstücks, die auch für andere Flurstücksobjektarten gelten (z.B. Historisches Flurstück). Es handelt sich um eine abstrakte Objektart.','{}','DLKM','Element');
INSERT INTO alkis_methode(definition,element,bezeichnung) VALUES ('Typ des Rückgabewerts: CharacterString','ax_flurstueck_kerndaten','AX_Flurstueck_Kerndaten::bildeFlurstueckskennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Gemeindekennzeichen','GDZ','''Gemeindezugehörigkeit'' enthält das Gemeindekennzeichen zur Zuordnung der Flustücksdaten zu einer Gemeinde.','ax_flurstueck_kerndaten','DLKM','gemeindezugehoerigkeit');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Flurstuecksnummer','DLKM','FSN','''Flurstücksnummer'' ist die Bezeichnung (Zähler/Nenner), mit der ein Flurstück innerhalb einer Flur (Flurnummer muss im Land vorhanden sein) oder Gemarkung identifiziert werden kann. Das Attribut setzt sich zusammen aus: 1. Spalte: Zähler 2. Spalte: Nenner Die 2. Spalte ist optional.','ax_flurstueck_kerndaten','DLKM','flurstuecksnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Gemarkung_Schluessel','DLKM','GMK','''Gemarkung'' enthält die Eigenschaften aus dem Datentyp ''AX_Gemarkung_Schlüssel'': ''land'' und ''gemarkungsnummer''.','ax_flurstueck_kerndaten','DLKM','gemarkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','ZFM','''Zweifelhafter Flurstücksnachweis'' ist eine Kennzeichnung eines Flurstücks, dessen Angaben nicht zweifelsfrei berichtigt werden können.','ax_flurstueck_kerndaten','DLKM','zweifelhafterflurstuecksnachweis');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','Area','DLKM','AFL','''Amtliche Fläche'' ist der im Liegenschaftskataster festgelegte Flächeninhalt des Flurstücks in [qm]. Flurstücksflächen kleiner 0,5 qm können mit bis zu zwei Nachkommastellen geführt werden, ansonsten ohne Nachkommastellen.','ax_flurstueck_kerndaten','DLKM','amtlicheflaeche');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Integer','DLKM','FLN','''Flurnummer'' ist die von der Katasterbehörde zur eindeutigen Bezeichnung vergebene Nummer einer Flur, die eine Gruppe von zusammenhängenden Flurstücken innerhalb einer Gemarkung umfasst.','ax_flurstueck_kerndaten','DLKM','flurnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','ARZ','''Abweichender Rechtszustand'' ist ein Hinweis darauf, dass außerhalb des Grundbuches in einem durch Gesetz geregelten Verfahren der Bodenordnung (siehe Objektart "Bau-, Raum- oder Bodenordnungsrecht", AA "Art der Festlegung", Werte 1750, 1770, 2100 bis 2340) ein neuer Rechtszustand eingetreten ist und das amtliche Verzeichnis der jeweiligen ausführenden Stelle maßgebend ist.','ax_flurstueck_kerndaten','DLKM','abweichenderrechtszustand');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','(DER) FSK','''Flurstückskennzeichen'' ist ein von der Katasterbehörde zur eindeutigen Bezeichnung des Flurstücks vergebenes Ordnungsmerkmal. Bildungsregel: Die Attributart setzt sich aus den nachfolgenden expliziten Attributarten in der angegebenen Reihenfolge zusammen: 1. Land (2 Stellen) 2. Gemarkungsnummer (4 Stellen) 3. Flurnummer (3 Stellen) 4. Flurstücksnummer 4.1 Zähler (5 Stellen) 4.2 Nenner (4 Stellen) 5. Flurstücksfolge (2 Stellen) Die Elemente sind rechtsbündig zu belegen, fehlende Stellen sind mit führenden Nullen zu belegen. Da die Flurnummer und die Flurstücksfolge optional sind, sind aufgrund der bundeseinheitlichen Definition im Flurstückskennzeichen die entsprechenden Stellen, sofern sie nicht belegt sind, durch Unterstrich "_" ersetzt. Gleiches gilt für Flurstücksnummern ohne Nenner, hier ist der fehlende Nenner im Flurstückskennzeichen durch Unterstriche zu ersetzen. Die Gesamtlänge des Flurstückkennzeichens beträgt immer 20 Zeichen. Das Attribut ist ein abgeleitetes Attribut und kann nicht gesetzt werden.','ax_flurstueck_kerndaten','DLKM','flurstueckskennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','RBV','''Rechtsbehelfsverfahren'' ist der Hinweis darauf, dass bei dem Flurstück ein laufendes Rechtsbehelfsverfahren anhängig ist.','ax_flurstueck_kerndaten','DLKM','rechtsbehelfsverfahren');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','FSF','''Flurstücksfolge'' ist eine weitere Angabe zur Flurstücksnummer zum Nachweis der Flurstücksentwicklung.','ax_flurstueck_kerndaten','DLKM','flurstuecksfolge');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','GM_Point','OBK','''Objektkoordinaten'' sind die Koordinaten [mm] eines das Objekt ''Flurstück'' repräsentierenden Punktes in einem amtlichen Lagebezugssystem. Die ''Objektkoordinaten'' sind übergangsweise aus bestehenden Verfahrenslösungen übernommen (Datenmigration).','ax_flurstueck_kerndaten','DLKM','objektkoordinaten');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_SonstigeEigenschaften_Flurstueck','SES','''Sonstige Eigenschaften'' sind flurstücksbezogene Informationen, die in dem Datentyp AX_SonstigeEigenschaften enthalten sind. Die Attributart setzt sich zusammen aus: 1. Kennung, Schlüssel gemäß Festlegung im ALB 2. Fläche des Abschnitts [qm] 3. Angaben zum Abschnitt/Flurstück (unstrukturiert) 4. Angaben zum Abschnitt - Stelle 5. Angaben zum Abschnitt - Nummer, Aktenzeichen 6. Angaben zum Abschnitt - Bemerkung, Die Angaben zum Abschnitt/Flurstück sind unstrukturiert (3. Stelle) oder strukturiert (4. - 6. Stelle). Die Attributart kommt vor wenn sie übergangsweise im Rahmen der Migration aus bestehenden Verfahrenslösungen benötigt wird oder wenn die Angaben nicht als eigenständige raumbezogene Elementarobjekte aus dem Objektbereich ''Gesetzliche Festlegungen, Zuständigkeiten und Gebietseinheiten'' geführt werden.','ax_flurstueck_kerndaten','DLKM','sonstigeeigenschaften');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','ZDE','"Zeitpunkt der Entstehung" ist der Zeitpunkt, zu dem das Flurstück fachlich entstanden ist. Das Attribut kommt vor, wenn der Zeitpunkt der Entstehung von dem Zeitpunkt abweicht, der systemseitig bei der Eintragung in den Bestandsdaten als Anfang der Lebenszeit (siehe Lebenszeitintervall bei Objekten) gesetzt wird. Die Regelungen hierzu sind länderspezifisch gefasst.','ax_flurstueck_kerndaten','DLKM','zeitpunktderentstehung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,type) VALUES ('ap_pto','02341','REO','Textförmiges Präsentationsobjekt mit punktförmiger Textgeometrie.','{"ap_tpo","au_punktobjekt"}','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('0..1','Angle','DWI','Winkel um den der Text oder die Signatur mit punktförmiger Bezugsgeometrie aus der Horizontalen gedreht ist. Angabe im Bogenmaß; Zählweise im mathematisch positiven Sinn (von Ost über Nord nach West und Süd). Das Attribut ist bei Objekterzeugung mit dem Wert 0 vorbelegt.','ap_pto','drehwinkel');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_buchungsblatt','DLKM','21007','NREO','[E] ''Buchungsblatt'' enthält die Buchungen (Buchungsstellen und Namensnummern) des Grundbuchs und des Liegenschhaftskatasters (bei buchungsfreien Grundstücken). Das Buchungsblatt für Buchungen im Liegenschaftskataster kann entweder ein Kataster-, Erwerber-, Pseudo- oder ein Fiktives Blatt sein.','{"aa_nreo"}','DLKM','Objektart','Die Attributart ''Buchungsblattkennzeichen'' ist objektbildend. Beim fiktiven Blatt darf die Relation ''besteht aus'' nur einmal vorkommen.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Buchungsblatt'' besteht aus ''Buchungsstelle''. Bei einem Buchungsblatt mit der Blattart ''Fiktives Blatt'' (Wert 5000) muss die Relation zu einer aufgeteilten Buchung (Wertearten 1101, 1102, 1401 bis 1403, 2201 bis 2205 und 2401 bis 2404) bestehen. Es handelt sich um die inverse Relationsrichtung.','ax_buchungsstelle','DLKM','(INV)21008-21007.2','istBestandteilVon','ax_buchungsblatt','DLKM','bestehtAus');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','(DER) BBK','''Buchungsblattkennzeichen'' ist ein eindeutiges Fachkennzeichen für ein Buchungsblatt. Aufbau Buchungsblattkennzeichen: 1.) Land (Verschlüsselung zweistellig), 2 Ziffern 2.) Buchungsblattbezirk (Verschlüsselung vierstellig), 4 Ziffern 3.) Buchungsblattnummer mit Buchstabenerweiterung (7 Stellen) Die Elemente sind rechtsbündig zu belegen, fehlende Stellen sind mit führenden Nullen zu belegen. Die Gesamtlänge des Buchungsblattkennzeichens beträgt immer 13 Zeichen Das Attribut ist ein abgeleitetes Attribut und kann nicht gesetzt werden.','ax_buchungsblatt','DLKM','buchungsblattkennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Buchungsblattbezirk_Schluessel','DLKM','BBZ','Buchungsblattbezirk des Buchungsblatts.','ax_buchungsblatt','DLKM','buchungsblattbezirk');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Blattart_Buchungsblatt','DLKM','BLT','''Blattart'' ist die Art des Buchungsblattes.','ax_buchungsblatt','DLKM','blattart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','BBN','Buchungsblattnummer mit Buchstabenerweiterung.','ax_buchungsblatt','DLKM','buchungsblattnummermitbuchstabenerweiterung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_wohnplatz','74005','REO','[E] ''Wohnplatz'' ist ein bewohntes Gebiet, das einen Eigennamen trägt.','{"au_punktobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','NAM','''Name'' ist der Eigenname, amtlicher Wohnplatzname von ''Wohnplatz''.','ax_wohnplatz','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ZNM','''Zweitname'' ist ein volkstümlicher Name insbesondere bei Objekten außerhalb von Ortslagen.','ax_wohnplatz','DLKM','zweitname');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type) VALUES ('ax_bauwerkeeinrichtungenundsonstigeangaben','50001','Eine Mixin-Klasse für alle ''Bauwerke, Einrichtungen und sonstigen Angaben''. Es handelt sich um eine abstrakte Objektart.','{}','DLKM','Element');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','QAG','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_bauwerkeeinrichtungenundsonstigeangaben','DLKM','qualitaetsangaben');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_schutzgebietnachwasserrecht','71005','ZUSO','[E] ''Schutzgebiet nach Wasserrecht'' ist ein fachlich übergeordnetes Gebiet von Flächen mit bodenbezogenen Beschränkungen, Belastungen oder anderen Eigenschaften nach öffentlichen, wasserrechtlichen Vorschriften.','{"aa_zuso"}','DLKM','Objektart','Das ZUSO ''Schutzgebiet nach Wasserrecht'' besteht aus einem oder mehreren REO ''Schutzzone''.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_SchutzgebietNachWasserrecht','FKT','''Funktion'' ist eine mit der Festlegung verbundene besondere öffentlichrechtliche Funktion von ''Schutzgebiet nach Wasserrecht''.','ax_schutzgebietnachwasserrecht','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung zuständig ist.','ax_schutzgebietnachwasserrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Schutzgebiet nach Wasserrecht''.','ax_schutzgebietnachwasserrecht','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qualitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_schutzgebietnachwasserrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','SGN','''Nummer des Schutzgebietes'' ist die amtlich festgelegte Verschlüsselung von ''Schutzgebiet nach Wasserrecht''.','ax_schutzgebietnachwasserrecht','DLKM','nummerdesschutzgebietes');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_SchutzgebietNachWasserrecht','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder andere öffentlich-rechtlichen Eigenschaft von ''Schutzgebiet nach Wasserrecht''.','ax_schutzgebietnachwasserrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_landschaft','74001','REO','[E] ''Landschaft'' ist hinsichtlich des äußeren Erscheinungsbildes (Bodenformen, Bewuchs, Besiedlung, Bewirtschaftung) ein in bestimmter Weise geprägter Teil der Erdoberfläche.','{"au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Landschaftstyp','LTP','''Landschaftstyp'' beschreibt das Erscheinungsbild von ''Landschaft''.','ax_landschaft','DLKM','landschaftstyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','NAM','''Name'' ist der Eigenname von ''Landschaft''.','ax_landschaft','DLKM','name');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Die Grab-/Bohrlöcher existieren für alle Objekte der ''Bodenschätzung'' und ''Muster-, Landesmuster- und Vergleichsstücke''. Die Grab-/Bohrlöcher von ''Muster-, Landesmuster- und Vergleichsstücke'' können gleichzeitig bestimmende Grab-/Bohrlöcher von ''Bodenschätzung'' sein. Dieses gilt, wenn für eine Fläche kein bestimmendes Grab-/Bohrloch vorliegt.','ax_grablochderbodenschaetzung','72003','REO','[E] ''Grabloch der Bodenschätzung'' ist der Lagepunkt der Profilbeschreibung von Grab- /Bohrlöchern.','{"au_punktobjekt"}','DLKM','Objektart','Die Attributart ''Bedeutung'' ist objektbildend.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..1','Jedes Grabloch einer Bodenschätzung liegt in einem Tagesabschnitt.','ax_tagesabschnitt','72003-72006','ax_grablochderbodenschaetzung','DLKM','gehoertZu');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_grablochderbodenschaetzung','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','WE1','''Bodenzahl oder Grünlandgrundzahl'' ist die Wertzahl nach dem Acker- oder Grünlandschätzungsrahmen.','ax_grablochderbodenschaetzung','DLKM','bodenzahlodergruenlandgrundzahl');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_KennzifferGrabloch','GKN','''Kennziffer'' ist ein von der zuständigen Behörde zur eindeutigen Bezeichnung der Grablöcher vergebenes Ordnungsmerkmal.','ax_grablochderbodenschaetzung','DLKM','kennziffer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1..2','AX_Bedeutung_GrablochDerBodenschaetzung','BED','''Bedeutung'' ist die Art des Grab-/Bohrlochs.','ax_grablochderbodenschaetzung','DLKM','bedeutung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Gemarkung_Schluessel','GMN','Jedes Grabloch einer Bodenschätzung liegt in einer Gemarkung.','ax_grablochderbodenschaetzung','DLKM','ingemarkung');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Die Objektart ''Natur-, Umwelt- oder Bodenschutzrecht'' mit der Attributart ''Art der Festlegung'' und der Werteart 1653 ''Naturdenkmal'' wird nur dann geführt, wenn ein entsprechendes Objekt der Objektart 54001 ''Vegetationsmerkmal'' mit den Wertearten 1011, 1012, 1100, 1210, 1220, 1230 oder die Objektart 61006 ''Felsen, Felsblock, Felsnadel'' vorhanden ist.','ax_naturumweltoderbodenschutzrecht','71006','REO','[E] ''Natur-, Umwelt- oder Bodenschutzrecht'' ist die auf den Grund und Boden bezogene Beschränkung, Belastung oder andere Eigenschaft einer Fläche oder eines Gegenstandes nach öffentlichen, natur-, umwelt- oder bodenschutzrechtlichen Vorschriften.','{"ag_objekt"}','DLKM','Objektart','Die Attributart ''Art der Festlegung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung zuständig ist.','ax_naturumweltoderbodenschutzrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname der Festlegung.','ax_naturumweltoderbodenschutzrecht','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qualitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_naturumweltoderbodenschutzrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kennziffer der Festlegung.','ax_naturumweltoderbodenschutzrecht','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_NaturUmweltOderBodenschutzrecht','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder andere öffentlich-rechtlichen Eigenschaft.','ax_naturumweltoderbodenschutzrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(lebenszeitintervall,konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Das Lebenszeitintervall des Objekts beginnt mit der Reservierung und endet mit der Löschung. Reservierungen erfolgen auftragsbezogen. Nicht benötigte Reservierungen können nach ihrer Löschung wieder verwendet werden.','Bereits vergebene Ordnungsnummern dürfen nicht reserviert werden. Die Attributart ''Antragsnummer'' oder ''Auftragsnummer'' muss belegt sein. Existiert zu einer Stammnummer bereits eine Folgenummer (z. B. 100/1), so darf diese Stammnummer (z.B. 100) nicht reserviert werden.','ax_reservierung','16001','NREO','[E] ''Reservierung'' enthält Ordnungsnummern des Liegenschaftskatasters, die für eine durchzuführende Vermessungssache reserviert sind.','{"aa_nreo"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','ADR','''Ablauf der Reservierung'' ist das Datum, bis zu dem die Reservierung gilt.','ax_reservierung','DLKM','ablaufderreservierung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','ONR','''Nummer'' ist die zu reservierende Ordnungsnummer.','ax_reservierung','DLKM','nummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Art_Reservierung','ART','''Art'' ist eine Kennzeichnung der Ordnungsnummern.','ax_reservierung','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ANR','Die ''Antragsnummer'' ist eine von der Katasterbehörde vergebene eindeutige Kennzeichnung für einen Antrag.','ax_reservierung','DLKM','antragsnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Dienststelle_Schluessel','VST','''Vermessungsstelle'' enthält den Namen der Stelle, für die die Reservierung vorgenommen worden ist (siehe Katalog der Dienststellen).','ax_reservierung','DLKM','vermessungsstelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NBZ','ax_reservierung','DLKM','nummerierungsbezirk');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','AUN','Die ''Auftragsnummer'' ist eine von der Katasterbehörde vergebene eindeutige Kennzeichnung. Alle zu einer Vermessungssache gehörenden Reservierungen müssen dieselbe Auftragsnummer wie der Fortführungsauftrag haben.','ax_reservierung','DLKM','auftragsnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','AX_Reservierungsauftrag_Gebietskennung','GBK','ax_reservierung','DLKM','gebietskennung');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_gehoelz','DLKM','43003','REO','[E] ''Gehölz'' ist eine Fläche, die mit einzelnen Bäumen, Baumgruppen, Büschen, Hecken und Sträuchern bestockt ist.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Vegetationsmerkmal_Gehoelz','VEG','''Vegetationsmerkmal'' beschreibt den Bewuchs von ''Gehölz''.','ax_gehoelz','DLKM','vegetationsmerkmal');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Gehoelz','FKT','''Funktion'' beschreibt, welchem Zweck ''Gehölz'' dient.','ax_gehoelz','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Gehölz''.','ax_gehoelz','DLKM','name');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_dienststelle','DLKM','73011','NREO','[E] ''Dienststelle'' enthält die Verschlüsselung von Dienststellen und ÖbVi/ÖbV, die Aufgaben der öffentlichen Verwaltung wahrnehmen, mit der entsprechenden Bezeichnung.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''Schlüssel'' ist objektbildend.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','''Dienststelle'' hat eine Anschrift.','ax_anschrift','73011-21003','beziehtSichAuf','ax_dienststelle','DLKM','hat');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Dienststelle_Schluessel','DLKM','SLL','Schlüssel der Dienststelle.','ax_dienststelle','DLKM','schluessel');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Behoerde','SAR','''Stellenart'' bezeichnet die Art der Stelle.','ax_dienststelle','DLKM','stellenart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','KEN','''Kennung'' dient zur Unterscheidung und Fortführung der verschiedenen Katalogarten (z.B. Behördenkatalog) innerhalb des Dienststellenkatalogs.','ax_dienststelle','DLKM','kennung');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('''Verschlüsselte Lagebezeichnung'' und ''Unverschlüsselte Lagebezeichnung'' schließen sich gegenseitig aus; eine dieser Attributarten muss vorhanden sein.','ax_lagebezeichnungohnehausnummer','DLKM','12001','NREO','[E] ''Lagebezeichnung ohne Hausnummer'' ist die ortsübliche oder amtlich festgesetzte Benennung der Lage von Flurstücken, die keine Hausnummer haben (z.B. Namen und Bezeichnungen von Gewannen, Straßen, Gewässern).','{"ax_lage"}','DLKM','Objektart');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1..*','Eine ''Lagebezeichnung ohne Hausnummer'' gehört zu einem oder mehreren ''Flurstücken''. Es handelt sich um die inverse Relationsrichtung.','ax_flurstueck','DLKM','(INV)11001-12001','zeigtAuf','ax_lagebezeichnungohnehausnummer','DLKM','gehoertZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Es handelt sich um die inverse Relationsrichtung.','ax_historischesflurstueckohneraumbezug','(INV)17003-12001','zeigtAuf','ax_lagebezeichnungohnehausnummer','DLKM','beschreibt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ORT','''Ortsteil'' ist eine Ergänzung zur Lagebezeichnung um den Ortsteil.','ax_lagebezeichnungohnehausnummer','DLKM','ortsteil');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ZLB','''Zusatz zur Lagebezeichnung'' ist eine Ergänzung zur Lagebezeichnung.','ax_lagebezeichnungohnehausnummer','DLKM','zusatzzurlagebezeichnung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_dammwalldeich','61003','REO','[E] ''Damm, Wall, Deich'' ist eine aus Erde oder anderen Baustoffen bestehende langgestreckte Aufschüttung, die Vegetation tragen kann.','{"ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_DammWallDeich','FKT','''Funktion'' beschreibt den Zweck von ''Damm, Wall, Deich''.','ax_dammwalldeich','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','HHO','''Objekthöhe'' ist die maximale Höhendifferenz in [m] zwischen dem höchsten Punkt von ''Damm, Wall, Deich'' und der Geländeoberfläche.','ax_dammwalldeich','DLKM','objekthoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Art_DammWallDeich','ART','''Art'' ist der Typ von ''Damm, Wall, Deich''.','ax_dammwalldeich','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Damm, Wall, Deich''.','ax_dammwalldeich','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qualitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_dammwalldeich','DLKM','qualitaetsangaben');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_bauwerkoderanlagefuersportfreizeitunderholung','51006','REO','[E] ''Bauwerk oder Anlage für Sport, Freizeit und Erholung'' ist ein Bauwerk oder eine Anlage in Sport-, Freizeit- und Erholungsanlagen.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Sportart_BauwerkOderAnlageFuerSportFreizeitUndErholung','SPO','''Sportart'' beschreibt, welche Sportarten ausgeübt werden können.','ax_bauwerkoderanlagefuersportfreizeitunderholung','DLKM','sportart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Bauwerk oder Anlage für Sport, Freizeit und Erholung''.','ax_bauwerkoderanlagefuersportfreizeitunderholung','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bauwerksfunktion_BauwerkOderAnlageFuerSportFreizeitUndErholung','BWF','''Bauwerksfunktion'' beschreibt die Art oder Funktion von ''Bauwerk oder Anlage für Sport, Freizeit und Erholung''.','ax_bauwerkoderanlagefuersportfreizeitunderholung','DLKM','bauwerksfunktion');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type) VALUES ('ax_k_ausgkopf_standard','AKS','Der komplexe Datentyp ''AX_K_AUSGKOPF_Standard'' enthält Angaben, die in den Kopfzeilen von Standardausgaben benötigt werden.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','DAG','''Datum der Ausgabe'' ist das Datum der erstmaligen Anfertigung der Ausgabe und wird bei nochmaligen Anfertigungen bei Fortführungsnachweisen beibehalten.','ax_k_ausgkopf_standard','DLKM','datumderausgabe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststellenlogo','ELL','Dienststellenlogo ist das Logo des Katasteramtes oder der Landesvermessung.','ax_k_ausgkopf_standard','DLKM','dienststellenlogo');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Landeswappen','DLKM','EWP','''EnthältEWP'' enthält eine eindeutige Dateibezeichnung (uri), in der das Landeswappen vorgehalten wird.','ax_k_ausgkopf_standard','DLKM','enthaeltewp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_K_ANSCHRIFT','DLKM','AFV','''Anschrift Dienststelle'' ist die Angabe über den Dienstsitz der katasterführenden Behörde.','ax_k_ausgkopf_standard','DLKM','anschriftdienststelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','ADA','''Art der Ausgabe'' enthält die Anlassart der Ausgabe.','ax_k_ausgkopf_standard','DLKM','artderausgabe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','FKV','''Dienststelle'' ist die entschlüsselte Bezeichnung der zuständigen Behörde.','ax_k_ausgkopf_standard','DLKM','dienststelle');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_regierungsbezirk','DLKM','73003','NREO','''Regierungsbezirk'' enthält alle zur Regierungsbezirksebene zählenden Verwaltungseinheiten innerhalb eines Bundeslandes.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''Schlüssel'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Regierungsbezirk_Schluessel','DLKM','SLL','''Schlüssel'' enthält die geltende amtliche Abkürzung von ''Regierungsbezirk''.','ax_regierungsbezirk','DLKM','schluessel');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_lage','DLKM','12005','NREO','[E] ''Lage'' ist eine Klasse mit Eigenschaften, die für alle Objektarten dieser Objektartengruppe gelten und an diese vererbt werden. Es handelt sich um eine abstrakte Objektart.','{"aa_nreo"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Lagebezeichnung','DLKM','LBZ','Die ''Lagebezeichnung'' beinhaltet die verschlüsselte oder unverschlüsselte Lagebezeichnung.','ax_lage','DLKM','lagebezeichnung');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Die Objekte ''Gewässermerkmal'' mit ART 1640, 1650 und 1660 liegen immer innerhalb der Objektarten ''Fließgewässer'' oder ''Meer''. Die Attributart ''Bezeichnung'' kann nur in Verbindung mit der Attributart ''Art'' und der Werteart 1610 vorkommen.','ax_gewaessermerkmal','55001','REO','[E] ''Gewässermerkmal'' sind besondere Eigenschaften eines Gewässers.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Art_Gewaessermerkmal','ART','''Art'' beschreibt die Ausprägung von ''Gewässermerkmal''.','ax_gewaessermerkmal','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Gewässermerkmal''.','ax_gewaessermerkmal','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kennziffer von ''Gewässermerkmal''.','ax_gewaessermerkmal','DLKM','bezeichnung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_leitung','51005','REO','[E] ''Leitung'' ist eine aus Drähten oder Fasern hergestellte Leitung zum Transport von elektrischer Energie und zur Übertragung von elektrischen Signalen.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_kontinuierlicheslinienobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Integer','SPG','''Spannungsebene'' beschreibt den höchsten vorkommenden Wert in [KV].','ax_leitung','DLKM','spannungsebene');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bauwerksfunktion_Leitung','BWF','''Bauwerksfunktion'' beschreibt die Art oder Funktion von ''Leitung''.','ax_leitung','DLKM','bauwerksfunktion');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Das Objekt ''Besondere Gebäudelinie'' erhält seinen Raumbezug durch eine Linie, die zur Vermittlung des Raumbezugs des entsprechenden Objekts ''Gebäude'' oder ''Bauteil'' beiträgt.','ax_besonderegebaeudelinie','31003','REO','[E] ''Besondere Gebäudelinie'' ist der Teil der Geometrie des Objekts ''Gebäude'' oder des Objekts ''Bauteil'', der besondere Eigenschaften besitzt.','{"ag_linienobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1..*','AX_Beschaffenheit_BesondereGebaeudelinie','BES','''Beschaffenheit'' gibt die Eigenschaft der ''Besonderen Gebäudelinie'' wieder.','ax_besonderegebaeudelinie','DLKM','beschaffenheit');
INSERT INTO alkis_elemente(lebenszeitintervall,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Das Objekt wird entsprechend der Beschreibung des Lebenszeitintervalls bei der Objektart ''Fortführungsnachweis - Deckblatt'' gelöscht.','ax_fortfuehrungsfall','15002','NREO','[E] ''Fortführungsfall'' beschreibt die notwendigen Angaben zum Aufbau eines Fortführungsnachweises. Er legt die Reihenfolge der zu verändernden Flurstücke innerhalb eines Fortführungsnachweises fest (Aufbau des Fortführungsnachweises). Diese Attributart ist optional, da bei Anlieferung des Fortführungsauftrages von Externen an die Vermessungsstelle in der Regel nicht befüllbar ist.','{"aa_nreo"}','DLKM','Objektart','Die Attributart ''Fortführungsfallnummer'' ist objektbildend. Eine der Attributarten ''Flurstück_alt'' oder ''Flurstück_neu'' muss vorhanden sein.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','ZAN','''ZeigtAufNeuesFlurstueck'' enthält das Flurstückskennzeichen des Flurstücks, das unter einem Fortführungsfall im Fortführungsnachweis neu gebildet oder verändert wurde. Bildungsregel: Die Attributart setzt sich aus den nachfolgenden expliziten Attributarten in der angegebenen Reihenfolge zusammen: 1. Land (2 Stellen) 2. Gemarkungsnummer (4 Stellen) 3. Flurnummer (3 Stellen) 4. Flurstücksnummer 4.1 Zähler (5 Stellen) 4.2 Nenner (4 Stellen) 5. Flurstücksfolge (2 Stellen) Die Elemente sind rechtsbündig zu belegen, fehlende Stellen sind mit führenden Nullen zu belegen. Da die Flurnummer und die Flurstücksfolge optional sind, sind aufgrund der bundeseinheitlichen Definition im Flurstückskennzeichen die entsprechenden Stellen, sofern sie nicht belegt sind, durch Unterstrich "_" ersetzt. Gleiches gilt für Flurstücksnummern ohne Nenner, hier ist der fehlende Nenner im Flurstückskennzeichen durch Unterstriche zu ersetzen. Die Gesamtlänge des Flurstückkennzeichens beträgt immer 20 Zeichen.','ax_fortfuehrungsfall','DLKM','zeigtaufneuesflurstueck');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEM','''Bemerkung'' enthält zusätzliche Informationen zum Fortführungsfall.','ax_fortfuehrungsfall','DLKM','bemerkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_FGraphik','VWA','''Verweist auf'' verweist auf einen Datentyp ''F-Graphik'', der eine URI zu einer Karte enthält, die die Veränderung darstellt (Gegenüberstellung alt-neu).','ax_fortfuehrungsfall','DLKM','verweistauf');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','LFD','Diese Attributart enthält die laufende Nummer des Fortführungsnachweises. Diese Nummer entspricht dem Datentyp ''AX_Fortfuehrungsnummer'' ohne Land und Gemarkung.','ax_fortfuehrungsfall','DLKM','laufendenummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','AFP','''Fortführungsmitteilung an Eigentümer/Antragsteller'' ist ein freies Textfeld für die Eingabe von Personen, für die die Fortführungsmitteilung bestimmt ist.','ax_fortfuehrungsfall','DLKM','fortfuehrungsmitteilunganeigentuemerantragsteller');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ANM','''Anmerkung für den Notar'' ist ein freies Textfeld zur Beschreibung von Fortführungsnachweis-relevanten Tatbeständen bezüglich des Flurstücks für den Notar.','ax_fortfuehrungsfall','DLKM','anmerkungfuerdennotar');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','ZAA','''ZeigtAufAltesFlurstueck'' enthält das Flurstückskennzeichen des Flurstücks, das unter einem Fortführungsfall im Fortführungsnachweis verändert wurden oder zu veränderten Objekten in Beziehung stehen. Bildungsregel: Die Attributart setzt sich aus den nachfolgenden expliziten Attributarten in der angegebenen Reihenfolge zusammen: 1. Land (2 Stellen) 2. Gemarkungsnummer (4 Stellen) 3. Flurnummer (3 Stellen) 4. Flurstücksnummer 4.1 Zähler (5 Stellen) 4.2 Nenner (4 Stellen) 5. Flurstücksfolge (2 Stellen) Die Elemente sind rechtsbündig zu belegen, fehlende Stellen sind mit führenden Nullen zu belegen. Da die Flurnummer und die Flurstücksfolge optional sind, sind aufgrund der bundeseinheitlichen Definition im Flurstückskennzeichen die entsprechenden Stellen, sofern sie nicht belegt sind, durch Unterstrich "_" ersetzt. Gleiches gilt für Flurstücksnummern ohne Nenner, hier ist der fehlende Nenner im Flurstückskennzeichen durch Unterstriche zu ersetzen. Die Gesamtlänge des Flurstückkennzeichens beträgt immer 20 Zeichen.','ax_fortfuehrungsfall','DLKM','zeigtaufaltesflurstueck');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Integer','ZDF','''Anzahl der Fortführungsmitteilungen'' enthält für jeden Fortführungsfall die Anzahl der zu erstellenden Fortführungsmitteilungen.','ax_fortfuehrungsfall','DLKM','anzahlderfortfuehrungsmitteilungen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','Integer','FFN','Die ''Fortführungsfallnummer'' gibt an, in welcher Reihenfolge die Fortführungen in einem Fortführungsnachweis behandelt werden und dient somit der Rekonstruktion des Fortführungsnachweises.','ax_fortfuehrungsfall','DLKM','fortfuehrungsfallnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1..*','AA_Anlassart','UIV','''Überschrift im Fortführungsnachweis'' gibt für den Fortführungsnachweis und die Mitteilungsverfahren den Grund der unter einem Fortführungsfall beschriebenen Veränderung bzw. Fortführung gemäß dem Katalog der Fortführungsanlässe an.','ax_fortfuehrungsfall','DLKM','ueberschriftimfortfuehrungsnachweis');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_punktortag','14002','REO','[E] ''PunktortAG'' ist ein Punktort mit redundanzfreier Geometrie (Besonderer Gebäudepunkt, Besonderer Bauwerkspunkt) innerhalb eines Geometriethemas.','{"ag_punktobjekt","ax_punktort"}','DLKM','Objektart');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_kleinraeumigerlandschaftsteil','74002','REO','[E] ''Kleinräumiger Landschaftsteil'' ist ein kleinerer Teil der Erdoberfläche, der hinsichtlich des äußeren Erscheinungsbildes (Bodenformen, Bewuchs, Besiedlung, Bewirtschaftung) in bestimmter Weise geprägt ist.','{"au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Landschaftstyp','LTP','''Landschaftstyp'' beschreibt das Erscheinungsbild von ''Kleinräumiger Landschaftsteil''.','ax_kleinraeumigerlandschaftsteil','DLKM','landschaftstyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','NAM','''Name'' ist der Eigenname von ''Kleinräumiger Landschaftsteil''.','ax_kleinraeumigerlandschaftsteil','DLKM','name');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_forstrecht','71010','REO','[E] ''Forstrecht'' ist die auf den Grund und Boden bezogene Beschränkung, Belastung oder andere Eigenschaft einer Fläche nach öffentlichen, forstrechtlichen Vorschriften.','{"ag_flaechenobjekt"}','DLKM','Objektart','Die Attributart ''Art der Festlegung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung zuständig ist (siehe Katalog der Dienststellen).','ax_forstrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_BesondereFunktion_Forstrecht','BFU','''Besondere Funktion'' ist die Angabe besonderer forstrechtlicher Bindungen.','ax_forstrecht','DLKM','besonderefunktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_forstrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die amtliche Nummer des Waldes.','ax_forstrecht','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_Forstrecht','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder anderen öffentlich-rechtlichen Eigenschaft.','ax_forstrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_bundesland_schluessel','73018','DLKM','Amtliche Verschlüsselung des Bundeslands.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LAN','Bundesland.','ax_bundesland_schluessel','DLKM','land');
INSERT INTO alkis_elemente(name,kennung,abgeleitet_aus,modellart,type) VALUES ('ax_post','12007','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','STN','''Straßenname'' enthält die postalisch geführte Schreibweise des Straßennamens, sie kann vom amtlichen Straßennamen abweichen.','ax_post','DLKM','strassenname');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','PLZ','''Postleitzahl'' ist die Postleitzahl der Postzustellung.','ax_post','DLKM','postleitzahl');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','ONM','''OrtsnamePost'' ist der postalische Ortsname.','ax_post','DLKM','ortsnamepost');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ZON','''ZusatzOrtsname'' enthält einen Zusatz zum postalischen Ortsnamen.','ax_post','DLKM','zusatzortsname');
INSERT INTO alkis_elemente(name,kennung,abgeleitet_aus,modellart,type) VALUES ('ax_li_processstep_mitdatenerhebung','50004','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..*','AX_LI_Source_MitDatenerhebung','SRC','ax_li_processstep_mitdatenerhebung','DLKM','source');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','CI_ResponsibleParty','PRO','ax_li_processstep_mitdatenerhebung','DLKM','processor');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','DateTime','DAT','ax_li_processstep_mitdatenerhebung','DLKM','datetime');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','AX_LI_ProcessStep_MitDatenerhebung_Description','DES','ax_li_processstep_mitdatenerhebung','DLKM','description');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_benutzergruppemitzugriffskontrolle','81003','NREO','[E] In der Objektart ''Benutzergruppe mit Zugriffskontrolle'' werden Informationen über die Benutzer der ALKIS-Bestandsdaten verwaltet, die den Umfang der Benutzung und Fortführung aus Gründen der Datenkonsistenz und des Datenschutzes einschränken.','{"ax_benutzergruppe"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AA_Anlassart','ZPF','''Zugriffsart Produktkennung Führung'' steuert über die Kennung der Fortführungsanlässe (siehe Codelist AX_Anlassart) die automatische Abgabe von Fortführungsmitteilungen und Änderungsdatensätzen.','ax_benutzergruppemitzugriffskontrolle','DLKM','zugriffsartproduktkennungfuehrung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AA_Anlassart_Benutzungsauftrag','ZPB','''Zugriffsart Produktkennung Benutzung'' steuert über die Bezeichnung der (Standard-) Ausgaben (siehe Ausgabekataloge) die funktionale Zuordnung von Rechten beim lesenden Zugriff auf den Datenbestand für Auskunftszwecke, Auswertungen und Fortführungsmitteilungen.','ax_benutzergruppemitzugriffskontrolle','DLKM','zugriffsartproduktkennungbenutzung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AA_Anlassart','ZFA','''Zugriffsart Fortführungsanlass'' steuert über die Kennung der Fortführungsanlässe (siehe Katalog der Fortführungsanlässe) die funktionale Zuordnung von Fortführungsrechten beim schreibenden Zugriff auf den Datenbestand.','ax_benutzergruppemitzugriffskontrolle','DLKM','zugriffsartfortfuehrungsanlass');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','Boolean','HIS','Die Atributart legt fest, ob der Zugriff auch auf historische Daten erlaubt ist. Ist das Attribut nicht belegt, ist der Zugriff nur auf aktuelle Bestandsdaten erlaubt.','ax_benutzergruppemitzugriffskontrolle','DLKM','zugriffhistorie');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1..*','Query','SEL','Selektionskriterien für die Benutzergruppe, die beschreiben, auf welche Objekte zugegriffen werden darf. Für jede Objektart, auf die zugegriffen werden darf, ist eine Query anzulegen. Der Umfang der Objekte aus dieser Objektart kann durch Filter-Prädikate eingeschränkt werden. Der Umfang der erlaubten Prädikate ist zur einfacheren Verarbeitbarkeit sehr begrenzt. Erlaubt sind lediglich die folgenden Prädikate in einer Query: - Räumliche Operatoren (wirken nur auf REO-Objektarten); - Operatoren auf den Attributen ''lebenszeitintervall'' und ''modellart''.','ax_benutzergruppemitzugriffskontrolle','DLKM','selektionskriterien');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_tatsaechlichenutzung','40001','REO','Die abstrakte Oberklasse für alle tatsächlichen Nutzungen. Objekte in der Grundfläche besitzen alle dasselbe Thema (TS_Theme ''Tatsächliche Nutzung (Grundfläche)''). Alle anderen AX_TatsaechlicheNutzung-Objekte liegen in einem anderen Thema. I.d.R. wird hierbei jedem überlagernden Objekt ein eigenes Thema zugeordnet. Unterführungsreferenzen regeln den Schichtenaufbau der verschiedenen Nutzungsebenen. Unterführungsreferenzen bestehen stets zwischen einer Nutzungsfläche und einem Bauwerk (z.B. Straße über Brücke). Es handelt sich um eine abstrakte Objektart.','{"ta_surfacecomponent"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','DateTime','DLU','In dieser Attributart kann das Datum der letzten Überprüfung der Art der Tatsächlichen Nutzung angegeben werden.','ax_tatsaechlichenutzung','DLKM','datumderletztenueberpruefung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_tatsaechlichenutzung','DLKM','qualitaetsangaben');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_regierungsbezirk_schluessel','73021','DLKM','Amtliche Verschlüsselung des Regierungsbezirks.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LAN','Bundesland.','ax_regierungsbezirk_schluessel','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','RBZ','Regierungsbezirk.','ax_regierungsbezirk_schluessel','DLKM','regierungsbezirk');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_bauraumoderbodenordnungsrecht','DLKM','71008','REO','[E] ''Bau-, Raum- oder Bodenordnungsrecht'' ist ein fachlich übergeordnetes Gebiet von Flächen mit bodenbezogenen Beschränkungen, Belastungen oder anderen Eigenschaften nach öffentlichen Vorschriften.','{"ag_flaechenobjekt"}','DLKM','Objektart','Die Attributart ''Art der Festlegung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','DAN','''Datum-Anordnung'' ist das Datum, an dem das Verfahren, das durch die Attributart ''Art der Festlegung'' bestimmt ist, eingeleitet oder angeordnet wurde.','ax_bauraumoderbodenordnungsrecht','DLKM','datumanordnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','DLKM','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung zuständig ist (siehe Katalog der Dienststellen).','ax_bauraumoderbodenordnungsrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','NAM','''Name'' ist der Eigenname von ''Bau-, Raum- oder Bodenordnungsrecht''.','ax_bauraumoderbodenordnungsrecht','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','DRK','''Datum-rechtskräftig'' ist das Datum, an dem ''Bau-, Raum oder Bodenordnungsrecht'' rechtskräftig geworden ist.','ax_bauraumoderbodenordnungsrecht','DLKM','datumrechtskraeftig');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','DAB','''Datum-Abgabe'' ist das Datum, an dem der neue Stand an das Kataster- und Vermessungsamt abgegeben wurde.','ax_bauraumoderbodenordnungsrecht','DLKM','datumabgabe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','DBE','''Datum-Besitzeinweisung'' ist das Datum, an dem die Beteiligten des Verfahrens, das durch die Attributart ''Art der Festlegung'' bestimmt ist, vor dem rechtskräftigen Eigentumsübergang in den Besitz eingewiesen wurden.','ax_bauraumoderbodenordnungsrecht','DLKM','datumbesitzeinweisung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','VOR','''Veränderung ohne Rücksprache'' ist die Kennzeichnung, daß das Kataster- und Vermessungsamt Änderungen an Flurstücken, die am Verfahren, das durch die ''Art der Festlegung'' bestimmt ist, beteiligt sind, ohne Rücksprache mit der ''Zuständigen Stelle'' durchführen darf.','ax_bauraumoderbodenordnungsrecht','DLKM','veraenderungohneruecksprache');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_bauraumoderbodenordnungsrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','BEZ','''Bezeichnung'' ist die amtlich festgelegte Verschlüsselung von ''Bau-, Raumoder Bodenordnungsrecht''.','ax_bauraumoderbodenordnungsrecht','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_BauRaumOderBodenordnungsrecht','DLKM','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder anderen öffentlich-rechtlichen Eigenschaft.','ax_bauraumoderbodenordnungsrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_schifffahrtsliniefaehrverkehr','57002','REO','[E] ''Schifffahrtslinie, Fährverkehr'' ist die regelmäßige Schiffs- oder Fährverbindung.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Art_SchifffahrtslinieFaehrverkehr','ART','''Art'' beschreibt die Art der Schiffs- oder Fährverbindung von ''Schifffahrtslinie, Fährverkehr''.','ax_schifffahrtsliniefaehrverkehr','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Schifffahrtslinie, Fährverkehr''.','ax_schifffahrtsliniefaehrverkehr','DLKM','name');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_wirtschaftlicheeinheit','75002','ZUSO','[E] ''Wirtschaftliche Einheit'' ist eine in der Örtlichkeit vorhandene wirtschaftliche Einheit mehrerer Flurstücke, die nicht mit der rechtlichen Einheit (Grundstück im rechtlichen Sinn) identisch sein muss (Beispiel: Wirtschaftliche Einheit zweier Flurstücke/Grundstücke, wobei nur ein Flurstück ein Erbbaugrundstück ist).','{"aa_zuso"}','DLKM','Objektart');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_gemarkung','DLKM','73007','NREO','[F] "Gemarkung" ist ein Katasterbezirk, der eine zusammenhängende Gruppe von Flurstücken umfasst. Er kann von Gemarkungsteilen/Fluren unterteilt werden.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''Schlüssel'' ist objektbildend. Der "Schlüssel Gesamt" setzt sich stets aus dem Schlüssel der Gemarkung und dem Schlüssel des Bundeslands zusammen.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Gemarkung_Schluessel','DLKM','SLL','''Schlüssel'' enthält die geltende amtliche Abkürzung der Verwaltungseinheit.','ax_gemarkung','DLKM','schluessel');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Dienststelle_Schluessel','ZST','"Gemarkung" ist Verwaltungsbezirk einer Dienststelle.','ax_gemarkung','DLKM','istamtsbezirkvon');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_seilbahnschwebebahn','53005','REO','[G] ''Seilbahn, Schwebebahn'' ist eine Beförderungseinrichtung, bei der Waggons, Kabinen oder sonstige Behälter an Seilen oder festen Schienen aufgehängt sind und sich an diesen entlang bewegen.','{"au_linienobjekt","ax_bauwerkeeinrichtungenundsonstigeangaben"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Seilbahn, Schwebebahn''.','ax_seilbahnschwebebahn','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bahnkategorie_SeilbahnSchwebebahn','BKT','''Bahnkategorie'' beschreibt die Art von ''Seilbahn, Schwebebahn''.','ax_seilbahnschwebebahn','DLKM','bahnkategorie');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_fgraphik','EFG','Die Externe Objektart "F-Graphik" enthält für die Anlage zum Fortführungsnachweis und zu den Fortführungsmitteilungen in einer externen Datei eine Gegenüberstellung des alten und neuen Bestandes, in der alle Veränderungen farbig gekennzeichnet sind. Das Format dieser externen Datei (z.B. NAS oder GeoTiff) wird durch die Implementierung festgelegt.','{}','DLKM','Datentyp','Diese temporäre Datei wird durch Verschneidung auf der Basis der Ausgabe-Objektart "Liegenschaftskarte" entweder innerhalb des ALKIS-Führungsprozesses aus den Objekt-Versionen vor und nach der Fortführung oder innerhalb des Erhebungsprozesses außerhalb ALKIS aus den Bestandsdaten und den Erhebungsdaten erzeugt und für den Benutzungsprozess bereitgestellt.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_K_AUSGKOPF_Standard','AKS','''Ausgabekopf'' enthält Angaben, die im Kopf des FME-Textteiles benötigt werden.','ax_fgraphik','DLKM','ausgabekopf');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','URI','URI','ax_fgraphik','DLKM','uri');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Das ZUSO ''Böschung, Kliff'' besteht aus einem REO ''Böschungsfläche'' und einem oder mehreren REO ''Geländekante''.','ax_boeschungkliff','61001','ZUSO','[E] ''Böschung'' ist die zwischen zwei verschieden hoch gelegenden Ebenen geneigte Geländeoberfläche künstlichen oder natürlichen Ursprungs. ''Kliff'' ist eine aus Lockermaterial oder Festgestein aufgebaute Steilküste.','{"aa_zuso"}','DLKM','Objektart','Ein neues ZUSO ''Böschung, Kliff'' ist zu bilden, wenn sich beim ZUSO der Wert eines Attributs ändert.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','HHO','''Objekthöhe'' ist der maximale Höhenunterschied zwischen Ober- und Unterkante von ''Böschung, Kliff'' in [m].','ax_boeschungkliff','DLKM','objekthoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Böschung, Kliff''.','ax_boeschungkliff','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_boeschungkliff','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_BoeschungKliff','ZUS','''Zustand'' gibt die Beschaffenheit der ''Böschung, Kliff'' an.','ax_boeschungkliff','DLKM','zustand');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_einrichtunginoeffentlichenbereichen','51010','REO','[E] ''Einrichtung in öffentlichen Bereichen'' sind Gegenstände und Einrichtungen verschiedenster Art in öffentlichen oder öffentlich zugänglichen Bereichen (z.B. Straßen, Parkanlagen).','{"ax_bauwerkeeinrichtungenundsonstigeangaben","ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Art_EinrichtungInOeffentlichenBereichen','ART','''Art'' beschreibt die Art der baulichen Anlage.','ax_einrichtunginoeffentlichenbereichen','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Distance','KMA','''Kilometerangabe'' gibt den tatsächlichen Wert der Kilometrierung in [km] auf dem Kilometerstein an.','ax_einrichtunginoeffentlichenbereichen','DLKM','kilometerangabe');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Die Attributart ''Fördergut'' kann nur in Verbindung mit der Attributart ''Funktion'' und der Werteart 2510 vorkommen. Die Attributart ''Primärenergie'' kann nur in Verbindung mit der Attributart ''Funktion'' und den Wertearten 2530, 2531, 2532, 2570, 2571 und 2572 vorkommen. Die Attributart ''Lagergut'' kann nur in Verbindung mit der Attributart ''Funktion'' und der Werteart 1740 vorkommen.','ax_industrieundgewerbeflaeche','DLKM','41002','REO','[E] ''Industrie- und Gewerbefläche'' ist eine Fläche, die vorwiegend industriellen oder gewerblichen Zwecken dient.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_IndustrieUndGewerbeflaeche','DLKM','FKT','''Funktion'' ist die zum Zeitpunkt der Erhebung vorherrschende Nutzung von ''Industrie- und Gewerbefläche''.','ax_industrieundgewerbeflaeche','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Primaerenergie_IndustrieUndGewerbeflaeche','PEG','''Primärenergie'' beschreibt die zur Strom- oder Wärmeerzeugung dienende Energieform oder den Energieträger.','ax_industrieundgewerbeflaeche','DLKM','primaerenergie');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Industrie- und Gewerbefläche'' insbesondere außerhalb von Ortslagen.','ax_industrieundgewerbeflaeche','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_IndustrieUndGewerbeflaeche','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''Industrie- und Gewerbefläche''.','ax_industrieundgewerbeflaeche','DLKM','zustand');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagergut_IndustrieUndGewerbeflaeche','LGT','''Lagergut'' gibt an, welches Produkt gelagert wird. Diese Attributart kann nur in Verbindung mit der Attributart ''Funktion'' und der Werteart 1740 vorkommen.','ax_industrieundgewerbeflaeche','DLKM','lagergut');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Foerdergut_IndustrieUndGewerbeflaeche','FGT','''Fördergut'' gibt an, welches Produkt gefördert wird.','ax_industrieundgewerbeflaeche','DLKM','foerdergut');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_dienststellenlogo','ELL','Die externe Objektart "Dienststellenlogo" enthält das Logo der Dienststelle als Pixelgraphik in einer externen Datei, z.B. im Format GeoTiff.','{}','DLKM','Datentyp','Das Dienststellenlogo wird in allen AFIS- und ALKIS- (Standard-) Ausgaben präsentiert; daher ist diese Datei durch die Implementierung als permanente Datei bereitzustellen.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','URI','URI','ax_dienststellenlogo','DLKM','uri');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('Der Verweis auf die Gemeinde ist konsistent mit der Gebietszugehörigkeit von ''erfrageStandardposition()''.','ax_verschluesseltelagebezeichnung','73023','DLKM','''Verschlüsselte Lagebezeichnung'' ist ein eindeutiges Fachkennzeichen (siehe Katalog der verschlüsselten Lagebezeichnungen). Die Attributart setzt sich zusammen aus dem Gemeindekennzeichen mit den Verschlüsselungen für 1. Spalte: Land 2. Spalte: Regierungsbezirk 3. Spalte: Kreis (kreisfreie Stadt) 4. Spalte: Gemeinde 5. Spalte: Lage.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LAG','Lage.','ax_verschluesseltelagebezeichnung','DLKM','lage');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LAN','Bundesland.','ax_verschluesseltelagebezeichnung','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','GEM','Gemeinde.','ax_verschluesseltelagebezeichnung','DLKM','gemeinde');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','KRS','Kreis.','ax_verschluesseltelagebezeichnung','DLKM','kreis');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','RBZ','Regierungsbezirk.','ax_verschluesseltelagebezeichnung','DLKM','regierungsbezirk');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_vorratsbehaelterspeicherbauwerk','51003','REO','[E] ''Vorratsbehälter, Speicherbauwerk'' ist ein geschlossenes Bauwerk zum Aufbewahren von festen, flüssigen oder gasförmigen Stoffen.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Speicherinhalt_VorratsbehaelterSpeicherbauwerk','SPE','''Speicherinhalt'' gibt an, welches Produkt gelagert oder gespeichert wird.','ax_vorratsbehaelterspeicherbauwerk','DLKM','speicherinhalt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','HHO','''Objekthöhe'' ist die Höhendifferenz in [m] zwischen dem höchsten Punkt von ''Vorratsbehälter, Speicherbauwerk'' und der Geländeoberfläche.','ax_vorratsbehaelterspeicherbauwerk','DLKM','objekthoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Vorratsbehälter, Speicherbauwerk''.','ax_vorratsbehaelterspeicherbauwerk','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_LageZurErdoberflaeche_VorratsbehaelterSpeicherbauwerk','OFL','''Lage zur Erdoberfläche'' ist die Angabe der relativen Lage von ''Vorratsbehälter, Speicherbauwerk'' zur Erdoberfläche.','ax_vorratsbehaelterspeicherbauwerk','DLKM','lagezurerdoberflaeche');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Bauwerksfunktion_VorratsbehaelterSpeicherbauwerk','BWF','''Bauwerksfunktion'' beschreibt die Art oder Funktion von ''Vorratsbehälter, Speicherbauwerk''.','ax_vorratsbehaelterspeicherbauwerk','DLKM','bauwerksfunktion');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_strassenverkehrsanlage','53002','REO','[E] ''Straßenverkehrsanlage'' ist eine besondere Anlage für den Straßenverkehr.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Art_Strassenverkehrsanlage','ART','''Art'' bezeichnet die zum Zeitpunkt der Erhebung erkennbare oder feststellbare Eigenschaft der ''Straßenverkehrsanlage''.','ax_strassenverkehrsanlage','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Straßenverkehrsanlage'' (z. B. Kamener Kreuz).','ax_strassenverkehrsanlage','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','BEZ','''Bezeichnung'' ist die Nummer von einem Autobahnknoten (z. B. A003050).','ax_strassenverkehrsanlage','DLKM','bezeichnung');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_gemeindekennzeichen','73014','DLKM','''Gemeindekennzeichen'' ist die vom Statistischen Bundesamt veröffentlichte Schlüsselnummer des kommunalen Gebietes (Stadt-, Landgemeinde, gemeindefreies Gebiet). Das Gemeindekennzeichen (siehe Katalog der Gemeinden) besteht aus den Verschlüsselungen für : 1. Spalte: Land 2. Spalte: Regierungsbezirk 3. Spalte: Kreis (kreisfreie Stadt) 4. Spalte: Gemeinde und optional (siehe Katalog der Gemeindeteile) dem 5. Spalte: Gemeindeteil','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LAN','Bundesland.','ax_gemeindekennzeichen','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','GMT','Gemeindeteil.','ax_gemeindekennzeichen','DLKM','gemeindeteil');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','GEM','Gemeinde.','ax_gemeindekennzeichen','DLKM','gemeinde');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','KRS','Kreis.','ax_gemeindekennzeichen','DLKM','kreis');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','RBZ','Regierungsbezirk. Diese Attributart ist optional, da nicht in allen Ländern Regierungsbezirke vorkommen.','ax_gemeindekennzeichen','DLKM','regierungsbezirk');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_dqmitdatenerhebung','50002','DLKM','Angaben zur Herkunft der Informationen (Erhebungsstelle). Die Information ist konform zu den Vorgaben aus ISO 19115 zu repräsentieren.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_LI_Lineage_MitDatenerhebung','DLKM','DPL','''Herkunft'' enthält Angaben zur Datenerhebung. Soll Erhebung und/oder Erhebungsstelle dokumentiert werden, dann erfolgt dies über LI_ProcessStep- und LI_Source-Elemente. Die Erhebungsstelle wird in einem LI_ProcessStep mit self.description = ''Erhebung'' und der Erhebungsstelle in self.processor dokumentiert. Die Datenerhebung wird in einem LI_Source-Element dokumentiert (über die Kennung aus der CodeList AX_Datenerhebung).','ax_dqmitdatenerhebung','DLKM','herkunft');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_duene','61007','REO','[E] ''Düne'' ist ein vom Wind angewehter Sandhügel.','{"au_flaechenobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Düne''.','ax_duene','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qualitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_duene','DLKM','qualitaetsangaben');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_flurstuecksnummer','11005','DLKM','''AX_Flurstücksnummer'' ist ein Datentyp, der alle Eigenschaften für den Aufbau der Attributart ''Flurstücksnummer'' enthält.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','NEN','Dieses Attribut enthält den Nenner der Flurstücknummer ohne führende Nullen. Diese sind gebenefalls bei der Erzeugung des Flurstückskennzeichens zu ergänzen.','ax_flurstuecksnummer','DLKM','nenner');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','ZAE','Dieses Attribut enthält den Zähler der Flurstücknummer ohne führende Nullen. Diese sind gebenefalls bei der Erzeugung des Flurstückskennzeichens zu ergänzen.','ax_flurstuecksnummer','DLKM','zaehler');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type) VALUES ('ax_kennziffergrabloch','72005','''Kennziffer Grabloch'' ist ein eindeutiges Fachkennzeichen für Grablöcher.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','LAN','''Land'' enthält den Schlüssel eines Bundeslands.','ax_kennziffergrabloch','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','GEM','''Gemarkungsnummer'' enhält die von der Katasterbehörde zur eindeutigen Bezeichnung der Gemarkung vergebene Nummer innerhalb eines Bundeslandes.','ax_kennziffergrabloch','DLKM','gemarkungsnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NBZ','''Nummerierungsbezirks'' beinhaltet das Kilometerquadrat, in dem das Grabloch liegt.','ax_kennziffergrabloch','DLKM','nummerierungsbezirk');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','NUM','Nummer des Grablochs.','ax_kennziffergrabloch','DLKM','nummerdesgrablochs');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_li_source_punktort','14010','DLKM','Die Datenerhebung wird in einem AX_LI_Source-Element dokumentiert (über die Kennung aus der CodeList AX_Datenerhebung_Punktort).','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..*','AX_LI_ProcessStep_Punktort','SRS','ax_li_source_punktort','DLKM','sourcestep');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,element,modellart,bezeichnung) VALUES ('0..1','AX_Datenerhebung_Punktort','DLKM','DES','ax_li_source_punktort','DLKM','description');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_schiffsverkehr','DLKM','42016','REO','[E] ''Schiffsverkehr'' umfasst die baulich geprägte Fläche und die mit ihr in Zusammenhang stehende Freifläche, die ausschließlich oder vorwiegend dem Schiffsverkehr dient.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Schiffsverkehr','FKT','''Funktion'' ist die zum Zeitpunkt der Erhebung vorherrschende Nutzung von ''Schiffsverkehr''.','ax_schiffsverkehr','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagebezeichnung','NAM','''Name'' ist der Eigenname von ''Schiffsverkehr''.','ax_schiffsverkehr','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Schiffsverkehr','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''Schiffsverkehr''. Diese Attributart kann nur in Verbindung mit der Attributart ''Funktion'' und der Werteart 5620 vorkommen.','ax_schiffsverkehr','DLKM','zustand');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_flaechegemischternutzung','DLKM','41006','REO','[E] ''Fläche gemischter Nutzung'' ist eine bebaute Fläche einschließlich der mit ihr im Zusammenhang stehenden Freifläche (Hofraumfläche, Hausgarten), auf der keine Art der baulichen Nutzung vorherrscht. Solche Flächen sind insbesondere ländlich-dörflich geprägte Flächen mit land- und forstwirtschaftlichen Betrieben, Wohngebäuden u.a. sowie städtisch geprägte Kerngebiete mit Handelsbetrieben und zentralen Einrichtungen für die Wirtschaft und die Verwaltung.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_FlaecheGemischterNutzung','FKT','''Funktion'' ist die zum Zeitpunkt der Erhebung vorherrschende Nutzung (Dominanzprinzip).','ax_flaechegemischternutzung','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_ArtDerBebauung_FlaecheGemischterNutzung','BEB','''Art der Bebauung'' differenziert nach offener und geschlossener Bauweise aus topographischer Sicht und nicht nach gesetzlichen Vorgaben (z.B. BauGB).','ax_flaechegemischternutzung','DLKM','artderbebauung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Fläche gemischter Nutzung'' insbesondere bei Objekten außerhalb von Ortslagen.','ax_flaechegemischternutzung','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_FlaecheGemischterNutzung','ZUS','''Zustand'' beschreibt, ob ''Fläche gemischter Nutzung'' ungenutzt ist.','ax_flaechegemischternutzung','DLKM','zustand');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('''Verschlüsselte Lagebezeichnung'' und ''Unverschlüsselte Lagebezeichnung'' schließen sich gegenseitig aus; eine dieser Attributarten muss vorhanden sein.','ax_lagebezeichnungmitpseudonummer','12003','NREO','[E] ''Lagebezeichnung mit Pseudonummer'' ist die von der Katasterbehörde für ein bestehendes oder geplantes Gebäude vergebene Lagebezeichnung und ggf. einem Adressierungszusatz, wenn von der Gemeinde für das Gebäude keine Lagebezeichnung mit Hausnummer vergeben wurde (z.B. Kirche, Nebengebäude).','{"ax_lage"}','DLKM','Objektart');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1','Eine ''Lagebezeichnung mit Pseudonummer'' gehört zu einem ''Gebäude''. Es handelt sich um die inverse Relationsrichtung.','ax_gebaeude','(INV)31001-12003','hat','ax_lagebezeichnungmitpseudonummer','DLKM','gehoertZu');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ORT','''Ortsteil'' ist eine Ergänzung zur Lagebezeichnung um den Ortsteil.','ax_lagebezeichnungmitpseudonummer','DLKM','ortsteil');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','LNR','''Laufende Nummer'' ist die von der Katasterbehörde vergebene Nummer zur Zuordnung einzelner Gebäude zueinander.','ax_lagebezeichnungmitpseudonummer','DLKM','laufendenummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','PNR','''Pseudonummer'' ist eine von der Katasterbehörde vergebene Nummer. Soll ein Nebengebäude einem Hauptgebäude, für das eine Hausnummer existiert, zugeordnet werden, kann diese Hausnummer beim Nebengebäude als ''Pseudonummer'' geführt werden, wenn zusätzlich die Attributart ''Laufende Nummer'' vorkommt.','ax_lagebezeichnungmitpseudonummer','DLKM','pseudonummer');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_gebaeude','DLKM','31001','REO','[A] ''Gebäude'' ist ein dauerhaft errichtetes Bauwerk, dessen Nachweis wegen seiner Bedeutung als Liegenschaft erforderlich ist sowie dem Zweck der Basisinformation des Liegenschaftskatasters dient.','{"ag_objekt"}','DLKM','Objektart','Objektbildende Eigenschaften sind länderspezifisch im Erhebungsprozess zu berücksichtigen. Differenzierungen innerhalb eines Gebäudes (z. B. bei Gebäuden mit vertikaler Gliederung) sind als ''Bauteile'' modelliert. Unterirdische Bauteile gehören nicht zur Gebäudegrundfläche.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','''Gebäude'' gehört zu ''Gebäude'', wenn die Gebäude baulich zusammen gehören und im Gegensatz zum Bauteil eine gleichrangige Bedeutung haben.','ax_gebaeude','31001-31001','haengtZusammenMit','ax_gebaeude','DLKM','gehoertZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','''Gebäude'' hat ''Lagebezeichnung mit Pseudonummer''.','ax_lagebezeichnungmitpseudonummer','31001-12003','gehoertZu','ax_gebaeude','DLKM','hat');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Gebäude'' gehört ''Person''. Die Relation kommt nur vor, wenn unabhängig von Eintragungen im Grundbuch (''Buchungsstelle'' mit der Attributart ''Buchungsart'') für das Gebäude ein Eigentum nach BGB begründet ist.','ax_person','31001-21001','besitzt','ax_gebaeude','DLKM','gehoert');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Gebäude'' zeigt auf ''Lagebezeichnung mit Hausnummer''.','ax_lagebezeichnungmithausnummer','31001-12002','beziehtSichAuf','ax_gebaeude','DLKM','zeigtAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','Es handelt sich um die inverse Relationsrichtung.','ax_gebaeude','(INV)31001-31001','gehoertZu','ax_gebaeude','DLKM','haengtZusammenMit');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Area','GFL','''Geschossfläche'' ist die Gebäudegeschossfläche in [qm].','ax_gebaeude','DLKM','geschossflaeche');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Weitere_Gebaeudefunktion','WGF','''Weitere Gebäudefunktion'' ist die Funktion, die ein Gebäude neben der dominierenden Gebäudefunktion hat.','ax_gebaeude','DLKM','weiteregebaeudefunktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','GKN','''Gebäudekennzeichen'' ist ein eindeutiges Fachkennzeichen für ein Gebäude, bestehend aus den Schlüsseln für die Gemeinde (8 Stellen), Straße (5 Stellen), die Hausnummer des Gebäudes (4 Stellen), dem Adressierungszusatz (4 Stellen) und die laufende Nummer des Gebäudes (3 Stellen). Die Stellen sind jeweils rechtsbündig zu führen. Fehlende Stellen werden mit Nullen aufgefüllt. Der Adressierungszusatz und die laufende Nummer des Nebengebäudes sind optional und werden, wenn sie nicht belegt sind, mit Unterstrich "_" gefüllt. Die Attributart wird im Rahmen der Migration aus den bisherigen Verfahrenslösungen übernommen und werden nur in ATKIS dauerhaft geführt.','ax_gebaeude','DLKM','gebaeudekennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Gebaeude','ZUS','''Zustand'' beschreibt die Beschaffenheit oder die Betriebsbereitschaft von ''Gebäude''. Diese Attributart wird nur dann optional geführt, wenn der Zustand des Gebäudes vom nutzungsfähigen Zustand abweicht.','ax_gebaeude','DLKM','zustand');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dachgeschossausbau_Gebaeude','DGA','''Dachgeschossausbau'' ist ein Hinweis auf den Ausbau bzw. die Ausbaufähigkeit des Dachgeschosses.','ax_gebaeude','DLKM','dachgeschossausbau');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Volume','URA','''Umbauter Raum'' ist der umbaute Raum [Kubikmeter] des Gebäudes.','ax_gebaeude','DLKM','umbauterraum');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Area','GRF','''Grundfläche'' ist die Gebäudegrundfläche in [qm].','ax_gebaeude','DLKM','grundflaeche');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Nutzung_Gebaeude','NTZ','''Nutzung'' ist die Gebäudenutzung und enthält den jeweiligen prozentualen Nutzungsanteil an der Gesamtnutzung. Das Attribut setzt sich zusammen aus: 1. Spalte: Nutzung 2. Spalte: Nutzungsanteil Die zulässigen Werte für die erste Spalte sind unter Werteart zu finden. Die Summe der Nutzungsanteile, die in den Attributen ''Nutzung'' nachgewiesen sind, muss immer 100 ergeben.','ax_gebaeude','DLKM','nutzung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','HHO','''Objekthöhe'' ist die Höhendifferenz in [m] zwischen dem höchsten Punkt der Dachkonstruktion und der festgelegten Geländeoberfläche des Gebäudes.','ax_gebaeude','DLKM','objekthoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','NAM','''Name'' ist der Eigenname oder die Bezeichnung des Gebäudes.','ax_gebaeude','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_LageZurErdoberflaeche_Gebaeude','OFL','''Lage zur Erdoberfläche'' ist die Angabe der relativen Lage des Gebäudes zur Erdoberfläche. Diese Attributart wird nur bei nicht ebenerdigen Gebäuden geführt.','ax_gebaeude','DLKM','lagezurerdoberflaeche');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dachform','DAF','''Dachform'' beschreibt die charakteristische Form des Daches.','ax_gebaeude','DLKM','dachform');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DAA','''Dachart'' gibt die Art der Dacheindeckung (z.B. Reetdach) an.','ax_gebaeude','DLKM','dachart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Integer','AUG','''Anzahl der unterirdischen Geschosse'' ist die Anzahl der unterirdischen Geschosse des Gebäudes.','ax_gebaeude','DLKM','anzahlderunterirdischengeschosse');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Bauweise_Gebaeude','BAW','''Bauweise'' ist die Beschreibung der Art der Bauweise.','ax_gebaeude','DLKM','bauweise');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','HOH','''Hochhaus'' ist ein Gebäude, das nach Gebäudehöhe und Ausprägung als Hochhaus zu bezeichnen ist. Für Gebäude im Geschossbau gilt dieses i.d.R. ab 8 oberirdischen Geschossen, für andere Gebäude ab einer Gebäudehöhe von 22 m. Abweichungen hiervon können sich durch die Festlegungen in den länderspezifischen Bauordnungen ergeben.','ax_gebaeude','DLKM','hochhaus');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Integer','AOG','''Anzahl der oberirdischen Geschosse'' ist die Anzahl der oberirdischen Geschosse des Gebäudes.','ax_gebaeude','DLKM','anzahlderoberirdischengeschosse');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DLKM','QAG','Angaben zur Herkunft der Informationen (Erhebungsstelle). Die Information ist konform zu den Vorgaben aus ISO 19115 zu repräsentieren.','ax_gebaeude','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','Integer','BJA','''Baujahr'' ist das Jahr der Fertigstellung oder der baulichen Veränderung des Gebäudes.','ax_gebaeude','DLKM','baujahr');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Gebaeudefunktion','DLKM','GFK','''Gebäudefunktion'' ist die zum Zeitpunkt der Erhebung vorherrschend funktionale Bedeutung des Gebäudes (Dominanzprinzip).','ax_gebaeude','DLKM','gebaeudefunktion');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_wald','DLKM','43002','REO','[E] ''Wald'' ist eine Fläche, die mit Forstpflanzen (Waldbäume und Waldsträucher) bestockt ist.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Vegetationsmerkmal_Wald','VEG','''Vegetationsmerkmal'' beschreibt den Bewuchs von ''Wald''.','ax_wald','DLKM','vegetationsmerkmal');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Wald''.','ax_wald','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kennziffer (Forstabteilungsnummer, Jagenzahl) von ''Wald''.','ax_wald','DLKM','bezeichnung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_georeferenziertegebaeudeadresse','12006','REO','[E] ''Georeferenzierte Gebäudeadresse'' enthält alle Informationen für die Ausgabe der amtlichen Hauskoordinate. Die Abgabe erfolgt über Bestandsdatenauszug bzw. NBA-Verfahren. Das bisherige Verfahren zur Abgabe der Hauskoordinaten kann durch eine XSLT-Transformation erzeugt werden.','{"au_punktobjekt"}','DLKM','Objektart','Die Objektart darf nur dann existieren, wenn die Relation ''hatAuch'' auf ein Objekt ''AX_LagebezeichnungMitHausnummer'' zeigt, das mit einem Objekt ''AX_Gebäude'' oder ''AX_Turm'' oder ''AX_Flurstueck'' verbunden ist. Bei Änderungen des Objekts ''AX_LagebezeichnungMitHausnummer'' muss stets auch das Objekt ''AX_Georeferenzierte Gebäudeadresse'' entsprechend fortgeführt werden.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1','Die inverse Relation wird optional belegt, damit keine Implementierung unmittelbar zur Umstellung auf das neue Verfahren zur Ableitung der Hauskoordinate gezwungen wird.','ax_lagebezeichnungmithausnummer','12006-12002','beziehtSichAuchAuf','ax_georeferenziertegebaeudeadresse','DLKM','hatAuch');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','HNR','''Hausnummer'' ist die von der Gemeinde für ein bestehendes oder geplantes Gebäude vergebene Nummer ohne Adressierungszusatz.','ax_georeferenziertegebaeudeadresse','DLKM','hausnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','CharacterString','GMD','ax_georeferenziertegebaeudeadresse','DLKM','gemeinde');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Post','POA','''Postalische Adresse'' enthält Angaben, die entweder direkt geführt oder extern ergänzt werden. Das Endprodukt muss bei Abgabe an den Kunden diese Informationen enthalten.','ax_georeferenziertegebaeudeadresse','DLKM','postalischeadresse');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','CharacterString','KRS','ax_georeferenziertegebaeudeadresse','DLKM','kreis');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ADZ','Adressierungszusatz wird (soweit vorhanden) aus der Attributart ''Hausnummer'' bei AX_LagebezeichnungMitHausnummer abgeleitet.','ax_georeferenziertegebaeudeadresse','DLKM','adressierungszusatz');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DSN','Enthält eine eindeutige Datensatznummer, bestehend aus dem Schlüssel des Bundeslandes gefolgt von einer Nummer. Wird im Rahmen der Migration belegt.','ax_georeferenziertegebaeudeadresse','DLKM','datensatznummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','CharacterString','LAN','ax_georeferenziertegebaeudeadresse','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','OTT','Belegt mit vier Stellen. Falls Ortsteil nicht vorkommt, wird Füllzeichen ''0'' verwendet.','ax_georeferenziertegebaeudeadresse','DLKM','ortsteil');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Qualitaet_Hauskoordinate','QUA','Enthält Qualitätsaussagen zur Lage der Gebäudekoordinate.','ax_georeferenziertegebaeudeadresse','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','RBZ','Belegt mit einer Stelle. Falls Regierungsbezirk nicht vorkommt, wird Füllzeichen ''0'' verwendet.','ax_georeferenziertegebaeudeadresse','DLKM','regierungsbezirk');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','CharacterString','SSS','ax_georeferenziertegebaeudeadresse','DLKM','strassenschluessel');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('''Schutzzone'' ist Bestandteil des ZUSO ''Schutzgebiet nach Wasserrecht'' oder ZUSO ''Schutzgebiet nach Natur-, Umwelt- oder Bodenschutzrecht''.','ax_schutzzone','71012','REO','[E] ''Schutzzone'' ist die auf den Grund und Boden bezogene Beschränkung, Belastung oder andere Eigenschaft einer Fläche nach öffentlichen oder wasserrechtlichen Vorschriften.','{"ag_flaechenobjekt"}','DLKM','Objektart','Die Attributart ''Zone'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Zone_Schutzzone','ZON','''Zone'' ist die amtlich festgesetzte Einstufung der Schutzzone.','ax_schutzzone','DLKM','zone');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_wegpfadsteig','53003','REO','[E] ''Weg, Pfad, Steig'' ist ein befestigter oder unbefestigter Geländestreifen, der zum Befahren und/oder Begehen vorgesehen ist.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_objekt"}','DLKM','Objektart','Ein Objekt dieser Objektart kann gebildet werden, wenn die unterlagernde Grundfläche nicht als TN Wegfläche erfasst wurde');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Art_WegPfadSteig','ART','''Art'' ist die zum Zeitpunkt der Erhebung vorherrschend vorkommende Nutzung.','ax_wegpfadsteig','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Weg, Pfad, Steig''.','ax_wegpfadsteig','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kennziffer von ''Weg, Pfad, Steig''.','ax_wegpfadsteig','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Markierung_WegPfadSteig','MKG','''Markierung'' ist die Kennzeichnung einer Route im Wegenetz.','ax_wegpfadsteig','DLKM','markierung');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_platz','DLKM','42009','REO','[E] ''Platz'' ist eine Verkehrsfläche in Ortschaften oder eine ebene, befestigte oder unbefestigte Fläche, die bestimmten Zwecken dient (z. B. für Verkehr, Märkte, Festveranstaltungen).','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Platz','FKT','''Funktion'' ist die zum Zeitpunkt der Erhebung objektiv erkennbare oder feststellbare vorkommende Nutzung.','ax_platz','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagebezeichnung','NAM','''Name'' ist der Eigenname von ''Platz''.','ax_platz','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ZNM','''Zweitname'' ist der touristische oder volkstümliche Name von ''Platz''.','ax_platz','DLKM','zweitname');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_turm','51001','REO','[E] ''Turm'' ist ein hoch aufragendes, auf einer verhältnismäßig kleinen Fläche freistehendes Bauwerk.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Turm'' zeigt auf eine ''Lagebezeichnung mit Hausnummer''.','ax_lagebezeichnungmithausnummer','51001-12002','weistZum','ax_turm','DLKM','zeigtAuf');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','HHO','''Objekthöhe'' ist die Höhendifferenz in [m] zwischen dem höchsten Punkt des eigentlichen Bauwerks ''Turm'' und der Geländeoberfläche. Aufgesetzte Anlagen (z.B. Antenne) zählen nicht zur Objekthöhe. Bei mehrfacher Bauwerksfunktion wird immer bis zurm höchsten Punkt des Turms gemessen.','ax_turm','DLKM','objekthoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Turm''.','ax_turm','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Turm','ZUS','''Zustand'' ist der Zustand von ''Turm''.','ax_turm','DLKM','zustand');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1..2','AX_Bauwerksfunktion_Turm','BWF','''Bauwerksfunktion'' beschreibt die Art oder Funktion von ''Turm''.','ax_turm','DLKM','bauwerksfunktion');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_lagebezeichnung','12004','DLKM','Der Auswahldatentyp ''Lagebezeichnung'' beinhaltet eine verschlüsselte oder unverschlüsselte Lagebezeichnung.','{}','DLKM','Auswahldatentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','UNV','''Unverschlüsselte Lagebezeichnung'' ist die unverschlüsselte Bezeichnung einer Lage.','ax_lagebezeichnung','DLKM','unverschluesselt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_VerschluesselteLagebezeichnung','DLKM','SCH','''Verschlüsselte Lagebezeichnung'' ist ein eindeutiges Fachkennzeichen (siehe Katalog der verschlüsselten Lagebezeichnungen). Die Attributart setzt sich zusammen aus dem Gemeindekennzeichen mit den Verschlüsselungen für 1. Spalte: Land 2. Spalte: Regierungsbezirk 3. Spalte: Kreis (kreisfreie Stadt) 4. Spalte: Gemeinde 5. Spalte: Lage','ax_lagebezeichnung','DLKM','verschluesselt');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_klassifizierungnachstrassenrecht','DLKM','71001','REO','[E] ''Klassifizierung nach Straßenrecht'' ist die auf den Grund und Boden bezogene Beschränkung, Belastung oder andere Eigenschaft einer Fläche nach öffentlichen, straßenrechtlichen Vorschriften.','{"ag_objekt"}','DLKM','Objektart','Die Attributart ''Art der Festlegung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung zuständig ist (siehe Katalog der Dienststellen).','ax_klassifizierungnachstrassenrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_klassifizierungnachstrassenrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','BEZ','''Bezeichnung'' ist die amtliche Nummer der Straße.','ax_klassifizierungnachstrassenrecht','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_KlassifizierungNachStrassenrecht','DLKM','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder anderen öffentlich-rechtlichen Eigenschaft.','ax_klassifizierungnachstrassenrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,definition,abgeleitet_aus,modellart,type) VALUES ('Der Datentyp setzt sich zusammen aus: - Art (zulässige Eintragungen siehe Werteliste) - Erster Stichtag. Diese Spalte muss bei den Wertearten 1000 und 1100 der Codelist ''AX_Art_BereichZeitlich'' belegt sein. - Intervall. Diese Spalte muss bei den Wertearten 3000 und 3100 der Codelist ''AX_Art_BereichZeitlich'' belegt sein.','ax_bereichzeitlich','81005','''Bereich - zeitlich'' bezeichnet den Zeitraum für die Abgabe von Änderungsinformationen und Bestandsdaten.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','Date','TAG','Erster Stichtag der Datenabgabe.','ax_bereichzeitlich','DLKM','ersterstichtag');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Art_BereichZeitlich','ART','Art','ax_bereichzeitlich','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','TM_Duration','INT','Intervall zwischen zwei Datenabgaben.','ax_bereichzeitlich','DLKM','intervall');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_benutzergruppe','81002','NREO','[E] In der ''Benutzergruppe'' werden Informationen über die Benutzer der Bestandsdaten verwaltet, die den Umfang der Benutzung und Fortführung aus Gründen der Datenkonsistenz und des Datenschutzes einschränken sowie Standardparameter für die Benutzergruppe vermerken. Es handelt sich um eine abstrakte Objektart.','{"aa_benutzergruppe"}','DLKM','Objektart');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1..*','Benutzer in der Benutzergruppe. Es handelt sich um die inverse Relationsrichtung.','ax_benutzer','(INV)81001-81002','gehoertZu','ax_benutzergruppe','DLKM','bestehtAus');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','SC_CRS','CRS','In dem Attribut ''Koordinatenreferenzsystem'' kann das bevorzugte Koordinatenreferenzsystem (CRS) für Koordinatenangaben im Ausgabedatenbestand angegeben werden. Die Angabe ist optional, fehlt sie, wird jeweils das ''native'', d.h. im Datenbestand vorhandene CRS verwendet. Die Koordinaten werden dann so ausgegeben, wie sie gespeichert sind. Diese Funktionalität ist nur für eine sehr begrenzte Zahl von CRS-Paaren sinnvoll, die ineinander mathematisch streng umgerechnet werden können. Andere Umrechnungen oder Umformungen, die einen Genauigkeitsverlust für die Koordinaten bedeuten, sollen an dieser Stelle nicht unterstützt werden; sie können durch externe Prozesse realisiert werden. Gleiches gilt für 3-dimensionale CRS ((X, Y, Z), (Breite, Länge, ellipsoidische Höhe), ...). Folgende 2D-Umrechnungen sollen unterstützt werden: a) bei Vorliegen von Gauß-Krüger-Koordinaten (ggf. inkl. NN-Höhe): - Ausgabe in einem anderen Streifen - Ausgabe in geographische Koordinaten (Breite, Länge) b) bei Vorliegen von UTM-Koordinaten (ggf. inkl. NN-Höhe) - Ausgabe in eine andere Zone - Ausgabe in geographische Koordinaten (Breite, Länge) c) bei Vorliegen von geographischen Koordinaten (Breite, Länge) - Ausgabe in GK- oder UTM-Koordinaten (je nach Ellipsoidgrundlage der geographischen Koordinaten).','ax_benutzergruppe','DLKM','koordinatenreferenzsystem');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','BEZ','''Bezeichnung'' ist die Bezeichnung für die Benutzergruppe, z.B. ''Notare''.','ax_benutzergruppe','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Dienststelle_Schluessel','ZST','''Zuständige Stelle'' ist die Dienststelle, die für die Eintragung der Benutzergruppe und die Zuordnung der Benutzer zu dieser Benutzergruppe zuständig ist.','ax_benutzergruppe','DLKM','zustaendigestelle');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_dienststelle_schluessel','73017','DLKM','Amtliche Verschlüsselung der Dienststelle.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LAN','''Dienststelle'' liegt innerhalb eines ''Bundeslandes''.','ax_dienststelle_schluessel','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','DST','Schlüssel der Dienststelle im Bundesland.','ax_dienststelle_schluessel','DLKM','stelle');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,erfassungskriterien) VALUES ('Die ''Geländekante'' ist Bestandteil des ZUSO ''Böschung, Kliff''. Die Geometrie der Objektart ''Geländekante'' ist immer identisch mit Teilen der Umringsgeometrie der Objektart ''Böschungsfläche''.','ax_gelaendekante','62040','REO','''Geländekante'' ist die Schnittlinie unterschiedlich geneigter Geländeflächen.','{"ag_linienobjekt"}','DLKM','Objektart','Erfassung bei erkennbarem Neigungswechsel, wenn es zur genauen morphologischen Beschreibung der Erdoberfläche und/oder zur Ableitung des Sekundären DGM erforderlich ist.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Erfassung_DGM','EMT','''Erfassung'' beschreibt die Erfassungsmethode, das Erfassungsdatum und die Sicherheit mit dem das Objekt erfasst wurden.','ax_gelaendekante','DLKM','erfassung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerGelaendekante','ART','''Art der Geländekante'' beschreibt die Eigenschaft der Geländekante.','ax_gelaendekante','DLKM','artdergelaendekante');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_flugverkehrsanlage','53007','REO','[E] ''Flugverkehrsanlage'' ist eine Fläche, auf der Luftfahrzeuge am Boden bewegt oder abgestellt werden.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Art_Flugverkehrsanlage','ART','''Art'' ist die zum Zeitpunkt der Erhebung vorherrschend vorkommende Nutzung.','ax_flugverkehrsanlage','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Flugverkehrsanlage''.','ax_flugverkehrsanlage','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Oberflaechenmaterial_Flugverkehrsanlage','OFM','''Oberflächenmaterial'' ist der Bewuchs oder das Material, das ''Flugverkehrsanlage'' bedeckt.','ax_flugverkehrsanlage','DLKM','oberflaechenmaterial');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_stehendesgewaesser','DLKM','44006','REO','[E] ''Stehendes Gewässer'' ist eine natürliche oder künstliche mit Wasser gefüllte, allseitig umschlossene Hohlform der Landoberfläche ohne unmittelbaren Zusammenhang mit ''Meer''.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_StehendesGewaesser','FKT','''Funktion'' ist die Art von ''Stehendes Gewässer''.','ax_stehendesgewaesser','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_HydrologischesMerkmal_StehendesGewaesser','HYD','''Hydrologisches Merkmal'' gibt die Wasserverhältnisse von ''Stehendes Gewässer'' an.','ax_stehendesgewaesser','DLKM','hydrologischesmerkmal');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','GWK','''Gewässerkennziffer'' ist die von der zuständigen Fachstelle vergebene Verschlüsselung.','ax_stehendesgewaesser','DLKM','gewaesserkennziffer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagebezeichnung','NAM','''Name'' ist der Eigenname von ''Stehendes Gewässer''.','ax_stehendesgewaesser','DLKM','name');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_denkmalschutzrecht','71009','REO','[E] ''Denkmalschutzrecht'' ist die auf den Grund und Boden bezogene Beschränkung, Belastung oder andere Eigenschaft einer Fläche oder Gegenstand nach öffentlichen, denkmalschutzrechtlichen Vorschriften.','{"ag_objekt"}','DLKM','Objektart','Die Attributart ''Art der Festlegung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung zuständig ist.','ax_denkmalschutzrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname der Festlegung von ''Denkmalschutzrecht''.','ax_denkmalschutzrecht','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qulitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_denkmalschutzrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kennziffer von ''Denkmalschutzrecht''.','ax_denkmalschutzrecht','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_Denkmalschutzrecht','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder anderen öffentlich-rechtlichen Eigenschaft.','ax_denkmalschutzrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_punktortta','DLKM','14004','REO','[E] ''PunktortTA'' ist ein Punktort, der in der Flurstücksgrenze liegt und einen Grenzpunkt verortet.','{"ax_punktort","ta_pointcomponent"}','DLKM','Objektart');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_sportfreizeitunderholungsflaeche','DLKM','41008','REO','[E] ''Sport-, Freizeit- und Erholungsfläche'' ist eine bebaute oder unbebaute Fläche, die dem Sport, der Freizeitgestaltung oder der Erholung dient.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_SportFreizeitUndErholungsflaeche','DLKM','FKT','''Funktion'' ist die Art der Nutzung von ''Sport-, Freizeit- und Erholungsfläche''.','ax_sportfreizeitunderholungsflaeche','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Sport-, Freizeit- und Erholungsfläche''.','ax_sportfreizeitunderholungsflaeche','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_SportFreizeitUndErholungsflaeche','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''SportFreizeitUndErholungsflaeche ''.','ax_sportfreizeitunderholungsflaeche','DLKM','zustand');
INSERT INTO alkis_elemente(lebenszeitintervall,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,erfassungskriterien) VALUES ('Der Zeitpunkt der Entstehung des ''Historischen Flurstück ALB'' ist identisch mit dem Zeitpunkt des Untergangs des Bezugsflurstücks (Flurstück zu seinen ''Lebzeiten''), aus dem das ''Historische Flurstück ALB'' entstanden ist (im ALB mit ''LF3 - letzte Fortführung'' bezeichnet. Soweit im ALB nur ein Jahr angegeben ist, ist dies zu einem Datum zu ergänzen). Das ''Historische Flurstück ALB'' geht nicht unter.','ax_historischesflurstueckalb','17002','NREO','[E] ''Historisches Flurstück ALB'' ist ein nicht mehr aktuelles Flurstück, das schon im ALB historisch geworden ist und nach ALKIS migriert wird und in der ALKIS-Standardhistorie geführt wird.','{"aa_nreo"}','DLKM','Objektart','Im Rahmen der Migration sind alle Flurstücke erfasst, die im ALB bereits historisch geworden sind. Diese Objektart wird nur im Rahmen der Führung der ALKIS-Standardhistorie (Rumpfhistorie) erfasst.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Buchung_HistorischesFlurstueck','BUG','''Buchung'' ist ein Hinweis auf die ''Buchungsstelle'' (und in Verbindung damit auch auf das ''Buchungsblatt''), auf den das Flurstück des Liegenschaftskatasters zum ''Zeitpunkt der Historisierung'' verweist. Bildungsregel: Siehe Datentyp ''AX_Buchung_HistorischesFlurstueck''.','ax_historischesflurstueckalb','DLKM','buchung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Flurstuecksnummer','FSN','''Flurstücksnummer'' ist die Bezeichnung (Zähler/Nenner), mit der das Flurstück innerhalb einer Gemarkung gekennzeichnet ist. Das Attribut setzt sich zusammen aus: 1. Spalte: Zähler 2. Spalte: Nenner Die 2. Spalte ist optional.','ax_historischesflurstueckalb','DLKM','flurstuecksnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Gemarkung_Schluessel','GMK','''Gemarkung'' enthält die Eigenschaften aus dem Datentyp ''AX_Gemarkung_Schlüssel'': ''land'' und ''gemarkungsnummer''.','ax_historischesflurstueckalb','DLKM','gemarkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','ZDE','''Zeitpunkt der Entstehung des Bezugsflurstücks'' ist der Zeitpunkt, zu dem das Flurstück, aus dem das Objekt ''Historisches Flurstück ALB'' direkt abgeleitet ist, fachlich entstanden ist (im ALB mit ''LF2 - Entstehung'' bezeichnet. Da im ALB nur ein Jahr angegeben ist, ist dies zu einem Datum zu ergänzen.) Hinweis: Der Zeitpunkt des Untergangs des Bezugsflurstücks ist identisch mit dem Beginn des Lebenszeitintervalls des ''Historischen Flurstück ALB''.','ax_historischesflurstueckalb','DLKM','zeitpunktderentstehungdesbezugsflurstuecks');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','Area','AFL','''Amtliche Fläche'' ist der im Liegenschaftskataster festgelegte Flächeninhalt des historischen Flurstücks in [qm]. Flurstücksflächen kleiner 0,5 qm können mit bis zu zwei Nachkommastellen geführt werden, ansonsten ohne Nachkommastellen.','ax_historischesflurstueckalb','DLKM','amtlicheflaeche');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Integer','FLN','''Flurnummer'' ist die von der Katasterbehörde zur eindeutigen Bezeichnung vergebene Nummer einer Flur, die eine Gruppe von Flurstücken innerhalb einer Gemarkung umfaßt.','ax_historischesflurstueckalb','DLKM','flurnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','(DER) FSK','''Flurstückskennzeichen'' ist das von der Katasterbehörde zur eindeutigen Bezeichnung des Flurstücks vergebenes Ordnungsmerkmal. Bildungsregel: Die Attributart setzt sich aus den nachfolgenden expliziten Attributarten in der angegebenen Reihenfolge zusammen: 1. Land (2 Stellen) 2. Gemarkungsnummer (4 Stellen) 3. Flurnummer (3 Stellen) 4. Flurstücksnummer 4.1 Zähler (5 Stellen) 4.2 Nenner (4 Stellen) 5. Flurstücksfolge ( 2 Stellen) Die Elemente sind rechtsbündig zu belegen, fehlende Stellen sind mit führenden Nullen zu belegen. Da die Flurnummer und die Flurstücksfolge optional sind, sind aufgrund der bundeseinheitlichen Definition im Flurstückskennzeichen die entsprechenden Stellen, sofern sie nicht belegt sind, durch Unterstrich "_" ersetzt. Gleiches gilt für Flurstücksnummern ohne Nenner, hier ist der fehlende Nenner im Flurstückskennzeichen durch Unterstriche zu ersetzen. Die Gesamtlänge des Flurstückkennzeichens beträgt immer 20 Zeichen. Das Attribut ist ein abgeleitetes Attribut und kann nicht gesetzt werden.','ax_historischesflurstueckalb','DLKM','flurstueckskennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','FSF','''Flurstücksfolge'' ist eine weitere Angabe zur Flurstücksnummer.','ax_historischesflurstueckalb','DLKM','flurstuecksfolge');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','VFK','''Vorgänger-Flurstückskennzeichen'' ist die Bezeichnung der Flurstücke, die dem Objekt ''Historisches Flurstück ALB'' direkt vorangehen. Bildungsregel: Die Attributart setzt sich aus den nachfolgenden expliziten Attributarten in der angegebenen Reihenfolge zusammen: 1. Land (2 Stellen) 2. Gemarkungsnummer (4 Stellen) 3. Flurnummer (3 Stellen) 4. Flurstücksnummer 4.1 Zähler (5 Stellen) 4.2 Nenner (4 Stellen) 5. Flurstücksfolge ( 2 Stellen) Die Elemente sind rechtsbündig zu belegen, fehlende Stellen sind mit führenden Nullen zu belegen. Da die Flurnummer und die Flurstücksfolge optional sind, sind aufgrund der bundeseinheitlichen Definition im Flurstückskennzeichen die entsprechenden Stellen, sofern sie nicht belegt sind, durch Unterstrich "_" ersetzt. Gleiches gilt für Flurstücksnummern ohne Nenner, hier ist der fehlende Nenner im Flurstückskennzeichen durch Unterstriche zu ersetzen. Die Gesamtlänge des Flurstückkennzeichens beträgt immer 20 Zeichen.','ax_historischesflurstueckalb','DLKM','vorgaengerflurstueckskennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','LNF','Enthält die laufende Nummer der Fortführung gemäß Belegung im ALB.','ax_historischesflurstueckalb','DLKM','laufendenummerderfortfuehrung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','GM_Point','OBK','''Objektkoordinaten'' sind die Koordinaten [mm] eines das Objekt ''Historisches Flurstück ALB'' repräsentierenden Punktes in einem amtlichen Lagebezugssystem.','ax_historischesflurstueckalb','DLKM','objektkoordinaten');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','NFK','''Nachfolger-Flurstückskennzeichen'' ist die Bezeichnung der Flurstücke, die dem Objekt ''Historisches Flurstück ALB'' direkt nachfolgen. Bildungsregel: Die Attributart setzt sich aus den nachfolgenden expliziten Attributarten in der angegebenen Reihenfolge zusammen: 1. Land (2 Stellen) 2. Gemarkungsnummer (4 Stellen) 3. Flurnummer (3 Stellen) 4. Flurstücksnummer 4.1 Zähler (5 Stellen) 4.2 Nenner (4 Stellen) 5. Flurstücksfolge ( 2 Stellen) Die Elemente sind rechtsbündig zu belegen, fehlende Stellen sind mit führenden Nullen zu belegen. Da die Flurnummer und die Flurstücksfolge optional sind, sind aufgrund der bundeseinheitlichen Definition im Flurstückskennzeichen die entsprechenden Stellen, sofern sie nicht belegt sind, durch Unterstrich "_" ersetzt. Gleiches gilt für Flurstücksnummern ohne Nenner, hier ist der fehlende Nenner im Flurstückskennzeichen durch Unterstriche zu ersetzen. Die Gesamtlänge des Flurstückkennzeichens beträgt immer 20 Zeichen.','ax_historischesflurstueckalb','DLKM','nachfolgerflurstueckskennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','FFA','Enthält die Fortführungsart gemäß Belegung im ALB.','ax_historischesflurstueckalb','DLKM','fortfuehrungsart');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_soll','61010','REO','''Soll'' ist eine runde, oft steilwandige Vertiefung in den norddeutschen Grundmoränenlandschaften; kann durch Abschmelzen von überschütteten Toteisblöcken (Toteisloch) oder durch Schmelzen periglazialer Eislinsen entstanden sein.','{"au_flaechenobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Soll''.','ax_soll','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qualitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_soll','DLKM','qualitaetsangaben');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_weg','DLKM','42006','REO','[E] ''Weg'' umfasst alle Flächen, die zum Befahren und/oder Begehen vorgesehen sind. Zum ''Weg'' gehören auch Seitenstreifen und Gräben zur Wegentwässerung.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Weg','FKT','''Funktion'' ist die zum Zeitpunkt der Erhebung objektiv erkennbare oder feststellbare vorherrschend vorkommende Nutzung.','ax_weg','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagebezeichnung','NAM','''Name'' ist die Bezeichnung oder der Eigenname von ''Wegflaeche''.','ax_weg','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die amtliche Nummer des Weges.','ax_weg','DLKM','bezeichnung');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,erfassungskriterien,bildungsregeln) VALUES ('Lückenlose und überschneidungsfreie Flächendeckung der Objekte der Objektart Flurstück. Die Positionen der Knoten der Kante müssen zugleich identisch sein mit den Positionen der Endpunkte der Linie. Jede Linie ist durch genau zwei Positionen bestimmt. Es muß entweder die Relation ''zeigt_auf'' oder ''weist_auf'' belegt sein. Jedes Flurstück gehört zu genau einer Gemarkung oder einer Flur/Gemarkungsteil.','ax_flurstueck','DLKM','11001','REO','[A] ''Flurstück'' ist ein Teil der Erdoberfläche, der von einer im Liegenschaftskataster festgelegten Grenzlinie umschlossen und mit einer Nummer bezeichnet ist. Es ist die Buchungseinheit des Liegenschaftskatasters.','{"ta_multisurfacecomponent","ax_flurstueck_kerndaten"}','DLKM','Objektart','Räumlich getrennt liegende Flurstücksteile sollen zerlegt und als eigene Flurstücke geführt werden. Im Rahmen der Migration sind räumlich getrennt liegende Flurstücke jedoch zugelassen. In diesem Fall besteht das Flurstück aus mindestens zwei Maschen.','Die Attributart ''Flurstückskennzeichen'' ist objektbildend.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Flurstück'' gehört anteilig zu ''Flurstück''. Die Relationsart kommt nur vor bei Flurstücken, die eine Relation zu einer Buchungsstelle mit einer der Buchungsarten Anliegerweg, Anliegergraben oder Anliegerwasserlauf aufweisen.','ax_flurstueck','11001.1-11001.2','beziehtSichAufFlurstueck','ax_flurstueck','DLKM','gehoertAnteiligZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Es handelt sich um die inverse Relationsrichtung.','ax_flurstueck','(INV)11001.1-11001.2','gehoertAnteiligZu','ax_flurstueck','DLKM','beziehtSichAufFlurstueck');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Flurstück'' weist auf ''Lagebezeichnung mit Hausnummer''.','ax_lagebezeichnungmithausnummer','DLKM','11001-12002','gehoertZu','ax_flurstueck','DLKM','weistAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Flurstück'' zeigt auf ''Lagebezeichnung ohne Hausnummer''.','ax_lagebezeichnungohnehausnummer','DLKM','11001-12001','gehoertZu','ax_flurstueck','DLKM','zeigtAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1','Ein (oder mehrere) Flurstück(e) ist (sind) unter genau einer Buchungsstelle gebucht. Bei Anteilsbuchungen ist dies nur dann möglich, wenn ein fiktives Buchungsblatt angelegt wird. Wird ein fiktives Buchunsblatt verwendet, ist die Kardinalität dieser Attributart 1..1.','ax_buchungsstelle','DLKM','11001-21008','grundstueckBestehtAus','ax_flurstueck','DLKM','istGebucht');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Dienststelle_Schluessel','DLKM','ZST','''Flurstück'' wird verwaltet von ''Dienststelle''. Diese Attributart wird nur dann belegt, wenn eine fachliche Zuständigkeit über eine Gemarkung bzw. Gemarkungsteil/Flur nicht abgebildet werden kann. Die Attributart enthält den Dienststellenschlüssel der Stelle, die fachlich für ein Flurstück zustandig ist.','ax_flurstueck','DLKM','zustaendigestelle');
INSERT INTO alkis_elemente(name,kennung,abgeleitet_aus,modellart,type) VALUES ('ax_reservierungsauftrag_gebietskennung','16004','{}','DLKM','Auswahldatentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','AX_Gemarkung_Schluessel','GMK','ax_reservierungsauftrag_gebietskennung','DLKM','gemarkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','AX_Buchungsblattbezirk_Schluessel','BBZ','ax_reservierungsauftrag_gebietskennung','DLKM','buchungsblattbezirk');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','AX_GemarkungsteilFlur_Schluessel','FLR','ax_reservierungsauftrag_gebietskennung','DLKM','flur');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_aufnahmepunkt','DLKM','13001','ZUSO','[E] ''Aufnahmepunkt'' ist ein Punkt des Lagefestpunktfeldes - Aufnahmepunktfeld und dient der örtlichen Aufnahme von Objektpunkten. Das Aufnahmepunktfeld ist eine Verdichtungsstufe des Lagefestpunktfeldes - Trigonometrisches Festpunktfeld (Grundlagenvermessung).','{"ax_netzpunkt"}','DLKM','Objektart','Das ZUSO besteht das aus einem oder mehreren REO ''Punktort''.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Aufnahmepunkt'' hat ''Sicherungspunkt''.','ax_sicherungspunkt','13001-13002','gehoertZu','ax_aufnahmepunkt','DLKM','hat');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_buchungsstelle','DLKM','21008','NREO','[E] ''Buchungsstelle'' ist die unter einer laufenden Nummer im Verzeichnis des Buchungsblattes eingetragene Buchung.','{"aa_nreo"}','DLKM','Objektart','Die Attributarten ''Buchungsart'' und ''Laufende Nummer'' sind objektbildend. Die Buchungsarten mit Wertearten 1101, 1102, 1401 bis 1403, 2201 bis 2205 und 2401 bis 2404 können nur auf einem Fiktiven Blatt vorkommen. Die Attributart ''Anteil'' ist dann immer zu belegen.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..*','Die Relation ''Buchungsstelle'' hat Vorgänger ''Buchungsstelle'' gibt Auskunft darüber, aus welchen Buchungsstellen die aktuelle Buchungsstelle entstanden ist.','ax_buchungsstelle','21008.9-21008.10','ax_buchungsstelle','DLKM','hatVorgaenger');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','Die ''Buchungsstelle'' wird verwaltet von ''Verwaltung''.','ax_verwaltung','21008-21004','beziehtSichAuf','ax_buchungsstelle','DLKM','wirdVerwaltetVon');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..*','''Buchungsstelle'' bezieht sich auf ''Buchungsblatt''.','ax_buchungsblatt','21008-21007.1','ax_buchungsstelle','DLKM','beziehtSichAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1','''Buchungsstelle'' ist Teil von ''Buchungsblatt''. Bei ''Buchungsart'' mit einer der Wertearten für aufgeteilte Buchungen (Wertearten 1101, 1102, 1401 bis 1403, 2201 bis 2205 und 2401 bis 2404) muss die Relation zu einem ''Buchungsblatt'' und der ''Blattart'' mit der Werteart ''Fiktives Blatt'' bestehen.','ax_buchungsblatt','DLKM','21008-21007.2','bestehtAus','ax_buchungsstelle','DLKM','istBestandteilVon');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..*','Eine ''Buchungsstelle'' verweist mit ''durch'' auf eine andere ''Buchungsstelle'' auf einem anderen Buchungsblatt (herrschend). Die Buchungsstelle ist belastet durch ein Recht, dass ''durch'' die andere Buchungsstelle an ihr ausgeübt wird.','ax_buchungsstelle','21008.7-21008.8','ax_buchungsstelle','DLKM','durch');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,element,modellart,bezeichnung) VALUES ('0..*','''Buchungsstelle'' verweist auf ''Flurstück''.','ax_flurstueck','DLKM','21008-11001','ax_buchungsstelle','DLKM','verweistAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Diese Relationsart legt fest, welche Flurstücke ein Grundstück bilden. Nur bei der ''Buchungsart'' mit den Wertearten 1100, 1101 und 1102 muss die Relationsart vorhanden sein, sofern nicht ein Objekt AX_HistorischesFlurstueckOhneRaumbezug über die Relationsart ''istGebucht'' auf die Buchungsstelle verweist. Es handelt sich um die inverse Relationsrichtung.','ax_flurstueck','DLKM','(INV)11001-21008','istGebucht','ax_buchungsstelle','DLKM','grundstueckBestehtAus');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,element,modellart,bezeichnung) VALUES ('0..*','Eine ''Buchungsstelle'' verweist mit ''zu'' auf eine andere ''Buchungsstelle'' des gleichen Buchungsblattes (herrschend).','ax_buchungsstelle','DLKM','21008.1-21008.2','ax_buchungsstelle','DLKM','zu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..*','Eine ''Buchungsstelle'' verweist mit ''an'' auf eine andere ''Buchungsstelle'' auf einem anderen Buchungsblatt. Die Buchungsstelle kann ein Recht (z.B. Erbbaurecht) oder einen Miteigentumsanteil ''an'' der anderen Buchungsstelle haben Die Relation zeigt stets vom begünstigten Recht zur belasteten Buchung (z.B. Erbbaurecht hat ein Recht ''an'' einem Grundstück).','ax_buchungsstelle','21008.5-21008.6','ax_buchungsstelle','DLKM','an');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','ZDE','''Zeitpunkt der Eintragung'' beinhaltet das Datum, an dem die Rechtsänderung stattgefunden hat (z.B. Eintragung im Grundbuch).','ax_buchungsstelle','DLKM','zeitpunktdereintragung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BTX','''Buchungstext'' enthält zusätzliche Angaben zur Buchungsart (z.B. die genaue Bezeichnung von Nutzungsrechten).','ax_buchungsstelle','DLKM','buchungstext');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Anteil','DLKM','ANT','''Anteil'' ist die Angabe des Miteigentumsanteils am Grundstück oder des Anteils am Recht. Das Attribut setzt sich zusammen aus: 1. Spalte: Zähler 2. Spalte: Nenner','ax_buchungsstelle','DLKM','anteil');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NRA','''Nummer im Aufteilungsplan'' ist die Nummer entsprechend der Teilungserklärung über die Aufteilung des Gebäudes in Lage und Größe der im Sondereigentum und der im gemeinschaftlichen Eigentum stehenden Gebäudeteile.','ax_buchungsstelle','DLKM','nummerimaufteilungsplan');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BUB','''Beschreibung des Umfangs der Buchung'' ist eine nähere Beschreibung der Buchungsart (z.B. ''von der Quelle bis zur Brücke'').','ax_buchungsstelle','DLKM','beschreibungdesumfangsderbuchung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BSO','''Beschreibung des Sondereigentums'' ist die Beschreibung von Wohnungseigentum an Wohnungen und von Teileigentum an nicht zu Wohnzwecken dienenden Räumen.','ax_buchungsstelle','DLKM','beschreibungdessondereigentums');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LNR','''Laufende Nummer'' ist die eindeutige Nummer der Buchungsstelle auf dem Buchungsblatt.','ax_buchungsstelle','DLKM','laufendenummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Buchungsart_Buchungsstelle','DLKM','BAR','''Buchungsart'' bezeichnet die Art der Buchung.','ax_buchungsstelle','DLKM','buchungsart');
INSERT INTO alkis_elemente(name,kennung,abgeleitet_aus,modellart,type) VALUES ('ax_li_processstep_ohnedatenerhebung','21013','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','CI_ResponsibleParty','PRO','ax_li_processstep_ohnedatenerhebung','DLKM','processor');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','DateTime','DAT','ax_li_processstep_ohnedatenerhebung','DLKM','datetime');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','AX_LI_ProcessStep_OhneDatenerhebung_Description','DES','ax_li_processstep_ohnedatenerhebung','DLKM','description');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_moor','DLKM','43005','REO','[E] ''Moor'' ist eine unkultivierte Fläche, deren obere Schicht aus vertorften oder zersetzten Pflanzenresten besteht. Torfstich bzw. Torfabbaufläche wird der Objektart 41005 ''Tagebau, Grube, Steinbruch'' mit AGT ''Torf'' zugeordnet.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Moor''.','ax_moor','DLKM','name');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type) VALUES ('ax_fortfuehrungsnummer','15004','''AX_Fortführungsnummer'' enthält die Bestandteile zur Ableitung der Nummer des Fortführungsnachweises.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','LFD','Diese Attributart enthält die laufende Nummer des Fortführungsnachweises.','ax_fortfuehrungsnummer','DLKM','laufendenummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','LAN','Diese Attributart enthält den Schlüssel des Bundeslandes.','ax_fortfuehrungsnummer','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','GEM','Diese Attributart enthält den Schlüssel der Gemarkung.','ax_fortfuehrungsnummer','DLKM','gemarkungsnummer');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_bergbaubetrieb','DLKM','41004','REO','[E] ''Bergbaubetrieb'' ist eine Fläche, die für die Förderung des Abbaugutes unter Tage genutzt wird.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Bergbaubetrieb''.','ax_bergbaubetrieb','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Abbaugut_Bergbaubetrieb','AGT','''Abbaugut'' gibt an, welches Material abgebaut wird.','ax_bergbaubetrieb','DLKM','abbaugut');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kurzbezeichnung.','ax_bergbaubetrieb','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Bergbaubetrieb','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''Bergbaubetrieb''.','ax_bergbaubetrieb','DLKM','zustand');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_strassenverkehr','DLKM','42001','REO','[E] ''Straßenverkehr'' umfasst alle für die bauliche Anlage Straße erforderlichen sowie dem Stra- ßenverkehr dienenden bebauten und unbebauten Flächen.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Strasse','FKT','''Funktion'' beschreibt die verkehrliche Nutzung von ''Straßenverkehr''.','ax_strassenverkehr','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagebezeichnung','NAM','''Name'' ist der Eigenname von ''Strassenverkehr''.','ax_strassenverkehr','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ZNM','''Zweitname'' ist ein von der Lagebezeichnung abweichender Name von ''Strassenverkehrsflaeche'' (z.B. "Deutsche Weinstraße").','ax_strassenverkehr','DLKM','zweitname');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Strasse','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''Strassenverkehrsflaeche''.','ax_strassenverkehr','DLKM','zustand');
INSERT INTO alkis_elemente(lebenszeitintervall,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Das Lebenszeitintervall des Objekts beginnt, wenn ein Punkt mit Punktkennung untergeht.','ax_punktkennunguntergegangen','16002','NREO','[E] ''Punktkennung untergegangen'' enthält Punktkennungen, die untergegangen sind.','{"aa_nreo"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Art_Punktkennung','ART','''Art'' ist eine Kennzeichnung der Ordnungsnummern.','ax_punktkennunguntergegangen','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','PKN','''Punktkennung'' ist ein von der Katasterbehörde vergebenes Ordnungsmerkmal.','ax_punktkennunguntergegangen','DLKM','punktkennung');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_bahnverkehr','DLKM','42010','REO','[E] ''Bahnverkehr'' umfasst alle für den Schienenverkehr erforderlichen Flächen. Flächen von Bahnverkehr sind - der Bahnkörper (Unterbau für Gleise; bestehend aus Dämmen oder Einschnitten und deren kleineren Böschungen, Durchlässen, schmalen Gräben zur Entwässerung, Stützmauern, Unter- und Überführung, Seiten und Schutzstreifen) mit seinen Bahnstrecken - an den Bahnkörper angrenzende bebaute und unbebaute Flächen (z.B. größere Böschungsflächen).','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Bahnverkehr','FKT','''Funktion'' ist die objektiv feststellbare Nutzung von ''Bahnverkehr''.','ax_bahnverkehr','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NRB','''Nummer der Bahnstrecke'' ist die von der Bahn AG festgelegte Verschlüsselung der Bahnstrecke.','ax_bahnverkehr','DLKM','nummerderbahnstrecke');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ZNM','''Zweitname'' ist der von der Lagebezeichnung abweichende Name von ''Bahnverkehr'' (z. B. ''Höllentalbahn'').','ax_bahnverkehr','DLKM','zweitname');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagebezeichnung','BEZ','''Bezeichnung'' ist die Angabe der Orte, in denen die Bahnlinie beginnt und endet (z. B. ''Bahnlinie Frankfurt - Würzburg).','ax_bahnverkehr','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Bahnkategorie','BKT','''Bahnkategorie'' beschreibt die Art des Verkehrsmittels.','ax_bahnverkehr','DLKM','bahnkategorie');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Bahnverkehr','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''Bahnverkehr''.','ax_bahnverkehr','DLKM','zustand');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Die ''Böschungsfläche'' ist Bestandteil des ZUSO ''Böschung, Kliff''.','ax_boeschungsflaeche','61002','REO','''Böschungsfläche'' ist eine durch Geländekanten begrenzte Geländeoberfläche künstlichen oder natürlichen Ursprungs.','{"ag_flaechenobjekt"}','DLKM','Objektart');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_untergeordnetesgewaesser','55002','REO','[E] ''UntergeordnetesGewaesser'' ist ein stehendes oder fließendes Gewässer mit untergeordneter Bedeutung.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_UntergeordnetesGewaesser','FKT','''Funktion'' ist die objektiv erkennbare Art von ''UntergeordnetesGewaesser''.','ax_untergeordnetesgewaesser','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_HydrologischesMerkmal_UntergeordnetesGewaesser','HYD','''Hydrologisches Merkmal'' gibt die Wasserverhältnisse von ''Untergeordnetes- Gewaesser'' an.','ax_untergeordnetesgewaesser','DLKM','hydrologischesmerkmal');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''UntergeordnetesGewaesser''.','ax_untergeordnetesgewaesser','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_LageZurErdoberflaeche_UntergeordnetesGewaesser','OFL','''Lage zur Erdoberfläche'' ist die Angabe der relativen Lage von ''UntergeordnetesGewaesser'' zur Erdoberfläche.','ax_untergeordnetesgewaesser','DLKM','lagezurerdoberflaeche');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Die Attributart ''Bewuchs'' ist immer zu belegen, wenn die Attributart ''Zustand'' mit Wert 5000 nicht belegt ist.','ax_vegetationsmerkmal','54001','REO','[E] ''Vegetationsmerkmal'' beschreibt den zusätzlichen Bewuchs oder besonderen Zustand einer Grundfläche.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Vegetationsmerkmal','FKT','''Funktion'' beschreibt, welchem Zweck ''Vegetationsmerkmal'' dient.','ax_vegetationsmerkmal','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Vegetationsmerkmal''.','ax_vegetationsmerkmal','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Bewuchs_Vegetationsmerkmal','BWS','''Bewuchs'' ist die Art des Vegetationsmerkmals.','ax_vegetationsmerkmal','DLKM','bewuchs');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Vegetationsmerkmal','ZUS','''Zustand'' ist der Zustand von ''Vegetationsmerkmal''.','ax_vegetationsmerkmal','DLKM','zustand');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_vertretung','21005','NREO','[E] ''Vertretung'' gibt an, welche Person eine andere Person in Katasterangelegenheiten vertritt.','{"aa_nreo"}','DLKM','Objektart','Die Relationsart ''vertritt'' ist objektbildend.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..*','Die Relation ''Vertretung'' bezieht sich auf ''Flurstück'' sagt aus, für welche Flurstücke die Vertretung wahrgenommen wird.','ax_flurstueck','21005-11001','ax_vertretung','DLKM','beziehtSichAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1','Die Relation ''Vertretung'' hängt an ''Person'' sagt aus, welche Person die Vertretung wahrnimmt.','ax_person','21005-21001','uebtAus','ax_vertretung','DLKM','haengtAn');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1..*','Die Relation ''Vertretung'' vertritt ''Person'' sagt aus, welche Person durch die Vertretung vertreten wird. Es handelt sich um die inverse Relationsrichtung.','ax_person','(INV)21001-21005','wirdVertretenVon','ax_vertretung','DLKM','vertritt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','AZV','''Angaben zur Vertretung'' beschreibt den Umfang der Vertretung (z.B. alle Flurstücke einer Gemeinde).','ax_vertretung','DLKM','angabenzurvertretung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','ADV','''Art der Vertretung'' beschreibt die Art der Vertretung ( z.B. Bevollmächtigter).','ax_vertretung','DLKM','artdervertretung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','BDV','''Beginn der Vertretung'' gibt das Datum des Beginns der Vertretung an.','ax_vertretung','DLKM','beginndervertretung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','EDV','''Ende der Vertretung'' gibt das Datum des Endes der Vertretung an.','ax_vertretung','DLKM','endedervertretung');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_wohnbauflaeche','DLKM','41001','REO','[E] ''Wohnbaufläche'' ist eine baulich geprägte Fläche einschließlich der mit ihr im Zusammenhang stehenden Freiflächen (z.B. Vorgärten, Ziergärten, Zufahrten, Stellplätze und Hofraumflächen), die ausschließlich oder vorwiegend dem Wohnen dient.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_ArtDerBebauung_Wohnbauflaeche','BEB','''Art der Bebauung'' differenziert nach offener und geschlossener Bauweise aus topographischer Sicht und nicht nach gesetzlichen Vorgaben (z.B. BauGB).','ax_wohnbauflaeche','DLKM','artderbebauung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Wohnbaufläche'' insbesondere bei Objekten au- ßerhalb von Ortslagen.','ax_wohnbauflaeche','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Wohnbauflaeche','ZUS','''Zustand'' beschreibt, ob ''Wohnbaufläche'' ungenutzt ist oder ob eine Fläche als Wohnbaufläche genutzt werden soll.','ax_wohnbauflaeche','DLKM','zustand');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,erfassungskriterien,bildungsregeln) VALUES ('ax_gebaeudeausgestaltung','91001','REO','[E] ''Gebäudeausgestaltung'' dient zur Speicherung von Gebäudeausgestaltungslinien, wenn eine Objektbildung im Zuge der Migration nicht möglich ist.','{"au_linienobjekt"}','DLKM','Objektart','''Gebäudeausgestaltung'' ist modelliert, wenn Gebäudelinien nicht automatisch aus der ALK migriert werden können. In diesem Fall bildet diese Objektart diejenigen Linien des Gebäudes zur kartographischen Ausgestaltung ab. Eine Neubildung dieser Objektart in ALKIS im Rahmen des Führungsprozesses ist nicht zulässig.','Die Attributart ''Darstellung'' ist objektbildend.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('1','''Gebäudeausgestaltung'' zeigt auf die zugehörige Objektart ''Gebäude''.','ax_gebaeude','91001-31001','ax_gebaeudeausgestaltung','DLKM','zeigtAuf');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Darstellung_Gebaeudeausgestaltung','DAR','''Darstellung'' beschreibt die Signaturierung der Gebäudeausgestaltungslinien.','ax_gebaeudeausgestaltung','DLKM','darstellung');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_anschrift','DLKM','21003','NREO','[E] ''Anschrift'' ist die postalische Adresse, verbunden mit weiteren Adressen aus dem Bereich elektronischer Kommunikationsmedien.','{"aa_nreo"}','DLKM','Objektart','Die Relationsarten ''gehört_zu'' und/oder ''bezieht_sich_auf'' sind objektbildend. Eine der beiden Relationsarten muss vorhanden sein.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Eine ''Anschrift'' gehört zu ''Person''. Es handelt sich um die inverse Relationsrichtung.','ax_person','DLKM','(INV)21001-21003','hat','ax_anschrift','DLKM','gehoertZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Es handelt sich um die inverse Relationsrichtung.','ax_dienststelle','(INV)73011-21003','hat','ax_anschrift','DLKM','beziehtSichAuf');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','HSN','''Hausnummer'' ist die von der Gemeinde für ein Gebäude vergebene Nummer, gegebenenfalls mit einem Adressierungszusatz. Diese Attributart ist immer im Zusammenhang mit der Attributart ''Straße'' zu verwenden.','ax_anschrift','DLKM','hausnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','WEA','''Weitere Adressen'' beinhalten weitere Anschriften aus dem Bereich elektronischer Kommunikationsmedien (z.B. E-Mail, URL).','ax_anschrift','DLKM','weitereadressen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','PFH','''Postfach'' ist die postalische Nummer des Postfaches.','ax_anschrift','DLKM','postfach');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','ORP','''Ort (Post)'' ist der postalische Ortsname.','ax_anschrift','DLKM','ort_post');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','ORA','''Ort (Amtliches Ortsnamensverzeichnis)'' ist der Ortsname laut amtlichem Ortsnamensverzeichnis.','ax_anschrift','DLKM','ort_amtlichesortsnamensverzeichnis');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','BLA','''Bestimmungsland'' ist eine in Großbuchstaben angegebene Bezeichnung im internationalen Brief- und Paketverkehr.','ax_anschrift','DLKM','bestimmungsland');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','TEL','''Telefon'' ist die Nummer des Telefonanschlusses.','ax_anschrift','DLKM','telefon');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','OTT','''Ortsteil'' ist der Name eines Ortsteils nach dem amtlichen Ortsverzeichnis.','ax_anschrift','DLKM','ortsteil');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','STR','''Straße'' ist der Straßen- oder Platzname nach dem amtlichen Straßenverzeichnis bzw. wie bekannt geworden.','ax_anschrift','DLKM','strasse');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','FAX','''Fax'' ist die Nummer des Faxanschlusses.','ax_anschrift','DLKM','fax');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','PLZ','''Postleitzahl - Postzustellung'' ist die Postleitzahl der Postzustellung.','ax_anschrift','DLKM','postleitzahlpostzustellung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','PZP','''Postleitzahl - Postfach'' ist die Postleitzahl des Postfaches.','ax_anschrift','DLKM','postleitzahlpostfach');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQOhneDatenerhebung','DLKM','QAG','Angaben zur Herkunft der Informationen (Erhebungsstelle). Die Information ist konform zu den Vorgaben aus ISO 19115 zu repräsentieren.','ax_anschrift','DLKM','qualitaetsangaben');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_landeswappen','EWP','DLKM','Die Externe Objektart "Landeswappen" enthält das Landeswappen als Pixelgraphik in einer externen Datei, z.B. im Format GeoTiff.','{}','DLKM','Datentyp','Das Landeswappen wird in allen AFIS- und ALKIS- (Standard-) Ausgaben präsentiert; daher ist diese Datei durch die Implementierung als permanente Datei bereitzustellen.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,element,modellart,bezeichnung) VALUES ('1','URI','DLKM','URI','ax_landeswappen','DLKM','uri');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Die Attributart ''Gemeindefläche'' wird im DLKM verpflichtend geführt.','ax_kommunalesgebiet','DLKM','75003','REO','''Kommunales Gebiet'' ist ein Teil der Erdoberfläche, der von einer festgelegten Grenzlinie umschlossen ist und den politischen Einflussbereich einer Kommune repräsentiert (z.B. Stadt-, Landgemeinde, gemeindefreies Gebiet).','{"ax_gebiet"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Gemeindekennzeichen','DLKM','GKZ','''Gemeindekennzeichen'' ist die amtliche Verschlüsselung der Gemeinde bzw. des Gemeindeteils (siehe Katalog der Gemeinden).','ax_kommunalesgebiet','DLKM','gemeindekennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Area','DLKM','GDF','''Gemeindefläche'' ist die amtliche bzw. statistische Fläche für eine Gemeinde.','ax_kommunalesgebiet','DLKM','gemeindeflaeche');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_besonderertopographischerpunkt','61009','ZUSO','[E] ''Besonderer Topographischer Punkt'' ist ein im Liegenschaftskataster geführter Topographischer Punkt.','{"aa_zuso"}','DLKM','Objektart','Das ZUSO besteht aus einem oder mehreren REO ''Punktort''.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','PKN','''Punktkennung'' ist ein von der Katasterbehörde vergebenes Ordnungsmerkmal.','ax_besonderertopographischerpunkt','DLKM','punktkennung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','ZST','''Zuständige Stelle'' enthält den Namen der Stelle, die eine Zuständigkeit besitzt.','ax_besonderertopographischerpunkt','DLKM','zustaendigestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','SOE','''Sonstige Eigenschaft'' sind Informationen zum ''Besonderen topographischen Punkt''. Sonstige Eigenschaften werden im Rahmen der Migration aus bestehenden Verfahrenslösungen übernommen.','ax_besonderertopographischerpunkt','DLKM','sonstigeeigenschaft');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,type) VALUES ('ap_fpo','02330','REO','Flächenförmiges Präsentationsobjekt','{"ap_gpo","au_flaechenobjekt"}','Objektart');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_dqpunktort','14006','DLKM','''DQPunktort'' enthält Angaben zur Herkunft, Genauigkeit und Vertrauenswürdigkeit der Informationen zu einem Punktort. Die Angaben zur Herkunft sind konform zu den Vorgaben aus ISO 19115 zu repräsentieren. Ein Beispiel: Das Qualitätselement zu einem Punktort mit den folgenden Eigenschaften: - Erhebungsstelle ''Land+Stellenart+Stelle'' - Datenerhebung ''Aus Katastervermessung ermittelt (1000)'' - Berechnungsdatum ''01.04.2001'' - kein Bestimmungsdatum - Genauigkeitsstufe 2000 - Genauigkeitswert 2,2 cm - Vertrauenswürdigkeit 1200 sieht wie folgt aus: self.herkunft.processStep[1].description = "Erhebung" self.herkunft.processStep[1].processor = <Erhebungsstelle gemäß der Codierung nach dem Metadatenkatalog> self.herkunft.processStep[2].description = "Berechnung" self.herkunft.processStep[2].dateTime = 2004-02-29T10:15:30Z self.herkunft.source[1].description = "1000" self.herkunft.source[1].sourceStep = self.herkunft.processStep[1] self.genauigkeitswert.result[1] = 2.2 cm self.genauigkeitsstufe = "2000" self.vertrauenswuerdigkeit = "1200"','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_LI_Lineage_Punktort','DLKM','DPL','''Herkunft'' enthält Angaben zur Datenerhebung sowie zum Datum der Berechnung und Bestimmung der Koordinaten. Soll Erhebung und/oder Erhebungsstelle dokumentiert werden, dann erfolgt dies über LI_ProcessStep- und LI_Source-Elemente. Die Erhebungsstelle wird in einem LI_ProcessStep mit self.description = ''Erhebung'' und der Erhebungsstelle in self.processor dokumentiert. Die Datenerhebung wird in einem LI_Source-Element dokumentiert (über die Kennung aus der CodeList AX_Datenerhebung_Punktort). Soll die Berechnung oder die Bestimmung mit Datum protokolliert werden, so ist ein entsprechender herkunft.processStep mit gesetzten Attributen self.dateTime und self.description ("Berechnung" bzw. "Bestimmung") zu erzeugen. Ggf. kann hier erneut die durchführende Stelle in self.processor dokumentiert werden.','ax_dqpunktort','DLKM','herkunft');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','DQ_RelativeInternalPositionalAccuracy','GWT','"Genauigkeitswert" gibt die realtive Genauigkeit gemäß der entsprechenden ISO-Norm an.','ax_dqpunktort','DLKM','genauigkeitswert');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Genauigkeitsstufe_Punktort','GST','"Genauigkeitsstufe " ist die Stufe der Standardabweichung (S) als Ergebnis einer Schätzung (i.d.R. nach der Methode der kleinsten Quadrate), in welche die Messelemente der gleichzeitig berechneten Punkte einbezogen und in der Regel die Ausgangspunkte als fehlerfrei eingeführt wurden.','ax_dqpunktort','DLKM','genauigkeitsstufe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','LZK','''Lagezuverlässigkeit'' enthält eine Aussage über die Identität zwischen den Koordinaten des amtlichen Nachweises und den bei der Grenzuntersuchung bestimmten Koordinaten von Objektpunkten. TRUE belegt die Überprüfung eines Punktes nach dem Katsternachweis. Damit wird zum Ausdruck gebracht, dass ein Punkt in der Örtlichkeit eindeutig identifiziert und unter Berücksichtigung der Nachbarschaftsbeziehungen als identisch mit dem Katasterzahlenwerk festgestellt wurde. FALSE gibt an, dass für eine aufgemessene Koordinate eine derartige Überprüfung nicht stattgefunden hat und die Koordinate zunächst vorläufigen Character besitzt, um eine spätere, genauere Bestimmung zu erleichtern (z.B. durch Transformation). Wird die Attribuart nicht geführt, entfällt eine Aussage über die Lagezuverlässigkeit.','ax_dqpunktort','DLKM','lagezuverlaessigkeit');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Vertrauenswuerdigkeit_Punktort','VWL','Die "Vertrauenswürdigkeit" gibt die Vertrauenswürdigkeit der Koordinate oder Höhe an.','ax_dqpunktort','DLKM','vertrauenswuerdigkeit');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,type) VALUES ('ap_tpo','02340','Textförmiges Präsentationsobjekt. Es handelt sich um eine abstrakte Objektart.','{"ap_gpo"}','Element');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('1','Real','FSP','Die Zeichensperrung steuert den zusätzlichen Raum, der zwischen 2 aufeinanderfolgende Zeichenkörper geschoben wird. Er ist ein Faktor, der mit der angegebenen Zeichenhöhe multipliziert wird, um den einzufügenden Zusatzabstand zu erhalten. Mit der Abhängigkeit von der Zeichenhöhe wird erreicht, dass das Schriftbild unabhängig von der Zeichenhöhe gleich wirkt. Der Defaultwert ist 0. Das Attribut ist bei Objekterzeugung mit dem Wert 0 vorbelegt.','ap_tpo','fontsperrung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('0..1','CharacterString','SIT','Schriftinhalt; enthält die darzustellenden Zeichen','ap_tpo','schriftinhalt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('1','AP_VertikaleAusrichtung','FVA','Die vertikale Ausrichtung eines Textes gibt an, ob die Bezugsgeometrie die Basis (Grundlinie) des Textes, die Mitte oder obere Buchstabenbegrenzung betrifft. Das Attribut ist bei Objekterzeugung mit dem Wert Mitte vorbelegt.','ap_tpo','vertikaleausrichtung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('1','AP_HorizontaleAusrichtung','FHA','Gibt die Ausrichtung des Textes bezüglich der Textgeometrie an. linksbündig: Der Text beginnt an der Punktgeometrie bzw. am Anfangspunkt der Liniengeometrie. rechtsbündig: Der Text endet an der Punktgeometrie bzw. am Endpunkt der Liniengeometrie zentrisch: Der Text erstreckt sich von der Punktgeometrie gleich weit nach links und rechts bzw. steht auf der Mitte der Standlinie. Das Attribut ist bei Objekterzeugung mit dem Wert zentrisch vorbelegt.','ap_tpo','horizontaleausrichtung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('1','Real','SKA','Skalierungsfaktor für die Schriftgröße (fontGroesse * skalierung). Das Attribut ist bei Objekterzeugung mit dem Wert 1 vorbelegt.','ap_tpo','skalierung');
INSERT INTO alkis_relationsart(kardinalitaet,zielobjektart,kennung,definition,element,bezeichnung) VALUES ('0..1','ap_lpo','02340-02320','Die Relation ermöglicht es, einem textförmigen Präsentationsobjekt ein linienförmiges Präsentationsobjekt zuzuweisen. Einziger bekannter Anwendungsfall ist der Zuordnungspfeil. Die Anwendung dieser Relation ist nur zugelassen, wenn sie im entsprechenden Signaturenkatalog beschrieben ist.','ap_tpo','hat');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_gemarkungsteilflur','DLKM','73008','NREO','"Gemarkungsteil/Flur" enthält die Gemarkungsteile und Fluren. Gemarkungsteile kommen nur in Bayern vor und entsprechen den Fluren in anderen Bundesländern.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''Schlüssel'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Dienststelle_Schluessel','ZST','"Gemarkungsteil" gehört zum Amtsbezirk einer Dienststelle. Die Relation kommt vor, wenn die Gemarkung als kleinste Verwaltungseinheit von Dienststellen nicht ausreicht.','ax_gemarkungsteilflur','DLKM','gehoertzu');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_GemarkungsteilFlur_Schluessel','DLKM','SLL','''Schlüssel'' enthält die geltende amtliche Abkürzung der Verwaltungseinheit.','ax_gemarkungsteilflur','DLKM','schluessel');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,type) VALUES ('ap_gpo','02300','Generisches Präsentationsobjekt Es handelt sich um eine abstrakte Objektart.','{}','Element');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('0..1','CharacterString','ART','''Art'' gibt die Kennung des Attributs an, das mit dem Präsentationsobjekt dargestellt werden soll. Wenn mehrere Eigenschaften eines Objekts in einem Präsentationsobjekt dargestellt werden sollen, beschreibt der Wert des Attributs ART, um welche Darstellungsanteile es sich bei dem Präsentationsobjekt handelt. Die zulässigen Werte werden im Signaturenkatalog angegeben. Die Attributart ''Art'' darf nur für folgende Fälle nicht belegt sein: 1.) Freie Präsentationsobjekte (dientZurDarstellungVon=NULL) 2.) AP_Darstellung Objekte, die sich auf alle Präsentationen eines Fachobjektes beziehen.','ap_gpo','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('0..1','Integer','DPR','Enthält die Darstellungspriorität für Elemente der Signatur. Eine gegenüber den Festlegungen des Signaturenkatalogs abweichende Priorität wird über dieses Attribut definiert und nicht über eine neue Signatur.','ap_gpo','darstellungsprioritaet');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('0..1','CharacterString','SNR','Enthält die Signaturnummer gemäß Signaturenkatalog. Hinweise: Die Signaturnummer wird nur dann angegeben, wenn für einen Sachverhalt mehrere Signaturnummern zulässig sind. Freie Präsentationsobjekte (dientZurDarstellungVon=NULL) müssen das Attribut ''Signaturnummer'' belegt haben.','ap_gpo','signaturnummer');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,definition,element,bezeichnung) VALUES ('0..*','Durch den Verweis auf einen Set beliebiger AFIS-ALKIS-ATKIS-Objekte gibt das Präsentationsobjekt an, zu wessen Präsentation es dient. Dieser Verweis kann für Fortführungen ausgenutzt werden oder zur Unterdrückung von Standardpräsentationen der zugrundeliegenden ALKIS-ATKIS-Objekte. Ein Verweis auf ein AA_Objekt vom Typ AP_GPO ist nicht zugelassen.','aa_objekt','02300-00001','Diese Relation stellt die Verbindung der Präsentationsobjekte zu den zugehörigen AA_Objekten her. Das Ziel der Relation darf nicht wiederum ein Präsentationsobjekt sein.','ap_gpo','dientZurDarstellungVon');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,type) VALUES ('ap_lto','02342','REO','Textförmiges Präsentationsobjekt mit linienförmiger Textgeometrie.','{"ap_tpo","au_kontinuierlicheslinienobjekt"}','Objektart');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_namensnummer','DLKM','21006','NREO','[E] ''Namensnummer'' ist die laufende Nummer der Eintragung, unter welcher der Eigentümer oder Erbbauberechtigte im Buchungsblatt geführt wird. Rechtsgemeinschaften werden auch unter AX_Namensnummer geführt.','{"aa_nreo"}','DLKM','Objektart');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..*','Die Relation ''Namensnummer'' hat Vorgänger ''Namensnummer'' gibt Auskunft darüber, aus welchen Namensnummern die aktuelle entstanden ist.','ax_namensnummer','21006.3-21006.4','ax_namensnummer','DLKM','hatVorgaenger');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,element,modellart,bezeichnung) VALUES ('0..1','Die Relation ''Namensnummer'' besteht aus Rechtsverhältnissen zu ''Namensnummer'' sagt aus, dass mehrere Namensnummern zu einer Rechtsgemeinschaft gehören können. Die Rechtsgemeinschaft selbst steht unter einer eigenen AX_Namensnummer, die zu allen Namensnummern der Rechtsgemeinschaft eine Relation besitzt.','ax_namensnummer','DLKM','21006.1-21006.2','ax_namensnummer','DLKM','bestehtAusRechtsverhaeltnissenZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,element,modellart,bezeichnung) VALUES ('1','Eine ''Namensnummer'' ist Teil von einem ''Buchungsblatt''.','ax_buchungsblatt','DLKM','21006-21007','ax_namensnummer','DLKM','istBestandteilVon');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','Durch die Relation ''Namensnummer'' benennt ''Person'' wird die Person zum Eigentümer, Erbbauberechtigten oder künftigen Erwerber.','ax_person','DLKM','21006-21001','weistAuf','ax_namensnummer','DLKM','benennt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Integer','SNR','''Strichblattnummer'' ist eine Unternummer der Grundbuchblattnummer. Sie wird der Attributart ''Nummer'' als Präfix vorangestellt.','ax_namensnummer','DLKM','strichblattnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','NMR','''Nummer'' ist die laufende Nummer der Eintragung gemäß Abteilung 1 Grundbuchblatt, unter der eine Person aufgeführt ist (z.B. 1 oder 1a).','ax_namensnummer','DLKM','nummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_ArtDerRechtsgemeinschaft_Namensnummer','ARG','''Art der Rechtsgemeinschaft'' ist die Art des für die Gesamthandgemeinschaft maßgebenden Rechtsverhältnisses.','ax_namensnummer','DLKM','artderrechtsgemeinschaft');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Anteil','DLKM','ANT','''Anteil'' ist der Anteil der Berechtigten in Bruchteilen (Par. 47 GBO) an einem gemeinschaftlichen Eigentum (Grundstück oder Recht).','ax_namensnummer','DLKM','anteil');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Eigentuemerart_Namensnummer','ART','''Eigentümerart'' ist die Kategorie des Eigentums.','ax_namensnummer','DLKM','eigentuemerart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BRG','"Beschrieb der Rechtsgemeinschaft" ist der Name oder die juristische Bezeichnung der Rechtgemeinschaft Diese Attributart kommt nur vor, wenn die "Art der Rechtsgemeinschaft" die Werteart "Sonstiges" aufweist.','ax_namensnummer','DLKM','beschriebderrechtsgemeinschaft');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','LNR','''Laufende Nummer nach DIN 1421'' ist die interne laufende Nummer für die Rangfolge der Person, die nach den Vorgaben aus DIN 1421 strukturiert ist.','ax_namensnummer','DLKM','laufendenummernachdin1421');
INSERT INTO alkis_elemente(name,kennung,abgeleitet_aus,modellart,type) VALUES ('ax_nutzung_gebaeude','31006','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','AX_Nutzung','NTZ','ax_nutzung_gebaeude','DLKM','nutzung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','Integer','ANT','ax_nutzung_gebaeude','DLKM','anteil');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Das Objekt ''Wasserspiegelhöhe'' muss innerhalb einer Gewässerfläche liegen.','ax_wasserspiegelhoehe','57001','REO','[E] ''Wasserspiegelhöhe'' ist die Höhe des mittleren Wasserstandes über bzw. unter der Höhenbezugsfläche.','{"au_punktobjekt","ax_bauwerkeeinrichtungenundsonstigeangaben"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','Length','HWS','''Höhe des Wasserspiegels'' ist die Differenz zwischen dem mittleren Wasserstand und der Höhenbezugsfläche in [m] auf dm gerundet.','ax_wasserspiegelhoehe','DLKM','hoehedeswasserspiegels');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_baublock','75001','REO','[E] ''Baublock'' ist ein Teil der Erdoberfläche, der von einer festgelegten Grenzlinie umschlossen ist und Teile einer Gemeinde definiert.','{"au_flaechenobjekt"}','DLKM','Objektart','Die Attributart ''Baublockbezeichnung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Art_Baublock','ART','''Art'' ist die Art der Baublockfläche.','ax_baublock','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','BBZ','''Baublockbezeichnung'' ist die von der Gemeinde vergebene eindeutige Bezeichnung eines Teils des Gemeindegebietes.','ax_baublock','DLKM','baublockbezeichnung');
INSERT INTO alkis_elemente(name,kennung,abgeleitet_aus,modellart,type) VALUES ('ax_erfassung_dgm','62001','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','AX_Identifikation','IDF','ax_erfassung_dgm','DLKM','identifikation');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_DQErfassungsmethode','DES','''Description'' ist die Erfassungsmethode und beschreibt das Messverfahren, mit dem unregelmäßig verteilte Geländepunkte, die Geländekante oder die Geripplinie erfasst wurden.','ax_erfassung_dgm','DLKM','description');
INSERT INTO alkis_elemente(lebenszeitintervall,konsistenzbedingungen,name,grunddatenbestand,kennung,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Das Lebenszeitintervall des Objekts beginnt mit dem Entstehen und endet spätestens mit dem Untergang eines Objektes der Objektarten "Lagefestpunkt, Höhenfestpunkt, Schwerefestpunkt, Referenzstationspunkt, Grenzpunkt, Besonderer Gebäudepunkt, Besonderer Bauwerkspunkt, Aufnahmepunkt, Sicherungspunkt, Sonstiger Vermessungspunkt, Besonderer topograpischer Punkt".','1. ''Punktort'' der Objektart ''Grenzpunkt'': Es gibt für jedes Objekt der Objektart ''Grenzpunkt'', der in einer Flurstücksgrenze liegt, nur einen ''PunktortTA''. (Hinweis: Nur dieser ''Punktort'' führt zur Darstellung in der Liegenschaftskarte.) Ein ''Grenzpunkt'' außerhalb einer Flurstücksgrenze (Sonderfall eines indirekt abgemarkten Grenzpunktes) hat immer einen ''PunktortAU''. 2. "Punktort" der Objektarten "Lagefestpunkt", "Höhenfestpunkt", "Schwerefestpunkt", "Referenzstationspunkt", "Besonderer topographischer Punkt", "Aufnahmepunkt", "Sicherungspunkt" und "Sonstiger Vermessungspunkt": Jedes Objekt besteht aus "PunktortAU"-Objekten. 3. "Punktort" der Objektart "Besonderer Gebäudepunkt" und "Besonderer Bauwerkspunkt": Jedes Objekt besteht aus "PunktortAG"-Objekten und/oder "PunktortAU"-Objekten. 4. Das Objekt ''PunktortAU'' wird auch zur Darstellung weiterer Bezugssysteme verwendet.','ax_punktort','DLKM','14001','[E] "Punktort" definiert die räumliche Position oder die ebene Lage oder die Höhe eines Objektes der Objektarten "Lagefestpunkt, Höhenfestpunkt, Schwerefestpunkt, Referenzstationspunkt, Grenzpunkt, Besonderer Gebäudepunkt, Aufnahmepunkt, Sicherungspunkt, Sonstiger Vermessungspunkt, Besonderer topographischer Punkt, Besonderer Bauwerkspunkt" in einem Bezugssystem (nach ISO 19111). Es sind keine zusammengesetzten Bezugssysteme (ISO 19111, Ziffer 6.2.3) zugelassen. Bei AX_Punktort handelt es sich um die abstrakte Verallgemeinerung der drei Punktortvarianten ''Punktort AG'', ''Punktort AU'' und ''Punktort TA'', die sich jeweils in ihrer geometrischen Ausprägung entsprechend dem AAA-Basisschema unterscheiden. Jedes Objekt Punktort kann nur zu einem Punktobjekt gehören, auch wenn mehrere Punkte aufeinander fallen. Es handelt sich um eine abstrakte Objektart.','{}','DLKM','Element','Das "Bezugssystem" (gemäß ISO 19111) ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','PRU','"Überprüfungsdatum" gibt das Datum der letzten Überprüfung (durch Messung) an, bei der die Koordinaten bzw. die Höhe gegenüber benachbarten Festpunkten als unverändert festgestellt wurden.','ax_punktort','DLKM','ueberpruefungsdatum');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','DLKM','KDS','''Kartendarstellung'' ist ein Hinweis darauf, dass der ''Punktort'' zur Darstellung in einer Karte führt. Welche Objektarten Bestandteil der ALKIS-Standardausgabe ''Liegenschaftskarte'' sind, regelt der ensprechende Filterausdruck (siehe GeoInfoDok, Kapitel 7.2) . Hinweis: Die Objektarten ''Grenzpunkt'', ''Besonderer Gebäudepunkt'', ''Besonderer topographischer Punkt'', ''Besonderer Bauwerkspunkt'', ''Aufnahmepunkt'', ''Sicherungspunkt'' und ''Sonstiger Vermessungspunkt'' weisen jeweils immer nur einen ''Punktort'' mit der Attributart ''Kartendarstellung'' mit der Werteart TRUE auf. Die Werteart TRUE kommt immer vor beim ''PunktortTA''-Objekt zu einem ''Grenzpunkt''.','ax_punktort','DLKM','kartendarstellung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQPunktort','DLKM','Q2D','Angaben zur Herkunft, Genauigkeit und Vertrauenswürdigkeit der Informationen.','ax_punktort','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','HIN','"Hinweise" kann Bemerkungen zur Messung, zur Berechnung, zum Koordinatenstatus, zu Genauigkeitsangaben und zum Punktuntergang enthalten.','ax_punktort','DLKM','hinweise');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Koordinatenstatus_Punktort','KST','"Koordinatenstatus" gibt an, ob die Koordinaten bzw. die Höhe amtlich sind oder einen anderen Status besitzen.','ax_punktort','DLKM','koordinatenstatus');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,type) VALUES ('ap_lpo','02320','REO','Linienförmiges Präsentationsobjekt','{"ap_gpo","au_linienobjekt"}','Objektart');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_verband','73012','NREO','''Verband'' umfasst die Verbände, denen Gemeinden angehören (z.B. Planungsverbände) mit den entsprechenden Bezeichnungen.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''enthaelt ist objektbildend. Die Attributart ''schluesselGesamt'' entfällt.');
INSERT INTO alkis_methode(definition,element,bezeichnung) VALUES ('Die Gemeinden des Verbands liegen alle in einem Kreis. Die Methode ''erfrageKreis()'' liefert den ''Kreis'' zurück. Typ des Rückgabewerts: AX_KreisRegion','ax_verband','AX_Verband::erfrageKreis');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Art_Verband','ART','''Art des Verbandes'' bezeichnet die Art des überregionalen Verbandes.','ax_verband','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1..*','AX_Gemeindekennzeichen','GDE','Der Verband enthält Gemeinden.','ax_verband','DLKM','enthaelt');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,erfassungskriterien,bildungsregeln) VALUES ('Hat das Muster-, Landesmuster- und Vergleichsstück die Raumbezugsart ''Punkt'' und ist ein zugehöriges ''Grabloch der Bodenschätzung'' vorhanden, sind die Positionen dieser Raumbezugsarten immer identisch.','ax_musterlandesmusterundvergleichsstueck','72002','REO','[E] ''Muster-, Landesmuster- und Vergleichsstück'' ist eine besondere bodengeschätzte Fläche nach dem Bodenschätzungsgesetz, für die eine Ertragsfähigkeit im Liegenschaftskataster nachzuweisen ist.','{"au_objekt"}','DLKM','Objektart','Für die Attributart ''Merkmal'' gilt: Musterstück und Landesmusterstück sind flächenförmig oder punktförmig und sind als Fläche oder Punkt modelliert, Vergleichsstück ist punktförmig und ist als Punkt modelliert.','Die Attributart ''Merkmal'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','MKN','''Nummer'' ist ein von der Finanzverwaltung zur eindeutigen Bezeichnung der Muster-, Landesmusterstücke und Vergleichsstücke vergebenes Ordnungsmerkmal (z.B.: 2328.07 mit Bundesland (23), Finanzamt (28), lfd. Nummer (07)).','ax_musterlandesmusterundvergleichsstueck','DLKM','nummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_SonstigeAngaben_MusterLandesmusterUndVergleichsstueck','SON','''Sonstige Angaben'' ist der Nachweis von Besonderheiten einer bodengeschätzten Fläche.','ax_musterlandesmusterundvergleichsstueck','DLKM','sonstigeangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','WE1','''Bodenzahl oder Grünlandgrundzahl'' ist die Wertzahl nach dem Acker- oder Grünlandschätzungsrahmen. Diese Attributart kommt nicht vor, wenn die ''Sonstige Angaben'' Wertearten mit den Bezeichnern ''Rieselwasser, künstliche Bewässerung (RiWa)'', ''Streuwiese (Str)'', ''Hutung (Hu)'', ''Acker-Hackrain (A-Hack)'', ''Grünland-Hackrain (Gr- Hack)'' oder ''Geringstland (Ger)'' aufweist.','ax_musterlandesmusterundvergleichsstueck','DLKM','bodenzahlodergruenlandgrundzahl');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_ZustandsstufeOderBodenstufe_MusterLandesmusterUndVergleichsstueck','KN2','''Zustandsstufe oder Bodenstufe'' ist die nach den Schätzungsrahmen festgelegte Bezeichnung der Zustands- oder Bodenstufe.','ax_musterlandesmusterundvergleichsstueck','DLKM','zustandsstufeoderbodenstufe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','WE2','''Ackerzahl oder Grünlandzahl'' ist die "Bodenzahl oder Grünlandgrundzahl" einschließlich Ab- und Zurechnungen nach dem Bodenschätzungsgesetz. Diese Attributart kommt nicht vor, wenn die ''Sonstige Angaben'' die Werteart mit dem Bezeichner ''Geringstland (Ger)'' aufweist.','ax_musterlandesmusterundvergleichsstueck','DLKM','ackerzahlodergruenlandzahl');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_musterlandesmusterundvergleichsstueck','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Kulturart_MusterLandesmusterUndVergleichsstueck','KUL','''Kulturart'' ist die bestandskräftig festgesetzte landwirtschaftliche Nutzungsart entsprechend dem Acker- oder Grünlandschätzungsrahmen.','ax_musterlandesmusterundvergleichsstueck','DLKM','kulturart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Merkmal_MusterLandesmusterUndVergleichsstueck','MDB','''Merkmal'' ist die Kennzeichnung zur Unterscheidung von Musterstück, Landesmusterstück und Vergleichsstück.','ax_musterlandesmusterundvergleichsstueck','DLKM','merkmal');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Bodenart_MusterLandesmusterUndVergleichsstueck','KN1','''Bodenart'' ist die nach den Durchführungsbestimmungen zum Bodenschätzungsgesetz (Schätzungsrahmen) festgelegte Bezeichnung der Bodenart.','ax_musterlandesmusterundvergleichsstueck','DLKM','bodenart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_EntstehungsartOderKlimastufeWasserverhaeltnisse_MusterLandes musterUndVergleichsstueck','KN3','''Entstehungsart oder Klimastufe/Wasserverhältnisse'' ist die nach den Schätzungsrahmen festgelegte Bezeichnung der Entstehungsart oder der Klimastufe und der Wasserverhältnisse.','ax_musterlandesmusterundvergleichsstueck','DLKM','entstehungsartoderklimastufewasserverhaeltnisse');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Flächenförmige Objekte der Objektart ''Bauwerk im Gewässerbereich'' mit BWF 2030-2050 und 2130-2136 liegen immer auf Objekten der Objektart ''Unland, Vegetationslose Fläche'' mit FKT 1110.','ax_bauwerkimgewaesserbereich','53009','REO','[E] ''Bauwerk im Gewässerbereich'' ist ein Bauwerk, mit dem ein Wasserlauf unter einem Verkehrsweg oder einem anderen Wasserlauf hindurch geführt wird. Ein ''Bauwerk im Gewässerbereich'' dient dem Abfluss oder der Rückhaltung von Gewässern oder als Messeinrichtung zur Feststellung des Wasserstandes oder als Uferbefestigung.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Bauwerk im Gewässerbereich''.','ax_bauwerkimgewaesserbereich','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kennziffer von ''Bauwerk im Gewässerbereich''.','ax_bauwerkimgewaesserbereich','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_BauwerkImGewaesserbereich','ZUS','''Zustand'' beschreibt die Beschaffenheit von ''Bauwerk im Gewässerbereich''.','ax_bauwerkimgewaesserbereich','DLKM','zustand');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bauwerksfunktion_BauwerkImGewaesserbereich','BWF','''Bauwerksfunktion'' beschreibt die bauliche Art von ''Bauwerk im Gewässerbereich''.','ax_bauwerkimgewaesserbereich','DLKM','bauwerksfunktion');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_gemeindeteil','DLKM','73006','NREO','''Gemeindeteil'' enthält alle zur Gemeindeteilebene zählenden Verwaltungseinheiten innerhalb eines Bundeslandes.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''Schlüssel'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Gemeindekennzeichen','DLKM','SLL','''Schlüssel'' enthält die geltende amtliche Abkürzung von ''Gemeindeteil''.','ax_gemeindeteil','DLKM','schluessel');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_gebiet','DLKM','75010','REO','[E] ''Gebiet'' ist ein Teil der Erdoberfläche, der von einer festgelegten Grenzlinie umschlossen ist und den politischen Einflussbereich einer Verwaltungseinheit repräsentiert. Es handelt sich um eine abstrakte Objektart.','{"ta_multisurfacecomponent"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','(DER) SCH','''Schlüssel (gesamt)'' enthält die geltende Abkürzung des Katalogeintrags (bzw. von dessen Bezeichnung). Er setzt sich ggf. aus mehreren Einzelteilen des Schlüssels des Katalogeintrags zusammen, die in der Attributart ''Schlüssel'' und dem dazugehörigen Datentyp angegeben sind. Die Reihenfolge der Schlüsselbestandteile ergibt sich ebenfalls aus diesem Datentyp. Im ''Schlüssel (gesamt)'' werden Stellen, für die keine Schlüssel vergeben sind, mit Nullen gefüllt. Das Attribut ist ein abgeleitetes Attribut und kann nicht gesetzt werden.','ax_gebiet','DLKM','schluesselgesamt');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_heide','DLKM','43004','REO','[E] ''Heide'' ist eine meist sandige Fläche mit typischen Sträuchern, Gräsern und geringwertigem Baumbestand.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Heide''.','ax_heide','DLKM','name');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_besondererhoehenpunkt','62090','REO','''Besonderer Höhenpunkt'' ist ein Höhenpunkt mit besonderer topographischer Bedeutung.','{"au_punktobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_BesondereBedeutung','BBD','''Besondere Bedeutung'' ist die besondere topographische Bedeutung des Höhenpunktes.','ax_besondererhoehenpunkt','DLKM','besonderebedeutung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_benutzergruppenba','81004','NREO','[E] In der Objektart ''Benutzergruppe (NBA)'' werden relevante Informationen für die Durchführung der NBA-Versorgung, z.B. die anzuwendenden Selektionskriterien, gespeichert. Eine gesonderte Prüfung der Zugriffsrechte erfolgt in diesem Fall nicht, deren Berücksichtigung ist von dem Administrator bei der Erzeugung und Pflege der NBA-Benutzergruppen sicherzustellen.','{"ax_benutzergruppe"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_BereichZeitlich','BRZ','''Bereich - zeitlich'' bezeichnet den Zeitraum für die Abgabe von Änderungsinformationen im Rahmen des NBA-Verfahrens.','ax_benutzergruppenba','DLKM','bereichzeitlich');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Portionierungsparameter','PPR','Portierungsparameter regeln die Aufteilung einer NBA-Transaktion in mehrere Portionen.','ax_benutzergruppenba','DLKM','portionierungsparameter');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1..*','Query','SEL','Standardselektionskriterien für die Benutzergruppe.','ax_benutzergruppenba','DLKM','selektionskriterien');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','QUI','Wird der Schalter gesetzt, so wird eine Quittierung der erfolgreichen Übernahme einer NBA-Lieferung angefordert. Das Attribut ist bei Objekterzeugung mit dem Wert false vorbelegt.','ax_benutzergruppenba','DLKM','quittierung');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_buchung_historischesflurstueck','17004','''Buchung'' ist ein Hinweis auf die ''Buchungsstelle'' (und in Verbindung damit auch auf das ''Buchungsblatt''), auf die das Flurstück des Liegenschaftskatasters zum ''Zeitpunkt der Historisierung'' verweist.','{}','DLKM','Datentyp','Die Attributart setzt sich zusammen aus: 1. Spalte: Blattart 2. Spalte: Buchungsart 3. Spalte: Ordnungsmerkmal mit den Verschlüsselungen/Nummern in der Reihenfolge - 1. Land - 2. Buchungsblattbezirk - 3. Buchungsblattnummer 4. Spalte: Laufende Nummer der Buchungsstelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','(DER) BBK','''Buchungsblattkennzeichen'' ist ein eindeutiges Fachkennzeichen für ein Buchungsblatt. Aufbau Buchungsblattkennzeichen : 1.) Land (Verschlüsselung zweistellig), 2 Ziffern 2.) Buchungsblattbezirk (Verschlüsselung vierstellig), 4 Ziffern 3.) Buchungsblattnummer mit Buchstabenerweiterung (7 Stellen) Die Elemente sind rechtsbündig zu belegen, fehlende Stellen sind mit führenden Nullen zu belegen. Die Gesamtlänge des Buchungsblattkennzeichens beträgt immer 13 Zeichen. Das Attribut ist ein abgeleitetes Attribut und kann nicht gesetzt werden.','ax_buchung_historischesflurstueck','DLKM','buchungsblattkennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','LFD','''Laufende Nummer der Buchungsstelle'' ist die eindeutige Nummer der Buchungsstelle auf dem Buchungsblatt.','ax_buchung_historischesflurstueck','DLKM','laufendenummerderbuchungsstelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Buchungsblattbezirk_Schluessel','BBZ','Buchungsblattbezirk des Buchungsblatts.','ax_buchung_historischesflurstueck','DLKM','buchungsblattbezirk');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','BUA','''Buchungsart'' bezeichnet die Art der Buchung als langschriftlichen Text..','ax_buchung_historischesflurstueck','DLKM','buchungsart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Blattart_HistorischesFlurstueck','BLA','''Blattart'' ist die Art des Buchungsblattes.','ax_buchung_historischesflurstueck','DLKM','blattart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','BBN','Buchungsblattnummer mit Buchstabenerweiterung.','ax_buchung_historischesflurstueck','DLKM','buchungsblattnummermitbuchstabenerweiterung');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,abgeleitet_aus,modellart,type) VALUES ('ax_li_source_mitdatenerhebung','50005','DLKM','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,element,modellart,bezeichnung) VALUES ('0..1','AX_LI_ProcessStep_MitDatenerhebung','ax_li_source_mitdatenerhebung','DLKM','sourcestep');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,element,modellart,bezeichnung) VALUES ('0..1','AX_Datenerhebung','ax_li_source_mitdatenerhebung','DLKM','description');
INSERT INTO alkis_elemente(name,kennung,objekttyp,abgeleitet_aus,type) VALUES ('ap_darstellung','02350','NREO','{"ap_gpo","aa_nreo"}','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('0..1','CharacterString','PNR','In diesem Attribut wird durch Verweis auf eine Regel im Signaturenkatalog beschrieben, wie Signaturen zu positionieren sind. Eine Positionierungsregel definiert z.B. welchen Abstand Bäumchen in einem Wald haben und ob die Verteilung regelmäßig oder zufällig ist.','ap_darstellung','positionierungsregel');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_anderefestlegungnachwasserrecht','71004','REO','[E] ''Andere Festlegung nach Wasserrecht'' ist die auf den Grund und Boden bezogene Beschränkung, Belastung oder andere Eigenschaft einer Fläche nach öffentlichen, wasserrechtlichen Vorschriften.','{"ag_flaechenobjekt"}','DLKM','Objektart','Die Attributart ''Art der Festlegung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NUM','''Nummer'' ist die amtliche Nummer der jeweiligen Festlegung.','ax_anderefestlegungnachwasserrecht','DLKM','nummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung zuständig ist (siehe Katalog der Dienststellen).','ax_anderefestlegungnachwasserrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qualitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_anderefestlegungnachwasserrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_AndereFestlegungNachWasserrecht','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder andere öffentlich-rechtlichen Eigenschaft.','ax_anderefestlegungnachwasserrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Der ''Grenzpunkt'' und der ihm zugeordnete ''Punktort'' mit der Attributart ''KArtendarstellung'' mit der Werteart TRUE und der Raumbezugsart Knoten erhält den Raumbezug durch einen Knoten der Masche, der zur Vermittlung des Raumbezuges des entsprechenden ''Flurstücks'' beiträgt. Ein ''Grenzpunkt'' außerhalb von Flurstücksgrenzen (Sonderfall eines indirekt abgemarkten Grenzpunktes) und der ihm zugeordnete ''Punktort'' erhält den Raumbezug durch einen Punkt. Dieser trägt nicht zur Vermittlung des Raumbezugs der Masche des entsprechenden Flurstücks bei. Wenn die zurückgestellte Abmarkung eines Grenzpunktes nachgeholt wird, dann ist die ausgesetzte Abmarkung, Wert 9600, zu löschen.','ax_grenzpunkt','DLKM','11003','ZUSO','[A] ''Grenzpunkt'' ist ein den Grenzverlauf bestimmender, meist durch Grenzzeichen gekennzeichneter Punkt.','{"aa_zuso"}','DLKM','Objektart','Das ZUSO besteht aus einem oder mehreren REO ''Punktort''.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..1','Ein von der Geometrie der Flurstücksfläche abweichender ''Grenzpunkt'' (Sonderfall des indirekt abgemarkten Grenzpunktes) zeigt auf einen ''Grenzpunkt'', der in der Flurstücksgrenze liegt.','ax_grenzpunkt','11003.1-11003.2','ax_grenzpunkt','DLKM','zeigtAuf');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','ZWM','''Zwischenmarke'' ist eine gebietsweise übliche Bezeichnung für ein Grenzzeichen, das in eine geradlinige Flurstücksgrenze eingebracht ist, um den Grenzverlauf bei fehlender Sichtverbindung oder großer Entfernung zwischen den Grenzzeichen ausreichend erkennbar zu machen.','ax_grenzpunkt','DLKM','zwischenmarke');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_GruendeDerAusgesetztenAbmarkung_Grenzpunkt','GAA','''Gründe der ausgesetzten Abmarkung'' zeigt die Gründe auf, weshalb eine Abmarkung zeitweilig ausgesetzt ist.','ax_grenzpunkt','DLKM','gruendederausgesetztenabmarkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','PKN','''Punktkennung'' ist ein von der Katasterbehörde vergebenes Ordnungsmerkmal.','ax_grenzpunkt','DLKM','punktkennung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','FGP','''Festgestellter Grenzpunkt'' ist ein Hinweis darauf, dass der Grenzpunkt Bestandskraft erlangt hat.','ax_grenzpunkt','DLKM','festgestelltergrenzpunkt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Marke','DLKM','ABM','''Abmarkung (Marke)'' ist die Marke zur dauerhaften Kennzeichnung von Grenzpunkten im Boden und an baulichen Anlagen. Die Attributart ist hierarchisch in vier Stufen gegliedert. Die Gliederungsstufen ergeben sich aus den Werten für die Bezeichner (Tausender-, Hunderter-, Zehner- und Einerstelle).','ax_grenzpunkt','DLKM','abmarkung_marke');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','ZST','''Zuständige Stelle'' enthält den Dienststellenschlüssel der Stelle, die eine Zuständigkeit besitzt.','ax_grenzpunkt','DLKM','zustaendigestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','SOE','''Sonstige Eigenschaft'' sind Informationen zum Grenzpunkt. Sonstige Eigenschaften werden im Rahmen der Migration aus bestehenden Verfahrenslösungen übernommen.','ax_grenzpunkt','DLKM','sonstigeeigenschaft');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_BemerkungZurAbmarkung_Grenzpunkt','BZA','''Bemerkung zur Abmarkung'' ist eine Angabe zur Sicherung der Abmarkung.','ax_grenzpunkt','DLKM','bemerkungzurabmarkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BPN','''Besondere Punktnummer'' ist eine durch amtliche Stellen vergebene fachspezifische Kennung für einen Grenzpunkt (z.B.: Landes- oder Bundesgrenzpunktes).','ax_grenzpunkt','DLKM','besonderepunktnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AAM','''Ausgesetzte Abmarkung'' ist eine Kennzeichnung der Stelle, die die Abmarkung eines Grenzpunktes zeitweilig ausgesetzt bzw. zurückgestellt hat (siehe Katalog der Dienststellen).','ax_grenzpunkt','DLKM','ausgesetzteabmarkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Horizontfreiheit_Grenzpunkt','HOZ','''Horizontfreiheit'' beschreibt die Abschattung bei Satellitenmessverfahren.','ax_grenzpunkt','DLKM','horizontfreiheit');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','RHO','''Relative Höhe'' ist die Angabe der Höhe [m] der ''Abmarkung (Marke)'' oberhalb der Erdoberfläche oder der Tiefe [m] unterhalb der Erdoberfläche. (Vorzeichenregel: oberhalb der Erdoberfläche ''+'', unterhalb der Erdoberfläche ''- ''.)','ax_grenzpunkt','DLKM','relativehoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ZDE','''Zeitpunkt der Entstehung'' ist der Zeitpunkt oder das Entstehungsjahr, zu dem der Grenzpunkt fachlich entstanden ist. Das Attribut kommt vor, wenn der Zeitpunkt der Entstehung von dem Zeitpunkt abweicht, der systemseitig bei der Eintragung in den Bestandsdaten als Anfang der Lebenszeit (siehe Lebenszeitintervall bei Objekten) gesetzt wird. Die Regelungen hierzu sind länderspezifisch gefasst.','ax_grenzpunkt','DLKM','zeitpunktderentstehung');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type) VALUES ('ax_folgeva','81007','Der komplexe Datentyp ''FOLGEVA'' enthält Parameter, die für die Folgeverarbeitung von (Standard-) Ausgaben benötigt werden.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Datenformat_Benutzer','DFM','''Datenformat'' steuert das Format (einschließlich Versionsbezeichnung) der Ausgabe bei einer regelmäßigen Abgabe von Daten.','ax_folgeva','DLKM','datenformat');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Ausgabemedium_Benutzer','AMD','''Ausgabemedium'' steuert den Datenträger für die Ausgabe bei einer regelmäßigen Abgabe von Daten.','ax_folgeva','DLKM','ausgabemedium');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','FAG','''Formatangabe'' enthält Parameter zur Steuerung der Formate bei der Präsentationsausgabe (z.B. DINA4 Hoch, DINA3 Quer). Die für die Standardausgaben zulässigen Formate sind in den jeweiligen Signaturenkatalogen angegeben.','ax_folgeva','DLKM','formatangabe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Real','MST','''Ausgabemaßstab'' ist der Maßstab des Ausgabeproduktes.','ax_folgeva','DLKM','ausgabemasstab');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_anderefestlegungnachstrassenrecht','71002','REO','[E] ''Andere Festlegung nach Straßenrecht'' ist die auf den Grund und Boden bezogene Beschränkung, Belastung oder andere Eigenschaft einer Fläche nach öffentlichen, straßenrechtlichen Vorschriften.','{"ag_objekt"}','DLKM','Objektart','Die Attributart ''Art der Festlegung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NUM','''Nummer'' ist die amtliche Nummer der jeweiligen Festlegung.','ax_anderefestlegungnachstrassenrecht','DLKM','nummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung zuständig ist (siehe Katalog der Dienststellen).','ax_anderefestlegungnachstrassenrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_anderefestlegungnachstrassenrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_AndereFestlegungNachStrassenrecht','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder anderen öffentlich-rechtlichen Eigenschaft.','ax_anderefestlegungnachstrassenrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('''Fließgewässer'' ist Bestandteil des ZUSO ''Wasserlauf'', ''Fließgewässer'' mit FKT 8300 ist Bestandteil des ZUSO ''Kanal''.','ax_fliessgewaesser','DLKM','44001','REO','[E] ''Fließgewässer'' ist ein geometrisch begrenztes, oberirdisches, auf dem Festland fließendes Gewässer, das die Wassermengen sammelt, die als Niederschläge auf die Erdoberfläche fallen oder in Quellen austreten, und in ein anderes Gewässer, ein Meer oder in einen See transportiert oder in einem System von natürlichen oder künstlichen Bodenvertiefungen verlaufendes Wasser, das zur Be- und Entwässerung an- oder abgeleitet wird oder ein geometrisch begrenzter, für die Schifffahrt angelegter künstlicher Wasserlauf, der in einem oder in mehreren Abschnitten die jeweils gleiche Höhe des Wasserspiegels besitzt.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Fliessgewaesser','FKT','''Funktion'' ist die Art von ''Fließgewässer''.','ax_fliessgewaesser','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagebezeichnung','NAM','''Name'' ist die Bezeichnung oder der Eigenname von ''Fließgewässer''.','ax_fliessgewaesser','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Kanal','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''Fließgewässer'' mit FKT=8300 (Kanal). Diese Attributart kann nur in Verbindung mit der Attributart ''Funktion'' und der Werteart 8300 vorkommen.','ax_fliessgewaesser','DLKM','zustand');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_dqohnedatenerhebung','21011','DLKM','Angaben zur Herkunft der Informationen (Erhebungsstelle). Die Information ist konform zu den Vorgaben aus ISO 19115 zu repräsentieren.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_LI_Lineage_OhneDatenerhebung','DLKM','DPL','''Herkunft'' enthält Angaben zur Erhebungsstelle. Die Erhebungsstelle wird in einem LI_ProcessStep mit self.description = ''Erhebung'' und der Erhebungsstelle in self.processor dokumentiert.','ax_dqohnedatenerhebung','DLKM','herkunft');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_kreisregion','DLKM','73004','NREO','''Kreis/Region'' enthält alle zur Kreisebene zählenden Verwaltungseinheiten innerhalb eines Bundeslandes.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''Schlüssel'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Kreis_Schluessel','DLKM','SLL','''Schlüssel'' enthält die geltende amtliche Abkürzung von ''Kreis/Region''.','ax_kreisregion','DLKM','schluessel');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..*','AX_Dienststelle_Schluessel','ZST','ax_kreisregion','DLKM','istamtsbezirkvon');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_bauwerkimverkehrsbereich','53001','REO','[E] ''Bauwerk im Verkehrsbereich'' ist ein Bauwerk, das dem Verkehr dient.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Bauwerk im Verkehrsbereich''.','ax_bauwerkimverkehrsbereich','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kennziffer von ''Bauwerk im Verkehrsbereich''.','ax_bauwerkimverkehrsbereich','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_BauwerkImVerkehrsbereich','ZUS','''Zustand'' beschreibt die derzeitige Benutzbarkeit von ''Bauwerk im Verkehrsbereich''.','ax_bauwerkimverkehrsbereich','DLKM','zustand');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bauwerksfunktion_BauwerkImVerkehrsbereich','BWF','''Bauwerksfunktion'' beschreibt die besondere Funktion oder Bauart von ''Bauwerk im Verkehrsbereich''.','ax_bauwerkimverkehrsbereich','DLKM','bauwerksfunktion');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('''Sonstiges Recht'' mit ADF 5400 kann nur auf Objekten der Objektartengruppe ''Vegetation'' liegen.','ax_sonstigesrecht','71011','REO','[E] ''Sonstiges Recht'' sind die auf den Grund und Boden bezogenen Beschränkungen, Belastungen oder anderen Eigenschaften einer Fläche nach weiteren, nicht unter die Objektarten 71001 bis 71010 zu subsumierenden öffentlich - rechtlichen Vorschriften.','{"ag_objekt"}','DLKM','Objektart','Die Attributart ''Art der Festlegung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung zuständig ist.','ax_sonstigesrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname der Festlegung von ''Sonstiges Recht''.','ax_sonstigesrecht','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qualitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_sonstigesrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kennziffer der Festlegung von ''Sonstiges Recht''.','ax_sonstigesrecht','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_SonstigesRecht','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder anderen öffentlich-rechtlichen Eigenschaft.','ax_sonstigesrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_schutzgebietnachnaturumweltoderbodenschutzrecht','71007','ZUSO','[E] ''Schutzgebiet nach Natur-, Umwelt- oder Bodenschutzrecht'' ist ein fachlich übergeordnetes Gebiet von Flächen mit bodenbezogenen Beschränkungen, Belastungen oder anderen Eigenschaften nach öffentlichen Vorschriften.','{"aa_zuso"}','DLKM','Objektart','Das ZUSO ''Schutzgebiet nach Natur-, Umwelt- oder Bodenschutzrecht'' besteht aus einem oder mehreren REO ''Schutzzone''.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung von ''Schutzgebiet nach Natur-, Umwelt- oder Bodenschutzrecht'' zuständig ist.','ax_schutzgebietnachnaturumweltoderbodenschutzrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Schutzgebiet nach Natur-, Umwelt- oder Bodenschutzrecht''.','ax_schutzgebietnachnaturumweltoderbodenschutzrecht','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qualitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_schutzgebietnachnaturumweltoderbodenschutzrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','SGN','''Nummer des Schutzgebietes'' ist die amtlich festgelegte Verschlüsselung von ''Schutzgebiet nach Natur-, Umwelt- oder Bodenschutzrecht''.','ax_schutzgebietnachnaturumweltoderbodenschutzrecht','DLKM','nummerdesschutzgebietes');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_SchutzgebietNachNaturUmweltOderBodenschutzrecht','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder anderen öffentlich-rechtlichen Eigenschaft.','ax_schutzgebietnachnaturumweltoderbodenschutzrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(name,kennung,abgeleitet_aus,modellart,type) VALUES ('ax_verwaltungsgemeinschaft_schluessel','73024','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','LAN','Bundesland.','ax_verwaltungsgemeinschaft_schluessel','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','KRS','Kreis.','ax_verwaltungsgemeinschaft_schluessel','DLKM','kreis');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','VWG','Verwaltungsgemeinschaft','ax_verwaltungsgemeinschaft_schluessel','DLKM','verwaltungsgemeinschaft');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','RBZ','Regierungsbezirk.','ax_verwaltungsgemeinschaft_schluessel','DLKM','regierungsbezirk');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_li_lineage_punktort','14008','DLKM','Soll Erhebung und/oder Erhebungsstelle dokumentiert werden, dann erfolgt dies über AX_LI_ProcessStep- und AX_LI_Source-Elemente.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,element,modellart,bezeichnung) VALUES ('0..*','AX_LI_Source_Punktort','DLKM','SRC','ax_li_lineage_punktort','DLKM','source');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,element,modellart,bezeichnung) VALUES ('0..*','AX_LI_ProcessStep_Punktort','DLKM','ax_li_lineage_punktort','DLKM','processstep');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_topographischelinie','91002','REO','[E] ''Topographische Linie'' ist eine topographische Abgrenzungslinie ohne Objektbedeutung, die Übergangsweise im Rahmen der Migration aus bestehenden Verfahrenslösungen benötigt wird.','{"au_linienobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Liniendarstellung_TopographischeLinie','LDS','''Liniendarstellung'' bezeichnet die Art der Liniendarstellung. Diese Information wird aus bestehenden Verfahrenslösungen übernommen Die Attributart ist nur im Rahmen der Migration zulässig.','ax_topographischelinie','DLKM','liniendarstellung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','SOE','''Sonstige Eigenschaft'' sind Informationen zur topographischen Linie','ax_topographischelinie','DLKM','sonstigeeigenschaft');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_kreis_schluessel','73022','DLKM','Amtliche Verschlüsselung des Kreises.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LAN','Bundesland.','ax_kreis_schluessel','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','KRS','Kreis.','ax_kreis_schluessel','DLKM','kreis');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','RBZ','Regierungsbezirk.','ax_kreis_schluessel','DLKM','regierungsbezirk');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_sonstigesbauwerkodersonstigeeinrichtung','51009','REO','[E] ''Sonstiges Bauwerk oder sonstige Einrichtung'' ist ein Bauwerk oder eine Einrichtung, das/die nicht zu den anderen Objektarten der Objektartengruppe Bauwerke und Einrichtungen gehört.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..1','''AX_SonstigesBauwerkOderSonstigeEinrichtung'' kann einem Gebäude zugeordnet werden, soweit dies fachlich erforderlich ist.','ax_gebaeude','51009-31001','ax_sonstigesbauwerkodersonstigeeinrichtung','DLKM','gehoertZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..1','''AX_SonstigesBauwerkOderSonstigeEinrichtung'' kann einem anderen Bauwerk zugeordnet werden.','ax_bauwerkeeinrichtungenundsonstigeangaben','51009-50001','ax_sonstigesbauwerkodersonstigeeinrichtung','DLKM','gehoertZuBauwerk');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Bauwerk','FKT','''Funktion'' beschreibt, welchem Zweck das Bauwerk dient.','ax_sonstigesbauwerkodersonstigeeinrichtung','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','HHO','''Objekthöhe'' ist die Höhendifferenz in [m] zwischen dem höchsten Punkt von ''Sonstiges Bauwerk oder sonstige Einrichtung'' und der Geländeoberfläche.','ax_sonstigesbauwerkodersonstigeeinrichtung','DLKM','objekthoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_HydrologischesMerkmal_SonstigesBauwerkOderSonstigeEinrichtung','HYD','''Hydrologisches Merkmal'' gibt die Wasserverhältnisse von ''Sonstiges Bauwerk oder sonstige Einrichtung'' an.','ax_sonstigesbauwerkodersonstigeeinrichtung','DLKM','hydrologischesmerkmal');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Sonstiges Bauwerk oder sonstige Einrichtung''.','ax_sonstigesbauwerkodersonstigeeinrichtung','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kennziffer von ''Sonstiges Bauwerk oder sonstige Einrichtung''.','ax_sonstigesbauwerkodersonstigeeinrichtung','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bauwerksfunktion_SonstigesBauwerkOderSonstigeEinrichtung','BWF','''Bauwerksfunktion'' beschreibt die Art oder Funktion von ''Sonstiges Bauwerk oder sonstige Einrichtung''.','ax_sonstigesbauwerkodersonstigeeinrichtung','DLKM','bauwerksfunktion');
INSERT INTO alkis_elemente(lebenszeitintervall,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,erfassungskriterien) VALUES ('Der Zeitpunkt der Entstehung des Objekts ''Historisches Flurstück'' ist identisch mit dem Zeitpunkt des Untergangs des Bezugsflurstücks (Flurstück zu seinen ''Lebzeiten''), aus dem das ''Historische Flurstück'' entstanden ist. Das ''Historische Flurstück'' geht nicht unter.','ax_historischesflurstueck','17001','REO','[E] ''Historisches Flurstück'' ist ein fachlich nicht mehr aktuelles Flurstück, das im Rahmen der Historisierung in ALKIS entsteht (ALKIS-Standardhistorie).','{"au_flaechenobjekt","ax_flurstueck_kerndaten"}','DLKM','Objektart','Im Rahmen der ALKIS-Standardhistorie sind alle historischen Flurstücke erfaßt.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Buchung_HistorischesFlurstueck','BUG','''Buchung'' ist ein Hinweis auf die ''Buchungsstelle'' (und in Verbindung damit auch auf das ''Buchungsblatt''), auf die das Flurstück des Liegenschaftskatasters zum ''Zeitpunkt der Historisierung'' verweist. Bildungsregel: Siehe Datentyp ''AX_Buchung_HistorischesFlurstueck''.','ax_historischesflurstueck','DLKM','buchung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','ZDH','''Zeitpunkt der Historisierung'' ist der Zeitpunkt, zu dem das Objekt ''Historisches Flurstück'' fachlich entstanden ist. Dieser Zeitpunkt ist identisch mit dem Zeitpunkt, zu dem das Objekt ''Flurstück'', aus dem das Objekt ''Historisches Flurstück'' direkt abgeleitet ist, fachlich untergegangen ist. Das Attribut kommt vor, wenn der Zeitpunkt der Historisierung vom Zeitpunkt der Löschung in den aktuellen Bestandsdaten, der systemseitig gesetzt wird, abweicht.','ax_historischesflurstueck','DLKM','zeitpunktderhistorisierung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','NFK','''Nachfolger-Flurstückskennzeichen'' ist die Bezeichnung der Flurstücke, die dem ''Historischen Flurstück'' direkt nachfolgen. Bildungsregel: Die Attributart setzt sich zusammen aus den nachfolgenden expliziten Attributarten in der Reihenfolge: 1. Land (2 Stellen) 2. Gemarkungsnummer (4 Stellen) 3. Flurnummer (3 Stellen) 4. Flurstücksnummer (5 Stellen für Zähler, 4 Stellen für Nenner) 5. Flurstücksfolge ( 2 Stellen) Da die Flurnummer und die Flurstücksfolge optional sind, sind aufgrund der bundeseinheitlichen Definition im Flurstückskennzeichen die entsprechenden Stellen, sofern sie länderspezifisch nicht belegt sind, durch Unterstrich "_" ersetzt.','ax_historischesflurstueck','DLKM','nachfolgerflurstueckskennzeichen');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Der ''Besondere Bauwerkspunkt'' und der ihm zugeordnete ''Punktort'' mit der Attributart ''Liegenschaftskarte'' und der Werteart TRUE erhält den Raumbezug durch einen Punkt der Fläche oder der Linie, die zur Vermittlung des Raumbezuges des entsprechenden Bauwerks oder der Einrichtung beiträgt.','ax_besondererbauwerkspunkt','51011','ZUSO','[E] ''Besonderer Bauwerkspunkt'' ist ein Punkt eines ''Bauwerks'' oder einer ''Einrichtung''.','{"aa_zuso"}','DLKM','Objektart','Das ZUSO besteht aus einem oder mehreren REO ''Punktort''.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','PKN','''Punktkennung'' ist ein von der Katasterbehörde vergebenes Ordnungsmerkmal.','ax_besondererbauwerkspunkt','DLKM','punktkennung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','ZST','''Zuständige Stelle'' enthält den Namen der Stelle, die eine Zuständigkeit besitzt.','ax_besondererbauwerkspunkt','DLKM','zustaendigestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','SOE','''Sonstige Eigenschaft'' sind Informationen zum ''Besonderen Bauwerkspunkt''. Sonstige Eigenschaften werden im Rahmen der Migration aus bestehenden Verfahrenslösungen übernommen.','ax_besondererbauwerkspunkt','DLKM','sonstigeeigenschaft');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_markantergelaendepunkt','62070','REO','''Markanter Geländepunkt'' ist ein Höhenpunkt an markanter Stelle des Geländes, der zur Ergänzung eines gitterförmigen DGM und/oder der Höhenliniendarstellung dient.','{"au_punktobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ErfassungMarkanterGelaendepunkt','EMM','''Erfassung markanter Geländepunkt'' beschreibt die Erfassungsmethode und das Erfassungsdatum.','ax_markantergelaendepunkt','DLKM','erfassungmarkantergelaendepunkt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_ArtDesMarkantenGelaendepunktes','AMP','''Art des markanten Punktes'' ist die Bedeutung des Punktes.','ax_markantergelaendepunkt','DLKM','artdesmarkantenpunktes');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_historischesbauwerkoderhistorischeeinrichtung','51007','REO','[E] ''Historisches Bauwerk oder historische Einrichtung'' ist ein Bauwerk oder eine Einrichtung vor- oder frühgeschichtlicher Kulturen.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Historisches Bauwerk oder historische Einrichtung''.','ax_historischesbauwerkoderhistorischeeinrichtung','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArchaeologischerTyp_HistorischesBauwerkOderHistorischeEinrichtung','ATP','''Archäologischer Typ'' beschreibt die Art von ''Historisches Bauwerk oder historische Einrichtung''.','ax_historischesbauwerkoderhistorischeeinrichtung','DLKM','archaeologischertyp');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_firstlinie','31004','REO','[E] ''Firstlinie'' kennzeichnet den Verlauf des Dachfirstes eines Gebäudes.','{"ag_linienobjekt"}','DLKM','Objektart');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_felsenfelsblockfelsnadel','61006','REO','[E] ''Felsen, Felsblock, Felsnadel'' ist eine aufragende Gesteinsmasse oder ein einzelner großer Stein.','{"au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','HHO','''Objekthöhe'' ist die Höhendifferenz in [m] zwischen dem höchsten Punkt von ''Felsen, Felsblock, Felsnadel'' und der Geländeoberfläche.','ax_felsenfelsblockfelsnadel','DLKM','objekthoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Felsen, Felsblock, Felsnadel''.','ax_felsenfelsblockfelsnadel','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','''Qualitätsangaben'' sind Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_felsenfelsblockfelsnadel','DLKM','qualitaetsangaben');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_verwaltungsgemeinschaft','73009','ZUSO','[E] ''Verwaltungsgemeinschaft'' bezeichnet einen Zusammenschluss von Gemeinden zur gemeinsamen Erfüllung von hoheitlichen Aufgaben.','{"aa_zuso","ax_katalogeintrag"}','DLKM','Objektart','Die Attributart ''Schlüssel'' ist objektbildend.');
INSERT INTO alkis_methode(definition,element,bezeichnung) VALUES ('Die Gemeinden der Verwaltungsgemeinschaft liegen alle in einem Kreis. Die Methode ''erfrageKreis()'' liefert den ''Kreis'' zurück. Typ des Rückgabewerts: AX_KreisRegion','ax_verwaltungsgemeinschaft','AX_Verwaltungsgemeinschaft::erfrageKreis');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Verwaltungsgemeinschaft_Schluessel','SLL','''Schlüssel'' enthält die geltende amtliche Abkürzung von ''Verwaltungsgemeinschaft''.','ax_verwaltungsgemeinschaft','DLKM','schluessel');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Bezeichnung_Verwaltungsgemeinschaft','BZA','''Bezeichnung (Art)'' enthält den landesspezifischen Begriff für eine Verwaltungsgemeinschaft.','ax_verwaltungsgemeinschaft','DLKM','bezeichnungart');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_bundesland','DLKM','73002','NREO','''Bundesland'' umfasst das Gebiet des jeweiligen Bundeslandes innerhalb der Bundesrepublik Deutschland.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''Schlüssel'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bundesland_Schluessel','DLKM','SLL','''Schlüssel'' enthält die geltende amtliche Abkürzung von ''Bundesland''.','ax_bundesland','DLKM','schluessel');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Dienststelle_Schluessel','ZST','''Bundesland'' ist Verwaltungsbezirk einer Dienststelle.','ax_bundesland','DLKM','istamtsbezirkvon');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_klassifizierungnachwasserrecht','DLKM','71003','REO','[E] ''Klassifizierung nach Wasserrecht'' ist die auf den Grund und Boden bezogene Beschränkung, Belastung oder andere Eigenschaft einer Fläche nach öffentlichen, wasserrechtlichen Vorschriften.','{"ag_flaechenobjekt"}','DLKM','Objektart','Die Attributart ''Art der Festlegung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','AFS','''Ausführende Stelle'' ist die Stelle, die für die Festlegung zuständig ist (siehe Katalog der Dienststellen).','ax_klassifizierungnachwasserrecht','DLKM','ausfuehrendestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_klassifizierungnachwasserrecht','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die amtliche Nummer des Gewässers','ax_klassifizierungnachwasserrecht','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_ArtDerFestlegung_KlassifizierungNachWasserrecht','DLKM','ADF','''Art der Festlegung'' ist die auf den Grund und Boden bezogene Art der Beschränkung, Belastung oder anderen öffentlich-rechtlichen Eigenschaft.','ax_klassifizierungnachwasserrecht','DLKM','artderfestlegung');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_netzpunkt','DLKM','13004','ZUSO','[E] ''Netzpunkt'' ist eine Klasse, die allgemeingültige Eigenschaften für alle Objektarten dieser Objektartengruppe enthält. Es handelt sich um eine abstrakte Objektart.','{"aa_zuso"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','RHO','''Relative Höhe'' ist die Angabe der Höhe [m] der ''Abmarkung (Marke)'' oberhalb der Erdoberfläche oder der Tiefe [m] unterhalb der Erdoberfläche. (Vorzeichenregel: oberhalb der Erdoberfläche ''+'', unterhalb der Erdoberfläche ''- ''.)','ax_netzpunkt','DLKM','relativehoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Horizontfreiheit_Netzpunkt','HOZ','''Horizontfreiheit'' beschreibt die Abschattung bei Satellitenmessverfahren.','ax_netzpunkt','DLKM','horizontfreiheit');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','PKN','"Punktkennung" ist ein von der Katasterbehörde vergebenes Ordnungsmerkmal.','ax_netzpunkt','DLKM','punktkennung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','ZST','''Zuständige Stelle'' enthält den Namen der Stelle, die eine Zuständigkeit besitzt.','ax_netzpunkt','DLKM','zustaendigestelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Marke','DLKM','VMA','''Vermarkung (Marke)'' ist die Marke zur dauerhaften Kennzeichnung von Vermessungspunkten im Boden und an baulichen Anlagen.','ax_netzpunkt','DLKM','vermarkung_marke');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','SOE','"Sonstige Eigenschaft" enthält Informationen zum Netzpunkt. Sonstige Eigenschaften werden im Rahmen der Migration aus bestehenden Verfahrenslösungen übernommen.','ax_netzpunkt','DLKM','sonstigeeigenschaft');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_bahnverkehrsanlage','53004','REO','[E] ''Bahnverkehrsanlage'' ist eine Fläche mit Einrichtungen zur Abwicklung des Personenund/oder Güterverkehrs bei Schienenbahnen. Dazu gehören das Empfangsgebäude, sonstige räumlich angegliederte Verwaltungs- und Lagergebäude, bahntechnische Einrichtungen, Freiflächen und Gleisanlagen. Die ''Bahnverkehrsanlage'' der Eisenbahnen beginnt oder endet im Allgemeinen am Einfahrtssignal oder an der Einfahrtsweiche.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bahnhofskategorie_Bahnverkehrsanlage','BFK','''Bahnhofskategorie'' ist die zum Zeitpunkt der Erhebung erkennbare oder feststellbare vorherrschend vorkommende Nutzung.','ax_bahnverkehrsanlage','DLKM','bahnhofskategorie');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Bahnverkehrsanlage''.','ax_bahnverkehrsanlage','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Bahnkategorie_Gleis','BKT','''Bahnkategorie'' bezeichnet das Verkehrsmittel, das die Verkehrsanlage nutzt.','ax_bahnverkehrsanlage','DLKM','bahnkategorie');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_buchungsblattbezirk_schluessel','73016','DLKM','Amtliche Verschlüsselung des Buchungsblattbezirks.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','BBB','Kennung des Bezirks','ax_buchungsblattbezirk_schluessel','DLKM','bezirk');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LAN','"Buchungsblattbezirk" liegt innerhalb eines "Bundeslandes".','ax_buchungsblattbezirk_schluessel','DLKM','land');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,type) VALUES ('ap_ppo','02310','REO','Punktförmiges Präsentationsobjekt','{"ap_gpo","au_punkthaufenobjekt"}','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('0..1','Angle','DWI','Winkel um den der Text oder die Signatur mit punktförmiger Bezugsgeometrie aus der Horizontalen gedreht ist. Angabe im Bogenmaß; Zählweise im mathematisch positiven Sinn (von Ost über Nord nach West und Süd). Das Attribut ist bei Objekterzeugung mit dem Wert 0 vorbelegt.','ap_ppo','drehwinkel');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,bezeichnung) VALUES ('0..1','Real','SKA','Skalierungsfaktor für Symbole. Das Attribut ist bei Objekterzeugung mit dem Wert 1 vorbelegt.','ap_ppo','skalierung');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type) VALUES ('ax_portionierungsparameter','81008','Alle REO und deren anhängende NREO und ZUSO, die innerhalb eines Portionsquadrates - die Größe wird durch ''seitenlaenge'' bestimmt - liegen, gemeinsam in eine Portion. Anhängende NREO und ZUSO werden nur in der jeweils ersten Portion ihres Auftretens abgegeben. Siehe auch GeoInfoDok, Kapitel 10. Die Portionen einer Lieferung werden über geeignete Kennungen als zusammengehörig kenntlich gemacht. Die Benennung folgt einer automatisiert auswertbaren Logik, die sich an der Art der Portionierung orientiert: <NBA-Profilkennung > <_> <Datum der NBA-Erzeugung im Format jjmmtt > <_> <Laufende Nummer der Portion, ohne führende Nullen> <von> <Gesamtzahl der Portionen der Lieferung, ohne führende Nullen> <_> <Portionierungsartabhängiger Dateinamensanteil>','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','Integer','SLG','Positiver Ganzzahl-Wert (Integer) ungleich Null. NBA-abgebendes System unterteilt aufgrund dieser Angabe automatisch das in den Selektionskritierien der AX_BenutzergruppeNBA angegebene Gebiet in entspr. Quadrate. Regel hierzu: Das Gebiet wird erst von West nach Ost, dann von Süd nach Nord abgearbeitet. Die erste linke untere Ecke ergibt sich dadurch, dass vom südwestlichsten Punkt des Abgabegebietes auf das nächste Koordinatenpaar mit vollen Meterwerten gegangen wird, das südwestlich davon liegt. Ist der südwestlichste Punkt des Abgabegebietes bereits ein Koordinatenpaar auf volle Meterwerte, so wird er direkt verwendet.','ax_portionierungsparameter','DLKM','seitenlaenge');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,abgeleitet_aus,modellart,type) VALUES ('ax_k_anschrift','AAS','DLKM','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','TEL','''Telefon'' ist die Nummer des Telefonanschlusses.','ax_k_anschrift','DLKM','telefon');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','STH','ax_k_anschrift','DLKM','strassehausnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','CharacterString','PLZ','ax_k_anschrift','DLKM','plzort');
INSERT INTO alkis_elemente(lebenszeitintervall,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Das Objekt kann nach Beendigung des letzten Mitteilungsverfahrens gelöscht werden. Gleichzeitig sind alle Objekte ''Fortführungsfall'' zu löschen, auf die das Objekt durch die Relation ''bezieht_sich_auf'' zeigt.','ax_fortfuehrungsnachweisdeckblatt','15001','NREO','[E] ''Fortführungsnachweis-Deckblatt'' enthält alle administrativen Angaben für einen Fortführungsnachweis.','{"aa_nreo"}','DLKM','Objektart','Die Attributart ''FN-Nummer'' und die Relationsart ''bezieht_sich_auf'' sind objektbildend.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('1..*','''Fortführungsnachweis-Deckblatt'' bezieht sich auf ''Fortführungfall''. Das Fortführungsnachweis-Deckblatt klammert alle in einem Fortführungsnachweis beschriebenen Fortführungsfälle.','ax_fortfuehrungsfall','15001-15002','ax_fortfuehrungsnachweisdeckblatt','DLKM','beziehtSichAuf');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','PRV','''Eignungsprüfung von'' beinhaltet die Angabe des Bearbeiters (Name und Dienstbezeichnung), der die fachtechnische Prüfung (Eignungsprüfung) durchgeführt hat.','ax_fortfuehrungsnachweisdeckblatt','DLKM','eignungspruefungvon');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Auszug','AGF','''Auszug für'' gibt an, für welchen Empfänger der Auszug eines Fortführungsnachweises bestimmt ist und wann dieser erstellt wurde.','ax_fortfuehrungsnachweisdeckblatt','DLKM','auszugfuer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Fortfuehrungsnummer','FNN','''FN-Nummer'' ist die Nummer des Fortführungsnachweises. Das Attribut setzt sich zusammen aus Verschlüsselungen für: 1. Spalte: Land 2. Spalte: Gemarkung 3. Spalte: Laufende Nummer Der Wert ''fNNummer.land'' entspricht dem Schlüssel des Bundeslands aus der Attributart ''in Gemarkung'' und wird aus dieser abgeleitet. Der Wert ''fNNummer.gemarkungsnummer'' entspricht dem Schlüssel der Gemarkung aus der Attributart ''in Gemarkung'' und wird aus dieser abgeleitet.','ax_fortfuehrungsnachweisdeckblatt','DLKM','fnnummer');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Gemarkung_Schluessel','GMN','Gemarkung, in der die Fortführung erfolgte.','ax_fortfuehrungsnachweisdeckblatt','DLKM','ingemarkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','TIT','''Titel'' beschreibt die Veränderungen an Flurstücken (Standardtext: Fortführungsnachweis, alternativ als freier Text: Umlegung und Name der Umlegung sowie Flurbereinigung und Name der Flurbereinigung möglich), die im Fortführungsnachweis dargestellt sind.','ax_fortfuehrungsnachweisdeckblatt','DLKM','titel');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','ERD','''Erstellt am'' beinhaltet das Datum der Erstellung des Fortführungsnachweises.','ax_fortfuehrungsnachweisdeckblatt','DLKM','erstelltam');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','PRD','''Eignungsprüfung am'' beinhaltet das Datum der fachtechnischen Prüfung (Eignungsprüfung) eines Fortführungsnachweises.','ax_fortfuehrungsnachweisdeckblatt','DLKM','eignungspruefungam');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','BBA','''Bekanntgabe an Beteiligte am'' beinhaltet das Datum, an dem die Abmarkung den Beteiligten bekanntgegeben worden ist.','ax_fortfuehrungsnachweisdeckblatt','DLKM','bekanntgabeanbeteiligteam');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','VWA','''Verwaltungsakt-J/N'' kennzeichnet, ob die Veränderung ein Verwaltungsakt ist.','ax_fortfuehrungsnachweisdeckblatt','DLKM','verwaltungsaktjn');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','FED','''Fortführungsentscheidung am'' beinhaltet das Datum, an dem die Fortführungsentscheidung ausgesprochen wurde.','ax_fortfuehrungsnachweisdeckblatt','DLKM','fortfuehrungsentscheidungam');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEM','''Bemerkung'' enthält zusätzliche Informationen zum Fortführungsnachweis.','ax_fortfuehrungsnachweisdeckblatt','DLKM','bemerkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','GFI','Enthält Grundbuchhinweise für das Finanzamt nach § 29 Abs. 4 Bewertungsgesetz.','ax_fortfuehrungsnachweisdeckblatt','DLKM','grundbuchmitteilungfuerfinanzamt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ERV','''Erstellt von'' ist die Angabe des Sachbearbeiters (Name und Dienstbezeichnung), der den Fortführungsnachweis erstellt hat.','ax_fortfuehrungsnachweisdeckblatt','DLKM','erstelltvon');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','AGV','''Fortführungsentscheidung von'' ist die Angabe des Bearbeiters (Name und Dienstbezeichnung), der die Fortführungsentscheidung ausgesprochen hat.','ax_fortfuehrungsnachweisdeckblatt','DLKM','fortfuehrungsentscheidungvon');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_K_AUSGKOPF_Standard','AKS','''Ausgabekopf'' enthält Angaben, die im Kopf des FME-Textteiles benötigt werden. Diese Attributart ist optional, da bei Anlieferung des Fortführungsauftrages von Externen an die Vermessungsstelle in der Regel nicht befüllbar ist.','ax_fortfuehrungsnachweisdeckblatt','DLKM','ausgabekopf');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','FME','''Fortführungsmitteilungen erzeugt'' ist der Zeitpunkt, an dem die Fortführungsmitteilungen erzeugt wurden.','ax_fortfuehrungsnachweisdeckblatt','DLKM','fortfuehrungsmitteilungenerzeugt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','FFB','''Fortführungsfall Nummernbereich'' enthält alle Fortführungsfallnummern innerhalb des Fortführungsnachweises (siehe Bestandsobjektart ''Fortführungsfall''). Diese Attributart ist optional, da bei Anlieferung des Fortführungsauftrages von Externen an die Vermessungsstelle in der Regel nicht befüllbar ist.','ax_fortfuehrungsnachweisdeckblatt','DLKM','fortfuehrungsfallnummernbereich');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_flaechebesondererfunktionalerpraegung','DLKM','41007','REO','[E] ''Fläche besonderer funktionaler Prägung'' ist eine baulich geprägte Fläche einschließlich der mit ihr im Zusammenhang stehenden Freifläche, auf denen vorwiegend Gebäude und/oder Anlagen zur Erfüllung öffentlicher Zwecke oder historische Anlagen vorhanden sind.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_ArtDerBebauung_FlaecheBesondererFunktionalerPraegung','BEB','''Art der Bebauung'' differenziert nach offener und geschlossener Bauweise aus topographischer Sicht und nicht nach gesetzlichen Vorgaben (z.B. BauGB).','ax_flaechebesondererfunktionalerpraegung','DLKM','artderbebauung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_FlaecheBesondererFunktionalerPraegung','FKT','''Funktion'' ist die zum Zeitpunkt der Erhebung vorherrschende Nutzung von ''Fläche besonderer funktionaler Prägung''.','ax_flaechebesondererfunktionalerpraegung','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Fläche besonderer funktionaler Prägung'' insbesondere außerhalb von Ortslagen.','ax_flaechebesondererfunktionalerpraegung','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_FlaecheBesondererFunktionalerPraegung','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von "Fläche funktionaler Prägung".','ax_flaechebesondererfunktionalerpraegung','DLKM','zustand');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_flugverkehr','DLKM','42015','REO','[E] ''Flugverkehr'' umfasst die baulich geprägte Fläche und die mit ihr in Zusammenhang stehende Freifläche, die ausschließlich oder vorwiegend dem Flugverkehr dient.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Nutzung_Flugverkehr','NTZ','''Nutzung'' gibt den Nutzerkreis von ''Flugverkehr'' an.','ax_flugverkehr','DLKM','nutzung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Flugverkehr','FKT','''Funktion'' ist die zum Zeitpunkt der Erhebung vorherrschende Nutzung (Dominanzprinzip).','ax_flugverkehr','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Art_Flugverkehr','ART','''Art'' ist Einstufung der Flugverkehrsfläche durch das Luftfahrtbundesamt.','ax_flugverkehr','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagebezeichnung','NAM','''Name'' ist der Eigenname von ''Flugverkehr''.','ax_flugverkehr','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BEZ','''Bezeichnung'' ist die von einer Fachstelle vergebene Kennziffer von ''Flugverkehr''.','ax_flugverkehr','DLKM','bezeichnung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Flugverkehr','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''Flugverkehr''.','ax_flugverkehr','DLKM','zustand');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Die Attributart ''Produkt'' kann nur in Verbindung mit der Attributart ''Bauwerksfunktion'' und den Wertearten 1101 und 1103 vorkommen.','ax_transportanlage','51004','REO','[E] ''Transportanlage'' ist eine Anlage zur Förderung oder zum Transport von Flüssigkeiten, Gasen und Gütern.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Produkt_Transportanlage','PRO','''Produkt'' gibt an, welches Produkt transportiert wird.','ax_transportanlage','DLKM','produkt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_LageZurErdoberflaeche_Transportanlage','OFL','''Lage zur Erdoberfläche'' ist die Angabe der relativen Lage von ''Transportanlage'' zur Erdoberfläche.','ax_transportanlage','DLKM','lagezurerdoberflaeche');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bauwerksfunktion_Transportanlage','BWF','''Bauwerksfunktion'' beschreibt die Art oder Funktion von ''Transportanlage''.','ax_transportanlage','DLKM','bauwerksfunktion');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,erfassungskriterien) VALUES ('Beim Attribut ''Bahnkategorie'' muss für die Modellart DLKM die Kardinalität 1..* eingehalten werden.','ax_gleis','53006','REO','[E] ''Gleis'' ist ein zur Führung von Schienenfahrzeugen verlegtes Schienenpaar.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_objekt"}','DLKM','Objektart','Modelliert ist die Mittellinie der Gleisachse. Die Drehscheibe ist als Fläche modelliert.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Art_Gleis','ART','''Art'' ist die besondere Ausführung von ''Gleis''.','ax_gleis','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist die der Objektart zugehörige Bezeichnung oder deren Eigenname.','ax_gleis','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Bahnkategorie_Gleis','BKT','''Bahnkategorie'' bezeichnet das Verkehrsmittel, das das Gleis nutzt.','ax_gleis','DLKM','bahnkategorie');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_LageZurOberflaeche_Gleis','OFL','''Lage zur Oberfläche'' bezeichnet die Lage zur Oberfläche.','ax_gleis','DLKM','lagezuroberflaeche');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_punktortau','DLKM','14003','REO','[E] ''PunktortAU'' ist ein Punktort mit unabhängiger Geometrie ohne Zugehörigkeit zu einem Geometriethema. Er kann zu ZUSOs der folgenden Objektarten gehören: Grenzpunkt, Besonderer Gebäudepunkt, Besonderer Bauwerkspunkt, Aufnahmepunkt, Sicherungspunkt, Sonstiger Vermessungspunkt, Besonderer topographischer Punkt, Lagefestpunkt, Höhenfestpunkt, Schwerefestpunkt, Referenzstationspunkt.','{"au_punktobjekt","ax_punktort"}','DLKM','Objektart');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_tagebaugrubesteinbruch','DLKM','41005','REO','[E] ''Tagebau, Grube, Steinbruch'' ist eine Fläche, auf der oberirdisch Bodenmaterial abgebaut wird. Rekultivierte Tagebaue, Gruben, Steinbrüche werden als Objekte entsprechend der vorhandenen Nutzung erfasst.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Tagebau, Grube, Steinbruch''.','ax_tagebaugrubesteinbruch','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Abbaugut_TagebauGrubeSteinbruch','AGT','''Abbaugut'' gibt an, welches Material abgebaut wird.','ax_tagebaugrubesteinbruch','DLKM','abbaugut');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_TagebauGrubeSteinbruch','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''Tagebau, Grube, Steinbruch''.','ax_tagebaugrubesteinbruch','DLKM','zustand');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_landwirtschaft','DLKM','43001','REO','[E] ''Landwirtschaft'' ist eine Fläche für den Anbau von Feldfrüchten sowie eine Fläche, die beweidet und gemäht werden kann, einschließlich der mit besonderen Pflanzen angebauten Fläche. Die Brache, die für einen bestimmten Zeitraum (z. B. ein halbes oder ganzes Jahr) landwirtschaftlich unbebaut bleibt, ist als ''Landwirtschaft'' bzw. ''Ackerland'' zu erfassen.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Vegetationsmerkmal_Landwirtschaft','VEG','''Vegetationsmerkmal'' ist die zum Zeitpunkt der Erhebung erkennbare oder feststellbare vorherrschend vorkommende landwirtschaftliche Nutzung (Dominanzprinzip).','ax_landwirtschaft','DLKM','vegetationsmerkmal');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist die Bezeichnung oder der Eigenname von ''Landwirtschaft''.','ax_landwirtschaft','DLKM','name');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_halde','DLKM','41003','REO','[E] ''Halde'' ist eine Fläche, auf der Material langfristig gelagert wird und beschreibt die auch im Relief zu modellierende tatsächliche Aufschüttung. Aufgeforstete Abraumhalden werden als Objekte der Objektart ''Wald'' erfasst.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist die einer ''Halde'' zugehörige Bezeichnung oder deren Eigenname.','ax_halde','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Halde','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''Halde''.','ax_halde','DLKM','zustand');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagergut_Halde','LGT','''Lagergut'' gibt an, welches Produkt gelagert wird.','ax_halde','DLKM','lagergut');
INSERT INTO alkis_elemente(name,kennung,abgeleitet_aus,modellart,type) VALUES ('ax_auszug','15005','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','AX_Art_Adressat_Auszug','ART','ax_auszug','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','Date','DAT','ax_auszug','DLKM','datum');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('1','CharacterString','ADR','ax_auszug','DLKM','adressat');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_gemarkungsteilflur_schluessel','73020','DLKM','Amtliche Verschlüsselung des Gemarkungsteils bzw. der Flur.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LAN','Bundesland.','ax_gemarkungsteilflur_schluessel','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','GMN','Gemarkung.','ax_gemarkungsteilflur_schluessel','DLKM','gemarkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','FLR','Gemarkungsteil bzw. Flur.','ax_gemarkungsteilflur_schluessel','DLKM','gemarkungsteilflur');
INSERT INTO alkis_elemente(lebenszeitintervall,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,erfassungskriterien) VALUES ('Der Zeitpunkt der Entstehung des ''Historischen Flurstück ohne Raumbezug'' ist identisch mit dem Zeitpunkt des Untergangs des Bezugsflurstücks (Flurstück zu seinen ''Lebzeiten''), aus dem das ''Historische Flurstück ohne Raumbezug'' entstanden ist (im ALB mit ''LF3 - letzte Fortführung'' bezeichnet. Soweit im ALB nur ein Jahr angegeben ist, ist dies zu einem Datum zu ergänzen). Das ''Historische Flurstück ALB'' geht nicht unter.','ax_historischesflurstueckohneraumbezug','17003','NREO','[E] ''Historisches Flurstück ohne Raumbezug'' ist ein nicht mehr aktuelles Flurstück, das schon im ALB historisch geworden ist, nach ALKIS migriert und im Rahmen der Vollhistorie geführt wird.','{"aa_nreo","ax_flurstueck_kerndaten"}','DLKM','Objektart','Im Rahmen der Migration sind alle Flurstücke erfaßt, die im ALB bereits historisch geworden sind. Diese Objektart wird nur im Rahmen der Führung der ALKIS-Vollhistorie (Versionierung) erfasst.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..*','''Flurstück ohne Raumbezug'' gehört anteilig zu ''Flurstück ohne Raumbezug''. Die Relationsart kommt nur vor bei Flurstücken, die eine Relation zu einer Buchungsstelle mit einer der Buchungsarten Anliegerweg, Anliegergraben oder Anliegerwasserlauf aufweist.','ax_historischesflurstueckohneraumbezug','17003.1-17003.2','ax_historischesflurstueckohneraumbezug','DLKM','gehoertAnteiligZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Flurstück ohne Raumbezug'' weist auf ''Lagebezeichnung mit Hausnummer''.','ax_lagebezeichnungmithausnummer','17003-12002','hat','ax_historischesflurstueckohneraumbezug','DLKM','weistAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Flurstück ohne Raumbezug'' zeigt auf ''Lagebezeichnung ohne Hausnummer''.','ax_lagebezeichnungohnehausnummer','17003-12001','beschreibt','ax_historischesflurstueckohneraumbezug','DLKM','zeigtAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..1','Ein (oder mehrere) Flurstück(e) ist (sind) unter einer Buchungsstelle gebucht.','ax_buchungsstelle','17003-21008','ax_historischesflurstueckohneraumbezug','DLKM','istGebucht');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','VFK','''Vorgänger-Flurstückskennzeichen'' ist die Bezeichnung der Flurstücke, die dem Objekt ''Historisches Flurstück ohne Raumbezugs'' direkt vorangehen. Bildungsregel: Die Attributart setzt sich aus den nachfolgenden expliziten Attributarten in der angegebenen Reihenfolge zusammen: 1. Land (2 Stellen) 2. Gemarkungsnummer (4 Stellen) 3. Flurnummer (3 Stellen) 4. Flurstücksnummer 4.1 Zähler (5 Stellen) 4.2 Nenner (4 Stellen) 5. Flurstücksfolge ( 2 Stellen) Die Elemente sind rechtsbündig zu belegen, fehlende Stellen sind mit führenden Nullen zu belegen. Da die Flurnummer und die Flurstücksfolge optional sind, sind aufgrund der bundeseinheitlichen Definition im Flurstückskennzeichen die entsprechenden Stellen, sofern sie nicht belegt sind, durch Unterstrich "_" ersetzt. Gleiches gilt für Flurstücksnummern ohne Nenner, hier ist der fehlende Nenner im Flurstückskennzeichen durch Unterstriche zu ersetzen. Die Gesamtlänge des Flurstückkennzeichens beträgt immer 20 Zeichen.','ax_historischesflurstueckohneraumbezug','DLKM','vorgaengerflurstueckskennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','CharacterString','NFK','''Nachfolger-Flurstückskennzeichen'' ist die Bezeichnung der Flurstücke, die dem Objekt ''Historisches Flurstück ohne Raumbezug'' direkt nachfolgen. Bildungsregel: Die Attributart setzt sich aus den nachfolgenden expliziten Attributarten in der angegebenen Reihenfolge zusammen: 1. Land (2 Stellen) 2. Gemarkungsnummer (4 Stellen) 3. Flurnummer (3 Stellen) 4. Flurstücksnummer 4.1 Zähler (5 Stellen) 4.2 Nenner (4 Stellen) 5. Flurstücksfolge ( 2 Stellen) Die Elemente sind rechtsbündig zu belegen, fehlende Stellen sind mit führenden Nullen zu belegen. Da die Flurnummer und die Flurstücksfolge optional sind, sind aufgrund der bundeseinheitlichen Definition im Flurstückskennzeichen die entsprechenden Stellen, sofern sie nicht belegt sind, durch Unterstrich "_" ersetzt. Gleiches gilt für Flurstücksnummern ohne Nenner, hier ist der fehlende Nenner im Flurstückskennzeichen durch Unterstriche zu ersetzen. Die Gesamtlänge des Flurstückkennzeichens beträgt immer 20 Zeichen.','ax_historischesflurstueckohneraumbezug','DLKM','nachfolgerflurstueckskennzeichen');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,erfassungskriterien,bildungsregeln) VALUES ('Die Objekte der Objektart ''Bodenschätzung'' sind überschneidungsfrei. Jede Kante der Masche weist genau eine Linie auf. Die Positionen der Knoten der Kante müssen zugleich identisch sein mit den Positionen der Endpunkte der Linie. Jede Linie ist durch genau zwei Positionen bestimmt.','ax_bodenschaetzung','72001','REO','[E] ''Bodenschätzung'' ist die kleinste Einheit einer bodengeschätzten Fläche nach dem Bodenschätzungsgesetz, für die eine Ertragsfähigkeit im Liegenschaftskataster nachzuweisen ist (Bodenschätzungsfläche). Ausgenommen sind Musterstücke, Landesmusterstücke und Vergleichsstücke der Bodenschätzung.','{"ta_multisurfacecomponent"}','DLKM','Objektart','Wird eine Bodenschätzungsfläche durch eine Fläche, die nicht Bodenschätzungsfläche ist durchschnitten (z.B. Straße, Weg, Gewässer), kann die Modellierung auf der Grundlage von zwei oder mehr getrennt liegenden Flächen erfolgen.','Die Attributarten ''Kulturart'' und ''Bodenart'' sind objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_SonstigeAngaben_Bodenschaetzung','SON','''Sonstige Angaben'' ist der Nachweis von Besonderheiten einer bodengeschätzten Fläche.','ax_bodenschaetzung','DLKM','sonstigeangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Integer','JAH','''Jahreszahl'' ist das Jahr, in dem eine Neukultur oder Tiefkultur angelegt worden ist. Diese Attributart kann nur vorkommen, wenn die ''Sonstige Angaben'' Wertearten mit den Bezeichnern ''Neukultur'' oder ''Tiefkultur'' aufweist.','ax_bodenschaetzung','DLKM','jahreszahl');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','WE1','"Bodenzahl oder Grünlandgrundzahl" ist die Wertzahl nach dem Acker- oder Grünlandschätzungsrahmen Diese Attributart kommt nicht vor, wenn die "Sonstige Angaben" Wertearten mit den Bezeichnern "Rieselwasser, künstliche Bewässerung (RiWa)" "Streuwiese (Str)", "Hutung (Hu)", "Acker-Hackrain (A-Hack)", "Grünland-Hackrain (Gr-Hack)" oder "Geringstland (Ger)" aufweist.','ax_bodenschaetzung','DLKM','bodenzahlodergruenlandgrundzahl');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_ZustandsstufeOderBodenstufe_Bodenschaetzung','KN2','''Zustandsstufe oder Bodenstufe'' ist die nach den Schätzungsrahmen festgelegte Bezeichnung der Zustands- oder Bodenstufe.','ax_bodenschaetzung','DLKM','zustandsstufeoderbodenstufe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','WE2','"Ackerzahl oder Grünlandzahl" ist die "Bodenzahl oder Grünlandgrundzahl" einschließlich Ab- und Zurechnungen nach dem Bodenschätzungsgesetz. Diese Attributart kommt nicht vor, wenn die "Sonstige Angaben" die Werteart mit dem Bezeichner "Geringstland (Ger)", "Rieselwasser, künstliche Bewässerung (RiWa)" oder "Unbedingtes Wiesenland (W)" aufweist.','ax_bodenschaetzung','DLKM','ackerzahlodergruenlandzahl');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_bodenschaetzung','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Kulturart_Bodenschaetzung','KUL','''Kulturart'' ist die bestandskräftig festgesetzte landwirtschaftliche Nutzungsart entsprechend dem Acker- oder Grünlandschätzungsrahmen.','ax_bodenschaetzung','DLKM','kulturart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bodenart_Bodenschaetzung','KN1','''Bodenart'' ist die nach den Durchführungsbestimmungen zum Bodenschätzungsgesetz (Schätzungsrahmen) festgelegte Bezeichnung der Bodenart.','ax_bodenschaetzung','DLKM','bodenart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_EntstehungsartOderKlimastufeWasserverhaeltnisse_Bodenschaetzung','KN3','''Entstehungsart oder Klimastufe/Wasserverhältnisse'' ist die nach den Schätzungsrahmen festgelegte Bezeichnung der Entstehungsart oder der Klimastufe und der Wasserverhältnisse.','ax_bodenschaetzung','DLKM','entstehungsartoderklimastufewasserverhaeltnisse');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_person','DLKM','21001','NREO','[E] ''Person'' ist eine natürliche oder juristische Person und kann z.B. in den Rollen Eigentümer, Erwerber, Verwalter oder Vertreter in Katasterangelegenheiten geführt werden.','{"aa_nreo"}','DLKM','Objektart','Die Relationsarten ''weist_auf'' und/oder ''benennt'' und/oder ''übt_aus'' sowie die inverse Relationsart zum ''Benutzer'' sind objektbildend. Eine dieser Relationen muss vorhanden sein. Diese Relationen sind nicht zu verwenden, wenn auf die ''Person'' die rekursive Relation ''zeigtAuf'' zeigt. In diesem Fall ist ''zeigtAuf'' objektbildend.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Die ''Person'' wird von der ''Vertretung'' in Katasterangelegenheiten vertreten.','ax_vertretung','21001-21005','vertritt','ax_person','DLKM','wirdVertretenVon');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','''Person'' gehört zu ''Personengruppe''.','ax_personengruppe','21001-21002','bestehtAus','ax_person','DLKM','gehoertZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Die ''Person'' übt die ''Vertretung'' in Katasterangelegenheiten aus. Es handelt sich um die inverse Relationsrichtung.','ax_vertretung','(INV)21005-21001','haengtAn','ax_person','DLKM','uebtAus');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Die ''Person'' hat ''Anschrift''.','ax_anschrift','DLKM','21001-21003','gehoertZu','ax_person','DLKM','hat');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Durch die Relation ''Person'' weist auf ''Namensnummer'' wird ausgedrückt, dass die Person als Eigentümer, Erbbauberechtigter oder künftiger Erwerber unter der Namensnummer eines Buchungsblattes eingetragen ist. Es handelt sich um die inverse Relationsrichtung.','ax_namensnummer','DLKM','(INV)21006-21001','benennt','ax_person','DLKM','weistAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Es handelt sich um die inverse Relationsrichtung.','ax_gebaeude','(INV)31001-21001','gehoert','ax_person','DLKM','besitzt');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('0..1','Die ''Person'' zeigt auf eine ''Person'' mit abweichenden Eigenschaften derselben Person. Für ein und dieselbe Person wurden zwei Objekte ''Person'' mit unterschiedlichen Attributen (z.B. Nachnamen durch Heirat geändert) angelegt. Bei Verwendung der Vollhistorie mit Hilfe des Versionierungskonzeptes werden diese Eigenschaften in verschiedenen Versionen geführt. Diese Relation wird dann nicht verwendet.','ax_person','21001.1-21001.2','ax_person','DLKM','zeigtAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Die Relation ''Person'' benennt ''Verwaltung'' weist der Verwaltung eine Person zu. Es handelt sich um die inverse Relationsrichtung.','ax_verwaltung','(INV)21004-21001','haengtAn','ax_person','DLKM','benennt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','NBA','''Namensbestandteil'' enthält z.B. Titel wie ''Baron''.','ax_person','DLKM','namensbestandteil');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','VNA','''Vorname'' ist der Vorname/ sind die Vornamen einer natürlichen Person.','ax_person','DLKM','vorname');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','DLKM','GEB','''Geburtsdatum'' ist das Geburtsdatum der Person.','ax_person','DLKM','geburtsdatum');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Anrede_Person','ANR','''Anrede'' ist die Anrede der Person. Diese Attributart ist optional, da Körperschaften und juristischen Person auch ohne Anrede angeschrieben werden können.','ax_person','DLKM','anrede');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','WOS','''Wohnort oder Sitz'' ist der Wohnort oder der Sitz einer natürlichen oder juristischen Person (Par. 15 Grundbuchverfügung). Diese Attributart kommt nur bei Personen vor, die die Rolle ''Eigentümer'' besitzen.','ax_person','DLKM','wohnortodersitz');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BER','''Beruf'' ist die Bezeichnung des oder der Berufe (Par. 15 Grundbuchverfügung). Diese Attributart kommt nur bei Personen vor, die die Rolle ''Eigentümer'' besitzen.','ax_person','DLKM','beruf');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','HLG','''Haushaltsstelle Landesgrundbesitz'' sind weitere, die juristische Person deutlich kennzeichnende Merkmale.','ax_person','DLKM','haushaltsstellelandesgrundbesitz');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','GNA','''Geburtsname'' ist der Geburtsname der Person.','ax_person','DLKM','geburtsname');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','DLKM','AKD','''Akademischer Grad'' ist der akademische Grad der Person (z.B. Dipl.-Ing., Dr., Prof. Dr.).','ax_person','DLKM','akademischergrad');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','NOF','''Nachname oder Firma'' ist - bei einer natürliche Person der Nachname (Familienname), - bei einer juristischen Person, Handels- oder Partnerschaftsgesellschaft der Name oder die Firma.','ax_person','DLKM','nachnameoderfirma');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQOhneDatenerhebung','DLKM','QAG','Angaben zur Herkunft der Informationen (Erhebungsstelle). Die Information ist konform zu den Vorgaben aus ISO 19115 zu repräsentieren.','ax_person','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','SOS','''Sonstige Eigenschaften'' sind weitere die Person deutlich kennzeichnende Merkmale (Par. 15 Grundbuchverfügung). Diese Attributart kommt nur bei Personen vor, die die Rolle ''Eigentümer'' besitzen.','ax_person','DLKM','sonstigeeigenschaften');
INSERT INTO alkis_elemente(name,kennung,definition,abgeleitet_aus,modellart,type) VALUES ('ax_sonstigeeigenschaften_flurstueck','11006','''AX_Sonstige Eigenschaften_Flurstück'' ist ein Datentyp, der alle Eigenschaften für den Aufbau der Attributart ''Sonstige Eigenschaften'' der Objektart Flurstück enthält.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ABE','Angaben zum Abschnitt - Bemerkung','ax_sonstigeeigenschaften_flurstueck','DLKM','angabenzumabschnittbemerkung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','AST','Angaben zum Abschnitt - Stelle','ax_sonstigeeigenschaften_flurstueck','DLKM','angabenzumabschnittstelle');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Area','FLA','Fläche des Abschnitts/Flurstück [qm]','ax_sonstigeeigenschaften_flurstueck','DLKM','flaechedesabschnitts');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ANA','Angaben zum Abschnitt - Nummer, Aktenzeichen','ax_sonstigeeigenschaften_flurstueck','DLKM','angabenzumabschnittnummeraktenzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','AFL','Angaben zum Abschnitt (unstrukturiert)','ax_sonstigeeigenschaften_flurstueck','DLKM','angabenzumabschnittflurstueck');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','SCH','Kennung, Schlüssel','ax_sonstigeeigenschaften_flurstueck','DLKM','kennungschluessel');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_anteil','21009','DLKM','''Anteil'' ist ein relativer Anteil an einer Buchungsstelle, ausgedrückt als rationale Zahl. Der Datentyp gehört zur Objektart ''Buchungsstelle''.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','Real','DLKM','NEN','Nenner des Quotienten.','ax_anteil','DLKM','nenner');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','Real','DLKM','ZAE','Zähler des Quotienten.','ax_anteil','DLKM','zaehler');
INSERT INTO alkis_elemente(name,kennung,abgeleitet_aus,modellart,type) VALUES ('ax_li_lineage_ohnedatenerhebung','21012','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,element,modellart,bezeichnung) VALUES ('0..1','AX_LI_ProcessStep_OhneDatenerhebung','DLKM','PRS','ax_li_lineage_ohnedatenerhebung','DLKM','processstep');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_friedhof','DLKM','41009','REO','[E] ''Friedhof'' ist eine Fläche, auf der Tote bestattet sind.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Friedhof','FKT','''Funktion'' ist die Art der Begräbnisstätte.','ax_friedhof','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Friedhof''.','ax_friedhof','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_Friedhof','ZUS','''Zustand'' beschreibt die Betriebsbereitschaft von ''Friedhof''.','ax_friedhof','DLKM','zustand');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,abgeleitet_aus,modellart,type) VALUES ('ax_li_lineage_mitdatenerhebung','50003','DLKM','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','AX_LI_Source_MitDatenerhebung','SRC','ax_li_lineage_mitdatenerhebung','DLKM','source');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','AX_LI_ProcessStep_MitDatenerhebung','PRS','ax_li_lineage_mitdatenerhebung','DLKM','processstep');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_gemarkung_schluessel','73019','DLKM','Amtliche Verschlüsselung der Gemarkung.','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','LAN','''Land'' enthält den Schlüssel für das Bundesland.','ax_gemarkung_schluessel','DLKM','land');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','GMN','''Gemarkungsnummer'' enthält die von der Katasterbehörde zur eindeutigen Bezeichnung der Gemarkung vergebene Nummer innerhalb eines Bundeslandes.','ax_gemarkung_schluessel','DLKM','gemarkungsnummer');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Die Relation zum Objekt ''AX_Georeferenzierte Gebäudeadresse'' muss nur dann gebildet werden, wenn die Relation zu einem Objekt ''AX_Gebäude'' existiert und wenn ''AX_GeoreferenzierteGebaeude'' dauerhaft im ALKIS-Bestand geführt wird. Bei Änderungen des Objekts ''AX_LagebezeichnungMitHausnummer'' muss stets auch das Objekt ''AX_Georeferenzierte Gebäudeadresse'' entsprechend fortgeführt werden.','ax_lagebezeichnungmithausnummer','DLKM','12002','NREO','[E] ''Lagebezeichnung mit Hausnummer'' ist die ortsübliche oder amtlich festgesetzte Benennung der Lage von Flurstücken und Gebäuden, die eine Lagebezeichnung mit Hausnummer haben. Hinweis zur Ableitung einer punktförmigen Geometrie zur Verortung der Hausnummer: Bei einer abweichenden Positionierung von der Standardposition liegt ein Präsentationsobjekt (Text) vor aus dem diese abgeleitet werden kann.','{"ax_lage"}','DLKM','Objektart');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,grunddatenbestand,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1..*','Eine ''Lagebezeichnung mit Hausnummer'' gehört zu einem oder mehreren ''Flurstücken''. Es handelt sich um die inverse Relationsrichtung.','ax_flurstueck','DLKM','(INV)11001-12002','weistAuf','ax_lagebezeichnungmithausnummer','DLKM','gehoertZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','Es handelt sich um die inverse Relationsrichtung.','ax_georeferenziertegebaeudeadresse','(INV)12006-12002','hatAuch','ax_lagebezeichnungmithausnummer','DLKM','beziehtSichAuchAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..*','Es handelt sich um die inverse Relationsrichtung.','ax_historischesflurstueckohneraumbezug','(INV)17003-12002','weistAuf','ax_lagebezeichnungmithausnummer','DLKM','hat');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','Eine ''Lagebezeichnung mit Hausnummer'' bezieht sich auf ein ''Gebäude''. Es handelt sich um die inverse Relationsrichtung.','ax_gebaeude','(INV)31001-12002','zeigtAuf','ax_lagebezeichnungmithausnummer','DLKM','beziehtSichAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','Eine ''Lagebezeichnung mit Hausnummer'' weist zum ''Turm''. Es handelt sich um die inverse Relationsrichtung.','ax_turm','(INV)51001-12002','zeigtAuf','ax_lagebezeichnungmithausnummer','DLKM','weistZum');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ORT','''Ortsteil'' ist eine Ergänzung zur Lagebezeichnung um den Ortsteil.','ax_lagebezeichnungmithausnummer','DLKM','ortsteil');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','HNR','''Hausnummer'' ist die von der Gemeinde für ein bestehendes oder geplantes Gebäude vergebene Nummer und ggf. einem Adressierungszusatz. Diese Attributart wird in Verbindung mit dem Straßennamen (verschlüsselte oder unverschlüsselte Lagebezeichnung) vergeben.','ax_lagebezeichnungmithausnummer','DLKM','hausnummer');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_benutzer','81001','NREO','[E] In der Objektart ''Benutzer'' werden allgemeine Informationen über den Benutzer verwaltet.','{"aa_benutzer"}','DLKM','Objektart');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1','''Benutzer'' gehört zu ''Benutzergruppe''.','ax_benutzergruppe','81001-81002','bestehtAus','ax_benutzer','DLKM','gehoertZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,element,modellart,bezeichnung) VALUES ('1','''Benutzer'' ist ''Person''.','ax_person','81001-21001','ax_benutzer','DLKM','ist');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ART','''Art'' ist die Bezeichnung des Benutzers (z.B. ''Notar'', ''Katasterverwaltung'').','ax_benutzer','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AA_Empfaenger','EMP','''Empfänger'' enthält die Bezeichnung des Empfängers (Prozess, Netzwerkadresse, o.ä.) der Ergebnisse des Auftrages. Die Informationen aus der Objektart ''Benutzer'' können hierzu berücksichtigt werden.','ax_benutzer','DLKM','empfaenger');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','DateTime','NOE','Das Attribut ist ab der ersten Übernahme der Quittierung systemseitig zu übernehmen.','ax_benutzer','DLKM','nbaquittierungerhalten');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_FOLGEVA','FVA','''Folgeverarbeitung'' enthält Parameter, die für die Folgeverarbeitung von (Standard-) Ausgaben benötigt werden.','ax_benutzer','DLKM','folgeverarbeitung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','DateTime','LAZ','''Letzte Abgabe/Zugriff'' ist der exakte Systemzeitpunkt der letzten Abgabe von Änderungsinformationen oder des letzten Zugriffs auf den Datenbestand. Dieses Attribut darf nur durch das System geändert werden.','ax_benutzer','DLKM','letzteabgabezugriff');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Boolean','NUE','Das Attribut ist ab der ersten Übernahme der Quittierung systemseitig zu belegen.','ax_benutzer','DLKM','nbauebernahmeerfolgreich');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..1','AX_LetzteAbgabeArt','LAA','ax_benutzer','DLKM','letzteabgabeart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','PKG','''Profilkennung'' ist das eindeutige Kennzeichen des Benutzers. Die Profilkennung ist bei jeder Benutzung dem Benutzungsprozess zu übergeben und dient diesem zur Prüfung der Berechtigung, die zu selektierenden Daten anzufordern.','ax_benutzer','DLKM','profilkennung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','DateTime','VAZ','Der vorletzteAbgabeZugriff erhält den letzten Wert von der Attributart letzteAbgabeZugriff.','ax_benutzer','DLKM','vorletzteabgabezugriff');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','ZWE','''Zahlungsweise'' kann die vertraglich festgelegten Zahlungsmodalitäten beschreiben, z.B. ''Rechnung je Vorgang'', ''Pauschale Kostenerstattung''.','ax_benutzer','DLKM','zahlungsweise');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','ZBG','''Zeitliche Berechtigung'' beschreibt evtl. zeitliche Begrenzungen der Zugehörigkeit des Benutzers zu einer Benutzergruppe, z.B. bei einer Begrenzung der Vertragsdauer.','ax_benutzer','DLKM','zeitlicheberechtigung');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Die Objekte sind überschneidungsfrei.','ax_bewertung','72004','REO','[E] ''Bewertung'' ist die Klassifizierung einer Fläche nach dem Bewertungsgesetz (Bewertungsfläche).','{"ag_flaechenobjekt"}','DLKM','Objektart','Die Attributart ''Klassifizierung'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Klassifizierung_Bewertung','KLA','''Klassifizierung'' ist die gesetzliche Klassifizierung nach dem Bewertungsgesetz.','ax_bewertung','DLKM','klassifizierung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_bewertung','DLKM','qualitaetsangaben');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_hafenbecken','DLKM','44005','REO','[E] ''Hafenbecken'' ist ein natürlicher oder künstlich angelegter oder abgetrennter Teil eines Gewässers, in dem Schiffe be- und entladen werden.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Nutzung_Hafenbecken','NTZ','''Nutzung '' gibt den Nutzerkreis von ''Hafenbecken'' an.','ax_hafenbecken','DLKM','nutzung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Funktion_Hafenbecken','FKT','''Funktion'' ist die objektiv erkennbare Nutzung von ''Hafenbecken''.','ax_hafenbecken','DLKM','funktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Lagebezeichnung','NAM','''Name'' ist der Eigenname von ''Hafenbecken''.','ax_hafenbecken','DLKM','name');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('Der ''Bauteil'' als Teil eines Gebäudes liegt immer innerhalb des Gebäudeumrisses, sofern er nicht unterhalb der Erdoberfläche liegt.','ax_bauteil','31002','REO','[E] ''Bauteil'' ist ein charakteristisches Merkmal eines Gebäudes mit gegenüber dem jeweiligen Objekt ''Gebäude'' abweichenden bzw. besonderen Eigenschaften.','{"ag_flaechenobjekt"}','DLKM','Objektart','Die Attributart ''Bauart'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bauart_Bauteil','BAT','''Bauart'' ist die Angabe der abweichenden baulichen Eigenschaften.','ax_bauteil','DLKM','bauart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Integer','AOG','''Anzahl der oberirdischen Geschosse'' ist die Anzahl der oberirdischen Geschosse des Bauteils.','ax_bauteil','DLKM','anzahlderoberirdischengeschosse');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','DHU','''Durchfahrtshöhe'' ist die von der Fachverwaltung angegebene maximale Höhe eines Fahrzeugs in [m], auf volle dm abgerundet, das eine Durchfahrt passieren kann. Diese Attributart wird nur bei der Attributart ''Bauart'' mit den Wertearten 2610 und 2620 geführt.','ax_bauteil','DLKM','durchfahrtshoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','Integer','BJA','''Baujahr'' ist das Jahr der Fertigstellung oder der baulichen Veränderung des Bauteils.','ax_bauteil','DLKM','baujahr');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_LageZurErdoberflaeche_Bauteil','OFL','''Lage zur Erdoberfläche'' ist die Angabe der relativen Lage des Gebäudeteils zur Erdoberfläche. Diese Attributart wird nur bei nicht ebenerdigen Gebäudeteilen geführt.','ax_bauteil','DLKM','lagezurerdoberflaeche');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dachform','DAF','''Dachform'' ist die charakteristische Form des Daches.','ax_bauteil','DLKM','dachform');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_gemeinde','DLKM','73005','NREO','''Gemeinde'' enthält alle zur Gemeindeebene zählenden Verwaltungseinheiten innerhalb eines Bundeslandes.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''Gemeindekennzeichen'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Gemeindekennzeichen','DLKM','GKZ','''Gemeindekennzeichen'' enthält die geltende amtliche Abkürzung von ''Gemeinde''.','ax_gemeinde','DLKM','gemeindekennzeichen');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,element,modellart,bezeichnung) VALUES ('0..*','AX_Dienststelle_Schluessel','ZST','ax_gemeinde','DLKM','istamtsbezirkvon');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_bauwerkoderanlagefuerindustrieundgewerbe','51002','REO','[E] ''Bauwerk oder Anlage für Industrie und Gewerbe'' ist ein Bauwerk oder eine Anlage, die überwiegend industriellen und gewerblichen Zwecken dient oder Einrichtung an Ver- und Entsorgungsleitungen ist.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","ag_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Length','HHO','''Objekthöhe'' ist die Höhendifferenz in [m] zwischen dem höchsten Punkt von ''Bauwerk oder Anlage für Industrie und Gewerbe'' und der Geländeoberfläche.','ax_bauwerkoderanlagefuerindustrieundgewerbe','DLKM','objekthoehe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Bauwerk oder Anlage für Industrie und Gewerbe''.','ax_bauwerkoderanlagefuerindustrieundgewerbe','DLKM','name');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Zustand_BauwerkOderAnlageFuerIndustrieUndGewerbe','ZUS','''Zustand'' ist der Zustand von ''Bauwerk oder Anlage für Industrie und Gewerbe''.','ax_bauwerkoderanlagefuerindustrieundgewerbe','DLKM','zustand');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Bauwerksfunktion_BauwerkOderAnlageFuerIndustrieUndGewerbe','BWF','''Bauwerksfunktion'' beschreibt die Art oder Funktion von ''Bauwerk oder Anlage für Industrie und Gewerbe''.','ax_bauwerkoderanlagefuerindustrieundgewerbe','DLKM','bauwerksfunktion');
INSERT INTO alkis_elemente(name,kennung,grunddatenbestand,definition,abgeleitet_aus,modellart,type) VALUES ('ax_katalogeintrag','73015','DLKM','''Katalogeintrag'' ist die abstrakte Oberklasse von Objektarten die einen Katalogcharakter besitzen. Es handelt sich um eine abstrakte Objektart.','{}','DLKM','Element');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','(DER) SCH','''Schlüssel (gesamt)'' enthält die geltende Abkürzung des Katalogeintrags (bzw. von dessen Bezeichnung). Er setzt sich ggf. aus mehreren Einzelteilen des Schlüssels des Katalogeintrags zusammen, die in der Attributart ''Schlüssel'' und dem dazugehörigen Datentyp angegeben sind. Die Reihenfolge der Schlüsselbestandteile ergibt sich ebenfalls aus diesem Datentyp. Im ''Schlüssel (gesamt)'' werden Stellen, für die keine Schlüssel vergeben sind, mit Nullen gefüllt. Das Attribut ist ein abgeleitetes Attribut und kann nicht gesetzt werden.','ax_katalogeintrag','DLKM','schluesselgesamt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..*','AX_Administrative_Funktion','ADM','''Administrative Funktion'' beschreibt den Typ einer Verwaltungseinheit.','ax_katalogeintrag','DLKM','administrativefunktion');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','DLKM','BEZ','''Bezeichnung'' enthält den langschriftlichen Namen des Katalogeintrags.','ax_katalogeintrag','DLKM','bezeichnung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_punktkennungvergleichend','16003','NREO','[E] ''Punktkennung vergleichend'' enthält vorläufige Punktkennungen.','{"aa_nreo"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','EPK','"Endgültige Punktkennung" enthält die im Führungsprozess vergebene endgültige Punktkennung für einen Punkt.','ax_punktkennungvergleichend','DLKM','endgueltigepunktkennung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','VPK','"Vorläufige Punktkennung" enthält die im Erhebungsprozess für Messungs- und Berechnungszwecke verwendete vorläufige Punktnummer.','ax_punktkennungvergleichend','DLKM','vorlaeufigepunktkennung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Art_Punktkennung','ART','''Art'' ist eine Kennzeichnung der Ordnungsnummern.','ax_punktkennungvergleichend','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','ANR','Die ''Antragsnummer'' ist eine von der Katasterbehörde vergebene eindeutige Kennzeichnung für einen Antrag. Sie stellt die Verbindung zur Antragsverwaltung der Katasterbehörde her.','ax_punktkennungvergleichend','DLKM','antragsnummer');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_lagebezeichnungkatalogeintrag','DLKM','73013','NREO','''Lagebezeichnung Katalogeintrag'' enthält die eindeutige Verschlüsselung von Lagebezeichnungen und Straßen innerhalb einer Gemeinde mit der entsprechenden Bezeichnung.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''Schlüssel'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_VerschluesselteLagebezeichnung','DLKM','SLL','''Schlüssel'' enthält die geltende amtliche Abkürzung der Lagebezeichnung.','ax_lagebezeichnungkatalogeintrag','DLKM','schluessel');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','KEN','''Kennung'' dient der Unterscheidung der Gruppen innerhalb des Katalogs, z.B. A = Amtlicher Lagebezeichnungskatalog der Kommune.','ax_lagebezeichnungkatalogeintrag','DLKM','kennung');
INSERT INTO alkis_elemente(konsistenzbedingungen,name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('Die Objekte sind überschneidungsfrei.','ax_tagesabschnitt','72006','REO','[E] ''Tagesabschnitt'' ist ein Ordnungskriterium der Schätzungsarbeiten für eine Bewertungsfläche. Innerhalb der Tagesabschnitte sind die Grablöcher eindeutig zugeordnet.','{"ag_flaechenobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','CharacterString','TNU','''Tagesabschnittsnummer'' bezieht sich auf eine Fläche, der Grablöcher eindeutig zugeordnet werden.','ax_tagesabschnitt','DLKM','tagesabschnittsnummer');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_hoehenlinie','61008','REO','[D] ''Höhenlinie'' ist die Schnittlinie einer Objektfläche (z.B. des Geländes) mit einer Fläche konstanter Höhe über oder unter einer Höhenbezugsfläche.','{"au_linienobjekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','Length','HHL','''Höhe der Höhenlinie'' ist der vertikale Abstand von ''Höhenlinie'' zum amtlichen Bezugssystem für die Höhe in [m] auf cm gerundet.','ax_hoehenlinie','DLKM','hoehevonhoehenlinie');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQMitDatenerhebung','DAQ','Angaben zur Herkunft der Informationen (Erhebungsstelle, Art der Datenerhebung).','ax_hoehenlinie','DLKM','qualitaetsangaben');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_sumpf','DLKM','43006','REO','[E] ''Sumpf'' ist ein wassergesättigtes, zeitweise unter Wasser stehendes Gelände. Nach Regenfällen kurzzeitig nasse Stellen im Boden werden nicht als ''Sumpf'' erfasst.','{"ax_tatsaechlichenutzung"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Sumpf''.','ax_sumpf','DLKM','name');
INSERT INTO alkis_elemente(name,kennung,abgeleitet_aus,modellart,type) VALUES ('ax_erfassungmarkantergelaendepunkt','62004','{}','DLKM','Datentyp');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_DQErfassungsmethodeMarkanterGelaendepunkt','DES','''Description'' ist die Erfassungsmethode und beschreibt das Messverfahren, mit dem der markante Geländepunkt er-fasst wurde.','ax_erfassungmarkantergelaendepunkt','DLKM','description');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_sicherungspunkt','13002','ZUSO','[E] ''Sicherungspunkt'' ist ein Punkt des Aufnahmepunktfeldes, der vermarkt ist und der Sicherung eines Aufnahmepunktes dient.','{"ax_netzpunkt"}','DLKM','Objektart','Das ZUSO besteht das aus einem oder mehreren REO ''Punktort''. Eine der beiden Relationsarten "beziehtSichAuf" oder gehoertZu" muss vorhanden sein. Sofern der Auf-nahmepunkt nicht mehr vorhanden ist, so kann der Siche-rungspunkt auch losgelöst vom Aufnahmepunkt weiter ge-führt werden. Die Relationsarten "beziehtSi-chAuf" oder gehoertZu" müssen dann nicht vorhanden sein.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','''Sicherungspunkt'' gehört zu ''Aufnahmepunkt''. Es handelt sich um die inverse Relationsrichtung.','ax_aufnahmepunkt','(INV)13001-13002','hat','ax_sicherungspunkt','DLKM','gehoertZu');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('0..1','"Sicherungspunkt" bezieht sich auf "Sonstiger Vermessungspunkt" Es handelt sich um die inverse Relationsrichtung.','ax_sonstigervermessungspunkt','(INV)13003-13002','hat','ax_sicherungspunkt','DLKM','beziehtSichAuf');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_verwaltung','21004','NREO','[E] ''Verwaltung'' beschreibt die Grundlagen und die Befugnisse des Verwalters entsprechend dem Wohnungseigentumsgesetz (z.B. für Wohnungs-/Teileigentum).','{"aa_nreo"}','DLKM','Objektart','Die Relationsart ''beziehtSichAuf'' ist objektbildend.');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1..*','Durch die Relation ''Verwaltung'' bezieht sich auf ''Buchungsstelle'' wird augedrückt, für welche Buchungsstellen die Verwaltung bestellt wurde. Es handelt sich um die inverse Relationsrichtung.','ax_buchungsstelle','(INV)21008-21004','wirdVerwaltetVon','ax_verwaltung','DLKM','beziehtSichAuf');
INSERT INTO alkis_relationsart(kardinalitaet,anmerkung,zielobjektart,kennung,inv__relation,element,modellart,bezeichnung) VALUES ('1','Durch die Relation ''Verwaltung'' hängt an ''Person'' wird die Verwaltung namentlich benannt.','ax_person','21004-21001','benennt','ax_verwaltung','DLKM','haengtAn');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','BDB','''Beginn der Bestellung'' ist der Zeitpunkt (Datum), ab dem eine natürliche oder juristische Person die Verwaltung einer Buchung ausübt.','ax_verwaltung','DLKM','beginnderbestellung');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','BGB','''Bestellungsbeschluss'' ist das Datum bzw. die Nummer der Bestellung.','ax_verwaltung','DLKM','bestellungsbeschluss');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','GRA','''Grundakt'' ist das Aktenzeichen der Grundakte, in der die Urkunde/der Nachweis der Bestellung zum Verwalter hinterlegt ist.','ax_verwaltung','DLKM','grundakt');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NOT','''Notariat'' gibt den Notar an, der die Bestellung beurkundet hat.','ax_verwaltung','DLKM','notariat');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_DQOhneDatenerhebung','QAG','Angaben zur Herkunft der Informationen (Erhebungsstelle). Die Information ist konform zu den Vorgaben aus ISO 19115 zu repräsentieren.','ax_verwaltung','DLKM','qualitaetsangaben');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Date','EDB','''Ende der Bestellung'' ist der Zeitpunkt (Datum), bis zu dem eine natürliche oder juristische Person die Verwaltung einer Buchung ausübt.','ax_verwaltung','DLKM','endederbestellung');
INSERT INTO alkis_elemente(name,kennung,objekttyp,definition,abgeleitet_aus,modellart,type) VALUES ('ax_einrichtungenfuerdenschiffsverkehr','53008','REO','[E] ''Einrichtungen für den Schiffsverkehr'' ist ein Bauwerk, das dem Schiffsverkehr dient.','{"ax_bauwerkeeinrichtungenundsonstigeangaben","au_objekt"}','DLKM','Objektart');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Art_EinrichtungenFuerDenSchiffsverkehr','ART','''Art'' beschreibt die bauliche Art von ''Einrichtungen für den Schiffsverkehr''.','ax_einrichtungenfuerdenschiffsverkehr','DLKM','art');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','Distance','KMA','''Kilometerangabe'' gibt den tatsächlichen Wert der Kilometrierung in [km] auf dem Kilometerstein an.','ax_einrichtungenfuerdenschiffsverkehr','DLKM','kilometerangabe');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','CharacterString','NAM','''Name'' ist der Eigenname von ''Einrichtungen für den Schiffsverkehr''.','ax_einrichtungenfuerdenschiffsverkehr','DLKM','name');
INSERT INTO alkis_elemente(name,grunddatenbestand,kennung,objekttyp,definition,abgeleitet_aus,modellart,type,bildungsregeln) VALUES ('ax_buchungsblattbezirk','DLKM','73010','NREO','[E] "Buchungsblattbezirk" enthält die Verschlüsselung von Buchungsbezirken mit der entsprechenden Bezeichnung.','{"ax_katalogeintrag","aa_nreo"}','DLKM','Objektart','Die Attributart ''Schlüssel'' ist objektbildend.');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,kennung,definition,element,modellart,bezeichnung) VALUES ('0..1','AX_Dienststelle_Schluessel','ZST','"Buchungsblattbezirk" wird von einem Grundbuchamt verwaltet, das im Katalog der Dienststellen geführt wird. Die Relation wird nur gebildet, wenn die Dienststelle ein Grundbuchamt ist.','ax_buchungsblattbezirk','DLKM','gehoertzu');
INSERT INTO alkis_attributart(kardinalitaet,datentyp,grunddatenbestand,kennung,definition,element,modellart,bezeichnung) VALUES ('1','AX_Buchungsblattbezirk_Schluessel','DLKM','SLL','''Schlüssel'' enthält die geltende amtliche Abkürzung des Bezirks.','ax_buchungsblattbezirk','DLKM','schluessel');
COMMIT;
