---
name: d.text
description: Draws text in the active display frame on the graphics monitor using the current font.
keywords: [ display, cartography ]
---

# d.text

Draws text in the active display frame on the graphics monitor using the current font.

=== "Command line"

    **d.text**
    [**-pgbrs**]
    [**text**=*string*]
    [**input**=*name*]
    [**color**=*name*]
    [**bgcolor**=*name*]
    [**rotation**=*float*]
    [**linespacing**=*float*]
    [**at**=*x,y*]
    [**line**=*integer*]
    [**align**=*string*]
    [**font**=*string*]
    [**size**=*float*]
    [**path**=*name*]
    [**charset**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.text
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***d.text***",
        **text**=*None*,
        **input**=*None*,
        **color**=*"gray"*,
        **bgcolor**=*"none"*,
        **rotation**=*0*,
        **linespacing**=*1.25*,
        **at**=*None*,
        **line**=*None*,
        **align**=*"ll"*,
        **font**=*None*,
        **size**=*5*,
        **path**=*None*,
        **charset**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("d.text")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_text*(**text**=*None*,
        **input**=*None*,
        **color**=*"gray"*,
        **bgcolor**=*"none"*,
        **rotation**=*0*,
        **linespacing**=*1.25*,
        **at**=*None*,
        **line**=*None*,
        **align**=*"ll"*,
        **font**=*None*,
        **size**=*5*,
        **path**=*None*,
        **charset**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_text()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **text**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to display  
    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **rotation**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation angle in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **linespacing**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line spacing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.25*  
    **at**=*x,y*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen position at which text will begin to be drawn (percentage, [0,0] is lower left)  
    **line**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The screen line number on which text will begin to be drawn  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **align**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text alignment  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ll, lc, lr, cl, cc, cr, ul, uc, ur*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ll*  
    **font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **size**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of letters in percentage of available frame height  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **path**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    **charset**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen position in pixels ([0,0] is top left)  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen position in geographic coordinates  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use bold text  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use radians instead of degrees for rotation  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Font size is height in pixels  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **text** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to display  
    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **rotation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation angle in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **linespacing** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line spacing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.25*  
    **at** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen position at which text will begin to be drawn (percentage, [0,0] is lower left)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **line** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The screen line number on which text will begin to be drawn  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **align** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text alignment  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ll, lc, lr, cl, cc, cr, ul, uc, ur*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ll*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of letters in percentage of available frame height  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *g*, *b*, *r*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Screen position in pixels ([0,0] is top left)  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Screen position in geographic coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use bold text  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use radians instead of degrees for rotation  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Font size is height in pixels  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **text** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to display  
    **input** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gray*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **rotation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation angle in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **linespacing** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line spacing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.25*  
    **at** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Screen position at which text will begin to be drawn (percentage, [0,0] is lower left)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *x,y*  
    **line** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The screen line number on which text will begin to be drawn  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-1000*  
    **align** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text alignment  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ll, lc, lr, cl, cc, cr, ul, uc, ur*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *ll*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height of letters in percentage of available frame height  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to font file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding (only applicable to TrueType fonts)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*, *g*, *b*, *r*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Screen position in pixels ([0,0] is top left)  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Screen position in geographic coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use bold text  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use radians instead of degrees for rotation  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Font size is height in pixels  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.text* draws text in the active display frame on the graphics monitor.
Text can be provided through standard input or redirected from a file
(using the UNIX redirection mechanism). In addition to the options
provided on the command line, colors, text size, font type, rotation
angle, and boldness can be adjusted with commands in the standard input
(i.e., if the user invokes *d.text* without options on the command line,
and then assigns values to these options on lines within the standard
input).

### Commands

**.C** *color*  
(where *color* is one of the available colors) causes text appearing on
subsequent lines to be drawn in that color.

**.G** *color*  
(where *color* is one of the available colors) causes the background of
text appearing on subsequent lines to be drawn in that color.

**.S** *size*  
(where *size* is a percentage within the range 0 to 100) adjusts text
size. Note that a size of 10 would allow 10 lines to be drawn in the
active display frame, 5 would allow the drawing of 20 lines, and 50
would allow the drawing of 2 lines.

**.F** *font*  
(where *font* is one of the fonts known by the GRASS program
*[d.font](d.font.md)*) manipulates the font type. Available fonts are
listed in the GRASS manual entry for *[d.font](d.font.md)*. The default
font type used (if unspecified by the user) is *romans*.

**.R** *rotation*  
(where *rotation* is an angle in degrees, counter-clockwise) to rotate
the text.

**.B 1**  
stipulates that following text be printed in **bold**. This command
means *bold on*.

**.B 0**  
turns *bold off* of all text appearing on lines beneath it. (*Bold off*
is used by default, if unspecified by the user.)

## EXAMPLE

The following command will print the short phrase "This is a test of
d.text" in the active display frame using the color yellow, in bold, and
using 4/100'ths (4%) of the active frame's vertical space per line:

```sh
d.text text="This is a test of d.text" color=yellow bgcolor=gray size=4
```

![Displayed Text](d_text.png)  
*Displayed Text*

## NOTES

Note that the GRASS command *[d.title](d.title.md)* creates map TITLEs
in a format suitable for input to *d.text*.

*d.text* needs escape sequences that can be used within lines to change
colors, boldness, and perhaps size.

## SEE ALSO

*[d.font](d.font.md), [d.title](d.title.md), [d.labels](d.labels.md)*

## AUTHORS

James Westervelt, U.S. Army Construction Engineering Research Laboratory

Updates by Huidae Cho

## SOURCE CODE

Available at: [d.text source code](https://github.com/OSGeo/grass/tree/main/display/d.text)
([history](https://github.com/OSGeo/grass/commits/main/display/d.text))  
Latest change: Tuesday Feb 18 17:20:26 2025 in commit [688e625](https://github.com/OSGeo/grass/commit/688e625e7db3be9a465ce99ba25f36d2ebdd5aeb)
