---
name: d.vect.chart
description: Displays charts of vector data in the active frame on the graphics monitor.
keywords: [ display, cartography, chart maps ]
---

# d.vect.chart

Displays charts of vector data in the active frame on the graphics monitor.

=== "Command line"

    **d.vect.chart**
    [**-cl3**]
    **map**=*name*
    [**type**=*string* [,*string*,...]]
    [**layer**=*string*]
    [**chart_type**=*string*]
    **columns**=*name* [,*name*,...]
    [**size_column**=*name*]
    [**size**=*integer*]
    [**scale**=*float*]
    [**outline_color**=*name*]
    [**colors**=*name* [,*name*,...]]
    [**max_ref**=*float* [,*float*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.vect.chart map=name columns=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.vect.chart***",
        **map**,
        **type**=*"point,line,boundary,centroid"*,
        **layer**=*"1"*,
        **chart_type**=*"pie"*,
        **columns**,
        **size_column**=*None*,
        **size**=*40*,
        **scale**=*1*,
        **outline_color**=*"black"*,
        **colors**=*"black"*,
        **max_ref**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.vect.chart", map="name", columns="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_vect_chart*(**map**,
        **type**=*"point,line,boundary,centroid"*,
        **layer**=*"1"*,
        **chart_type**=*"pie"*,
        **columns**,
        **size_column**=*None*,
        **size**=*40*,
        **scale**=*1*,
        **outline_color**=*"black"*,
        **colors**=*"black"*,
        **max_ref**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_vect_chart(map="name", columns="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **chart_type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Chart type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *pie, bar*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pie*  
    **columns**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute columns containing data  
    **size_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column used for pie chart size  
    **size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of chart (diameter for pie, total width for bar)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *40*  
    **scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for size (to get size in pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **outline_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Outline color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **colors**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Colors used to fill charts  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **max_ref**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum value used for bar plot reference  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Center the bar chart around a data point  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create legend information and send to stdout  
    **-3**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create 3D charts  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **chart_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Chart type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *pie, bar*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pie*  
    **columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute columns containing data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **size_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column used for pie chart size  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of chart (diameter for pie, total width for bar)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *40*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for size (to get size in pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **outline_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Outline color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **colors** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colors used to fill charts  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **max_ref** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum value used for bar plot reference  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *l*, *3*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Center the bar chart around a data point  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create legend information and send to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**3**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create 3D charts  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **chart_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Chart type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *pie, bar*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pie*  
    **columns** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute columns containing data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **size_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column used for pie chart size  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of chart (diameter for pie, total width for bar)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *40*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for size (to get size in pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **outline_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Outline color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **colors** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colors used to fill charts  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **max_ref** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum value used for bar plot reference  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *l*, *3*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Center the bar chart around a data point  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create legend information and send to stdout  
    &nbsp;&nbsp;&nbsp;&nbsp;**3**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create 3D charts  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.vect.chart* displays charts for GRASS vector data in the active frame
on the graphics monitor.

## NOTES

The charts are positioned as follows:

- vector points: on point position,
- vector lines: on line centers,
- vector areas: on area centroids.

Bar charts are placed with their lower edge starting from the
y-coordinate of the feature being symbolized, and centered with respect
to the x-coordinate. The **-c** flag can be used to center the bar chart
in both x and y directions.

The 'sizecol' parameter is proportionate to the radius.

The optional **max_ref** parameter accepts a list of values that
represent the maximum value for each column listed in the values for the
parameter **columns**. These values are used to create a framed bar plot
if **chart_type** is *bar* (See Example 2).

## EXAMPLES

### Example 1

Pie-charts of monthly winter precipitation (North Carolina sample
dataset):

```sh
g.region vector=nc_state -p
d.vect nc_state
d.vect.chart precip_30ynormals chart_type=pie columns=nov,dec,jan,feb -l

# show pie chart as 3D
d.erase
d.vect nc_state
d.vect.chart precip_30ynormals chart_type=pie columns=nov,dec,jan,feb -l -3
```

![d.vect.chart 2D pie chart](d_vect_chart_pie_2d.png)  
2D pie-chart of monthly winter precipitation in North Carolina

![d.vect.chart 3D pie chart](d_vect_chart_pie_3d.png)  
3D pie-chart of monthly winter precipitation in North Carolina

### Example 2

Bar-chart of different census map values:

```sh
d.vect.chart map=vectmap columns=cens51,cens61,cens71,cens81 chart_type=bar
```

### Example 3

Creation of framed bar charts of an erodibiliy index from the Spearfish
sample dataset:

```sh
g.region raster=erode.index -p
r.to.vect -s input=erode.index output=erode_index type=area
v.extract input=erode_index output=erode_index_ctrds type=centroid
d.rast aspect
d.vect.chart map=erode_index_ctrds chart_type=bar columns=cat \
             size=10 max_ref=12 scale=0.05 colors=yellow
d.vect erode_index_ctrds icon=basic/circle fcol=black col=black size=5
```

![d.vect.chart example](d.vect.chart_example.jpg)  
Bar charts of an erodibiliy index (spatial subset)

## SEE ALSO

*[d.erase](d.erase.md), [d.vect](d.vect.md),
[d.vect.thematic](d.vect.thematic.md), [d.what.vect](d.what.vect.md),
[d.rast](d.rast.md)*

## AUTHOR

Radim Blazek, ITC-Irst, Trento, Italy

## SOURCE CODE

Available at: [d.vect.chart source code](https://github.com/OSGeo/grass/tree/main/display/d.vect.chart)
([history](https://github.com/OSGeo/grass/commits/main/display/d.vect.chart))  
Latest change: Thursday May 08 14:17:52 2025 in commit [3caa352](https://github.com/OSGeo/grass/commit/3caa352f78f86a51ca463a6f1ba7ffe3db9771df)
