---
name: g.gui.datacatalog
description: Tool for browsing, modifying and managing GRASS maps.
keywords: [ general, GUI, map management ]
description: wxGUI Data Catalog
index: topic_GUI|GUI
---

# g.gui.datacatalog

Tool for browsing, modifying and managing GRASS maps.

=== "Command line"

    **g.gui.datacatalog**
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.gui.datacatalog
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.gui.datacatalog***",
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.gui.datacatalog")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_gui_datacatalog*(        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_gui_datacatalog()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

# wxGUI Data Catalog

## DESCRIPTION

The **Data Catalog** is a *[wxGUI](wxGUI.md)* component for browsing,
modifying and managing GRASS maps.

Data Catalog allows you to:

- browse GRASS projects and mapsets in the current GIS directory
- browse GRASS 2D/3D raster and vector maps
- rename, copy, move and delete GRASS maps including reprojection
  between different projects
- drag and drop maps for copying and moving
- searching and filtering maps using regular expressions
- display map in current project
- show metadata of maps

Note that projects are called *locations* at some places and in old
documentation.

![data catalog screenshot](datacatalog.png)  
*Figure: Data Catalog integrated in wxGUI.*

## NOTES

Some operations (copying, renaming, deleting) are by default enabled
only within the current mapset. To allow changing data outside of your
current mapset, you need to press *Unlock* button in Data Catalog
toolbar.

### WARNING

When renaming, copying or deleting maps outside of Data Catalog, you
need to reload the current mapset or entire database, because it is
currently not synchronized.

## SEE ALSO

*[wxGUI](wxGUI.md), [wxGUI components](wxGUI.components.md)*

*[g.copy](g.copy.md), [g.rename](g.rename.md), [g.remove](g.remove.md),
[g.list](g.list.md)*

## AUTHORS

Anna Petrasova, NCSU GeoForAll Laboratory  
Tereza Fiedlerova, OSGeoREL, Czech Technical University in Prague, Czech
Republic

## SOURCE CODE

Available at: [g.gui.datacatalog source code](https://github.com/OSGeo/grass/tree/main/gui/wxpython/datacatalog)
([history](https://github.com/OSGeo/grass/commits/main/gui/wxpython/datacatalog))  
Latest change: Thursday Oct 23 21:46:51 2025 in commit [e68610c](https://github.com/OSGeo/grass/commit/e68610cd0ebcd41aba993d8e3c467c4761a8fb9a)
