---
title: General tools
author: GRASS Development Team
---


| Name | Description |
|--------|-------------|
| [g.access](g.access.md) | Controls access to the current mapset for other users on the system. If no option given, prints current status. |
| [g.copy](g.copy.md) | Creates copies of maps and other elements Copies available data files in the current mapset search path to the user's current mapset. |
| [g.dirseps](g.dirseps.md) | Internal GRASS utility for converting directory separator characters. Converts any directory separator characters in the input string to or from native host format, and writes the changed path to standard output. Useful in scripts for Windows compatibility. |
| [g.download.location](g.download.location.md) | Download GRASS project (location) from the web Get GRASS project from an URL or file path |
| [g.download.project](g.download.project.md) | Download GRASS project from the web Get GRASS project from an URL or file path |
| [g.extension.all](g.extension.all.md) | Rebuilds or removes all locally installed GRASS Addons extensions. By default only extensions built against different GIS Library are rebuilt. |
| [g.extension](g.extension.md) | Maintains GRASS Addons extensions in local GRASS installation. Downloads and installs extensions from GRASS Addons repository or other source into the local GRASS installation or removes installed extensions. |
| [g.filename](g.filename.md) | Prints GRASS data base file names. |
| [g.findetc](g.findetc.md) | Searches for GRASS support files. |
| [g.findfile](g.findfile.md) | Searches for GRASS data base files and sets variables for the shell. |
| [g.gisenv](g.gisenv.md) | Outputs and modifies the user's current GRASS variable settings. Prints all defined GRASS variables if no option is given. |
| [g.gui.animation](g.gui.animation.md) | Tool for animating a series of raster and vector maps or a space time raster or vector dataset. |
| [g.gui.datacatalog](g.gui.datacatalog.md) | Tool for browsing, modifying and managing GRASS maps. |
| [g.gui.dbmgr](g.gui.dbmgr.md) | Launches graphical attribute table manager. |
| [g.gui.gcp](g.gui.gcp.md) | Georectifies a map and allows managing Ground Control Points. |
| [g.gui.gmodeler](g.gui.gmodeler.md) | Graphical Modeler. Allows interactively creating, editing and managing models. |
| [g.gui.iclass](g.gui.iclass.md) | Tool for supervised classification of imagery data. Generates spectral signatures for an image by allowing the user to outline regions of interest. |
| [g.gui.image2target](g.gui.image2target.md) | Georectifies a map and allows managing Ground Control Points for 3D correction. |
| [g.gui.mapswipe](g.gui.mapswipe.md) | Interactively compares two maps by swiping a visibility bar. |
| [g.gui](g.gui.md) | Launches a GRASS graphical user interface (GUI) session. Optionally updates default user interface settings. |
| [g.gui.photo2image](g.gui.photo2image.md) | Corrects scanning distortions of a paper photo. |
| [g.gui.psmap](g.gui.psmap.md) | Tool for creating hardcopy map outputs. |
| [g.gui.rdigit](g.gui.rdigit.md) | Interactive editing and digitizing of raster maps. |
| [g.gui.rlisetup](g.gui.rlisetup.md) | Configuration tool for r.li modules. |
| [g.gui.timeline](g.gui.timeline.md) | Allows comparing temporal datasets by displaying their temporal extents in a plot. |
| [g.gui.tplot](g.gui.tplot.md) | Plots the values of temporal datasets. |
| [g.gui.vdigit](g.gui.vdigit.md) | Interactive editing and digitization of vector maps. |
| [g.list](g.list.md) | Lists available GRASS data base files of the user-specified data type optionally using the search pattern. |
| [g.manual](g.manual.md) | Displays the manual pages of GRASS modules. |
| [g.mapset](g.mapset.md) | Changes or reports current mapset. Optionally, creates new mapset or lists available mapsets in given project (location). |
| [g.mapsets](g.mapsets.md) | Modifies or reports the user's current mapset search path. Affects the user's access to data existing under the other mapsets in the current project. |
| [g.message](g.message.md) | Prints a message, warning, progress info, or fatal error in the GRASS way. This module should be used in scripts for messages served to user. |
| [g.mkfontcap](g.mkfontcap.md) | Generates the font configuration file by scanning various directories for fonts. |
| [g.parser](g.parser.md) | Provides automated parser, GUI, and help support for GRASS scripts. |
| [g.pnmcomp](g.pnmcomp.md) | Overlays multiple PPM image files. |
| [g.ppmtopng](g.ppmtopng.md) | Converts between PPM/PGM and PNG image formats. |
| [g.proj](g.proj.md) | Prints or modifies GRASS projection information files (in various co-ordinate system descriptions). Can also be used to create new GRASS projects. |
| [g.region](g.region.md) | Manages the boundary definitions for the geographic region. |
| [g.remove](g.remove.md) | Removes data base element files from the user's current mapset using the search pattern. |
| [g.rename](g.rename.md) | Renames data base element files in the user's current mapset. |
| [g.search.modules](g.search.modules.md) | Search in GRASS modules using keywords |
| [g.tempfile](g.tempfile.md) | Creates a temporary file and prints it's file name. |
| [g.version](g.version.md) | Displays GRASS version info. Optionally also prints build or copyright information. |
