---
name: i.colors.enhance.py
description: Performs auto-balancing of colors for RGB images.
keywords: [ imagery, RGB, satellite, colors ]
---

# i.colors.enhance.py

Performs auto-balancing of colors for RGB images.

=== "Command line"

    **i.colors.enhance.py**
    [**-fprs**]
    **red**=*name*
    **green**=*name*
    **blue**=*name*
    [**strength**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.colors.enhance.py red=name green=name blue=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.colors.enhance.py***",
        **red**,
        **green**,
        **blue**,
        **strength**=*98*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.colors.enhance.py", red="name", green="name", blue="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_colors_enhance_py*(**red**,
        **green**,
        **blue**,
        **strength**=*98*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_colors_enhance_py(red="name", green="name", blue="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **red**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of red channel  
    **green**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of green channel  
    **blue**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of blue channel  
    **strength**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cropping intensity (upper brightness level)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *98*  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extend colors to full range of data on each channel  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserve relative colors, adjust brightness only  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reset to standard color range  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Process bands serially (default: run in parallel)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **red** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of red channel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of green channel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **blue** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of blue channel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **strength** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cropping intensity (upper brightness level)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *98*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *p*, *r*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend colors to full range of data on each channel  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Preserve relative colors, adjust brightness only  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reset to standard color range  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Process bands serially (default: run in parallel)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **red** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of red channel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **green** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of green channel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **blue** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of blue channel  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **strength** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cropping intensity (upper brightness level)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *98*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *p*, *r*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend colors to full range of data on each channel  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Preserve relative colors, adjust brightness only  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reset to standard color range  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Process bands serially (default: run in parallel)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.colors.enhance* auto-balances and enhances the color channels of a
RGB image (e.g. from Landsat) to provide a more natural color mixture.
Only the color table of each image band is modified, the base data
remains untouched.

The module works by calculating a histogram for each color channel and
removing an adjustable amount of outliers from either end before
recalibrating the color scale with *r.colors*.

It will work with any 8-bit RGB imagery set and the script is easily
modified to work with other datasets of greater band-depth.

## NOTES

Depending on the image, it may or may not be advantageous to use the
**-p** flag to preserve the relative color scaling. You will have to
experiment with the different options to find a setting that works best
for your particular imagery.

The **strength** option should generally be set in the 90-99 range. The
lower the number, the more saturated the image becomes. It represents
the percentage cut-off for the top end of the color histogram curve. The
lower end is fixed at 2% of the area under the curve.

For quicker execution of this module on large images you can achieve
largely similar results by switching to a coarser resolution before the
running of the module (using *g.region*) and then back to the original
resolution afterwards.

## EXAMPLE

North Carolina sample dataset example with Landsat data:

```sh
g.region raster=lsat7_2002_10 -p
d.rgb blue=lsat7_2002_10 green=lsat7_2002_20 red=lsat7_2002_30
d.barscale at=55.3125,93.125 bcolor=white text_pos=over

i.colors.enhance blue=lsat7_2002_10 green=lsat7_2002_20 red=lsat7_2002_30 strength=95
d.rgb blue=lsat7_2002_10 green=lsat7_2002_20 red=lsat7_2002_30
d.barscale at=55.3125,93.125 bcolor=white text_pos=over
```

![Uncorrected RGB composite of Landsat ETM channels
B/G/R](i_colors_enhance_uncorrected.jpg)  
Uncorrected RGB composite of Landsat ETM channels B/G/R

![Color corrected RGB composite of Landsat ETM channels
B/G/R](i_colors_enhance_corrected.jpg)  
Color corrected RGB composite of Landsat ETM channels B/G/R

## TODO

The **strength** option requires further refinement.

## SEE ALSO

*[d.rgb](d.rgb.md), [g.region](g.region.md), [i.oif](i.oif.md),
[r.colors](r.colors.md), [r.composite](r.composite.md),
[r.univar](r.univar.md)*

## AUTHORS

Markus Neteler, Trento, Italy  
M. Hamish Bowman, Dept. Marine Science, Otago University, New Zealand

## SOURCE CODE

Available at: [i.colors.enhance source code](https://github.com/OSGeo/grass/tree/main/scripts/i.colors.enhance)
([history](https://github.com/OSGeo/grass/commits/main/scripts/i.colors.enhance))  
Latest change: Sunday Oct 19 00:09:21 2025 in commit [5f20320](https://github.com/OSGeo/grass/commit/5f20320dc7ec7bc36d9a8f45414d34349e1d9500)
