---
name: i.ifft
description: Inverse Fast Fourier Transform (IFFT) for image processing.
keywords: [ imagery, transformation, Fast Fourier Transform ]
---

# i.ifft

Inverse Fast Fourier Transform (IFFT) for image processing.

=== "Command line"

    **i.ifft**
    **real**=*name*
    **imaginary**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.ifft real=name imaginary=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.ifft***",
        **real**,
        **imaginary**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.ifft", real="name", imaginary="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_ifft*(**real**,
        **imaginary**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_ifft(real="name", imaginary="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **real**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (image fft, real part)  
    **imaginary**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (image fft, imaginary part  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **real** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (image fft, real part)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **imaginary** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (image fft, imaginary part  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **real** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (image fft, real part)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **imaginary** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map (image fft, imaginary part  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.ifft* is an image processing program based on the algorithm given by
Frigo et al. (1998), that converts real and imaginary frequency space
images (produced by *[i.fft](i.fft.md)*) into a normal image.

## NOTES

The current mask is respected when reading the real and imaginary
component files; thus, creating a mask is a primary step for selecting
the portion of the frequency space data to be included in the inverse
transform. The module *[wxGUI vector digitizer](wxGUI.vdigit.md)* can be
used to create masks while viewing the real or imaginary component
image. Alternatively *r.circle* can be used to generate high-, low- and
donut filters specifying the DC point as circle/ring center. When
*i.ifft* is executed, it (automatically) uses the same GRASS region
definition setting that was used during the original transformation done
with *[i.fft](i.fft.md)*.

## REFERENCES

- M. Frigo and S. G. Johnson (1998): "FFTW: An Adaptive Software
  Architecture for the FFT". See [www.fftw.org](https://fftw.org/): FFTW
  is a C subroutine library for computing the Discrete Fourier Transform
  (DFT) in one or more dimensions, of both real and complex data, and of
  arbitrary input size.
- Richards, J.A (1986): **Remote Sensing Digital Image Analysis**,
  Springer-Verlag, 1986.
- Personal communication, between program author and Ali R. Vali, Space
  Research Center, University of Texas, Austin, 1990.

## SEE ALSO

*[i.cca](i.cca.md), [g.gui.iclass](g.gui.iclass.md), [i.fft](i.fft.md),
[i.pca](i.pca.md), [r.circle](r.circle.md), [wxGUI vector
digitizer](wxGUI.vdigit.md)*

## AUTHORS

David Satnik, GIS Laboratory, Central Washington University  
Glynn Clements (FFTW support)

## SOURCE CODE

Available at: [i.ifft source code](https://github.com/OSGeo/grass/tree/main/imagery/i.ifft)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.ifft))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
