---
name: r.external
description: Links GDAL supported raster data as a pseudo GRASS raster map.
keywords: [ raster, import, external ]
---

# r.external

Links GDAL supported raster data as a pseudo GRASS raster map.

=== "Command line"

    **r.external**
    [**-fojeahvtmr**]
    [**input**=*name*]
    [**source**=*name*]
    **output**=*name*
    [**band**=*integer*]
    [**title**=*phrase*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.external output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.external***",
        **input**=*None*,
        **source**=*None*,
        **output**,
        **band**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.external", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_external*(**input**=*None*,
        **source**=*None*,
        **output**,
        **band**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_external(output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster file to be linked  
    **source**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of non-file GDAL data source  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **band**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Band to select (default is all bands)  
    **title**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;List supported formats and exit  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    **-j**  
    &nbsp;&nbsp;&nbsp;&nbsp;Perform projection check only and exit  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extend region extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Also updates the default region if in the PERMANENT mapset  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Auto-adjustment for lat/lon  
    &nbsp;&nbsp;&nbsp;&nbsp;Attempt to fix small precision errors in resolution and extents  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Flip horizontally  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;Flip vertically  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available bands including band type in dataset and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: band number,type,projection check  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Read data range from metadata  
    &nbsp;&nbsp;&nbsp;&nbsp;WARNING: metadata are sometimes approximations with wrong data range  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create fast link without data range  
    &nbsp;&nbsp;&nbsp;&nbsp;WARNING: some modules do not work correctly without known data range  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster file to be linked  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **source** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of non-file GDAL data source  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **band** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Band to select (default is all bands)  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *o*, *j*, *e*, *a*, *h*, *v*, *t*, *m*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported formats and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform projection check only and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend region extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also updates the default region if in the PERMANENT mapset  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Auto-adjustment for lat/lon  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Attempt to fix small precision errors in resolution and extents  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Flip horizontally  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Flip vertically  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available bands including band type in dataset and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Format: band number,type,projection check  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Read data range from metadata  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;WARNING: metadata are sometimes approximations with wrong data range  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create fast link without data range  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;WARNING: some modules do not work correctly without known data range  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster file to be linked  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **source** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of non-file GDAL data source  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **band** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Band to select (default is all bands)  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *o*, *j*, *e*, *a*, *h*, *v*, *t*, *m*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported formats and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform projection check only and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend region extents based on new dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also updates the default region if in the PERMANENT mapset  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Auto-adjustment for lat/lon  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Attempt to fix small precision errors in resolution and extents  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Flip horizontally  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Flip vertically  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available bands including band type in dataset and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Format: band number,type,projection check  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Read data range from metadata  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;WARNING: metadata are sometimes approximations with wrong data range  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create fast link without data range  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;WARNING: some modules do not work correctly without known data range  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.external* allows a user to link a GDAL supported raster file to a
binary raster map layer, from any GDAL supported raster map format, with
an optional title. The file is not imported but just registered as GRASS
raster map.

## NOTES

In essence, *r.external* creates a read-only link to the original
dataset which is only valid if the original dataset remains at the
originally indicated directory and filename.

## NULL data handling

GDAL-linked (*r.external*) maps do not have or use a NULL bitmap, hence
*r.null* cannot manipulate them directly. Here NULL cells are those
whose value matches the value reported by the GDALGetRasterNoDataValue()
function.

To introduce additional NULL values to a computation based on a
GDAL-linked raster, the user needs to either create a mask with with
*r.mask* and then "apply" it using e.g. *r.resample* or *r.mapcalc*, or
use *r.mapcalc* to create a copy with the appropriate categories changed
to NULL (`if()` condition).

## EXAMPLES

### RGB Orthophoto from GeoTIFF

```sh
# import of all channels (each channel will become a GRASS raster map):
r.external input=/home/user/data/maps/059100.tif output=ortho
g.region raster=ortho.3 -p
d.rgb r=ortho.1 g=ortho.2 b=ortho.3
r.composite r=ortho.1 g=ortho.2 b=ortho.3 output=ortho.rgb
```

### Processing workflow without data import and export

External raster maps to be processed can be directly linked using
*r.external*; likewise, results can be written out to standard raster
formats with *r.external.out* (GDAL supported formats):

```sh
# register GeoTIFF file to be used in current mapset:
r.external input=terra_lst1km20030314.LST_Day.tif output=modis_celsius

# define output directory for files resulting from GRASS calculation:
r.external.out directory=$HOME/gisoutput/ format="GTiff"

# perform GRASS calculation (here: extract pixels > 20 deg C)
# this stores the output map directly as GeoTIFF:
r.mapcalc "warm.tif = if(modis_celsius > 20.0, modis_celsius, null() )"

# cease GDAL output connection and turn back to write GRASS raster files:
r.external.out -r

# now use the resulting file elsewhere
gdalinfo $HOME/gisoutput/warm.tif
```

## REFERENCES

GDAL Pages: [https://gdal.org/](https://gdal.org)  

## SEE ALSO

*[r.import](r.import.md), [r.in.gdal](r.in.gdal.md),
[r.external.out](r.external.out.md)*

*[v.import](v.import.md), [v.in.ogr](v.in.ogr.md),
[v.external](v.external.md), [v.external.out](v.external.out.md)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [r.external source code](https://github.com/OSGeo/grass/tree/main/raster/r.external)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.external))  
Latest change: Tuesday Aug 26 16:54:41 2025 in commit [2f08636](https://github.com/OSGeo/grass/commit/2f08636ee5285de8e7d9331184ce8425a4b40273)
