---
name: r3.info
description: Outputs basic information about a user-specified 3D raster map layer.
keywords: [ raster3d, metadata, voxel, extent ]
---

# r3.info

Outputs basic information about a user-specified 3D raster map layer.

=== "Command line"

    **r3.info**
    [**-grh**]
    **map**=*name*
    [**format**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.info map=name
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r3.info***",
        **map**,
        **format**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r3.info", map="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_info*(**map**,
        **format**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_info(map="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    **format**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print raster3d array information  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print range  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print raster3d history  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *r*, *h*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print raster3d array information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print range  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print raster3d history  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, shell, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: shell script style output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *r*, *h*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print raster3d array information  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print range  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print raster3d history  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.info* reports metadata and range of 3D voxel maps.

## NOTES

For backward compatibility, using the **-g**, **-r** flags without specifying
a **format** currently defaults to the **shell** format. In the next major
release, this behavior may change to default to the **plain** format to better
support interactive use. To ensure consistent behavior in scripts, explicitly
specify the  **shell** or **json** format.

<!-- markdownlint-disable MD046 -->
## EXAMPLES

### Get full report

Below is the full report produced by *r3.info* for the raster3d map "volume",
created using `r3.mapcalc expression="volume = row() + col() + depth()"`:

=== "Command line"

    ```sh
    r3.info volume
    ```

    Possible output:

    ```text
    +----------------------------------------------------------------------------+
    | Map:      volume                         Date: Mon Jul 21 23:14:24 2025    |
    | Mapset:   PERMANENT                      Login of Creator: nishantbansal   |
    | Project: nc_spm_08_grass7                                                  |
    | DataBase: /grassdata                                                       |
    | Title:    volume                                                           |
    | Units:    none                                                             |
    | Vertical unit: units                                                       |
    | Timestamp: none                                                            |
    |----------------------------------------------------------------------------|
    |                                                                            |
    |   Type of Map:  raster_3d            Number of Categories: 0               |
    |   Data Type:    DCELL                                                      |
    |   Rows:         100                                                        |
    |   Columns:      200                                                        |
    |   Depths:       50                                                         |
    |   Total Cells:  1000000                                                    |
    |   Total size:           147591 Bytes                                       |
    |   Number of tiles:      294                                                |
    |   Mean tile size:       502 Bytes                                          |
    |   Tile size in memory:  31320 Bytes                                        |
    |   Number of tiles in x, y and  z:   7, 7, 6                                |
    |   Dimension of a tile in x, y, z:   29, 15, 9                              |
    |                                                                            |
    |        Projection: Lambert Conformal Conic (zone 0)                        |
    |            N:        200    S:        100   Res:     1                     |
    |            E:        400    W:        200   Res:     1                     |
    |            T:        500    B:        450   Res:     1                     |
    |   Range of data:   min =          3 max =        350                       |
    |                                                                            |
    |   Data Source:                                                             |
    |                                                                            |
    |                                                                            |
    |                                                                            |
    |   Data Description:                                                        |
    |    generated by r3.mapcalc                                                 |
    |                                                                            |
    |   Comments:                                                                |
    |    r3.mapcalc expression="volume = row() + col() + depth()" region="cur\   |
    |    rent"                                                                   |
    |                                                                            |
    +----------------------------------------------------------------------------+
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    data = gs.parse_command("r3.info", map="volume", format="json")
    print(data["title"])
    ```

    Possible output:

    ```text
    volume
    ```

    The whole JSON may look like this:

    ```json
    {
        "map": "volume",
        "date": "Mon Jul 21 23:14:24 2025",
        "mapset": "PERMANENT",
        "creator": "nishantbansal",
        "project": "nc_spm_08_grass7",
        "database": "/grassdata",
        "title": "volume",
        "units": "none",
        "vertical_units": "units",
        "timestamp": null,
        "maptype": "raster_3d",
        "ncats": 0,
        "datatype": "DCELL",
        "rows": 100,
        "cols": 200,
        "depths": 50,
        "cells": 1000000,
        "size": 147591,
        "ntiles": 294,
        "meansize": 502,
        "tilesize": 31320,
        "tilenumx": 7,
        "tilenumy": 7,
        "tilenumz": 6,
        "tiledimx": 29,
        "tiledimy": 15,
        "tiledimz": 9,
        "north": 200,
        "south": 100,
        "nsres": 1,
        "east": 400,
        "west": 200,
        "ewres": 1,
        "top": 500,
        "bottom": 450,
        "tbres": 1,
        "min": 3,
        "max": 350,
        "source1": "",
        "source2": "",
        "description": "generated by r3.mapcalc",
        "comments": "r3.mapcalc expression=\"volume = row() + col() + depth()\" region=\"current\""
    }
    ```

Alternatively, the output from *r3.info* may be limited to a
subset of the available information by passing various flags to the
module:

### Get raster3d array information

=== "Command line"

    ```sh
    r3.info volume -g format=shell
    ```

    Possible output:

    ```text
    north=200
    south=100
    east=400
    west=200
    bottom=450
    top=500
    nsres=1
    ewres=1
    tbres=1
    rows=100
    cols=200
    depths=50
    datatype="DCELL"
    timestamp="none"
    units="none"
    vertical_units="units"
    tilenumx=7
    tilenumy=7
    tilenumz=6
    tiledimx=29
    tiledimy=15
    tiledimz=9
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    data = gs.parse_command("r3.info", map="volume", flags="g", format="json")
    print(data)
    ```

    Possible output:

    ```text
    {'north': 200, 'south': 100, 'east': 400, 'west': 200, 'bottom': 450, 'top': 500, 'nsres': 1, 'ewres': 1, 'tbres': 1, 'rows': 100, 'cols': 200, 'depths': 50, 'datatype': 'DCELL', 'timestamp': None, 'units': 'none', 'vertical_units': 'units', 'tilenumx': 7, 'tilenumy': 7, 'tilenumz': 6, 'tiledimx': 29, 'tiledimy': 15, 'tiledimz': 9}
    ```

### Get the map data range

=== "Command line"

    ```sh
    r3.info -r volume format=shell
    ```

    Possible output:

    ```text
    min=3.000000
    max=350.000000
    ```

=== "Python (grass.script)"

    ```python
    import grass.script as gs

    data = gs.parse_command("r3.info", map="volume", flags="r", format="json")
    print(data)
    ```

    Possible output:

    ```text
    {'min': 3, 'max': 350}
    ```
<!-- markdownlint-restore -->

## SEE ALSO

*[r.info](r.info.md)*

## AUTHORS

Roman Waupotitsch, Michael Shapiro, Helena Mitasova, Bill Brown, Lubos
Mitas, Jaro Hofierka

## SOURCE CODE

Available at: [r3.info source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.info)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.info))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
