---
name: v.external
description: Creates a new pseudo-vector map as a link to an OGR-supported layer or a PostGIS feature table.
keywords: [ vector, import, external, OGR, PostGIS, level1 ]
---

# v.external

Creates a new pseudo-vector map as a link to an OGR-supported layer or a PostGIS feature table.

=== "Command line"

    **v.external**
    [**-ojfltb**]
    **input**=*string*
    [**layer**=*name*]
    [**where**=*sql_query*]
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.external input=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.external***",
        **input**,
        **layer**=*None*,
        **where**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.external", input="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_external*(**input**,
        **layer**=*None*,
        **where**=*None*,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_external(input="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input OGR or PostGIS data source  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples:\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ESRI Shapefile: directory containing a shapefile\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MapInfo File: directory containing a mapinfo file\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: connection string, eg. 'PG:dbname=db user=grass'  
    **layer**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of OGR layer or PostGIS feature table to be linked  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples:\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ESRI Shapefile: shapefile name\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MapInfo File: mapinfo file name\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: table name  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output GRASS vector map (default: input layer)  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    **-j**  
    &nbsp;&nbsp;&nbsp;&nbsp;Perform projection check only and exit  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;List supported formats and exit  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available layers in data source and exit  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available layers including feature type in data source and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: layer name,type,projection check,geometry  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input OGR or PostGIS data source  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples:\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ESRI Shapefile: directory containing a shapefile\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MapInfo File: directory containing a mapinfo file\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: connection string, eg. 'PG:dbname=db user=grass'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of OGR layer or PostGIS feature table to be linked  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples:\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ESRI Shapefile: shapefile name\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MapInfo File: mapinfo file name\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource_layer, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output GRASS vector map (default: input layer)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *j*, *f*, *l*, *t*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform projection check only and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported formats and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available layers in data source and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available layers including feature type in data source and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Format: layer name,type,projection check,geometry  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input OGR or PostGIS data source  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples:\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ESRI Shapefile: directory containing a shapefile\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MapInfo File: directory containing a mapinfo file\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: connection string, eg. 'PG:dbname=db user=grass'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of OGR layer or PostGIS feature table to be linked  
    &nbsp;&nbsp;&nbsp;&nbsp;Examples:\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ESRI Shapefile: shapefile name\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;MapInfo File: mapinfo file name\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, datasource_layer, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output GRASS vector map (default: input layer)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *j*, *f*, *l*, *t*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current project's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**j**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Perform projection check only and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported formats and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available layers in data source and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available layers including feature type in data source and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Format: layer name,type,projection check,geometry  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.external* creates new vector map as a link to external OGR layer or
PostGIS feature table. OGR (Simple Features Library) is part of the
[GDAL](https://gdal.org) library, so you need to install GDAL to use
*v.external* for external OGR layers. Note that a PostGIS feature table
can be linked also using built-in *GRASS-PostGIS data driver* (requires
GRASS to be built with PostgreSQL support).

## NOTES

The simple feature data model used by OGR (or PostGIS) is very different
from the topological format used by GRASS. Instead of true topology, so
called 'pseudo topology' is created for data linked by *v.external*.
User should learn the difference between those two formats, because
**some modules** working correctly with GRASS native data, **can produce
wrong results** with input vector maps created by *v.external*.

**Limitations:**

Due to these data model differences *v.external* does not work with all
data formats. In general, for all formats that do not have a key column
(e.g. SHAPE file), attributes are not accessible, and attributes would
get lost when modifying the geometries. Therefore it is generally not
safe to link vector data with *v.external*. In many cases it does not
make sense to use *v.external* linked data with simple features, instead
vector data should be imported with *v.import* or *v.in.ogr* to get true
topology support. Importantly, point cloud data which do not have
topology, can be linked with *v.external* as long as there are no
attributes attached to these point cloud data, or if the format of the
point cloud data has a key column that allows linking vector geometries
to attributes.

See *[v.db.connect](v.db.connect.md)* for an example of maintaining
attributes in external DBMS in also writable mode.

### Supported OGR vector formats

To list supported OGR formats, type

```sh
v.external -f
```

For details see [GDAL web
site](https://gdal.org/en/stable/drivers/vector/).

## EXAMPLES

### ESRI Shapefile

Assuming that 'test_shape.shp' is located in directory
'/home/user/shape_data'.

```sh
v.external input=/home/user/shape_data layer=test_shape output=grass_map
```

### PostGIS layers

By default, PostGIS links are created by built-in PostGIS support, ie.
using *GRASS-PostGIS data driver*. If the environment variable
`GRASS_VECTOR_OGR` exists, or GRASS is compiled without PostgreSQL
support then GRASS will use OGR-PostgreSQL driver for creating a link.

List of layers for given data source can be printed by **-l** flag.

```sh
v.external input="PG:host=localhost user=postgres dbname=postgis" -l

...
polymap
...
```

```sh
v.external input="PG:host=localhost user=postgres dbname=postgis" layer=polymap
```

Note: Authentication details (user password) can be preferably defined
by *[db.login](db.login.md)*.

### MapInfo files

Assuming that 'mapinfo_test' MapInfo file is located in the current
directory (".").

```sh
v.external input=./ layer=mapinfo_test output=grass_map
```

### SDTS files

Note: you have to select the CATD file

```sh
v.external input=CITXCATD.DDF output=cities
```

### TIGER files

```sh
v.external input=input/2000/56015/ layer=CompleteChain,PIP output=t56015_all
```

### Linking subset of features

By **where** option only subset of features can be linked. In the
example below only one feature (in this case a vector tile) will be
linked as a new GRASS vector map.

```sh
v.external in="PG:dbname=tiles" layer=wrs2_descending where="pr=191026"
...
Number of areas: 1
...
```

## REFERENCES

[OGR vector library C API](https://gdal.org/en/stable/api/)
documentation

## SEE ALSO

*[v.external.out](v.external.out.md), [v.clean](v.clean.md),
[v.db.connect](v.db.connect.md), [v.import](v.import.md),
[v.in.db](v.in.db.md), [v.in.ogr](v.in.ogr.md),
[v.out.ogr](v.out.ogr.md)*

[GDAL Library](https://gdal.org/)  
[PostGIS](https://postgis.net/)

See also GRASS [user wiki
page](https://grasswiki.osgeo.org/wiki/Working_with_external_data_in_GRASS_7)
for more examples.

## AUTHORS

Radim Blazek, ITC-Irst, Trento, Italy  
PostGIS support by Martin Landa, GeoForAll (OSGeoREL) Lab, Czech
Technical University in Prague, Czech Republic

## SOURCE CODE

Available at: [v.external source code](https://github.com/OSGeo/grass/tree/main/vector/v.external)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.external))  
Latest change: Tuesday Aug 26 16:54:41 2025 in commit [2f08636](https://github.com/OSGeo/grass/commit/2f08636ee5285de8e7d9331184ce8425a4b40273)
