---
name: v.split
description: Splits vector lines to shorter segments.
keywords: [ vector, geometry, densification, node, segment, vertex ]
---

# v.split

Splits vector lines to shorter segments.

=== "Command line"

    **v.split**
    [**-nf**]
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    [**length**=*float*]
    [**units**=*string*]
    [**vertices**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.split input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.split***",
        **input**,
        **layer**=*"-1"*,
        **output**,
        **length**=*None*,
        **units**=*"map"*,
        **vertices**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.split", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_split*(**input**,
        **layer**=*"-1"*,
        **output**,
        **length**=*None*,
        **units**=*"map"*,
        **vertices**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_split(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **length**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum segment length  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *map, meters, kilometers, feet, surveyfeet, miles, nautmiles*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *map*  
    **vertices**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of vertices in segment  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Add new vertices, but do not split  
    &nbsp;&nbsp;&nbsp;&nbsp;Applies only to 'length' option  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force segments to be exactly of given length, except for last one  
    &nbsp;&nbsp;&nbsp;&nbsp;Applies only to 'length' option  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **length** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum segment length  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *map, meters, kilometers, feet, surveyfeet, miles, nautmiles*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *map*  
    **vertices** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of vertices in segment  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add new vertices, but do not split  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Applies only to 'length' option  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force segments to be exactly of given length, except for last one  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Applies only to 'length' option  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **length** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum segment length  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *map, meters, kilometers, feet, surveyfeet, miles, nautmiles*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *map*  
    **vertices** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of vertices in segment  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *f*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Add new vertices, but do not split  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Applies only to 'length' option  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force segments to be exactly of given length, except for last one  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Applies only to 'length' option  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.split* splits vector lines into shorter segments using a maximal
distance between nodes. The resulting length of all segments is expected
to be equal and not higher than the given **length** parameter.

## NOTES

*v.split* does not change the layer, nor the category information, nor
the attribute table links of the original file. It just splits each line
in segments and attributes the same category to all segments of the same
original line. As the attribute table is linked to the features with
their category as key, all segments originating from the same original
line are linked to the same line in the original attribute table which
is just copied to the new map.

### Notes on individual segment information

When running *v.to.db* on a map produced by *v.split*, *v.to.db* will
add length information for each segment in its respective attribute
line, but since all the segments of the same original line share the
same attribute table line, it only gets updated once.

To obtain the length of each segment, the user will have to attribute
different category values to each of them. The best way to do this on a
separate layer, using *v.category*

```sh
v.category v_split op=add layer=2 output=v_split_2
```

and then run the following commands on the new layer 2:

```sh
v.db.addtable v_split_2 layer=2
v.db.addcolumn map=v_split_2 column="length double precision" layer=2
v.to.db map=v_split_2 type=line option=length columns=length units=meters layer=2
```

To link the new segments in the new layer to the original segments, use:

```sh
v.db.addcolumn map=v_split_2 layer=2 column="cat_1 int"
v.to.db map=v_split_2 layer=2 option=query query_layer=1 query_column=cat columns=cat_1
```

## EXAMPLES

The examples are based on the North Carolina sample data.

### Example 1: Inserting nodes to railroad lines map

```sh
# extract one railroad line for this example
v.extract input=railroads output=myrr cats=1

# show line, category, direction (to find the beginning)
g.region vector=myrr
d.erase
d.vect myrr display=shape,cat,dir

# insert nodes at a distance not longer than 1000m
v.split input=myrr output=myrr_split_1km length=1000

d.vect myrr_split_1km display=shape,topo
```

Note: In case that the vector line data are not polylines, generate
first polylines as the second step, eg.:

```sh
# join segments into polyline
v.build.polylines input=myrr output=myrr_polylines
# regenerate categories
v.category input=myrr_polylines output=myrailroads option=add
```

### Example 2: Inserting vertices to railroad lines map

Note: first run the two steps from example 1.

```sh
# insert vertices at a distance not longer than 1000m
v.split -n input=myrr output=myrr_split length=1000
d.vect myrr_split display=shape,topo
```

## SEE ALSO

*[v.edit](v.edit.md), [v.build.polylines](v.build.polylines.md),
[v.to.points](v.to.points.md), [v.segment](v.segment.md)*

## AUTHOR

Radim Blazek

## SOURCE CODE

Available at: [v.split source code](https://github.com/OSGeo/grass/tree/main/vector/v.split)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.split))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
