---
name: d.rast.leg.py
description: Displays a raster map and its legend on a graphics window
keywords: [ display, cartography, legend ]
---

# d.rast.leg.py

Displays a raster map and its legend on a graphics window

=== "Command line"

    **d.rast.leg.py**
    [**-fns**]
    **map**=*name*
    [**lines**=*integer*]
    [**raster**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.rast.leg.py map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.rast.leg.py***",
        **map**,
        **lines**=*None*,
        **raster**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.rast.leg.py", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_rast_leg_py*(**map**,
        **lines**=*None*,
        **raster**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_rast_leg_py(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to display  
    **lines**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of lines to appear in the legend  
    **raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map to generate legend from  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Flip legend  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Omit entries with missing label  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw smooth gradient  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to display  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **lines** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of lines to appear in the legend  
    **raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map to generate legend from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *n*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Flip legend  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Omit entries with missing label  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw smooth gradient  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to display  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **lines** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of lines to appear in the legend  
    **raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map to generate legend from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *f*, *n*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Flip legend  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Omit entries with missing label  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw smooth gradient  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.rast.leg* shows a raster map along with its legend. It first clears
the entire screen, then divides it into a main (left) and a minor
(right) frames, and displays a raster map in the main frame and the map
legend in the minor frame. The main frame remains active when the
program finishes.

## NOTES

The legend may be flipped with the **-f** flag.

If the **lines** parameter is not given then the legend frame will
display as many lines as number of categories in the map, otherwise, it
will display the first **lines** minus 1 categories with the rest being
truncated.

The user may adjust the **lines** parameter or the size of graphics
window to get an appropriate result.

The user may specify a second raster map with the **raster** parameter
from which the legend is generated. This is useful to visualize (time)
series of raster maps with a common static legend instead of the default
dynamic legend.

To remove all frames when clearing the display, use `d.erase -f`.

## EXAMPLE

In this example, the polar diagram of the 'aspect' angle map in the
North Carolina sample dataset is generated:

```sh
g.region raster=landclass96 -p
d.rast.leg landclass96
```

## SEE ALSO

*[d.legend](d.legend.md), [d.erase](d.erase.md), [d.rast](d.rast.md)*

## AUTHORS

Jianping Xu, Scott Madry, Rutgers University  
Markus Neteler

## SOURCE CODE

Available at: [d.rast.leg source code](https://github.com/OSGeo/grass/tree/main/scripts/d.rast.leg)
([history](https://github.com/OSGeo/grass/commits/main/scripts/d.rast.leg))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
