---
name: d.shade.py
description: Drapes a color raster over an shaded relief or aspect map.
keywords: [ display, elevation, relief, hillshade, visualization ]
---

# d.shade.py

Drapes a color raster over an shaded relief or aspect map.

=== "Command line"

    **d.shade.py**
    **shade**=*name*
    **color**=*name*
    [**brighten**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.shade.py shade=name color=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.shade.py***",
        **shade**,
        **color**,
        **brighten**=*0*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.shade.py", shade="name", color="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_shade_py*(**shade**,
        **color**,
        **brighten**=*0*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_shade_py(shade="name", color="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **shade**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of shaded relief or aspect raster map  
    **color**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster to drape over relief raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Typically, this raster is elevation or other colorful raster  
    **brighten**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent to brighten  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-99-99*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **shade** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of shaded relief or aspect raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster to drape over relief raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Typically, this raster is elevation or other colorful raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **brighten** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent to brighten  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-99-99*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **shade** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of shaded relief or aspect raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster to drape over relief raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Typically, this raster is elevation or other colorful raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **brighten** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent to brighten  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-99-99*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.shade* will drape a color raster map over a shaded relief map. In
place of shaded relief, any raster map can be used including aspect or
slope. The color raster map is usually an elevation raster map with
colorful color table (as opposed to gray scale color table). However,
any raster map can be used including categorical raster maps.

The advantage of this module is that it allows visualizing the shaded
map without a need to create a new raster which would combine both.
Comparing to creating shaded relief as semi-transparent overlay on the
color raster map, this module gives result with more saturated colors.

The input for this module can be created for example using
[r.slope.aspect](r.slope.aspect.md) or [r.relief](r.relief.md)  
.

## NOTES

Refer to the *[d.his](d.his.md)* help page for more details; *d.shade*
is simply a frontend to that module.

## EXAMPLES

In this example, the `aspect` map in the North Carolina sample dataset
is used to hillshade the `elevation` map:

```sh
g.region raster=aspect -p
d.mon wx0
d.shade shade=aspect color=elevation
```

![Elevation with aspect shades](dshade.png)

Figure: A detail of raster created by applying shading effect of aspect
to elevation raster map from North Carolina dataset elevation map

In this next example, a shaded relief raster map is created and used to
create a colorized hillshade:

```sh
g.region raster=elevation
r.relief input=elevation output=elevation_shaded_relief

d.mon wx1
d.shade shade=elevation_shaded_relief color=elevation
```

Interesting visualizations can be created using different color tables
for elevation raster map, for example using `haxby` color table.

## SEE ALSO

*[d.his](d.his.md), [g.pnmcomp](g.pnmcomp.md), [r.shade](r.shade.md),
[r.slope.aspect](r.slope.aspect.md), [r.relief](r.relief.md)  
[wxGUI 3D viewer (NVIZ)](wxGUI.nviz.md)*

## AUTHORS

Unknown; updated to GRASS 5.7 by Michael Barton

## SOURCE CODE

Available at: [d.shade source code](https://github.com/OSGeo/grass/tree/main/scripts/d.shade)
([history](https://github.com/OSGeo/grass/commits/main/scripts/d.shade))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
