---
title: Database tools
author: GRASS Development Team
---

# Database tools

To learn more about these tool in general, go to [Database introduction](databaseintro.md).

| Name | Description |
|--------|-------------|
| [db.columns](db.columns.md) | List all columns for a given table. |
| [db.connect](db.connect.md) | Prints/sets general DB connection for current mapset. |
| [db.copy](db.copy.md) | Copy a table. Either 'from_table' (optionally with 'where') can be used or 'select' option, but not 'from_table' and 'select' at the same time. |
| [db.createdb](db.createdb.md) | Creates an empty database. |
| [db.databases](db.databases.md) | Lists all databases for a given driver and location. |
| [db.describe](db.describe.md) | Describes a table in detail. |
| [db.drivers](db.drivers.md) | Lists all database drivers. |
| [db.dropcolumn](db.dropcolumn.md) | Drops a column from selected attribute table. |
| [db.dropdb](db.dropdb.md) | Removes an existing database. |
| [db.droptable](db.droptable.md) | Drops an attribute table. |
| [db.execute](db.execute.md) | Executes any SQL statement. For SELECT statements use 'db.select'. |
| [db.in.ogr](db.in.ogr.md) | Imports attribute tables in various formats. |
| [db.login](db.login.md) | Sets user/password for DB driver/database. |
| [db.out.ogr](db.out.ogr.md) | Exports attribute tables into various formats. |
| [db.select](db.select.md) | Selects data from attribute table. Performs SQL query statement(s). |
| [db.tables](db.tables.md) | Lists all tables for a given database. |
| [db.test](db.test.md) | Test database driver, database must exist and set by db.connect. |
| [db.univar](db.univar.md) | Calculates univariate statistics on selected table column. |
