---
name: db.describe
description: Describes a table in detail.
keywords: [ database, json, attribute table ]
---

# db.describe

Describes a table in detail.

=== "Command line"

    **db.describe**
    [**-c**]
    **table**=*name*
    [**driver**=*name*]
    [**database**=*name*]
    **format**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.describe table=name format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***db.describe***",
        **table**,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("db.describe", table="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_describe*(**table**,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_describe(table="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **table**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print column names only instead of full column descriptions  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print column names only instead of full column descriptions  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, pg, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print column names only instead of full column descriptions  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.describe* displays table information. If parameter **-c** is used
only column names instead of full column descriptions is given.

## NOTE

If parameters for database connection are already set with
[db.connect](db.connect.md), they are taken as default values and do not
need to be specified each time.

## EXAMPLES

*List column descriptions of table in SQLite database (note that this is
the default setting)*  

```sh
db.describe driver=sqlite table=hospitals \
   database='$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db'

# or simply
db.describe myarchsites
```

### DBF example

```sh
db.describe -c table=hospitals database='$GISDBASE/$LOCATION_NAME/PERMANENT/dbf/' \
            driver=dbf
ncols: 16
nrows: 160
Column 1: cat:INTEGER:11
Column 2: OBJECTID:INTEGER:11
Column 3: AREA:DOUBLE PRECISION:20
[...]
```

```sh
db.describe table=hospitals database='$GISDBASE/$LOCATION_NAME/PERMANENT/dbf/' \
            driver=dbf
table:hospitals
description:
insert:yes
delete:yes
ncols:16
nrows:160

column:cat
description:
type:INTEGER
len:11
scale:0
precision:10
default:
nullok:yes
select:yes
update:yes

column:OBJECTID
description:
type:INTEGER
[...]
```

### JSON Output

```sh
db.describe table=hospitals format=json
```

```sh
{
    "table": "hospitals",
    "description": "",
    "insert": null,
    "delete": null,
    "ncols": 16,
    "nrows": 160,
    "columns": [
        {
            "position": 1,
            "column": "cat",
            "description": "",
            "type": "INTEGER",
            "length": 20,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 2,
            "column": "OBJECTID",
            "description": "",
            "type": "INTEGER",
            "length": 20,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 3,
            "column": "AREA",
            "description": "",
            "type": "DOUBLE PRECISION",
            "length": 20,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 4,
            "column": "PERIMETER",
            "description": "",
            "type": "DOUBLE PRECISION",
            "length": 20,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 5,
            "column": "HLS_",
            "description": "",
            "type": "INTEGER",
            "length": 20,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 6,
            "column": "HLS_ID",
            "description": "",
            "type": "INTEGER",
            "length": 20,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 7,
            "column": "NAME",
            "description": "",
            "type": "CHARACTER",
            "length": 45,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 8,
            "column": "ADDRESS",
            "description": "",
            "type": "CHARACTER",
            "length": 35,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 9,
            "column": "CITY",
            "description": "",
            "type": "CHARACTER",
            "length": 16,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 10,
            "column": "ZIP",
            "description": "",
            "type": "CHARACTER",
            "length": 5,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 11,
            "column": "COUNTY",
            "description": "",
            "type": "CHARACTER",
            "length": 12,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 12,
            "column": "PHONE",
            "description": "",
            "type": "CHARACTER",
            "length": 14,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 13,
            "column": "CANCER",
            "description": "",
            "type": "CHARACTER",
            "length": 4,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 14,
            "column": "POLYGONID",
            "description": "",
            "type": "INTEGER",
            "length": 20,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 15,
            "column": "SCALE",
            "description": "",
            "type": "DOUBLE PRECISION",
            "length": 20,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        },
        {
            "position": 16,
            "column": "ANGLE",
            "description": "",
            "type": "DOUBLE PRECISION",
            "length": 20,
            "scale": 0,
            "precision": 0,
            "default": null,
            "nullok": true,
            "select": null,
            "update": null
        }
    ]
}
```

## SEE ALSO

*[db.columns](db.columns.md), [db.droptable](db.droptable.md),
[db.execute](db.execute.md), [db.login](db.login.md),
[db.tables](db.tables.md), [GRASS SQL interface](sql.md)*

## AUTHOR

Radim Blazek, ITC-Irst, Trento, Italy

## SOURCE CODE

Available at: [db.describe source code](https://github.com/OSGeo/grass/tree/main/db/db.describe)
([history](https://github.com/OSGeo/grass/commits/main/db/db.describe))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
