---
name: db.in.ogr.py
description: Imports attribute tables in various formats.
keywords: [ database, import, attribute table ]
---

# db.in.ogr.py

Imports attribute tables in various formats.

=== "Command line"

    **db.in.ogr.py**
    **input**=*name*
    [**gdal_config**=*string*]
    [**gdal_doo**=*string*]
    [**db_table**=*name*]
    [**output**=*name*]
    [**key**=*string*]
    [**encoding**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.in.ogr.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.in.ogr.py***",
        **input**,
        **gdal_config**=*None*,
        **gdal_doo**=*None*,
        **db_table**=*None*,
        **output**=*None*,
        **key**=*None*,
        **encoding**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.in.ogr.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_in_ogr_py*(**input**,
        **gdal_config**=*None*,
        **gdal_doo**=*None*,
        **db_table**=*None*,
        **output**=*None*,
        **key**=*None*,
        **encoding**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_in_ogr_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Table file to be imported or DB connection string  
    **gdal_config**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;GDAL configuration options  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma-separated list of key=value pairs  
    **gdal_doo**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;GDAL dataset open options  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma-separated list of key=value pairs  
    **db_table**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of table from given DB to be imported  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output table  
    **key**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for auto-generated unique key column  
    **encoding**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Encoding value for attribute data  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Table file to be imported or DB connection string  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **gdal_config** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GDAL configuration options  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma-separated list of key=value pairs  
    **gdal_doo** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GDAL dataset open options  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma-separated list of key=value pairs  
    **db_table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of table from given DB to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, dbtable, *name*  
    **key** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for auto-generated unique key column  
    **encoding** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Encoding value for attribute data  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Table file to be imported or DB connection string  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **gdal_config** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GDAL configuration options  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma-separated list of key=value pairs  
    **gdal_doo** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GDAL dataset open options  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma-separated list of key=value pairs  
    **db_table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of table from given DB to be imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, dbtable, *name*  
    **key** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for auto-generated unique key column  
    **encoding** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Encoding value for attribute data  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.in.ogr* imports attribute tables in various formats as supported by
the [OGR library](https://gdal.org/) on the local system (DBF, CSV,
PostgreSQL, SQLite, MySQL, ODBC, etc.). Optionally a unique **key** (ID)
column can be added to the table.

## EXAMPLES

### Import CSV file

Limited type recognition can be done for Integer, Real, String, Date,
Time and DateTime columns through a descriptive file with same name as
the CSV file, but .csvt extension ([see details about the .csvt extension](https://gdal.org/en/stable/drivers/vector/csv.html)).

```sh
# NOTE: create koeppen_gridcode.csvt first for automated type recognition
db.in.ogr input=koeppen_gridcode.csv output=koeppen_gridcode gdal_doo="AUTODETECT_TYPE=YES"
db.describe koeppen_gridcode -c
db.select table=koeppen_gridcode
```

### Import DBF table

Import of a DBF table with additional unique key column (e.g., needed
for *[v.in.db](v.in.db.md)*).

```sh
db.in.ogr input=/path/to/mydata.dbf output=census_raleigh key=myid
db.describe -c census_raleigh
```

### Import of a SQLite table

```sh
db.in.ogr input=/path/to/sqlite.db db_table=census_raleigh output=census_raleigh
```

### Import of a PostgreSQL table

```sh
# HINT: if the database contains spatial tables, but you want to import a non-spatial
table, set the environmental variable PG_LIST_ALL_TABLES to YES before importing

db.in.ogr input="PG:host=localhost dbname=ecad user=neteler" \
          db_table=ecad_verona_tmean output=ecad_verona_tmean
db.select table=ecad_verona_tmean
db.describe -c ecad_verona_tmean
```

### Import XLS file

To force reading headers, define environmental variable
`OGR_XLS_HEADERS='FORCE'`. Parameter **db_table** refers to the list
within XLS file.

```sh
export OGR_XLS_HEADERS='FORCE'
db.in.ogr input=address.xls db_table=address_data
```

## SEE ALSO

*[db.select](db.select.md), [v.in.ogr](v.in.ogr.md),
[v.in.db](v.in.db.md)*

[GRASS SQL interface](sql.md)

## AUTHOR

Markus Neteler

## SOURCE CODE

Available at: [db.in.ogr source code](https://github.com/OSGeo/grass/tree/main/scripts/db.in.ogr)
([history](https://github.com/OSGeo/grass/commits/main/scripts/db.in.ogr))  
Latest change: Tuesday May 20 22:51:55 2025 in commit [6f8ee15](https://github.com/OSGeo/grass/commit/6f8ee15f43b0425f1bee79306540f3221004d255)
