---
name: g.download.project.py
description: Download GRASS project from the web Get GRASS project from an URL or file path
keywords: [ general, data, download, import ]
---

# g.download.project.py

Download GRASS project from the web

Get GRASS project from an URL or file path

=== "Command line"

    **g.download.project.py**
    **url**=*string*
    [**name**=*name*]
    [**path**=*path*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.download.project.py url=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.download.project.py***",
        **url**,
        **name**=*None*,
        **path**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.download.project.py", url="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_download_project_py*(**url**,
        **name**=*None*,
        **path**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_download_project_py(url="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the archive with a project to be downloaded  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of ZIP, TAR.GZ, or other similar archive  
    **name**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    **path**=*path*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the archive with a project to be downloaded  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of ZIP, TAR.GZ, or other similar archive  
    **name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of the archive with a project to be downloaded  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of ZIP, TAR.GZ, or other similar archive  
    **name** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Project (location) name  
    &nbsp;&nbsp;&nbsp;&nbsp;Project name (not path to project)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, location, *name*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS database directory  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: path to the current GRASS database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbase, *path*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.download.project* downloads an archived (e.g., `.zip` or `.tar.gz`)
project (previously called location) from a given URL and unpacks it to
a specified or current GRASS Spatial Database. URL can be also a
local file on the disk. If the archive contains a directory which
contains a project, the module will recognize that and use the project
automatically. The first directory which is a project is used. Other
projects or any other files are ignored.

## EXAMPLES

### Download the full GRASS sample project within a running session

Download and unpack the full North Carolina sample project into the
user's HOME directory:

```sh
g.download.project url=https://grass.osgeo.org/sampledata/north_carolina/nc_spm_full_v2alpha2.tar.gz path=$HOME
```

### Download the full GRASS sample project in a temporary session

In a temporary session, download and unpack the full North Carolina
sample project into the user's HOME directory:

```sh
grass --tmp-project XY --exec g.download.project url=https://grass.osgeo.org/sampledata/north_carolina/nc_spm_full_v2alpha2.tar.gz path=$HOME
```

## SEE ALSO

*[g.mapset](g.mapset.md), [g.mapsets](g.mapsets.md),
[r.proj](r.proj.md), [v.proj](v.proj.md),
[g.proj.all](https://grass.osgeo.org/grass-stable/manuals/addons/g.proj.all.html)*

## AUTHOR

Vaclav Petras, [NCSU GeoForAll
Lab](http://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [g.download.project source code](https://github.com/OSGeo/grass/tree/main/scripts/g.download.project)
([history](https://github.com/OSGeo/grass/commits/main/scripts/g.download.project))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
