---
name: g.mkfontcap
description: Generates the font configuration file by scanning various directories for fonts.
keywords: [ general, display ]
---

# g.mkfontcap

Generates the font configuration file by scanning various directories for fonts.

=== "Command line"

    **g.mkfontcap**
    [**-s**]
    [**extradirs**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.mkfontcap
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.mkfontcap***",
        **extradirs**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.mkfontcap")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_mkfontcap*(**extradirs**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_mkfontcap()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **extradirs**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of extra directories to scan  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma-separated list of extra directories to scan for Freetype-compatible fonts as well as the defaults (see documentation)  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Write font configuration file to standard output instead of $GISBASE/etc  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **extradirs** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of extra directories to scan  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma-separated list of extra directories to scan for Freetype-compatible fonts as well as the defaults (see documentation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write font configuration file to standard output instead of $GISBASE/etc  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **extradirs** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of extra directories to scan  
    &nbsp;&nbsp;&nbsp;&nbsp;Comma-separated list of extra directories to scan for Freetype-compatible fonts as well as the defaults (see documentation)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write font configuration file to standard output instead of $GISBASE/etc  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.mkfontcap* is a utility to generate a GRASS font configuration file
("fontcap") containing details of the fonts available on the current
system. If [Freetype](https://freetype.org/) is not installed, the font
list will be limited to the set of Hershey stroke fonts supplied with
GRASS. With Freetype enabled however, the module will recursively scan
all files within a predefined hierarchy to find Freetype-compatible
scalable fonts. The list of directories scanned is currently:

```sh
    /usr/lib/X11/fonts
    /usr/share/X11/fonts
    /usr/share/fonts
    /usr/local/share/fonts
    ${HOME}/Library/Fonts
    /Library/Fonts
    /System/Library/Fonts
    ${WINDIR}/Fonts
```

These correspond to directories where fonts can be found on some common
operating systems. Extra directories to search can easily by added using
the **extradirs** parameter, which accepts a comma-separated list. An
extra directory may optionally contain an environment variable *at the
start* of the string, if enclosed in ${xxx} syntax (see examples
above).

The module will normally write to the standard fontcap file location,
`$GISBASE/etc/fontcap`. If the environment variable `GRASS_FONT_CAP` is
set, the output will instead be written to the file specified by that
variable. This is useful if you don't have permission to modify
`$GISBASE/etc/fontcap`: in this case you can use e.g.

```sh
# use local file version instead of system copy
GRASS_FONT_CAP=$HOME/.gfontcap
export GRASS_FONT_CAP

g.mkfontcap
```

to create a personal copy and then to make GRASS use that file instead
of the system copy.

The output list of fonts is sorted first by type (Stroke fonts first,
followed by Freetype) and within each type by the short name of the
font.

## SEE ALSO

*[d.font](d.font.md)*

## AUTHOR

Paul Kelly

## SOURCE CODE

Available at: [g.mkfontcap source code](https://github.com/OSGeo/grass/tree/main/general/g.mkfontcap)
([history](https://github.com/OSGeo/grass/commits/main/general/g.mkfontcap))  
Latest change: Thursday May 08 14:35:40 2025 in commit [9528b1e](https://github.com/OSGeo/grass/commit/9528b1e38ba37992c1597a979dc3efbb07b74ec5)
