---
name: i.signatures
description: Manage imagery classification signature files
keywords: [ imagery, classification, signatures ]
---

# i.signatures

Manage imagery classification signature files

=== "Command line"

    **i.signatures**
    [**-p**]
    [**type**=*name*]
    **format**=*name*
    [**mapset**=*name* [,*name*,...]]
    [**remove**=*name* [,*name*,...]]
    [**rename**=*from,to* [,*from,to*,...]]
    [**copy**=*from,to* [,*from,to*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.signatures format=plain copy=from,to
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***i.signatures***",
        **type**=*None*,
        **format**=*"plain"*,
        **mapset**=*None*,
        **remove**=*None*,
        **rename**=*None*,
        **copy**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("i.signatures", format="json", copy="from,to")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_signatures*(**type**=*None*,
        **format**=*"plain"*,
        **mapset**=*None*,
        **remove**=*None*,
        **rename**=*None*,
        **copy**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_signatures(format="json", copy="from,to")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **type**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sig, sigset, libsvm*  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **mapset**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset to list  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: current search path  
    **remove**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file(s) to remove  
    **rename**=*from,to* [,*from,to*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file to rename  
    **copy**=*from,to* [,*from,to*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file to copy  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print signature files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigtype, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sig, sigset, libsvm*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **mapset** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset to list  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: current search path  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **remove** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file(s) to remove  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigfile, *name*  
    **rename** : list[tuple[str, str]] | tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file to rename  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigfile, *from,to*  
    **copy** : list[tuple[str, str]] | tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigfile, *from,to*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print signature files  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of signature file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigtype, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sig, sigset, libsvm*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **mapset** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of mapset to list  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: current search path  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, mapset, *name*  
    **remove** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file(s) to remove  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigfile, *name*  
    **rename** : list[tuple[str, str]] | tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file to rename  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigfile, *from,to*  
    **copy** : list[tuple[str, str]] | tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of file to copy  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sigfile, *from,to*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print signature files  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.signatures* module allows managing signature files:

- "sig" – generated by [i.gensig](i.gensig.md) for
  [i.maxlik](i.maxlik.md)
- "sigset" – generated by [i.gensigset](i.gensigset.md) for
  [i.smap](i.smap.md)
- "libsvm" - generated internally by [i.svm.train](i.svm.train.md) and used by
  [i.svm.predict](i.svm.predict.md) for classification.
The module can perform multiple actions per run. The order of execution
is "copy", "remove", "rename". When the print flag is specified without
specifying any type of signature files, it would print all signatures
grouped by type.

## NOTES

By default the module will list signature files from all mapsets in the
current search path. It is possible to limit listing only to a single
mapset by providing the "mapset" option. The mapset can be also not
listed in the current search path.  
Actions "remove" and "rename" operate only on the current mapset
(although accept fully qualified names). The "copy" action will accept a
signature file name from any mapset as its first argument (source file
to copy).

## EXAMPLES

Print names of all signature files:

```sh
i.signatures -p
```

Print only signature files of certain type as a JSON:

```sh
i.signatures -p type=sigset format=json
```

Delete signature file called "foo" of type "sig" (i.gensig / i.maxlik).

```sh
i.signatures remove=foo type=sig
```

Copy signature file "bar" from mapset "baz" to current mapset

```sh
i.signatures copy=bar@baz,best_version type=sigset
```

## SEE ALSO

*[i.gensig](i.gensig.md) [i.gensigset](i.gensigset.md) [i.svm.predict](i.svm.predict.md)*

## AUTHOR

Maris Nartiss

## SOURCE CODE

Available at: [i.signatures source code](https://github.com/OSGeo/grass/tree/main/imagery/i.signatures)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.signatures))  
Latest change: Wednesday Apr 02 10:01:47 2025 in commit [e328b0b](https://github.com/OSGeo/grass/commit/e328b0b93b6e035d0c434c3b7d4713a4200caf6a)
