---
name: i.spectral.py
description: Displays spectral response at user specified locations in group or images.
keywords: [ imagery, querying, raster, multispectral ]
---

# i.spectral.py

Displays spectral response at user specified locations in group or images.

=== "Command line"

    **i.spectral.py**
    [**-cgt**]
    [**group**=*name*]
    [**subgroup**=*name*]
    [**raster**=*name* [,*name*,...]]
    **coordinates**=*east,north* [,*east,north*,...]
    [**output**=*name*]
    [**format**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.spectral.py coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.spectral.py***",
        **group**=*None*,
        **subgroup**=*None*,
        **raster**=*None*,
        **coordinates**,
        **output**=*None*,
        **format**=*"png"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.spectral.py", coordinates=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_spectral_py*(**group**=*None*,
        **subgroup**=*None*,
        **raster**=*None*,
        **coordinates**,
        **output**=*None*,
        **format**=*"png"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_spectral_py(coordinates=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **subgroup**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    **raster**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    **coordinates**=*east,north* [,*east,north*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output image is valid for -g (or text file for -t flag)  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Graphics format for output file (valid for -g flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *png, eps, svg*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *png*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Show sampling coordinates instead of numbering in the legend (valid for -g flag)  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use gnuplot for display  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;output to text file  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **raster** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output image is valid for -g (or text file for -t flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Graphics format for output file (valid for -g flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *png, eps, svg*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *png*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *g*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show sampling coordinates instead of numbering in the legend (valid for -g flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use gnuplot for display  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;output to text file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, group, *name*  
    **subgroup** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery subgroup  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, subgroup, *name*  
    **raster** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output image is valid for -g (or text file for -t flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Graphics format for output file (valid for -g flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *png, eps, svg*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *png*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *g*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Show sampling coordinates instead of numbering in the legend (valid for -g flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use gnuplot for display  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;output to text file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.spectral* displays spectral response at user specified locations in
images.

## NOTES

This script requires the launch of one of the supported monitors (cairo,
png, ps) or gnuplot to be installed.

## EXAMPLE

Analysis of LANDSAT TM7 channels (North Carolina dataset):

```sh
g.region raster=lsat7_2002_10 -p
i.spectral -g raster=lsat7_2002_10,lsat7_2002_20,lsat7_2002_30,lsat7_2002_40,lsat7_2002_50,lsat7_2002_70 \
           coordinates=636069,215440,637958,223393,633277,223605
```

![Spectral plot of 3 different land cover types](i_spectral.png)  
*Spectral plot of 3 different land cover types: (1) water, (2) green
vegetation, and (3) highway*

North Carolina sample dataset:

```sh
g.region raster=lsat7_2002_10 -p
LIST=`g.list type=raster pattern="lsat7_2002_[1-5,7]0" separator=","`
d.mon start=cairo output=plot.png
i.spectral raster=$LIST coordinates=637502.25,221744.25
d.mon stop=cairo
```

This will search all LANDSAT map for 2002 but select only the B, G, R,
NIR, and MIR channels.

## SEE ALSO

*[d.where](d.where.md), [r.what](r.what.md), [Cairo
driver](cairodriver.md), [PNG driver](pngdriver.md), [PS driver
(Postscript)](psdriver.md)*

## AUTHORS

Markus Neteler  
Francesco Pirotti

## SOURCE CODE

Available at: [i.spectral source code](https://github.com/OSGeo/grass/tree/main/scripts/i.spectral)
([history](https://github.com/OSGeo/grass/commits/main/scripts/i.spectral))  
Latest change: Friday Mar 07 23:20:43 2025 in commit [b94776a](https://github.com/OSGeo/grass/commit/b94776ae711b613e98849395a1b4635336af9479)
