---
name: r.mode
description: Finds the mode of values in a cover map within areas assigned the same category value in a user-specified base map.
keywords: [ raster, statistics, algebra ]
---

# r.mode

Finds the mode of values in a cover map within areas assigned the same category value in a user-specified base map.

=== "Command line"

    **r.mode**
    **base**=*string*
    **cover**=*string*
    **output**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.mode base=string cover=string output=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.mode***",
        **base**,
        **cover**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.mode", base="string", cover="string", output="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_mode*(**base**,
        **cover**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_mode(base="string", cover="string", output="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **base**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Base map to be reclassified  
    **cover**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Coverage map  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **base** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base map to be reclassified  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **cover** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coverage map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **base** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base map to be reclassified  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **cover** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coverage map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.mode* calculates the most frequently occurring value (i. e., mode) of
data contained in a *cover* raster map layer for areas assigned the same
category value in the user-specified *base* raster map layer. These
modes are stored in the new *output* map layer.

The *output* map is actually a *reclass* of the *base* map.

The **base** parameter defines an existing raster map layer in the
user's current mapset search path. For each group of cells assigned the
same category value in the *base* map, the mode of the values assigned
these cells in the *cover* map will be computed.

The **cover** parameter defines an existing raster map layer containing
the values to be used to compute the mode within each category of the
*base* map.

## NOTES

The user should use the results of *r.mode* with care. Since this
utility assigns a value to each cell which is based on global
information (i.e., information at spatial locations other than just the
location of the cell itself), the resultant map layer is only valid if
the geographic region and mask settings are the same as they were at the
time that the result map was created.

Results are affected by the current region settings and mask.

## EXAMPLE

Mode of K-factor (erosion) for Spearfish fields:

```sh
g.region raster=fields -p
r.mode base=fields cover=soils.Kfactor output=K.by.farm.mode
r.univar K.by.farm.mode
```

## SEE ALSO

*[g.region](g.region.md), [r.category](r.category.md),
[r.clump](r.clump.md), [r.describe](r.describe.md),
[r.mapcalc](r.mapcalc.md), [r.mfilter](r.mfilter.md),
[r.neighbors](r.neighbors.md), [r.reclass](r.reclass.md),
[r.stats](r.stats.md), [r.statistics](r.statistics.md),
[r.univar](r.univar.md)*

## AUTHOR

Michael Shapiro, U.S.Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [r.mode source code](https://github.com/OSGeo/grass/tree/main/raster/r.mode)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.mode))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
