---
name: r3.in.xyz.py
description: Create a 3D raster map from an assemblage of many coordinates using univariate statistics
keywords: [ raster3d, import, voxel, LIDAR, statistics, conversion, aggregation, binning ]
---

# r3.in.xyz.py

Create a 3D raster map from an assemblage of many coordinates using univariate statistics

=== "Command line"

    **r3.in.xyz.py**
    [**-sgi**]
    **input**=*name*
    **output**=*name*
    [**method**=*string*]
    [**type**=*string*]
    [**separator**=*character*]
    [**x**=*integer*]
    [**y**=*integer*]
    [**z**=*integer*]
    [**value_column**=*integer*]
    [**vrange**=*min,max*]
    [**vscale**=*float*]
    [**percent**=*integer*]
    [**pth**=*integer*]
    [**trim**=*float*]
    [**workers**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.in.xyz.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.in.xyz.py***",
        **input**,
        **output**,
        **method**=*"mean"*,
        **type**=*"float"*,
        **separator**=*"pipe"*,
        **x**=*1*,
        **y**=*2*,
        **z**=*3*,
        **value_column**=*0*,
        **vrange**=*None*,
        **vscale**=*1.0*,
        **percent**=*100*,
        **pth**=*None*,
        **trim**=*None*,
        **workers**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.in.xyz.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_in_xyz_py*(**input**,
        **output**,
        **method**=*"mean"*,
        **type**=*"float"*,
        **separator**=*"pipe"*,
        **x**=*1*,
        **y**=*2*,
        **z**=*3*,
        **value_column**=*0*,
        **vrange**=*None*,
        **vscale**=*1.0*,
        **percent**=*100*,
        **pth**=*None*,
        **trim**=*None*,
        **workers**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_in_xyz_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;ASCII file containing input data  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistic to use for raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n, min, max, range, sum, mean, stddev, variance, coeff_var, median, percentile, skewness, trimmean*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *float, double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *float*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **x**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of x coordinates in input file (first column is 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **y**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of y coordinates in input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **z**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of z coordinates in input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **value_column**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of data values in input file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given or set to 0, the data points' z-values are used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **vrange**=*min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for value column data (min,max)  
    **vscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor to apply to value column data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **percent**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent of map to keep in memory  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **pth**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;pth percentile of the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    **trim**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Discard &lt;trim&gt; percent of the smallest and &lt;trim&gt; percent of the largest observations  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-50*  
    **workers**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes to launch  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Scan data file for extent then exit  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;In scan mode, print using shell script style  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore broken lines  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;ASCII file containing input data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, 3d-raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistic to use for raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n, min, max, range, sum, mean, stddev, variance, coeff_var, median, percentile, skewness, trimmean*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *float, double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *float*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **x** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of x coordinates in input file (first column is 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **y** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of y coordinates in input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **z** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of z coordinates in input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **value_column** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of data values in input file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given or set to 0, the data points' z-values are used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **vrange** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for value column data (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **vscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor to apply to value column data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **percent** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent of map to keep in memory  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **pth** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;pth percentile of the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    **trim** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Discard &lt;trim&gt; percent of the smallest and &lt;trim&gt; percent of the largest observations  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-50*  
    **workers** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes to launch  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *g*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Scan data file for extent then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In scan mode, print using shell script style  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore broken lines  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;ASCII file containing input data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, 3d-raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistic to use for raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n, min, max, range, sum, mean, stddev, variance, coeff_var, median, percentile, skewness, trimmean*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *float, double*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *float*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **x** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of x coordinates in input file (first column is 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **y** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of y coordinates in input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **z** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of z coordinates in input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **value_column** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column number of data values in input file  
    &nbsp;&nbsp;&nbsp;&nbsp;If not given or set to 0, the data points' z-values are used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **vrange** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for value column data (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **vscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor to apply to value column data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **percent** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percent of map to keep in memory  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **pth** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;pth percentile of the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-100*  
    **trim** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Discard &lt;trim&gt; percent of the smallest and &lt;trim&gt; percent of the largest observations  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-50*  
    **workers** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of parallel processes to launch  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-256*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *g*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Scan data file for extent then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In scan mode, print using shell script style  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore broken lines  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.in.xyz* imports sparse XYZ data from an ASCII file into a 3D raster
map (voxels). It does this by running the *r.in.xyz* module multiple
times for different z-ranges and then assembling the slices with
*r.to.rast3*.

See the [r.in.xyz](r.in.xyz.md) help page for general parameter usage
and tips.

The map is created using the rows, columns, and depths set by current
region settings. Be sure to check and adjust these with the *g.region*
module before performing the import.

You may either use the z-value as the data value for the voxel (e.g.
with the 'n' statistic), or alternately scan another column for the data
values to bin into the voxels. This alternate data column can be both
filtered by range and have a scaling factor applied to it.

## NOTES

The 2D and 3D horizontal region resolutions must match. See the EXAMPLES
section below.

Unlike *r.in.xyz*, reading from stdin and z-scaling are not possible.
Filtering by z-range is accomplished by setting the 3D region.

To enable parallel processing support, set the **workers=** option to
match the number of CPUs or CPU-cores available on your system.
Alternatively, the `WORKERS` environment variable can be set to the
number of concurrent processes desired.

Points falling exactly on a vertical bound will belong to the depth band
below them, except for points exactly on the top bound, which will
belong to the top-most slice.

The script is expected to be nearly as efficient as if it was fully
written in C.

## EXAMPLE

Using the Serpent Mound dataset. (see the [GRASS LiDAR wiki
page](https://grasswiki.osgeo.org/wiki/LIDAR))

```sh
  #scan dataset for extent:
  r3.in.xyz -s in=Serpent_Mound_Model_LAS_Data.txt out=dummy \
     x=1 y=2 z=3 separator=space

  # set the 2D and 3D regions:
  g.region n=4323641.57 s=4320942.61 w=289020.90 e=290106.02 res=1 -a
  g.region b=166 t=216 res3=1 tbres=5 -3 -p

  r3.in.xyz in=Serpent_Mound_Model_LAS_Data.txt out=serpent3D \
     method=mean x=1 y=2 z=3 separator=space type=float
```

The same, but aggregate and store backscatter strength from column 5
into voxels in instead of the z-value:

```sh
  r3.in.xyz in=Serpent_Mound_Model_LAS_Data.txt out=serpent3D.bakscat \
     method=mean x=1 y=2 z=3 val=5 separator=space type=float
```

## KNOWN ISSUES

*r.to.rast3* always creates a `double` output map regardless of input.

## SEE ALSO

*[g.region](g.region.md), [r.in.xyz](r.in.xyz.md),
[r.to.rast3](r.to.rast3.md)*

## AUTHOR

Hamish Bowman  
*Dunedin, New Zealand*

## SOURCE CODE

Available at: [r3.in.xyz source code](https://github.com/OSGeo/grass/tree/main/scripts/r3.in.xyz)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r3.in.xyz))  
Latest change: Tuesday Oct 21 09:57:14 2025 in commit [fb0165c](https://github.com/OSGeo/grass/commit/fb0165c2d021b7700528aca09c224847be871729)
