---
name: r3.out.v5d
description: Exports GRASS 3D raster map to 3-dimensional Vis5D file.
keywords: [ raster3d, export, output, voxel ]
---

# r3.out.v5d

Exports GRASS 3D raster map to 3-dimensional Vis5D file.

=== "Command line"

    **r3.out.v5d**
    [**-m**]
    **input**=*string*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.out.v5d input=string output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.out.v5d***",
        **input**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.out.v5d", input="string", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_out_v5d*(**input**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_out_v5d(input="string", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map to be converted to Vis5D (V5D) file  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for V5D output file  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use map coordinates instead of xyz coordinates  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map to be converted to Vis5D (V5D) file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for V5D output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use map coordinates instead of xyz coordinates  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map to be converted to Vis5D (V5D) file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for V5D output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use map coordinates instead of xyz coordinates  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Exports 3D raster maps to V5D format. The *map* parameter is a valid 3D
raster map in the current mapset search path. The *output* parameter is
the name of a V5D file which will be written in the current working
directory.

[Vis5D](https://vis5d.sourceforge.net/) is a system for interactive
visualization of large 5D gridded data sets such as those produced by
numerical weather models. The user can make isosurfaces, contour line
slices, colored slices, volume renderings, etc. of data in a 3D raster
map, then rotate and animate the images in real time. There's also a
feature for wind trajectory tracing, a way to make text annotations for
publications, support for interactive data analysis, etc.

## SEE ALSO

*[r3.in.v5d](r3.in.v5d.md), [r3.out.vtk](r3.out.vtk.md)*

## AUTHOR

Jaro Hofierka, GeoModel s.r.o., Slovakia

## SOURCE CODE

Available at: [r3.out.v5d source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.out.v5d)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.out.v5d))  
Latest change: Saturday Oct 25 22:50:58 2025 in commit [ee87f21](https://github.com/OSGeo/grass/commit/ee87f21833475fd40805f58d1702f7d64478a27b)
