---
name: v.category
description: Attaches, deletes or reports vector categories to/from/of map geometry.
keywords: [ vector, category, layer ]
---

# v.category

Attaches, deletes or reports vector categories to/from/of map geometry.

=== "Command line"

    **v.category**
    [**-gt**]
    **input**=*name*
    [**layer**=*string* [,*string*,...]]
    [**type**=*string* [,*string*,...]]
    [**ids**=*range*]
    [**output**=*name*]
    **option**=*string*
    [**cat**=*integer*]
    [**step**=*integer*]
    **format**=*name*
    [**separator**=*character*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.category input=name option=add format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***v.category***",
        **input**,
        **layer**=*"1"*,
        **type**=*"point,line,centroid,face"*,
        **ids**=*None*,
        **output**=*None*,
        **option**,
        **cat**=*1*,
        **step**=*1*,
        **format**=*"plain"*,
        **separator**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("v.category", input="name", option="add", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_category*(**input**,
        **layer**=*"1"*,
        **type**=*"point,line,centroid,face"*,
        **ids**=*None*,
        **output**=*None*,
        **option**,
        **cat**=*1*,
        **step**=*1*,
        **format**=*"plain"*,
        **separator**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_category(input="name", option="add", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,centroid,face*  
    **ids**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature ids (by default all features are processed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **option**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Action to be done  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *add, del, chlayer, sum, report, print, layers, transfer*  
    &nbsp;&nbsp;&nbsp;&nbsp;**add**: add a category to features without category in the given layer  
    &nbsp;&nbsp;&nbsp;&nbsp;**del**: delete category (cat=-1 to delete all categories of given layer)  
    &nbsp;&nbsp;&nbsp;&nbsp;**chlayer**: change layer number (e.g. layer=3,1 changes layer 3 to layer 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: add the value specified by cat option to the current category value  
    &nbsp;&nbsp;&nbsp;&nbsp;**report**: print report (statistics), in CSV style: layer type count min max  
    &nbsp;&nbsp;&nbsp;&nbsp;**print**: print category values, layers are separated by '|', more cats in the same layer are separated by '/'  
    &nbsp;&nbsp;&nbsp;&nbsp;**layers**: print only layer numbers  
    &nbsp;&nbsp;&nbsp;&nbsp;**transfer**: copy values from one layer to another (e.g. layer=1,2,3 copies values from layer 1 to layer 2 and 3)  
    **cat**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **step**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category increment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;CSV style output, currently only for report [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: layer type count min max. This flag is deprecated and will be removed in a future release. Use format=csv instead.  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not copy attribute table(s)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,centroid,face*  
    **ids** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature ids (by default all features are processed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *range*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **option** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Action to be done  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *add, del, chlayer, sum, report, print, layers, transfer*  
    &nbsp;&nbsp;&nbsp;&nbsp;**add**: add a category to features without category in the given layer  
    &nbsp;&nbsp;&nbsp;&nbsp;**del**: delete category (cat=-1 to delete all categories of given layer)  
    &nbsp;&nbsp;&nbsp;&nbsp;**chlayer**: change layer number (e.g. layer=3,1 changes layer 3 to layer 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: add the value specified by cat option to the current category value  
    &nbsp;&nbsp;&nbsp;&nbsp;**report**: print report (statistics), in CSV style: layer type count min max  
    &nbsp;&nbsp;&nbsp;&nbsp;**print**: print category values, layers are separated by '|', more cats in the same layer are separated by '/'  
    &nbsp;&nbsp;&nbsp;&nbsp;**layers**: print only layer numbers  
    &nbsp;&nbsp;&nbsp;&nbsp;**transfer**: copy values from one layer to another (e.g. layer=1,2,3 copies values from layer 1 to layer 2 and 3)  
    **cat** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category increment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;CSV style output, currently only for report [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Format: layer type count min max. This flag is deprecated and will be removed in a future release. Use format=csv instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not copy attribute table(s)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,centroid,face*  
    **ids** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature ids (by default all features are processed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *range*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **option** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Action to be done  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *add, del, chlayer, sum, report, print, layers, transfer*  
    &nbsp;&nbsp;&nbsp;&nbsp;**add**: add a category to features without category in the given layer  
    &nbsp;&nbsp;&nbsp;&nbsp;**del**: delete category (cat=-1 to delete all categories of given layer)  
    &nbsp;&nbsp;&nbsp;&nbsp;**chlayer**: change layer number (e.g. layer=3,1 changes layer 3 to layer 1)  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: add the value specified by cat option to the current category value  
    &nbsp;&nbsp;&nbsp;&nbsp;**report**: print report (statistics), in CSV style: layer type count min max  
    &nbsp;&nbsp;&nbsp;&nbsp;**print**: print category values, layers are separated by '|', more cats in the same layer are separated by '/'  
    &nbsp;&nbsp;&nbsp;&nbsp;**layers**: print only layer numbers  
    &nbsp;&nbsp;&nbsp;&nbsp;**transfer**: copy values from one layer to another (e.g. layer=1,2,3 copies values from layer 1 to layer 2 and 3)  
    **cat** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category increment  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Human readable text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;CSV style output, currently only for report [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Format: layer type count min max. This flag is deprecated and will be removed in a future release. Use format=csv instead.  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not copy attribute table(s)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.category* attaches, copies, deletes or reports categories to/from/of
vector geometry objects. Further on, *v.category* adds a number given by
the *cat* option to categories of the selected layer. These categories
(IDs) are used to assign IDs or to group geometry objects into
categories (several different geometry objects share the same category).
These categories are also used to link geometry object(s) to attribute
records (from an attribute table linked to vector map).

## NOTES

Use *[v.to.db](v.to.db.md)* to upload related categories to a linked
attribute table.

The **type** parameter specifies the type of geometry objects to which
the category is added; it is similar to an input filter - only the
geometry specified in 'type' is processed.

If the **type** parameter is set to **centroid** and the **option**
parameter set to **add**, new categories will be added to existing
centroids. Note however, that new centroids cannot be created this way.
To do so, they must be added manually using *[wxGUI vector
digitizer](wxGUI.vdigit.md)* or by running *v.category* with the type
parameter set to area.

If categories are copied with *option=transfer*, a warning is issued if
categories already exit in the layer they are copied to. In this case
the user must make sure beforehand that copying categories from one
layer to another layer does not cause undesired grouping of different
geometry objects into the same categories. This can be avoided by
specifying only one *layer*. The module will then find the next free
layer number and copy categories to there. The new layer number is
reported at the end.

Areas are a special case because it is impossible to attach a cat to an
area without a centroid; in this case, the module places new centroids
in areas automatically for **type=area**.

The **cat** parameter is only used with **option**=*add*,
**option**=*sum* and **option**=*del*.

Categories can be deleted for the given layer with *option=del*. If
**cat** is set to *-1*, all categories for the given layer are deleted.
If **cat** is zero or positive, only this category value will be
deleted. By default, **cat** is set to *1* which means that only
categories of value *1* will be deleted.

With **option=report**, the module reports for each layer and type the
total number of categories, the minimum and the maximum category number.
If there are e.g. two lines with line 1 having category 1 and line 1
having categories 1 and 2, then there are a total of three category
values with minimum 1 and maximum 2.

The **ids** parameter specifies the list of feature IDs to which the
operation is performed; by default, all vector feature ids are
processed. The *feature ID* is an internal (unique) geometry ID that all
vector primitives possess, and is separate from any category the feature
may also possess. Use

```sh
  v.edit map=inputname tool=select
```

to find out the geometry ids of certain features.

## EXAMPLES

### Report vector categories

```sh
v.category input=testmap option=report

LAYER/TABLE 1/testmap:
type       count        min        max
point          0          0          0
line        1379          1       1379
boundary       0          0          0
centroid       0          0          0
area           0          0          0
all         1379          1       1379
```

Report vector categories in JSON format:

```sh
v.category input=testmap option=report format=json

[
  {
      "type": "line",
      "layer": 1,
      "count": 1379,
      "min": 1,
      "max": 1379
  },
  {
      "type": "all",
      "layer": 1,
      "count": 1379,
      "min": 1,
      "max": 1379
  }
]
```

### Delete all vector categories in layer 1

```sh
v.category input=testmap output=outmap option=del cat=-1
```

### Add vector categories in layer 1 with step=2

```sh
v.category input=outmap output=stepmap option=add step=2

# report
v.category input=stepmap option=report
LAYER/TABLE 1/outmap:
type       count        min        max
point          0          0          0
line        1379          1       2757
boundary       0          0          0
centroid       0          0          0
area           0          0          0
all         1379          1       2757
```

### Add categories/centroids to a vector map without categories

```sh
v.category input=wkt output=wktnew option=add
```

Results can be tested using *[d.what.vect](d.what.vect.md)*.

### Copy categories from layer 1 to layer 2,3,4,5,6,7 and 8

Existing layer will be overwritten, non-existing will be created.

```sh
v.category input=observer output=observer_new option=transfer layer=1,2,3,4,5,6,7,8
```

### Print vector categories of given layer

Print vector categories from the first layer, only for feature ids 1-50.

```sh
v.category input=roads option=print layer=1 id=1-50
```

Print vector categories from the first layer, only for feature ids 1-50 in JSON format.

```sh
v.category input=roads option=print layer=1 id=1-50 format=json
```

### Print only layer numbers in JSON format

```sh
v.category input=roads option=layers format=json
```

### Using v.category JSON output with pandas

Using report option in JSON format with pandas:

```python
import grass.script as gs
import pandas as pd

# Run v.category command with report option.
data = gs.parse_command(
    "v.category",
    input="bridges",
    option="report",
    format="json",
)

df = pd.DataFrame(data)
print(df)
```

```sh
    type  layer  count  min    max
0  point      1  10938    1  10938
1    all      1  10938    1  10938
```

Using print option with the first layer, only for feature ids 1-5 in JSON
format with pandas:

```python
import grass.script as gs
import pandas as pd

# Run v.category command with print option.
data = gs.parse_command(
    "v.category",
    input="bridges",
    option="print",
    ids="1-5",
    format="json",
)

df = pd.DataFrame(data)
print(df)
```

```sh
    id  layer  category
0   1      1         1
1   2      1         2
2   3      1         3
3   4      1         4
4   5      1         5
```

## SEE ALSO

*[v.centroids](v.centroids.md), [v.db.connect](v.db.connect.md),
[v.edit](v.edit.md), [v.to.db](v.to.db.md)*

## AUTHOR

Radim Blazek, ITC-irst, Trento, Italy  
Modified (the id parameter) by Martin Landa, FBK-irst (formerly
ITC-irst), Trento, Italy, 2008/02

## SOURCE CODE

Available at: [v.category source code](https://github.com/OSGeo/grass/tree/main/vector/v.category)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.category))  
Latest change: Thursday Oct 02 14:39:13 2025 in commit [1850489](https://github.com/OSGeo/grass/commit/1850489bf42c72d8dcfe2e4db1738441b4a7dc43)
