---
name: v.to.points
description: Creates points along input lines in new vector map with 2 layers.
keywords: [ vector, geometry, 3D, line, node, vertex, point ]
---

# v.to.points

Creates points along input lines in new vector map with 2 layers.

=== "Command line"

    **v.to.points**
    [**-iprt**]
    **input**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    **output**=*name*
    [**use**=*string*]
    [**dmax**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.to.points input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.to.points***",
        **input**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid,face"*,
        **output**,
        **use**=*None*,
        **dmax**=*100*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.to.points", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_to_points*(**input**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid,face"*,
        **output**,
        **use**=*None*,
        **dmax**=*100*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_to_points(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,face*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **use**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Use line nodes (start/end) or vertices only  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *node, start, end, vertex*  
    **dmax**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance between points in map units or percentage with -p  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Interpolate points between line vertices (only for use=vertex)  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use dmax as percentage of line length  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Start from the end node  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,face*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **use** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Use line nodes (start/end) or vertices only  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *node, start, end, vertex*  
    **dmax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance between points in map units or percentage with -p  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *p*, *r*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Interpolate points between line vertices (only for use=vertex)  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use dmax as percentage of line length  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Start from the end node  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,face*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **use** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Use line nodes (start/end) or vertices only  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *node, start, end, vertex*  
    **dmax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance between points in map units or percentage with -p  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *p*, *r*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Interpolate points between line vertices (only for use=vertex)  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use dmax as percentage of line length  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Start from the end node  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.to.points* creates points along input 2D or 3D lines, boundaries and
faces. Point features including centroids and kernels are copied from
input vector map to the output. For details see notes about **type**
parameter.

The output is a vector map with 2 layers. Layer 1 holds the category of
the input features; all points created along the same line have the same
category, equal to the category of that line. In layer 2 each point has
its unique category; other attributes stored in layer 2 are *lcat* - the
category of the input line and *along* - the distance from line's start.

By default only features with category are processed, see **layer**
parameter for details.

## NOTES

The **dmax** parameter is the maximum limit but not an exact distance.
To place points with exact distance from the beginning of the vector
line the user should use *[v.segment](v.segment.md)*.

Set **layer** to -1 to process features from all layers including
features without category. Features will be assigned new unique
categories at layer 1. Option **layer=-1** should be used to convert
boundaries, as in most of cases boundaries lack category values.

The **type** parameter is used to control which input vector geometry
types to convert into points. Some caveats to consider about this
parameter:

- Points and centroids can be considered as "lines" with only one node.
  Consequently, the result of selecting *point* or *centroid* as the
  type parameter is that all points/centroids get written into the
  output vector map. The original category numbers of the input
  points/centroids get written to the '*lcat*' attribute in layer 2 of
  the output vector map. All values for *along* are zero in the output
  vector map, as only point geometry was used for input (there is no
  linear distance to calculate *along*, as each point/centroid is the
  start *and* end of its own "line").
- Boundaries are treated as lines, with points getting interpolated
  along the boundary perimeter according to **dmax**. If two adjoining
  polygons share a topological boundary, the boundary only gets
  converted to points once.
- If the **type** parameter is set to *area*, the boundary of each area
  is converted to points *regardless* of whether or not there is a
  topological boundary between adjacent areas. In other words, the
  common boundary of two adjoining areas, for example, gets converted to
  points twice. The centroid is not converted to a point in the output
  vector for *type=area*.

The **use=vertex** option is used to digitize points that fall on the
line's vertices *only*. Parameter **dmax** is ignored in this case.
Similarly to **use=node** when only line's node are used. To filter only
starting/ending nodes use **use=start/end**.

If the **-i** flag is used in conjunction with the **use=vertex**
option, *v.to.points* will digitize points on the line vertices, as well
as interpolate points between line vertices using **dmax** as the
maximum allowable spacing.

Use the **-p** flag to treat **dmax** as a percentage of each line
length. For example, to get points created for the beginning, middle and
end only, use the **-p** flag and set **dmax** so that:

```sh
 50 < dmax <= 100
```

Hence, if **dmax** is between 0.5x and 1.0x the line length, you will
always get points created at exactly the beginning, middle and end of
the input line.

Use the **-r** flag to create points starting from the end node.

## EXAMPLES

### Points along the input lines

In this example, the 'railroads' vector lines map of the North Carolina
sample dataset is used to create points along the input lines:

```sh
# The North Carolina data are metric.
# 200m distance for points (maximum limit but not an exact distance)
v.to.points input=railroads output=railroads_points dmax=200

# verify the two layers in the resulting map
v.category input=railroads_points option=report

# vector info
v.info map=railroads_points
```

### Extract nodes as points

```sh
v.to.points input=railroads output=railroads_nodes use=node
```

### Extract starting/ending nodes as points

```sh
v.to.points input=railroads output=railroads_start use=start

v.to.points input=railroads output=railroads_end use=end
```

## SEE ALSO

*[v.segment](v.segment.md), [v.split](v.split.md),
[v.to.rast](v.to.rast.md), [v.to.db](v.to.db.md)*

## AUTHORS

Radim Blazek  
Updated to GRASS 7 by Martin Landa, Czech Technical University in
Prague, Czech Republic

## SOURCE CODE

Available at: [v.to.points source code](https://github.com/OSGeo/grass/tree/main/vector/v.to.points)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.to.points))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
