---
name: r.to.rast3elev
description: Creates a 3D volume map based on 2D elevation and value raster maps.
keywords: [ raster, conversion, raster3d, voxel ]
---

# r.to.rast3elev

Creates a 3D volume map based on 2D elevation and value raster maps.

=== "Command line"

    **r.to.rast3elev**
    [**-ulm**]
    **input**=*name* [,*name*,...]
    **elevation**=*name* [,*name*,...]
    **output**=*name*
    [**upper**=*float*]
    [**lower**=*float*]
    [**tilesize**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.to.rast3elev input=name elevation=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.to.rast3elev***",
        **input**,
        **elevation**,
        **output**,
        **upper**=*None*,
        **lower**=*None*,
        **tilesize**=*32*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.to.rast3elev", input="name", elevation="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_to_rast3elev*(**input**,
        **elevation**,
        **output**,
        **upper**=*None*,
        **lower**=*None*,
        **tilesize**=*32*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_to_rast3elev(input="name", elevation="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    **elevation**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map(s)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **upper**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to fill the upper cells, default is null  
    **lower**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to fill the lower cells, default is null  
    **tilesize**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum tile size in kilo bytes. Default is 32KB.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use the input map values to fill the upper cells  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use the input map values to fill the lower cells  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **upper** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to fill the upper cells, default is null  
    **lower** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to fill the lower cells, default is null  
    **tilesize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum tile size in kilo bytes. Default is 32KB.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *u*, *l*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the input map values to fill the upper cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the input map values to fill the lower cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **upper** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to fill the upper cells, default is null  
    **lower** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to fill the lower cells, default is null  
    **tilesize** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum tile size in kilo bytes. Default is 32KB.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *u*, *l*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the input map values to fill the upper cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the input map values to fill the lower cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.to.rast3elev* creates a 3D volume map based on 2D elevation and value
raster maps. If the 2d and 3d region settings are different, the 2d
resolution will be adjust to the 3d resolution.

![How r.to.rast3elev works](r.to.rast3elev.png)  
*How r.to.rast3elev works*

## NOTES

The height of the 2D elevation maps will be used to verify the position
within the 3D region. If the cell value of the elevation raster maps is
located within the 3D region, the cell value of the appropriate 2D input
raster maps will be written to the associated 3D cell. There are flags
and options to fill the upper and lower 3D cells with a specific value,
or the input raster maps values.

## EXAMPLES

Simple Spearfish sample data set example

```sh
g.region raster=elevation.10m -p
g.region res=200 res3=200 t=2000 b=0 tbres=20 -p

# Write the values of raster map soils based on the elevation of elevation.10m
# to the 3D map volev

r.to.rast3elev in=soils elev=elevation.10m out=volev

# Write the values of map soils based on the elevation of elevation.10m
# to the 3D map volev_l and fill the lower cells with the soils map values

r.to.rast3elev in=soils elev=elevation.10m out=volev_l -l

# Write the values of map soils based on the elevation of elevation.10m
# to the 3D map volev_u and fill the upper cells with the soils map values

r.to.rast3elev in=soils elev=elevation.10m out=volev_u -u

# Example with multiple elevation maps.
## first we need three support maps

r.mapcalc expression="one = 1"
r.mapcalc expression="two = 2"
r.mapcalc expression="three = 3"

## Now we generate the new evelation maps

r.mapcalc expression="elev_mid = elevation.10m - 500"
r.mapcalc expression="elev_bottom = elevation.10m - 1000"

## Now fill the lower cells below the elevation maps with the values one, two and three

r.to.rast3elev -l input=one,two,three elevation=elevation.10m,elev_mid,elev_bottom output=threelayer

## Export the map for visualization with paraview (https://www.paraview.org)
## By default the null value is -9999.99, we adjust it to 0.0 for
## better visualization
r3.out.vtk null=0.0 input=threelayer output=/tmp/threelayer.vtk

# Start paraview

paraview --data=/tmp/threelayer.vtk

# Note: First you need to choose the surface representation style and
# then color by "threelayer" in paraview.
```

## SEE ALSO

*[r.to.rast3](r.to.rast3.md), [r3.cross.rast](r3.cross.rast.md),
[g.region](g.region.md)*

## AUTHOR

Soeren Gebbert

## SOURCE CODE

Available at: [r.to.rast3elev source code](https://github.com/OSGeo/grass/tree/main/raster/r.to.rast3elev)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.to.rast3elev))  
Latest change: Tuesday Feb 18 17:20:26 2025 in commit [688e625](https://github.com/OSGeo/grass/commit/688e625e7db3be9a465ce99ba25f36d2ebdd5aeb)
