---
hide:
  - toc
---

# Topic: statistics

| Tool | Description |
|--------|-------------|
| [d.correlate](d.correlate.md) | Prints a graph of the correlation between raster maps (in pairs). |
| [db.univar](db.univar.md) | Calculates univariate statistics on selected table column. |
| [i.cca](i.cca.md) | Canonical components analysis (CCA) program for image processing. |
| [r.clump](r.clump.md) | Recategorizes data in a raster map by grouping cells that form physically discrete areas into unique categories. |
| [r.coin](r.coin.md) | Tabulates the mutual occurrence (coincidence) of categories for two raster map layers. |
| [r.covar](r.covar.md) | Outputs a covariance/correlation matrix for user-specified raster map layer(s). |
| [r.cross](r.cross.md) | Creates a cross product of the category values from multiple raster map layers. |
| [r.kappa](r.kappa.md) | Calculates error matrix and kappa parameter for accuracy assessment of classification result. |
| [r.mode](r.mode.md) | Finds the mode of values in a cover map within areas assigned the same category value in a user-specified base map. |
| [r.object.geometry](r.object.geometry.md) | Calculates geometry parameters for raster objects. |
| [r.quant](r.quant.md) | Produces the quantization file for a floating-point map. |
| [r.reclass.area](r.reclass.area.md) | Reclasses a raster map greater or less than user specified area size (in hectares). |
| [r.regression.line](r.regression.line.md) | Calculates linear regression from two raster maps: y = a + b*x. |
| [r.regression.multi](r.regression.multi.md) | Calculates multiple linear regression from raster maps. |
| [r.report](r.report.md) | Reports statistics for raster maps. |
| [r.statistics](r.statistics.md) | Calculates category or object oriented statistics. |
| [r.stats](r.stats.md) | Generates area statistics for raster map. |
| [r.stats.quantile](r.stats.quantile.md) | Compute category quantiles using two passes. |
| [r.stats.zonal](r.stats.zonal.md) | Calculates category or object oriented statistics (accumulator-based statistics). |
| [r.support.stats](r.support.stats.md) | Update raster map statistics |
| [r.univar](r.univar.md) | Calculates univariate statistics from the non-null cells of a raster map. Statistics include number of cells counted, minimum and maximum cell values, range, arithmetic mean, population variance, standard deviation, coefficient of variation, and sum. |
| [r3.stats](r3.stats.md) | Generates volume statistics for 3D raster maps. |
| [r3.univar](r3.univar.md) | Calculates univariate statistics from the non-null cells of a 3D raster map. Statistics include number of cells counted, minimum and maximum cell values, range, arithmetic mean, population variance, standard deviation, coefficient of variation, and sum. |
| [t.rast.univar](t.rast.univar.md) | Calculates univariate statistics from the non-null cells for each registered raster map of a space time raster dataset. |
| [t.rast3d.univar](t.rast3d.univar.md) | Calculates univariate statistics from the non-null cells for each registered 3D raster map of a space time 3D raster dataset. |
| [t.vect.univar](t.vect.univar.md) | Calculates univariate statistics of attributes for each registered vector map of a space time vector dataset |
| [v.db.univar](v.db.univar.md) | Calculates univariate statistics on selected table column for a GRASS vector map. |
| [v.kcv](v.kcv.md) | Randomly partition points into test/train sets. |
| [v.normal](v.normal.md) | Tests for normality for vector points. |
| [v.outlier](v.outlier.md) | Removes outliers from vector point data. |
| [v.qcount](v.qcount.md) | Indices for quadrat counts of vector point lists. |
| [v.rast.stats](v.rast.stats.md) | Calculates univariate statistics from a raster map based on a vector map and uploads statistics to new attribute columns. |
| [v.univar](v.univar.md) | Calculates univariate statistics of vector map features. Variance and standard deviation is calculated only for points if specified. |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [statistics] } -->
