---
name: v.kernel
description: Generates a raster density map from vector points map. Density is computed using a moving kernel. Optionally generates a vector density map on a vector network.
keywords: [ vector, kernel density, point density, heatmap, hotspot ]
---

# v.kernel

Generates a raster density map from vector points map.

Density is computed using a moving kernel. Optionally generates a vector density map on a vector network.

=== "Command line"

    **v.kernel**
    [**-oqnm**]
    **input**=*name*
    [**net**=*name*]
    [**output**=*name*]
    [**net_output**=*name*]
    **radius**=*float*
    [**dsize**=*float*]
    [**segmax**=*float*]
    [**distmax**=*float*]
    [**multiplier**=*float*]
    [**node**=*string*]
    [**kernel**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.kernel input=name output=name radius=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.kernel***",
        **input**,
        **net**=*None*,
        **output**=*None*,
        **net_output**=*None*,
        **radius**,
        **dsize**=*0.*,
        **segmax**=*100.*,
        **distmax**=*100.*,
        **multiplier**=*1.*,
        **node**=*"none"*,
        **kernel**=*"gaussian"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.kernel", input="name", output="name", radius=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_kernel*(**input**,
        **net**=*None*,
        **output**=*None*,
        **net_output**=*None*,
        **radius**,
        **dsize**=*0.*,
        **segmax**=*100.*,
        **distmax**=*100.*,
        **multiplier**=*1.*,
        **node**=*"none"*,
        **kernel**=*"gaussian"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_kernel(input="name", output="name", radius=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map with training points  
    **net**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input network vector map  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **net_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector density map  
    &nbsp;&nbsp;&nbsp;&nbsp;Outputs vector map if network map is given  
    **radius**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Kernel radius in map units  
    **dsize**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Discretization error in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.*  
    **segmax**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum length of segment on network  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **distmax**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance from point to network  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **multiplier**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiply the density result by this number  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.*  
    **node**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Node method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, split*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    &nbsp;&nbsp;&nbsp;&nbsp;**none**: No method applied at nodes with more than 2 arcs  
    &nbsp;&nbsp;&nbsp;&nbsp;**split**: Equal split (Okabe 2009) applied at nodes  
    **kernel**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kernel function  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *uniform, triangular, epanechnikov, quartic, triweight, gaussian, cosine*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gaussian*  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Try to calculate an optimal radius with given 'radius' taken as maximum (experimental)  
    **-q**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only calculate optimal radius and exit (no map is written)  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;In network mode, normalize values by sum of density multiplied by length of each segment. Integral over the output map then gives 1.0 \* multiplier  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;In network mode, multiply the result by number of input points  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map with training points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **net** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input network vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **net_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector density map  
    &nbsp;&nbsp;&nbsp;&nbsp;Outputs vector map if network map is given  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **radius** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kernel radius in map units  
    **dsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Discretization error in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.*  
    **segmax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum length of segment on network  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **distmax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance from point to network  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **multiplier** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiply the density result by this number  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.*  
    **node** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Node method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, split*  
    &nbsp;&nbsp;&nbsp;&nbsp;**none**: No method applied at nodes with more than 2 arcs  
    &nbsp;&nbsp;&nbsp;&nbsp;**split**: Equal split (Okabe 2009) applied at nodes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **kernel** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kernel function  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *uniform, triangular, epanechnikov, quartic, triweight, gaussian, cosine*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gaussian*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *q*, *n*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Try to calculate an optimal radius with given 'radius' taken as maximum (experimental)  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only calculate optimal radius and exit (no map is written)  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In network mode, normalize values by sum of density multiplied by length of each segment. Integral over the output map then gives 1.0 \* multiplier  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In network mode, multiply the result by number of input points  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map with training points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **net** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input network vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **net_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector density map  
    &nbsp;&nbsp;&nbsp;&nbsp;Outputs vector map if network map is given  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **radius** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kernel radius in map units  
    **dsize** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Discretization error in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.*  
    **segmax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum length of segment on network  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **distmax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance from point to network  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100.*  
    **multiplier** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiply the density result by this number  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.*  
    **node** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Node method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, split*  
    &nbsp;&nbsp;&nbsp;&nbsp;**none**: No method applied at nodes with more than 2 arcs  
    &nbsp;&nbsp;&nbsp;&nbsp;**split**: Equal split (Okabe 2009) applied at nodes  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **kernel** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kernel function  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *uniform, triangular, epanechnikov, quartic, triweight, gaussian, cosine*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gaussian*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *q*, *n*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Try to calculate an optimal radius with given 'radius' taken as maximum (experimental)  
    &nbsp;&nbsp;&nbsp;&nbsp;**q**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only calculate optimal radius and exit (no map is written)  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In network mode, normalize values by sum of density multiplied by length of each segment. Integral over the output map then gives 1.0 \* multiplier  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In network mode, multiply the result by number of input points  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.kernel* generates a raster density map from vector points data using
a moving kernel. Available [kernel density
functions](https://en.wikipedia.org/wiki/Kernel_(statistics)#Kernel_functions_in_common_use)
are *uniform, triangular, epanechnikov, quartic, triweight, gaussian,
cosine*. The default function is *gaussian*.

The module can also generate a vector density map on a vector network.
Conventional kernel functions produce biased estimates by overestimating
the densities around network nodes, whereas the equal split method of
Okabe et al. (2009) produces unbiased density estimates. The equal split
method uses the kernel function selected with the **kernel** option and
can be enabled with **node=split**.

## NOTES

The **multiplier** option is needed to overcome the limitation that the
resulting density in case of a vector map output is stored as category
(integer). The density result stored as category may be multiplied by
this number.

For the *gaussian* kernel, standard deviation for the [gaussian
function](https://en.wikipedia.org/wiki/Kernel_(statistics)#Kernel_functions_in_common_use)
is set to 1/4 of the radius.

With the **-o** flag (experimental) the command tries to calculate an
optimal radius. The value of *radius* is taken as maximum value. The
radius is calculated based on the gaussian function, using ALL points,
not just those in the current region.

## EXAMPLES

Compute density of points (using vector map of schools from North
Carolina sample dataset):

```sh
g.region region=wake_30m
v.kernel input=schools_wake output=schools_density radius=5000 multiplier=1000000
r.colors map=schools_density color=bcyr
```

![Density of schools](v_kernel.png)  
*School density*

## KNOWN ISSUES

The module only considers the presence of points, but not (yet) any
attribute values.

## REFERENCES

- Okabe, A., Satoh, T., Sugihara, K. (2009). *A kernel density
  estimation method for networks, its computational method and a
  GIS-based tool*. **International Journal of Geographical Information
  Science**, Vol 23(1), pp. 7-32.  
  DOI:
  [10.1080/13658810802475491](https://doi.org/10.1080/13658810802475491)

## SEE ALSO

*[v.surf.rst](v.surf.rst.md)*

Overview: [Interpolation and
Resampling](https://grasswiki.osgeo.org/wiki/Interpolation) in GRASS

## AUTHORS

Stefano Menegon, [ITC-irst](http://mpa.itc.it/), Trento, Italy  
Radim Blazek (additional kernel density functions and network part)

## SOURCE CODE

Available at: [v.kernel source code](https://github.com/OSGeo/grass/tree/main/vector/v.kernel)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.kernel))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
