---
name: v.out.ogr
description: Exports a vector map layer to any of the supported OGR vector formats. By default a vector map layer is exported to OGC GeoPackage format.
keywords: [ vector, export, output, OGR ]
---

# v.out.ogr

Exports a vector map layer to any of the supported OGR vector formats.

By default a vector map layer is exported to OGC GeoPackage format.

=== "Command line"

    **v.out.ogr**
    [**-uasce2mnl**]
    **input**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    **output**=*name*
    **format**=*string*
    [**output_layer**=*string*]
    [**output_type**=*string* [,*string*,...]]
    [**dsco**=*string* [,*string*,...]]
    [**lco**=*string* [,*string*,...]]
    [**method**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.out.ogr input=name output=name format=GPKG
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.out.ogr***",
        **input**,
        **layer**=*"1"*,
        **type**=*"auto"*,
        **output**,
        **format**=*"GPKG"*,
        **output_layer**=*None*,
        **output_type**=*""*,
        **dsco**=*""*,
        **lco**=*""*,
        **method**=*"fast"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.out.ogr", input="name", output="name", format="GPKG")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_out_ogr*(**input**,
        **layer**=*"1"*,
        **type**=*"auto"*,
        **output**,
        **format**=*"GPKG"*,
        **output_layer**=*None*,
        **output_type**=*""*,
        **dsco**=*""*,
        **lco**=*""*,
        **method**=*"fast"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_out_ogr(input="name", output="name", format="GPKG")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map to export  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Combination of types is not supported by all output formats. Default is to use first type found in input vector map.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel, auto*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *auto*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output OGR datasource  
    &nbsp;&nbsp;&nbsp;&nbsp;For example: ESRI Shapefile: filename or directory for storage\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: connection string  
    **format**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Data format to write  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *AmigoCloud, Arrow, CSV, Carto, DGN, DXF, ESRI_Shapefile, Elasticsearch, FlatGeobuf, GML, GMLAS, GPKG, GPSBabel, GPX, GeoJSON, GeoJSONSeq, GeoRSS, JML, JP2OpenJPEG, JSONFG, KML, LIBKML, MBTiles, MEM, MVT, MapInfo_File, MapML, MiraMonVector, MySQL, NGW, ODS, OGR_GMT, OpenFileGDB, PCIDSK, PDF, PDS4, PGDUMP, PMTiles, Parquet, PostgreSQL, S57, SQLite, Selafin, VDV, VICAR, WAsP, XLSX, netCDF*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GPKG*  
    **output_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output OGR layer. If not specified, input name is used  
    &nbsp;&nbsp;&nbsp;&nbsp;For example: ESRI Shapefile: shapefile name\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: table name  
    **output_type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Optionally change default output type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;**line**: export area boundaries as linestrings  
    &nbsp;&nbsp;&nbsp;&nbsp;**boundary**: export lines as polygons  
    **dsco**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR dataset creation option (format specific, NAME=VALUE)  
    **lco**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR layer creation option (format specific, NAME=VALUE)  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method to use for export, default is fast export, use slow export in case of problems with the fast method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *fast, slow*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fast*  
    &nbsp;&nbsp;&nbsp;&nbsp;**fast**: new, faster method  
    &nbsp;&nbsp;&nbsp;&nbsp;**slow**: old, slower method  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Open an existing OGR datasource for update  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Append to existing layer  
    &nbsp;&nbsp;&nbsp;&nbsp;A new OGR layer is created if it does not exist  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Skip export of GRASS category ID ('cat') attribute  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Also export features without category (not labeled). Otherwise only features with category are exported.  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use ESRI-style .prj file format (applies to Shapefile output only)  
    **-2**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force 2D output even if input is 3D (applies to Shapefile output only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Useful if input is 3D but all z coordinates are identical  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Export vector data as multi-features  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a new empty layer in defined OGR datasource and exit. Nothing is read from input.  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List supported output formats and exit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map to export  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Combination of types is not supported by all output formats. Default is to use first type found in input vector map.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel, auto*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *auto*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output OGR datasource  
    &nbsp;&nbsp;&nbsp;&nbsp;For example: ESRI Shapefile: filename or directory for storage\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: connection string  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data format to write  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *AmigoCloud, Arrow, CSV, Carto, DGN, DXF, ESRI_Shapefile, Elasticsearch, FlatGeobuf, GML, GMLAS, GPKG, GPSBabel, GPX, GeoJSON, GeoJSONSeq, GeoRSS, JML, JP2OpenJPEG, JSONFG, KML, LIBKML, MBTiles, MEM, MVT, MapInfo_File, MapML, MiraMonVector, MySQL, NGW, ODS, OGR_GMT, OpenFileGDB, PCIDSK, PDF, PDS4, PGDUMP, PMTiles, Parquet, PostgreSQL, S57, SQLite, Selafin, VDV, VICAR, WAsP, XLSX, netCDF*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GPKG*  
    **output_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output OGR layer. If not specified, input name is used  
    &nbsp;&nbsp;&nbsp;&nbsp;For example: ESRI Shapefile: shapefile name\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: table name  
    **output_type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optionally change default output type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;**line**: export area boundaries as linestrings  
    &nbsp;&nbsp;&nbsp;&nbsp;**boundary**: export lines as polygons  
    **dsco** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR dataset creation option (format specific, NAME=VALUE)  
    **lco** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR layer creation option (format specific, NAME=VALUE)  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method to use for export, default is fast export, use slow export in case of problems with the fast method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *fast, slow*  
    &nbsp;&nbsp;&nbsp;&nbsp;**fast**: new, faster method  
    &nbsp;&nbsp;&nbsp;&nbsp;**slow**: old, slower method  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fast*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *u*, *a*, *s*, *c*, *e*, *2*, *m*, *n*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Open an existing OGR datasource for update  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Append to existing layer  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;A new OGR layer is created if it does not exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Skip export of GRASS category ID ('cat') attribute  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also export features without category (not labeled). Otherwise only features with category are exported.  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use ESRI-style .prj file format (applies to Shapefile output only)  
    &nbsp;&nbsp;&nbsp;&nbsp;**2**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force 2D output even if input is 3D (applies to Shapefile output only)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Useful if input is 3D but all z coordinates are identical  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export vector data as multi-features  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a new empty layer in defined OGR datasource and exit. Nothing is read from input.  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported output formats and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map to export  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Combination of types is not supported by all output formats. Default is to use first type found in input vector map.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face, kernel, auto*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *auto*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output OGR datasource  
    &nbsp;&nbsp;&nbsp;&nbsp;For example: ESRI Shapefile: filename or directory for storage\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: connection string  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data format to write  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *AmigoCloud, Arrow, CSV, Carto, DGN, DXF, ESRI_Shapefile, Elasticsearch, FlatGeobuf, GML, GMLAS, GPKG, GPSBabel, GPX, GeoJSON, GeoJSONSeq, GeoRSS, JML, JP2OpenJPEG, JSONFG, KML, LIBKML, MBTiles, MEM, MVT, MapInfo_File, MapML, MiraMonVector, MySQL, NGW, ODS, OGR_GMT, OpenFileGDB, PCIDSK, PDF, PDS4, PGDUMP, PMTiles, Parquet, PostgreSQL, S57, SQLite, Selafin, VDV, VICAR, WAsP, XLSX, netCDF*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GPKG*  
    **output_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output OGR layer. If not specified, input name is used  
    &nbsp;&nbsp;&nbsp;&nbsp;For example: ESRI Shapefile: shapefile name\
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;PostGIS database: table name  
    **output_type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optionally change default output type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *line, boundary*  
    &nbsp;&nbsp;&nbsp;&nbsp;**line**: export area boundaries as linestrings  
    &nbsp;&nbsp;&nbsp;&nbsp;**boundary**: export lines as polygons  
    **dsco** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR dataset creation option (format specific, NAME=VALUE)  
    **lco** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;OGR layer creation option (format specific, NAME=VALUE)  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method to use for export, default is fast export, use slow export in case of problems with the fast method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *fast, slow*  
    &nbsp;&nbsp;&nbsp;&nbsp;**fast**: new, faster method  
    &nbsp;&nbsp;&nbsp;&nbsp;**slow**: old, slower method  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *fast*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *u*, *a*, *s*, *c*, *e*, *2*, *m*, *n*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Open an existing OGR datasource for update  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Append to existing layer  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;A new OGR layer is created if it does not exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Skip export of GRASS category ID ('cat') attribute  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also export features without category (not labeled). Otherwise only features with category are exported.  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use ESRI-style .prj file format (applies to Shapefile output only)  
    &nbsp;&nbsp;&nbsp;&nbsp;**2**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force 2D output even if input is 3D (applies to Shapefile output only)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Useful if input is 3D but all z coordinates are identical  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Export vector data as multi-features  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a new empty layer in defined OGR datasource and exit. Nothing is read from input.  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List supported output formats and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.out.ogr* converts GRASS vector map layer to any of the supported
[OGR](https://gdal.org/) vector formats (including OGC GeoPackage, ESRI
Shapefile, SpatiaLite or GML).

OGR (Simple Features Library) is part of the [GDAL](https://gdal.org)
library, so you need to install this library to use *v.out.ogr*.

The OGR library supports many various formats including:

- [OGC GeoPackage](https://gdal.org/en/stable/drivers/vector/gpkg.html)
- [ESRI
  Shapefile](https://gdal.org/en/stable/drivers/vector/shapefile.html)
- [PostGIS](https://gdal.org/en/stable/drivers/vector/pg.html)
- [SpatiaLite](https://gdal.org/en/stable/drivers/vector/sqlite.html)
- [CSV](https://gdal.org/en/stable/drivers/vector/csv.html)
- [GML](https://gdal.org/en/stable/drivers/vector/gml.html)
- [KML](https://gdal.org/en/stable/drivers/vector/kml.html)
- [Mapinfo File](https://gdal.org/en/stable/drivers/vector/mitab.html)
- [TIGER](https://gdal.org/en/stable/drivers/vector/tiger.html)
- ... and many others

The list of supported formats is printed with the *-l* flag.

For further available formats view the [GDAL vector drivers documentation](https://gdal.org/en/stable/drivers/vector/).

## NOTES

By default, islands will appear as holes inside surrounding areas. To
export polygons with holes into, e.g., a Esri Shapefile, and make the
holes appear as filled areas, the flag **-c** has to be used.

*v.out.ogr* exports 3D vector data as 2.5D simple features if possible
(not supported by all formats). For exporting 3D vector data as 2D
simple features, use **-2** flag.

By default, *v.out.ogr* converts GRASS vector data to single simple
features. If GRASS feature has more categories defined in the given
**layer**, then this feature is exported multiple times. GRASS features
without category are skipped by default. To export features also without
category, the **-c** flag must be given.

When **-m** flag is given, *v.out.ogr* export GRASS vector data as
multi-features. Multi-feature is formed by GRASS features with the same
category. When **-c** flag is given, the module also export GRASS
features without category as one multi-feature. Note that multi-features
are not supported by all formats.

ESRI Shapefile export: note that due to the DBF table specifications
column names may not be longer than 10 characters.

Performance: export to SQLite based formats including OGC GeoPackage may
become faster with the environmental variable `OGR_SQLITE_CACHE=1024`
being set (value depends on available RAM, see [OGR
ConfigOptions](https://trac.osgeo.org/gdal/wiki/ConfigOptions#OGR_SQLITE_CACHE)).

## EXAMPLES

### Export to OGC GeoPackage

Export lines from a GRASS vector map to OGC GeoPackage format:

```sh
v.out.ogr input=roadsmajor type=line output=roadsmajor.gpkg
```

Export areas from GRASS vector map to OGC GeoPackage format, converting
islands (holes) to filled polygons:

```sh
v.out.ogr -c input=areas_islands type=area output=areas_islands.gpkg
```

Export mixed geometry type GRASS vector map to OGC GeoPackage format:

```sh
v.out.ogr input=generic_vector output=mixed_geometry.gpkg
```

### Export to ESRI Shapefile

Export lines from GRASS vector map to Shapefile format:

```sh
v.out.ogr input=roadsmajor type=line format=ESRI_Shapefile output=lines.shp
```

Export areas from GRASS vector map to Shapefile format, converting
islands (holes) to filled polygons:

```sh
v.out.ogr -c input=areas_islands type=area format=ESRI_Shapefile output=areas_islands.shp
```

Export 3D lines from GRASS vector map to Shapefile format:

```sh
v.out.ogr input=lines_3d type=line format=ESRI_Shapefile output=lines_3d.shp lco="SHPT=ARCZ"
```

Export 3D points (e.g., Lidar points) from GRASS vector map to Shapefile
format

```sh
v.out.ogr points_3d type=point format=ESRI_Shapefile output=points_3d.shp lco="SHPT=POINTZ"
```

Export 3D faces from GRASS vector map to Shapefile format:

```sh
v.out.ogr input=objects_3d type=face format=ESRI_Shapefile output=faces_3d.shp lco="SHPT=POLYGONZ"
```

Export 3D faces from GRASS vector map to Shapefile format, automatic 3D
setting:

```sh
v.out.ogr input=objects_3d type=face format=ESRI_Shapefile output=faces_3d.shp"
```

### Export to GML

Export lines from GRASS vector map to GML format (generates
'/tmp/testogr.gml' file with layer 'testogr'):

```sh
v.out.ogr input=multi type=line output=/tmp/testogr.gml output_layer=testogr format=GML
```

### Export to PostgreSQL/PostGIS

Export areas from GRASS vector map to PostGIS database:

```sh
v.out.ogr input=polygons type=area output="PG:host=localhost dbname=postgis user=postgres" output_layer=polymap format=PostgreSQL
```

*Note:* For exporting GRASS vector data to PostGIS database can be also
used *[v.out.postgis](v.out.postgis.md)* module. This module is not
based on OGR library and supports beside simple features also
topological format (PostGIS Topology).

### Export to KML (Google Earth)

Export faces (3D vectors) from GRASS vector map to KML format for Google
Earth:

```sh
v.out.ogr input=buildings_3d output=buildings_3d.kml output_layer=buildings_3d format=KML type=face
```

Generate and export GRASS vector "asteroid" map (faces, 3D vectors) to
KML format for Google Earth:

```sh
# near Raleigh (NC, USA)
g.region n=35.73952587 s=35.73279182 w=-78.68263928 e=-78.67499517

# two layers of random points
v.random -z output=random3d_a n=10 zmin=0 zmax=200
v.random -z output=random3d_b n=15 zmin=400 zmax=600

# merge into one 3D points map
v.patch input=random3d_a,random3d_b output=random3d

# generate 3D convex hull
v.hull input=random3d output="random3d_hull"

# export to KML 3D
v.out.ogr input=random3d_hull output=random3d_hull.kml format=KML type=face dsco="AltitudeMode=absolute"

# now open KML file 'random3d_hull.kml' in Google Earth or NASA WorldWind or ...
```

## REFERENCES

- [OGR vector library](https://gdal.org/)
- [OGR vector library C API](https://gdal.org/api/) documentation

## SEE ALSO

*[v.out.postgis](v.out.postgis.md), [db.out.ogr](db.out.ogr.md),
[v.external](v.external.md), [v.external.out](v.external.out.md),
[v.in.ogr](v.in.ogr.md), [v.pack](v.pack.md)*

## AUTHORS

Radim Blazek, ITC-Irst, Trento, Italy  
Some contributions: Markus Neteler  
Multi-feature support by Martin Landa, Czech Technical University in
Prague, 2013

## SOURCE CODE

Available at: [v.out.ogr source code](https://github.com/OSGeo/grass/tree/main/vector/v.out.ogr)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.out.ogr))  
Latest change: Monday Dec 08 21:47:55 2025 in commit [d3c6479](https://github.com/OSGeo/grass/commit/d3c6479bef77a58e3b5d85259303dbfb9c1babe8)
