---
name: v.transform
description: Performs an affine transformation (shift, scale and rotate) on vector map.
keywords: [ vector, transformation, geometry, GCP ]
---

# v.transform

Performs an affine transformation (shift, scale and rotate) on vector map.

=== "Command line"

    **v.transform**
    [**-twxyab**]
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    [**xshift**=*float*]
    [**yshift**=*float*]
    [**zshift**=*float*]
    [**xscale**=*float*]
    [**yscale**=*float*]
    [**zscale**=*float*]
    [**zrotation**=*float*]
    [**columns**=*name* [,*name*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.transform input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.transform***",
        **input**,
        **layer**=*"-1"*,
        **output**,
        **xshift**=*0.0*,
        **yshift**=*0.0*,
        **zshift**=*0.0*,
        **xscale**=*1.0*,
        **yscale**=*1.0*,
        **zscale**=*1.0*,
        **zrotation**=*0.0*,
        **columns**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.transform", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_transform*(**input**,
        **layer**=*"-1"*,
        **output**,
        **xshift**=*0.0*,
        **yshift**=*0.0*,
        **zshift**=*0.0*,
        **xscale**=*1.0*,
        **yscale**=*1.0*,
        **zscale**=*1.0*,
        **zrotation**=*0.0*,
        **columns**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_transform(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **xshift**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for x coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **yshift**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for y coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **zshift**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **xscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for x coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **yscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for y coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **zscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **zrotation**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation around z axis in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **columns**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) used as transformation parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: parameter:column, e.g. xshift:xs,yshift:ys,zrot:zr  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Shift all z values to bottom=0  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates x, y and then apply other parameters  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates x, z and then apply other parameters  
    **-y**  
    &nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates y, z and then apply other parameters  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates after the other transformations  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **xshift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for x coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **yshift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for y coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **zshift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **xscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for x coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **yscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for y coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **zrotation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation around z axis in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) used as transformation parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: parameter:column, e.g. xshift:xs,yshift:ys,zrot:zr  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *w*, *x*, *y*, *a*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Shift all z values to bottom=0  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates x, y and then apply other parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates x, z and then apply other parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;**y**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates y, z and then apply other parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates after the other transformations  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **xshift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for x coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **yshift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for y coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **zshift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **xscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for x coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **yscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for y coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scaling factor for z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **zrotation** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Rotation around z axis in degrees (counter-clockwise)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s) used as transformation parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;Format: parameter:column, e.g. xshift:xs,yshift:ys,zrot:zr  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *w*, *x*, *y*, *a*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Shift all z values to bottom=0  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates x, y and then apply other parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates x, z and then apply other parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;**y**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates y, z and then apply other parameters  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Swap coordinates after the other transformations  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.transform* performs an affine transformation (translate and rotate)
of a vector map. An affine transform includes one or several linear
transformations (scaling, rotation) and translation (shifting). Several
linear transformations can be combined in a single operation. The
command can be used to georeference unreferenced vector maps or to
modify existing geocoded maps.

## NOTES

Coordinate transformation based on Ground Control Points (GCPs) is done
by *[v.rectify](v.rectify.md)* and not supported by *v.transform*.

Transformation parameters (i.e. *xshift*, *yshift*, etc.) can be fetched
from attribute table connected to the vector map. In this case vector
objects can be transformed with different parameters based on their
category number. If the parameter cannot be fetched from the table,
default value is used instead.

Note that the transformation matrix can be printed by
*[m.transform](m.transform.md)*.

## EXAMPLE

### DXF/DWG drawings

Most DXF/DWG drawings are done within XY coordinate space. To transform
them to a national grid, we can use *v.transform* together with
*v.rectify* and a first-order transformation.

```sh
v.transform -t in=watertowerXY out=watertower_z zscale=0.04 zshift=1320
v.rectify in=watertower_z out=watertowerUTM points=wt.points order=1
```

### Extrude 2D vector points to 3D based on attribute column values

Spearfish example with manual table editing for vertical shift:

```sh
# work on own map copy:
g.copy vect=archsites@PERMANENT,myarchsites
# add new 'zs' column to later store height of each site:
v.db.addcolumn myarchsites col="zs double precision"
v.db.update myarchsites layer=1 column=zs value="cat * 1000"

# perform z transformation:
v.transform -t input=archsites output=myarchsites3d column="zshift:zs" table="archsites_t"
# drop table containing transformation parameters:
echo "drop table archsites_t" | db.execute
```

The resulting map is a 3D vector map.

### Extrude 2D vector points to 3D with automated elevation extraction

Spearfish example with automated elevation extraction for vertical
shift:

```sh
# work on own map copy:
g.copy vect=archsites@PERMANENT,myarchsites
# add new 'zs' column to later store height of each site:
v.db.addcolumn myarchsites col="zs double precision"

# set region to elevation map and fetch individual heights:
g.region raster=elevation.10m -p
v.what.rast myarchsites rast=elevation.10m col=zs
# verify:
v.db.select myarchsites

# perform transformation to 3D
v.transform -t myarchsites output=myarchsites3d column="zshift:zs" layer=1
# drop table containing transformation parameters
v.db.dropcolumn myarchsites3d col=zs
```

The resulting map is a 3D vector map.

## SEE ALSO

*[m.transform](m.transform.md), [i.rectify](i.rectify.md),
[v.rectify](v.rectify.md), [r.region](r.region.md)*

## AUTHORS

Radim Blazek, ITC-irst, Trento, Italy,  
Column support added by Martin Landa, FBK-irst (formerly ITC-irst),
Trento, Italy (2007/09)

## SOURCE CODE

Available at: [v.transform source code](https://github.com/OSGeo/grass/tree/main/vector/v.transform)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.transform))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
