---
name: d.vect
description: Displays user-specified vector map in the active graphics frame.
keywords: [ display, graphics, vector, level1 ]
---

# d.vect

Displays user-specified vector map in the active graphics frame.

=== "Command line"

    **d.vect**
    [**-cirs**]
    **map**=*name*
    [**layer**=*string*]
    **display**=*string* [,*string*,...]
    [**type**=*string* [,*string*,...]]
    [**cats**=*range*]
    [**where**=*sql_query*]
    [**color**=*name*]
    [**fill_color**=*name*]
    [**rgb_column**=*name*]
    [**zcolor**=*style*]
    [**width**=*integer*]
    [**width_column**=*name*]
    [**width_scale**=*float*]
    [**icon**=*string*]
    [**size**=*float*]
    [**size_column**=*name*]
    [**rotation_column**=*name*]
    [**icon_area**=*string*]
    [**icon_line**=*string*]
    [**legend_label**=*string*]
    [**label_layer**=*string*]
    [**attribute_column**=*name*]
    [**label_color**=*name*]
    [**label_bgcolor**=*name*]
    [**label_bcolor**=*name*]
    [**label_size**=*integer*]
    [**font**=*string*]
    [**encoding**=*string*]
    [**xref**=*string*]
    [**yref**=*string*]
    [**minreg**=*float*]
    [**maxreg**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.vect map=name display=shape
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.vect***",
        **map**,
        **layer**=*"1"*,
        **display**=*"shape"*,
        **type**=*"point,line,area,face"*,
        **cats**=*None*,
        **where**=*None*,
        **color**=*"0:29:57"*,
        **fill_color**=*"0:103:204"*,
        **rgb_column**=*None*,
        **zcolor**=*None*,
        **width**=*0*,
        **width_column**=*None*,
        **width_scale**=*1*,
        **icon**=*"basic/x"*,
        **size**=*5*,
        **size_column**=*None*,
        **rotation_column**=*None*,
        **icon_area**=*"legend/area"*,
        **icon_line**=*"legend/line"*,
        **legend_label**=*None*,
        **label_layer**=*"1"*,
        **attribute_column**=*None*,
        **label_color**=*"red"*,
        **label_bgcolor**=*"none"*,
        **label_bcolor**=*"none"*,
        **label_size**=*8*,
        **font**=*None*,
        **encoding**=*None*,
        **xref**=*"left"*,
        **yref**=*"center"*,
        **minreg**=*None*,
        **maxreg**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.vect", map="name", display="shape")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_vect*(**map**,
        **layer**=*"1"*,
        **display**=*"shape"*,
        **type**=*"point,line,area,face"*,
        **cats**=*None*,
        **where**=*None*,
        **color**=*"0:29:57"*,
        **fill_color**=*"0:103:204"*,
        **rgb_column**=*None*,
        **zcolor**=*None*,
        **width**=*0*,
        **width_column**=*None*,
        **width_scale**=*1*,
        **icon**=*"basic/x"*,
        **size**=*5*,
        **size_column**=*None*,
        **rotation_column**=*None*,
        **icon_area**=*"legend/area"*,
        **icon_line**=*"legend/line"*,
        **legend_label**=*None*,
        **label_layer**=*"1"*,
        **attribute_column**=*None*,
        **label_color**=*"red"*,
        **label_bgcolor**=*"none"*,
        **label_bcolor**=*"none"*,
        **label_size**=*8*,
        **font**=*None*,
        **encoding**=*None*,
        **xref**=*"left"*,
        **yref**=*"center"*,
        **minreg**=*None*,
        **maxreg**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_vect(map="name", display="shape")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **display**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *shape, cat, topo, vert, dir, zcoor*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *shape*  
    &nbsp;&nbsp;&nbsp;&nbsp;**shape**: Display geometry of features  
    &nbsp;&nbsp;&nbsp;&nbsp;**cat**: Display category numbers of features  
    &nbsp;&nbsp;&nbsp;&nbsp;**topo**: Display topology information (nodes, edges)  
    &nbsp;&nbsp;&nbsp;&nbsp;**vert**: Display vertices of features  
    &nbsp;&nbsp;&nbsp;&nbsp;**dir**: Display direction of linear features  
    &nbsp;&nbsp;&nbsp;&nbsp;**zcoor**: Display z-coordinate of features (only for 3D vector maps)  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area,face*  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:29:57*  
    **fill_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area fill color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:103:204*  
    **rgb_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colorize features according to color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Color definition in R:G:B form  
    **zcolor**=*style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colorize point or area features according to z-coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **width_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of numeric column containing line width  
    &nbsp;&nbsp;&nbsp;&nbsp;These values will be scaled by width_scale  
    **width_scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for width_column  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **icon**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point and centroid symbol  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/x*  
    **size**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;When used with the size_column option this becomes the scale factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **size_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of numeric column containing symbol size  
    **rotation_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of numeric column containing symbol rotation angle  
    &nbsp;&nbsp;&nbsp;&nbsp;Measured in degrees CCW from east  
    **icon_area**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area/boundary symbol for legend  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/area*  
    **icon_line**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line symbol for legend  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/line*  
    **legend_label**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label to display after symbol in vector legend  
    **label_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number for labels (default: the given layer number)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **attribute_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column to be displayed as a label  
    **label_color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *red*  
    **label_bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **label_bcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **label_size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **encoding**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding  
    **xref**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label horizontal justification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *left, center, right*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *left*  
    **yref**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label vertical justification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *top, center, bottom*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *center*  
    **minreg**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum region size (average from height and width) when map is displayed  
    **maxreg**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum region size (average from height and width) when map is displayed  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Random colors according to category number (or layer number if 'layer=-1' is given)  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use values from 'cats' option as feature id  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use square root of the value of size_column  
    &nbsp;&nbsp;&nbsp;&nbsp;This makes circle areas proportionate to the size_column values instead of circle radius  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not show this layer in vector legend  
  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **display** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *shape, cat, topo, vert, dir, zcoor*  
    &nbsp;&nbsp;&nbsp;&nbsp;**shape**: Display geometry of features  
    &nbsp;&nbsp;&nbsp;&nbsp;**cat**: Display category numbers of features  
    &nbsp;&nbsp;&nbsp;&nbsp;**topo**: Display topology information (nodes, edges)  
    &nbsp;&nbsp;&nbsp;&nbsp;**vert**: Display vertices of features  
    &nbsp;&nbsp;&nbsp;&nbsp;**dir**: Display direction of linear features  
    &nbsp;&nbsp;&nbsp;&nbsp;**zcoor**: Display z-coordinate of features (only for 3D vector maps)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *shape*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area,face*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:29:57*  
    **fill_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area fill color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:103:204*  
    **rgb_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colorize features according to color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Color definition in R:G:B form  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **zcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colorize point or area features according to z-coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, colortable, *style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **width_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of numeric column containing line width  
    &nbsp;&nbsp;&nbsp;&nbsp;These values will be scaled by width_scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **width_scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for width_column  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **icon** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point and centroid symbol  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/x*  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;When used with the size_column option this becomes the scale factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **size_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of numeric column containing symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **rotation_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of numeric column containing symbol rotation angle  
    &nbsp;&nbsp;&nbsp;&nbsp;Measured in degrees CCW from east  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **icon_area** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area/boundary symbol for legend  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/area*  
    **icon_line** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line symbol for legend  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/line*  
    **legend_label** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label to display after symbol in vector legend  
    **label_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number for labels (default: the given layer number)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **attribute_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column to be displayed as a label  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **label_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *red*  
    **label_bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **label_bcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **label_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **encoding** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding  
    **xref** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label horizontal justification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *left, center, right*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *left*  
    **yref** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label vertical justification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *top, center, bottom*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *center*  
    **minreg** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum region size (average from height and width) when map is displayed  
    **maxreg** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum region size (average from height and width) when map is displayed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *i*, *r*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Random colors according to category number (or layer number if 'layer=-1' is given)  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use values from 'cats' option as feature id  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use square root of the value of size_column  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This makes circle areas proportionate to the size_column values instead of circle radius  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not show this layer in vector legend  
  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **display** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Display  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *shape, cat, topo, vert, dir, zcoor*  
    &nbsp;&nbsp;&nbsp;&nbsp;**shape**: Display geometry of features  
    &nbsp;&nbsp;&nbsp;&nbsp;**cat**: Display category numbers of features  
    &nbsp;&nbsp;&nbsp;&nbsp;**topo**: Display topology information (nodes, edges)  
    &nbsp;&nbsp;&nbsp;&nbsp;**vert**: Display vertices of features  
    &nbsp;&nbsp;&nbsp;&nbsp;**dir**: Display direction of linear features  
    &nbsp;&nbsp;&nbsp;&nbsp;**zcoor**: Display z-coordinate of features (only for 3D vector maps)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *shape*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area,face*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:29:57*  
    **fill_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area fill color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0:103:204*  
    **rgb_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colorize features according to color definition column  
    &nbsp;&nbsp;&nbsp;&nbsp;Color definition in R:G:B form  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **zcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colorize point or area features according to z-coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, colortable, *style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line width  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **width_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of numeric column containing line width  
    &nbsp;&nbsp;&nbsp;&nbsp;These values will be scaled by width_scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **width_scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor for width_column  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **icon** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point and centroid symbol  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *basic/x*  
    **size** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;When used with the size_column option this becomes the scale factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **size_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of numeric column containing symbol size  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **rotation_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of numeric column containing symbol rotation angle  
    &nbsp;&nbsp;&nbsp;&nbsp;Measured in degrees CCW from east  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **icon_area** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area/boundary symbol for legend  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/area*  
    **icon_line** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line symbol for legend  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *basic/arrow, basic/arrow1, basic/arrow2, basic/arrow3, basic/box, basic/circle, basic/cross1, basic/cross2, basic/cross3, basic/diamond, basic/hexagon, basic/marker, basic/octagon, basic/pin, basic/pin_dot, basic/point, basic/pushpin, basic/star, basic/triangle, basic/x, demo/muchomurka, demo/smrk, extra/4pt_star, extra/adcp, extra/airport, extra/alpha_flag, extra/bridge, extra/dim_arrow, extra/dive_flag, extra/fiducial, extra/fish, extra/half-box, extra/half-circle, extra/offbox_ne, extra/offbox_nw, extra/offbox_se, extra/offbox_sw, extra/pentagon, extra/ping, extra/ring, extra/simple_zia, extra/target, geology/circle_cross, geology/half-arrow_left, geology/half-arrow_right, geology/strike_box, geology/strike_circle, geology/strike_cleavage, geology/strike_half-bowtie, geology/strike_line, geology/strike_parallel, geology/strike_triangle, legend/area, legend/area_curved, legend/line, legend/line_crooked, n_arrows/basic_compass, n_arrows/fancy_compass, n_arrows/n_arrow1a, n_arrows/n_arrow1b, n_arrows/n_arrow2, n_arrows/n_arrow3, n_arrows/n_arrow4, n_arrows/n_arrow5, n_arrows/n_arrow6, n_arrows/n_arrow7a, n_arrows/n_arrow7b, n_arrows/n_arrow8a, n_arrows/n_arrow8b, n_arrows/n_arrow9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *legend/line*  
    **legend_label** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label to display after symbol in vector legend  
    **label_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number for labels (default: the given layer number)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **attribute_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of column to be displayed as a label  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **label_color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *red*  
    **label_bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **label_bcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label border color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **label_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label size (pixels)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Font name  
    **encoding** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text encoding  
    **xref** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label horizontal justification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *left, center, right*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *left*  
    **yref** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Label vertical justification  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *top, center, bottom*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *center*  
    **minreg** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum region size (average from height and width) when map is displayed  
    **maxreg** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum region size (average from height and width) when map is displayed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *i*, *r*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Random colors according to category number (or layer number if 'layer=-1' is given)  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use values from 'cats' option as feature id  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use square root of the value of size_column  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This makes circle areas proportionate to the size_column values instead of circle radius  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not show this layer in vector legend  
  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.vect* displays vector maps in the active frame on the graphics
monitor.

## NOTES

*d.vect* can simply be used typing `d.vect map=vector_map`. There are a
large variety of optional parameters which allow the user to specify
vector type, colors, data fields, SQL queries, label size and
justification, etc.

When *d.vect* is used with **where** parameter on MS Windows Command
Prompt, it is important to use `ˆ` caret symbol for escaping special
characters `< > ( ) & | , ; "`.

```sh
d.vect map=vector_map where="cat ˆ> 10 AND cat ˆ< 20"
```

By default *d.vect* areas are filled with **fill_color** and outlined
with **color**. Area outlines can be suppressed with

```sh
d.vect map=vector_map color=none
```

and areas can be made transparent with

```sh
d.vect map=vector_map fill_color=none
```

In order to display attributes in the map, **attribute_column** must be
specified.

Feature colors may be specified by *[v.colors](v.colors.md)* in a form
of color table or in an attribute table column containing `RRR:GGG:BBB`
values.

A table for a vector map might look like this:

```sh
db.select sql="select * from testisola"
cat|label|GRASSRGB
0|no data|255:255:255
90|FRASSILONGO|23:245:67
104|LEVICO|23:145:67
139|PERGINE VALSUGANA|223:45:237
168|SANT'ORSOLA|223:45:67
190|TENNA|123:45:67
```

To add the GRASSRGB color column, use
*[v.db.addcolumn](v.db.addcolumn.md)*:

```sh
v.db.addcolumn map=testisola columns="GRASSRGB varchar(11)"
```

To add/change a color, use *[v.db.update](v.db.update.md)*:

```sh
v.db.update map=testisola column=GRASSRGB value="123:45:237" where="cat=139"
```

A much simpler method of color coding is by using the **-c** flag which
displays vector elements of like category number with a random color.

This module can use FreeType/TrueType fonts if they have already been
selected with *[d.font](d.font.md)*.

Parameter **width** is set by default to '0'. XDRIVER specifies the
precise behaviour for non-zero line width, but drivers have some freedom
as to how zero-width lines are handled, so they can use the hardware's
"thin line" drawing primitive, if it has one. A width of zero can
potentially result in significantly faster operation. On drivers where
there is no such thing as a "thin" line, the driver will use a sensible
default (which might not be the same as '1').

## EXAMPLES

Spearfish examples:

```sh
# display roads with category numbers:
d.vect map=roads display=shape,cat label_color=green

# display randomly colorized soils map with attributes
d.vect -c map=soils attribute_column=label

# display randomly colorized selected vectors from soils map
d.vect -c map=soils where="label='VBF'" display=shape attribute_column=label
```

3D points, 3D lines and 3D polygons colorized according to z height (for
3D lines and polygons a z height is computed by a midpoint of line/area
bounding box):

```sh
g.region raster=elevation.10m
r.random input=elevation.10m n=5000 vector=random3d -z
d.mon start=x0
# display as black points
d.vect map=random3d
# display 3D points colorized according to z height
d.vect map=random3d zcolor=gyr

# 3D contour lines
r.contour input=elevation.10m output=contour20m step=20
d.vect map=contour20m zcolor=gyr

# generate 3D triangles
v.delaunay input=random3d output=random3d_del
# display 3D polygons colorized according to z height
d.vect map=random3d_del type=area zcolor=gyr
```

## SEE ALSO

*[v.colors](v.colors.md), [d.erase](d.erase.md), [d.rast](d.rast.md),
[v.colors](v.colors.md), [v.db.addcolumn](v.db.addcolumn.md),
[v.db.update](v.db.update.md)*

*[GRASS SQL interface](sql.md)*

## AUTHORS

CERL  
Radim Blazek, ITC-Irst, Trento, Italy  
Support for color tables by Martin Landa, Czech Technical University in
Prague (8/2011)  
and many other GRASS developers

## SOURCE CODE

Available at: [d.vect source code](https://github.com/OSGeo/grass/tree/main/display/d.vect)
([history](https://github.com/OSGeo/grass/commits/main/display/d.vect))  
Latest change: Saturday Aug 09 12:50:00 2025 in commit [1ccfa1e](https://github.com/OSGeo/grass/commit/1ccfa1e6cb078a19a188bef52cc155fc3d47aa06)
