---
name: i.aster.toar
description: Calculates Top of Atmosphere Radiance/Reflectance/Brightness Temperature from ASTER DN.
keywords: [ imagery, radiometric conversion, radiance, reflectance, brightness temperature, satellite, ASTER ]
---

# i.aster.toar

Calculates Top of Atmosphere Radiance/Reflectance/Brightness Temperature from ASTER DN.

=== "Command line"

    **i.aster.toar**
    [**-rabcde**]
    **input**=*name* [,*name*,...]
    **dayofyear**=*float*
    **sun_elevation**=*float*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.aster.toar input=name dayofyear=0.0 sun_elevation=0.0 output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.aster.toar***",
        **input**,
        **dayofyear**,
        **sun_elevation**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.aster.toar", input="name", dayofyear=0.0, sun_elevation=0.0, output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_aster_toar*(**input**,
        **dayofyear**,
        **sun_elevation**,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_aster_toar(input="name", dayofyear=0.0, sun_elevation=0.0, output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of ASTER DN layers (15 layers)  
    **dayofyear**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Day of Year of satellite overpass [0-366]  
    **sun_elevation**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Sun elevation angle (degrees, &lt; 90.0)  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name of the output layers (will add .x)  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output is radiance (W/m2)  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;VNIR is High Gain  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;SWIR is High Gain  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;VNIR is Low Gain 1  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;SWIR is Low Gain 1  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;SWIR is Low Gain 2  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of ASTER DN layers (15 layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dayofyear** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Day of Year of satellite overpass [0-366]  
    **sun_elevation** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sun elevation angle (degrees, &lt; 90.0)  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name of the output layers (will add .x)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *a*, *b*, *c*, *d*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output is radiance (W/m2)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;VNIR is High Gain  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SWIR is High Gain  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;VNIR is Low Gain 1  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SWIR is Low Gain 1  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SWIR is Low Gain 2  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Names of ASTER DN layers (15 layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dayofyear** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Day of Year of satellite overpass [0-366]  
    **sun_elevation** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sun elevation angle (degrees, &lt; 90.0)  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name of the output layers (will add .x)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *a*, *b*, *c*, *d*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output is radiance (W/m2)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;VNIR is High Gain  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SWIR is High Gain  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;VNIR is Low Gain 1  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SWIR is Low Gain 1  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SWIR is Low Gain 2  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.aster.toar* calculates the Top Of Atmosphere (TOA) reflectance for
Terra-ASTER L1B in the visible, NIR and SWIR bands (9+1 bands) and
brightness temperature for the TIR bands (5 bands), all from L1B DN
values. It is useful to apply after import of original ASTER imagery
that is generally in standard DN values range.

The order of input bands is

- VNIR: 1,2,3N,3B
- SWIR: 4,5,6,7,8,9
- TIR: 10,11,12,13,14

in one comma-separated list.

## NOTES

Internally, a gain code is defined to modify gains according to spectral
bands following the GeoSystems GmbH ATCOR Ver. 2.0 Calibration Files.
The function is defined in gain_aster.c file.

```sh
/*Gain Code*/
    /*0 - High (Not Applicable for band 10-14: TIR)*/
    /*1 - Normal*/
    /*2 - Low 1(Not Applicable for band 10-14: TIR)*/
    /*3 - Low 2(Not Applicable for Band 1-3N/B and 10-14)*/
```

## SEE ALSO

*[i.landsat.toar](i.landsat.toar.md), [r.in.aster](r.in.aster.md)*

ASTER sensor data download: [ASTER: Advanced Spaceborne Thermal Emission
and Reflection Radiometer](https://asterweb.jpl.nasa.gov/)

## AUTHOR

Yann Chemin, CSU, Australia

## SOURCE CODE

Available at: [i.aster.toar source code](https://github.com/OSGeo/grass/tree/main/imagery/i.aster.toar)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.aster.toar))  
Latest change: Saturday May 31 03:33:38 2025 in commit [1935794](https://github.com/OSGeo/grass/commit/193579448e84c26e98f04e97918b6c61d5a2adff)
