---
name: i.evapo.pt
description: Computes evapotranspiration calculation Priestley and Taylor formulation, 1972.
keywords: [ imagery, evapotranspiration ]
---

# i.evapo.pt

Computes evapotranspiration calculation Priestley and Taylor formulation, 1972.

=== "Command line"

    **i.evapo.pt**
    [**-z**]
    **net_radiation**=*name*
    **soil_heatflux**=*name*
    **air_temperature**=*name*
    **atmospheric_pressure**=*name*
    **priestley_taylor_coeff**=*float*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.evapo.pt net_radiation=name soil_heatflux=name air_temperature=name atmospheric_pressure=name priestley_taylor_coeff=1.26 output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.evapo.pt***",
        **net_radiation**,
        **soil_heatflux**,
        **air_temperature**,
        **atmospheric_pressure**,
        **priestley_taylor_coeff**=*1.26*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.evapo.pt", net_radiation="name", soil_heatflux="name", air_temperature="name", atmospheric_pressure="name", priestley_taylor_coeff=1.26, output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_evapo_pt*(**net_radiation**,
        **soil_heatflux**,
        **air_temperature**,
        **atmospheric_pressure**,
        **priestley_taylor_coeff**=*1.26*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_evapo_pt(net_radiation="name", soil_heatflux="name", air_temperature="name", atmospheric_pressure="name", priestley_taylor_coeff=1.26, output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **net_radiation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input net radiation raster map [W/m2]  
    **soil_heatflux**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input soil heat flux raster map [W/m2]  
    **air_temperature**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input air temperature raster map [K]  
    **atmospheric_pressure**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input atmospheric pressure raster map [millibars]  
    **priestley_taylor_coeff**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Priestley-Taylor coefficient  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.26*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output evapotranspiration raster map [mm/d]  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set negative ETa to zero  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **net_radiation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input net radiation raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soil_heatflux** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input soil heat flux raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **air_temperature** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input air temperature raster map [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **atmospheric_pressure** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input atmospheric pressure raster map [millibars]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **priestley_taylor_coeff** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Priestley-Taylor coefficient  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.26*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output evapotranspiration raster map [mm/d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set negative ETa to zero  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **net_radiation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input net radiation raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **soil_heatflux** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input soil heat flux raster map [W/m2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **air_temperature** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input air temperature raster map [K]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **atmospheric_pressure** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input atmospheric pressure raster map [millibars]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **priestley_taylor_coeff** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Priestley-Taylor coefficient  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.26*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output evapotranspiration raster map [mm/d]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set negative ETa to zero  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.evapo.pt* Calculates the diurnal evapotranspiration after Prestley
and Taylor (1972). The Priestley-Taylor model (Priestley and Taylor,
1972) is a modification of Penman's more theoretical equation.

## NOTES

RNETD optional output from *i.evapo.potrad* is giving good results as
input for net radiation in this module.

Alpha values:

- 1.32 for estimates from vegetated areas as a result of the increase in
  surface roughness (Morton, 1983; Brutsaert and Stricker, 1979)
- 1.26 is applicable in humid climates (De Bruin and Keijman, 1979;
  Stewart and Rouse, 1976; Shuttleworth and Calder, 1979), and temperate
  hardwood swamps (Munro, 1979)
- 1.74 has been recommended for estimating potential evapotranspiration
  in more arid regions (ASCE, 1990). This worked well in Greece with
  University of Thessaloniki.

Alpha values extracted from: [Watflood
manual](http://www.civil.uwaterloo.ca/Watflood/Manual/02_03_1.htm).

## SEE ALSO

*[i.evapo.mh](i.evapo.mh.md), [i.evapo.pm](i.evapo.pm.md),
[i.evapo.time](i.evapo.time.md), [i.eb.netrad](i.eb.netrad.md),
[r.sun](r.sun.md)*

## AUTHOR

Yann Chemin, GRASS Development Team, 2007-08

## SOURCE CODE

Available at: [i.evapo.pt source code](https://github.com/OSGeo/grass/tree/main/imagery/i.evapo.pt)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.evapo.pt))  
Latest change: Thursday Jun 26 21:25:27 2025 in commit [3ec2b13](https://github.com/OSGeo/grass/commit/3ec2b13945d963db69544e3fc9339fbff72f33f3)
