---
name: i.target
description: Targets an imagery group to a GRASS location and mapset.
keywords: [ imagery, map management ]
---

# i.target

Targets an imagery group to a GRASS location and mapset.

=== "Command line"

    **i.target**
    [**-c**]
    **group**=*name*
    [**location**=*string*]
    [**mapset**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.target group=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.target***",
        **group**,
        **location**=*None*,
        **mapset**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.target", group="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_target*(**group**,
        **location**=*None*,
        **mapset**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_target(group="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **group**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    **location**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery target location  
    **mapset**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target mapset  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set current location and mapset as target for imagery group  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: group, *name*  
    **location** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery target location  
    **mapset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target mapset  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set current location and mapset as target for imagery group  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **group** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input imagery group  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: group, *name*  
    **location** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of imagery target location  
    **mapset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of target mapset  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set current location and mapset as target for imagery group  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.target* targets an [imagery group](i.group.md) to a GRASS data base
project name and mapset. A project name and mapset are required for the
*[i.rectify](i.rectify.md)* imagery module, into which to write the
rectified map just prior to completion of the program; *i.target*
enables the user to specify this project. *i.target* must be run before
*[g.gui.gcp](g.gui.gcp.md)* and *[i.rectify](i.rectify.md)*.

## NOTES

The module's first option asks for the name of the [imagery
group](i.group.md) that needs a target. The imagery group must be
present in the user's current mapset. An [imagery group](i.group.md) may
be targeted to any GRASS project.

If a group name is given without setting options, the currently targeted
group will be displayed.

## SEE ALSO

The GRASS 4 *[Image Processing
manual](https://grass.osgeo.org/gdp/imagery/grass4_image_processing.pdf)*

*[g.gui.gcp](g.gui.gcp.md), [i.group](i.group.md),
[i.rectify](i.rectify.md)*  
*[Manage Ground Control Points](wxGUI.gcp.md)*

## AUTHORS

Michael Shapiro, U.S. Army Construction Engineering Research Laboratory

Parser support: Bob Covill

## SOURCE CODE

Available at: [i.target source code](https://github.com/OSGeo/grass/tree/main/imagery/i.target)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.target))  
Latest change: Tuesday Oct 21 09:57:14 2025 in commit [fb0165c](https://github.com/OSGeo/grass/commit/fb0165c2d021b7700528aca09c224847be871729)
