---
name: r.blend.py
description: Blends color components of two raster maps by a given ratio.
keywords: [ raster, composite ]
---

# r.blend.py

Blends color components of two raster maps by a given ratio.

=== "Command line"

    **r.blend.py**
    [**-c**]
    **first**=*name*
    **second**=*name*
    **output**=*basename*
    [**percent**=*float*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.blend.py first=name second=name output=basename
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.blend.py***",
        **first**,
        **second**,
        **output**,
        **percent**=*50*,
        **nprocs**=*0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.blend.py", first="name", second="name", output="basename")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_blend_py*(**first**,
        **second**,
        **output**,
        **percent**=*50*,
        **nprocs**=*0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_blend_py(first="name", second="name", output="basename")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **first**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of first raster map for blending  
    **second**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of second raster map for blending  
    **output**=*basename* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for red, green and blue output raster maps  
    **percent**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage weight of first map for color blending  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Combine resulting R,G,B layers into single output map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **first** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of first raster map for blending  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **second** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of second raster map for blending  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for red, green and blue output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **percent** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage weight of first map for color blending  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Combine resulting R,G,B layers into single output map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **first** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of first raster map for blending  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **second** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of second raster map for blending  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename for red, green and blue output raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *basename*  
    **percent** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage weight of first map for color blending  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *50*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads for parallel computing  
    &nbsp;&nbsp;&nbsp;&nbsp;0: use OpenMP default; &gt;0: use nprocs; &lt;0: use MAX-nprocs  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Combine resulting R,G,B layers into single output map  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.blend* blends color components of 2 raster maps by a specified
percentage of the first map.

## EXAMPLE

Blending the aspect map with the elevation map for a shaded map (North
Carolina sample dataset):

```sh
g.region raster=elevation
r.relief input=elevation output=relief zscale=10
r.blend -c first=elevation second=relief output=blend percent=75
```

![r.blend example](r_blend.png)  
*Figure: Elevation blended with shaded relief*

## SEE ALSO

*[d.shade](d.shade.md), [g.region](g.region.md), [r.shade](r.shade.md),
[r.colors](r.colors.md), [r.his](r.his.md), [r.mapcalc](r.mapcalc.md),
[r.rgb](r.rgb.md), [r.support](r.support.md)*

## AUTHORS

Unknown: probably CERL  
Updated to GRASS 5.7 by Michael Barton, Arizona State University

## SOURCE CODE

Available at: [r.blend source code](https://github.com/OSGeo/grass/tree/main/scripts/r.blend)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.blend))  
Latest change: Thursday Nov 06 23:50:00 2025 in commit [f714bf8](https://github.com/OSGeo/grass/commit/f714bf80e54f853796854f03b5c86fd7f5b1cd9d)
