---
name: r.colors
description: Creates/modifies the color table associated with a raster map.
keywords: [ raster, color table ]
---

# r.colors

Creates/modifies the color table associated with a raster map.

=== "Command line"

    **r.colors**
    [**-rwldngae**]
    [**map**=*name* [,*name*,...]]
    [**file**=*name*]
    [**color**=*style*]
    [**raster**=*name*]
    [**raster_3d**=*name*]
    [**rules**=*name*]
    [**offset**=*float*]
    [**scale**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.colors map=name
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***r.colors***",
        **map**=*None*,
        **file**=*None*,
        **color**=*None*,
        **raster**=*None*,
        **raster_3d**=*None*,
        **rules**=*None*,
        **offset**=*0*,
        **scale**=*1*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("r.colors", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_colors*(**map**=*None*,
        **file**=*None*,
        **color**=*None*,
        **raster**=*None*,
        **raster_3d**=*None*,
        **rules**=*None*,
        **offset**=*0*,
        **scale**=*1*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_colors(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one map name per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Input map names can be defined in an input file in case a large amount of maps must be specified. This option is mutual exclusive to the map option.  
    **color**=*style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy color table  
    **raster_3d**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map from which to copy color table  
    **rules**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;"-" to read rules from stdin  
    **offset**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset for color rule values  
    &nbsp;&nbsp;&nbsp;&nbsp;New value = (old value + offset) \* scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for color rule values  
    &nbsp;&nbsp;&nbsp;&nbsp;New value = (old value + offset) \* scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove existing color table  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only write new color table if it does not already exist  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available rules then exit  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available rules with description then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;If a color rule is given, only this rule is listed  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Invert colors  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Logarithmic scaling  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Logarithmic-absolute scaling  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Histogram equalization  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one map name per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Input map names can be defined in an input file in case a large amount of maps must be specified. This option is mutual exclusive to the map option.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, colortable, *style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster_3d** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map from which to copy color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **rules** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;"-" to read rules from stdin  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **offset** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset for color rule values  
    &nbsp;&nbsp;&nbsp;&nbsp;New value = (old value + offset) \* scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for color rule values  
    &nbsp;&nbsp;&nbsp;&nbsp;New value = (old value + offset) \* scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *w*, *l*, *d*, *n*, *g*, *a*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove existing color table  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only write new color table if it does not already exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available rules then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available rules with description then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;If a color rule is given, only this rule is listed  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert colors  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic-absolute scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Histogram equalization  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input file with one map name per line  
    &nbsp;&nbsp;&nbsp;&nbsp;Input map names can be defined in an input file in case a large amount of maps must be specified. This option is mutual exclusive to the map option.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, colortable, *style*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *aspect, aspectcolr, bcyr, bgyr, blues, byg, byr, celsius, corine, curvature, differences, elevation, etopo2, evi, fahrenheit, forest_cover, gdd, grass, greens, grey, grey.eq, grey.log, grey1.0, grey255, gyr, haxby, inferno, kelvin, magma, ndvi, ndwi, nlcd, oranges, plasma, population, population_dens, precipitation, precipitation_daily, precipitation_monthly, rainbow, ramp, random, reds, roygbiv, rstcurv, ryb, ryg, sepia, slope, soilmoisture, srtm, srtm_percent, srtm_plus, terrain, viridis, water, wave*  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspect](colortables/aspect.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: aspect oriented grey colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![aspectcolr](colortables/aspectcolr.png) &nbsp;&nbsp;&nbsp;&nbsp;**aspectcolr**: aspect oriented rainbow colors [range: 0 to 360]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bcyr](colortables/bcyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bcyr**: blue through cyan through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![bgyr](colortables/bgyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**bgyr**: blue through green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![blues](colortables/blues.png) &nbsp;&nbsp;&nbsp;&nbsp;**blues**: white to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byg](colortables/byg.png) &nbsp;&nbsp;&nbsp;&nbsp;**byg**: blue through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![byr](colortables/byr.png) &nbsp;&nbsp;&nbsp;&nbsp;**byr**: blue through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![celsius](colortables/celsius.png) &nbsp;&nbsp;&nbsp;&nbsp;**celsius**: blue to red for degree Celsius temperature [range: -80 to 80]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![corine](colortables/corine.png) &nbsp;&nbsp;&nbsp;&nbsp;**corine**: EU Corine land cover colors [range: 111 to 995]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![curvature](colortables/curvature.png) &nbsp;&nbsp;&nbsp;&nbsp;**curvature**: for terrain curvatures (from v.surf.rst and r.slope.aspect) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![differences](colortables/differences.png) &nbsp;&nbsp;&nbsp;&nbsp;**differences**: differences oriented colors [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![elevation](colortables/elevation.png) &nbsp;&nbsp;&nbsp;&nbsp;**elevation**: maps relative ranges of raster values to elevation color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![etopo2](colortables/etopo2.png) &nbsp;&nbsp;&nbsp;&nbsp;**etopo2**: colors for ETOPO2 worldwide bathymetry/topography [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![evi](colortables/evi.png) &nbsp;&nbsp;&nbsp;&nbsp;**evi**: enhanced vegetative index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![fahrenheit](colortables/fahrenheit.png) &nbsp;&nbsp;&nbsp;&nbsp;**fahrenheit**: blue to red for Fahrenheit temperature [range: -112 to 176]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![forest_cover](colortables/forest_cover.png) &nbsp;&nbsp;&nbsp;&nbsp;**forest_cover**: percentage of forest cover [range: 0 to 100]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gdd](colortables/gdd.png) &nbsp;&nbsp;&nbsp;&nbsp;**gdd**: accumulated growing degree days [range: 0 to 6000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grass](colortables/grass.png) &nbsp;&nbsp;&nbsp;&nbsp;**grass**: GRASS green (perceptually uniform) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![greens](colortables/greens.png) &nbsp;&nbsp;&nbsp;&nbsp;**greens**: white to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey](colortables/grey.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey**: grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.eq](colortables/grey.eq.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.eq**: histogram-equalized grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey.log](colortables/grey.log.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey.log**: histogram logarithmic transformed grey scale [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey1.0](colortables/grey1.0.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey1.0**: grey scale for raster values between 0.0-1.0 [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![grey255](colortables/grey255.png) &nbsp;&nbsp;&nbsp;&nbsp;**grey255**: grey scale for raster values between 0-255 [range: 0 to 255]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![gyr](colortables/gyr.png) &nbsp;&nbsp;&nbsp;&nbsp;**gyr**: green through yellow to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![haxby](colortables/haxby.png) &nbsp;&nbsp;&nbsp;&nbsp;**haxby**: relative colors for bathymetry or topography [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![inferno](colortables/inferno.png) &nbsp;&nbsp;&nbsp;&nbsp;**inferno**: perceptually uniform sequential color table inferno [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![kelvin](colortables/kelvin.png) &nbsp;&nbsp;&nbsp;&nbsp;**kelvin**: blue to red for temperature in Kelvin scale [range: 193.15 to 353.15]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![magma](colortables/magma.png) &nbsp;&nbsp;&nbsp;&nbsp;**magma**: perceptually uniform sequential color table magma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndvi](colortables/ndvi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndvi**: Normalized Difference Vegetation Index colors [range: -1 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ndwi](colortables/ndwi.png) &nbsp;&nbsp;&nbsp;&nbsp;**ndwi**: Normalized Difference Water Index colors [range: -200 to 200]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![nlcd](colortables/nlcd.png) &nbsp;&nbsp;&nbsp;&nbsp;**nlcd**: US National Land Cover Dataset colors [range: 0 to 95]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![oranges](colortables/oranges.png) &nbsp;&nbsp;&nbsp;&nbsp;**oranges**: white to orange [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![plasma](colortables/plasma.png) &nbsp;&nbsp;&nbsp;&nbsp;**plasma**: perceptually uniform sequential color table plasma [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population](colortables/population.png) &nbsp;&nbsp;&nbsp;&nbsp;**population**: color table covering human population classification breaks [range: 0 to 2e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![population_dens](colortables/population_dens.png) &nbsp;&nbsp;&nbsp;&nbsp;**population_dens**: color table covering human population density classification breaks [range: 0 to 1e+009]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation](colortables/precipitation.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation**: precipitation color table (0..2000mm) [range: 0 to 7000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_daily](colortables/precipitation_daily.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_daily**: precipitation color table (0..1000mm) [range: 0 to 10000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![precipitation_monthly](colortables/precipitation_monthly.png) &nbsp;&nbsp;&nbsp;&nbsp;**precipitation_monthly**: precipitation color table (0..1000mm) [range: 0 to 1000]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rainbow](colortables/rainbow.png) &nbsp;&nbsp;&nbsp;&nbsp;**rainbow**: rainbow color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ramp](colortables/ramp.png) &nbsp;&nbsp;&nbsp;&nbsp;**ramp**: color ramp [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![random](colortables/random.png) &nbsp;&nbsp;&nbsp;&nbsp;**random**: random color table [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![reds](colortables/reds.png) &nbsp;&nbsp;&nbsp;&nbsp;**reds**: white to red [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![roygbiv](colortables/roygbiv.png) &nbsp;&nbsp;&nbsp;&nbsp;**roygbiv**:  [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![rstcurv](colortables/rstcurv.png) &nbsp;&nbsp;&nbsp;&nbsp;**rstcurv**: terrain curvature (from r.resamp.rst) [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryb](colortables/ryb.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryb**: red through yellow to blue [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![ryg](colortables/ryg.png) &nbsp;&nbsp;&nbsp;&nbsp;**ryg**: red through yellow to green [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![sepia](colortables/sepia.png) &nbsp;&nbsp;&nbsp;&nbsp;**sepia**: yellowish-brown through to white [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![slope](colortables/slope.png) &nbsp;&nbsp;&nbsp;&nbsp;**slope**: r.slope.aspect-type slope colors for raster values 0-90 [range: 0 to 90]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![soilmoisture](colortables/soilmoisture.png) &nbsp;&nbsp;&nbsp;&nbsp;**soilmoisture**: soilmoisture color table (0.0-1.0) [range: 0 to 1]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm](colortables/srtm.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm**: color palette for Shuttle Radar Topography Mission elevation [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_percent](colortables/srtm_percent.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_percent**: color palette for Shuttle Radar Topography Mission using relative elevation [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![srtm_plus](colortables/srtm_plus.png) &nbsp;&nbsp;&nbsp;&nbsp;**srtm_plus**: color palette for Shuttle Radar Topography Mission elevation (with seafloor colors) [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![terrain](colortables/terrain.png) &nbsp;&nbsp;&nbsp;&nbsp;**terrain**: global elevation color table covering -11000 to +8850m [range: -11000 to 8850]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![viridis](colortables/viridis.png) &nbsp;&nbsp;&nbsp;&nbsp;**viridis**: perceptually uniform sequential color table viridis [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![water](colortables/water.png) &nbsp;&nbsp;&nbsp;&nbsp;**water**: water depth [range: map values]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;![wave](colortables/wave.png) &nbsp;&nbsp;&nbsp;&nbsp;**wave**: color wave [range: map values]  
    **raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **raster_3d** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map from which to copy color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **rules** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to rules file  
    &nbsp;&nbsp;&nbsp;&nbsp;"-" to read rules from stdin  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **offset** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Offset for color rule values  
    &nbsp;&nbsp;&nbsp;&nbsp;New value = (old value + offset) \* scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale for color rule values  
    &nbsp;&nbsp;&nbsp;&nbsp;New value = (old value + offset) \* scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *w*, *l*, *d*, *n*, *g*, *a*, *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove existing color table  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only write new color table if it does not already exist  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available rules then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available rules with description then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;If a color rule is given, only this rule is listed  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert colors  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logarithmic-absolute scaling  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Histogram equalization  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.colors* allows the user to create and/or modify the color table for a
raster map or several raster maps at once. The raster maps (specified on
the command line by **map** or as **file** using an input file with one
map name per line) must exist in the user's current mapset search path.

The **raster** option allows user to specify a raster map *name* from
which to copy the color map.

The **raster_3d** option allows user to specify a 3D raster map *name*
from which to copy the color map.

The **-e** flag equalizes the original raster's color table. It can
preclude the need for *grey.eq* rule, when used as **-e color**=*grey*.
Note however, that this will not yield a color table identical to
*color=grey.eq*, because *grey.eq* scales the fraction by 256 to get a
grey level, while **-e** uses it to interpolate the original color
table. If the original color table is a 0-255 grey scale, **-e** is
effectively scaling the fraction by 255. Different algorithms are used.
**-e** is designed to work with any color table, both the floating point
and the integer raster maps.

The **-g** flag divides the raster's grey value range into 100
logarithmically equal steps (where "step" is a rule with the same grey
level for the start and end points). It can preclude the need for
*grey.log* rule, when used as **-g color**=*grey*. Note however, that
this will not yield a color table identical to *color=grey.log*.
Different algorithms are used. Unlike **color**=*grey.log*, **-g** is
designed to work with both floating point and integer rasters, without
performance issues with large datasets, of any original color table.
Logarithmic scaling doesn't work on negative values. In the case when
the value range includes zero, there's no realistic solution.

The **-e** and **-g** flags are not mutually exclusive.

**offset** and **scale** modify color rules to match the values of a
raster map using the formula *new_value = (old_value + offset) x scale*.
For example, if the units of a raster map are Kelvin x 50, the color
rules *celsius* can be applied with *offset=273.15* and *scale=50*.

If the user specifies the **-w** flag, the current color table file for
the input map will not be overwritten. This means that the color table
is created only if the *map* does not already have a color table. If
this option is not specified, the color table will be created if one
does not exist, or modified if it does.

Color table types *aspect, grey, grey.eq* (histogram-equalized grey
scale), *byg* (blue-yellow-green), *byr* (blue-yellow-red), *gyr*
(green-yellow-red), *rainbow, ramp, ryg* (red-yellow-green), *random*,
and *wave* are pre-defined color tables that *r.colors* knows how to
create without any further input.

In case several input raster maps are provided the range (min, max) of
all maps will be used for color table creation. Hence the created color
table will span from the smallest minimum to the largest maximum value
of all input raster maps and will be applied to all input raster maps.

In general, tables which associate colors with percentages (aspect,
bcyr, byg, byr, elevation, grey, gyr, rainbow, ramp, ryb, ryg and wave)
can be applied to any data, while those which use absolute values
(aspectcolr, curvature, etopo2, evi, ndvi, population, slope, srtm, and
terrain) only make sense for data with certain ranges. One can get a
rough idea of the applicability of a colour table by reading the
corresponding rules file (`$GISBASE/etc/colors/<name>`). For example the
*slope* rule is defined as:

```sh
0  255:255:255
2  255:255:0
5  0:255:0
10 0:255 255
15 0:0:255
30 255:0:255
50 255:0:0
90 0:0:0
```

This is designed for the slope map generated by
*[r.slope.aspect](r.slope.aspect.md)*, where the value is a slope angle
between 0 and 90 degrees.

Similarly, the *aspectcolr* rule:

```sh
0 white
1 yellow
90 green
180 cyan
270 red
360 yellow
```

is designed for the aspect maps produced by
*[r.slope.aspect](r.slope.aspect.md)*, where the value is a heading
between 0 and 360 degrees.

The **rules** color table type will cause *r.colors* to read color table
specifications from standard input (stdin) and will build the color
table accordingly.

Using color table type **rules**, there are two ways to build a color
table: by category values and by "percent" values.

To build a color table by category values' indices, the user should
determine the range of category values in the raster map with which the
color table will be used. Specific category values will then be
associated with specific colors. Note that a color does not have to be
assigned for every valid category value because *r.colors* will
interpolate a color ramp to fill in where color specification rules have
been left out. The format of such a specification is as follows:

```sh
category_value color_name
category_value color_name
.. ..
.. ..
category_value color_name
end
```

Each category value must be valid for the raster map, category values
must be in ascending order and only use standard GRASS color names
(aqua, black, blue, brown, cyan, gray, green, grey, indigo, magenta,
orange, purple, red, violet, white, yellow).

Colors can also be specified by color numbers each in the range 0-255.
The format of a category value color table specification using color
numbers instead of color names is as follows:

```sh
category_value red_number:green_number:blue_number
category_value red_number:green_number:blue_number
.. .. .. ..
.. .. .. ..
category_value red_number:green_number:blue_number
end
```

Specifying a color table by "percent" values allows one to treat a color
table as if it were numbered from 0 to 100. The format of a "percent"
value color table specification is the same as for a category value
color specification, except that the category values are replaced by
"percent" values, each from 0-100, in ascending order. The format is as
follows:

```sh
percent_value% color_name
percent_value% color_name
.. ..
.. ..
percent_value% color_name
end
```

Using "percent" value color table specification rules, colors can also
be specified by color numbers each in the range 0-255. The format of a
percent value color table specification using color numbers instead of
color names is as follows:

```sh
percent_value% red_number:green_number:blue_number
percent_value% red_number:green_number:blue_number
.. .. .. ..
.. .. .. ..
percent_value% red_number:green_number:blue_number
end
```

Note that you can also mix these two methods of color table
specification; for example:

```sh
0 black
10% yellow
78 blue
100% 0:255:230
end
```

To set the NULL (no data) color, use the "nv" (null values) parameter:

```sh
0 black
10% yellow
nv white
end
```

To set the color to used for undefined values (beyond the range of the
color rules) use the "default" parameter:

```sh
0 red
1 blue
default grey
end
```

## NOTES

All color tables are stored in `$GISBASE/etc/colors/`. Further
user-defined color tables can also be stored in this directory for
access from the *color* parameter or in a user defined directory. See
also *r.colors.out* for printing color tables easily to the terminal.

The color table assigned to a raster map is stored in
`$GISDBASE/location/mapset/colr/`.

## EXAMPLES

The below example shows how you can specify colors for a three category
map, assigning red to category 1, green to category 2, and blue to
category 3. Start by using a text editor to create the following rules
specification file (save it with the name *rules.file*):

```sh
1 red
2 green
3 blue
end
```

The color table can then by assigned to map *threecats* by the following
GRASS commands (two ways are available):

```sh
# read input from stdin
cat rules.file | r.colors map=threecats rules=-

# read directly from file
r.colors map=threecats rules=rules.file
```

To create a natural looking lookup table (LUT) for true map layer
*elevation*, use the following rules specification file. It will assign
light green shades to the lower elevations (first 20% of the LUT), and
then darker greens (next 15%, and next 20%) and light browns (next 20%)
for middle elevations, and darker browns (next 15%) for higher
elevations, and finally yellow for the highest peaks (last 10% of LUT).

```sh
0% 0:230:0
20% 0:160:0
35% 50:130:0
55% 120:100:30
75% 120:130:40
90% 170:160:50
100% 255:255:100
```

To invert the current rules:

```sh
r.colors map=current_raster -n rast=current_raster
```

## SEE ALSO

*[d.colortable](d.colortable.md), [d.histogram](d.histogram.md),
[d.legend](d.legend.md), [r.colors.out](r.colors.out.md)
[r.colors.stddev](r.colors.stddev.md), [r.support](r.support.md),
[r.univar](r.univar.md), [v.colors](v.colors.md),
[v.colors.out](v.colors.out.md), [r3.colors](r3.colors.md),
[r3.colors.out](r3.colors.out.md)*

See also wiki page [Color
tables](https://grasswiki.osgeo.org/wiki/Color_tables) (from GRASS User
Wiki)

[ColorBrewer](https://colorbrewer2.org) is an online tool designed to
help people select good color schemes for maps and other graphics.

## AUTHORS

Michael Shapiro and David Johnson  
Support for 3D rasters by Soeren Gebbert

## SOURCE CODE

Available at: [r.colors source code](https://github.com/OSGeo/grass/tree/main/raster/r.colors)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.colors))  
Latest change: Thursday Oct 09 18:01:34 2025 in commit [c32823c](https://github.com/OSGeo/grass/commit/c32823cbb080d14d419b2f734087c7ba396b3e2c)
