---
name: r.li.edgedensity
description: Calculates edge density index on a raster map, using a 4 neighbour algorithm
keywords: [ raster, landscape structure analysis, patch index ]
---

# r.li.edgedensity

Calculates edge density index on a raster map, using a 4 neighbour algorithm

=== "Command line"

    **r.li.edgedensity**
    [**-b**]
    **input**=*name*
    **config**=*name*
    **output**=*name*
    [**patch_type**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.li.edgedensity input=name config=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.li.edgedensity***",
        **input**,
        **config**,
        **output**,
        **patch_type**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.li.edgedensity", input="name", config="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_li_edgedensity*(**input**,
        **config**,
        **output**,
        **patch_type**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_li_edgedensity(input="name", config="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **config**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Configuration file  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **patch_type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value of the patch type  
    &nbsp;&nbsp;&nbsp;&nbsp;It can be integer, double or float; it will be changed in function of map type  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Exclude border edges  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **config** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Configuration file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **patch_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value of the patch type  
    &nbsp;&nbsp;&nbsp;&nbsp;It can be integer, double or float; it will be changed in function of map type  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Exclude border edges  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **config** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Configuration file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **patch_type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value of the patch type  
    &nbsp;&nbsp;&nbsp;&nbsp;It can be integer, double or float; it will be changed in function of map type  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Exclude border edges  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.li.edgedensity* calculates:

- the density of all edges of patch type *k* ![r.li.edgedensity formula
  1](r_li_edgedensity_formula_1.png) , or
- the density of all edges in the sampling area if *k* is not specified,
  ![r.li.edgedensity formula 2](r_li_edgedensity_formula_2.png)

with:

- **k**: patch type
- **m**: number of patch types
- **n**: number of edge segments of patch type k
- **e_ik** :total edge length in the landscape involving patch type *k*
- **Area**: total landscape area

The unit is meters per hectare.

## NOTES

Do not use absolute path names for the **config** and **output**
file/map parameters. If the "moving window" method was selected in
**g.gui.rlisetup**, then the output will be a raster map, otherwise an
ASCII file will be generated in the folder
`C:\Users\userxy\AppData\Roaming\GRASS8\r.li\output\` (MS-Windows) or
`$HOME/.grass8/r.li/output/` (GNU/Linux).

If the input raster map contains only NULL values then
*r.li.edgedensity* consider to have 0 patches.  
If area is 0 *r.li.edgedensity* returns NULL; this is only possible if
input raster is masked.

## EXAMPLES

To calculate the edge density index on map *my_map*, using *my_conf*
configuration file (previously defined with *g.gui.rlisetup*) and saving
results in *my_out*, run:

```sh
r.li.edgedensity input=my_map conf=my_conf output=my_out
```

To calculate edge density index of patch_type 34, using "my_conf"
configuration file and on map "my_map", saving results in "my_out" file
run:  

```sh
r.li.edgedensity input=my_map conf=my_conf output=my_out patch_type=34
```

Forest map (Spearfish sample dataset) example:

```sh
g.region raster=landcover.30m -p
r.mapcalc "forests = if(landcover.30m >= 41 && landcover.30m <= 43,1,null())"
r.li.edgedensity input=forests conf=movwindow7 out=forests_edgedens_mov7
r.univar forests_edgedens_mov7
```

Forest map (North Carolina sample dataset) example:

```sh
g.region raster=landclass96 -p
r.mapcalc "forests = if(landclass96 == 5, 1, null() )"
r.li.edgedensity input=forests conf=movwindow7 out=forests_edgedensity_mov7

# verify
r.univar forests_edgedensity_mov7
r.to.vect input=forests output=forests type=area
d.mon wx0
d.rast forests_edgedensity_mov7
d.vect forests type=boundary
```

## SEE ALSO

*[r.li](r.li.md) (package overview),
[g.gui.rlisetup](g.gui.rlisetup.md)*

## REFERENCES

McGarigal, K., and B. J. Marks. 1995. FRAGSTATS: spatial pattern
analysis program for quantifying landscape structure. USDA For. Serv.
Gen. Tech. Rep. PNW-351. ([PDF](https://doi.org/10.2737/PNW-GTR-351))

## AUTHORS

Serena Pallecchi, student of Computer Science University of Pisa
(Italy).  
Commission from Faunalia Pontedera (PI), Italy (<www.faunalia.it>)  
Markus Metz

## SOURCE CODE

Available at: [r.li.edgedensity source code](https://github.com/OSGeo/grass/tree/main/raster/r.li/r.li.edgedensity)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.li/r.li.edgedensity))  
Latest change: Wednesday Apr 30 17:57:46 2025 in commit [633b026](https://github.com/OSGeo/grass/commit/633b0261cc1d660aa1be383297c3ad1be98f03cd)
