---
name: r.out.png
description: Export a GRASS raster map as a non-georeferenced PNG image.
keywords: [ raster, export, output, PNG ]
---

# r.out.png

Export a GRASS raster map as a non-georeferenced PNG image.

=== "Command line"

    **r.out.png**
    [**-tw**]
    **input**=*name*
    **output**=*name*
    [**compression**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.png input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.png***",
        **input**,
        **output**,
        **compression**=*6*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.png", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_png*(**input**,
        **output**,
        **compression**=*6*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_png(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PNG file (use '-' for stdout)  
    **compression**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compression level of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;(0 = none, 1 = fastest, 9 = best)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Make NULL cells transparent  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output world file  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PNG file (use '-' for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **compression** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compression level of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;(0 = none, 1 = fastest, 9 = best)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Make NULL cells transparent  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output world file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PNG file (use '-' for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **compression** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Compression level of PNG file  
    &nbsp;&nbsp;&nbsp;&nbsp;(0 = none, 1 = fastest, 9 = best)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-9*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *6*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *w*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Make NULL cells transparent  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output world file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.out.png* exports a GRASS raster map in non-georeferenced Portable
Network Graphics (PNG) image format, respecting the current region
resolution and bounds.

Optionally the user can choose to export a World File (.wld) to provide
basic georeferencing support. When used with the transparency flag this
can create images useful for KML, TMS, or WMS overlays. (e.g. for use in
Google Earth or as OpenLayers tiles) If output is redirected to stdout,
the world file will be called `png_map.wld`.

## EXAMPLE

The example is based on the North Carolina sample data.

Export of the soil map to PNG format with world file:

```sh
g.region raster=soils_Kfactor -p
# export PNG file with additional world file
r.out.png input=soils_Kfactor output=soils_Kfactor -w
# verify
gdalinfo soils_Kfactor.png
```

## SEE ALSO

*[r.out.gdal](r.out.gdal.md), [r.out.ppm](r.out.ppm.md),
[r.out.ascii](r.out.ascii.md), [r.import](r.import.md)*

## AUTHORS

Alex Shevlakov  
Hamish Bowman

## SOURCE CODE

Available at: [r.out.png source code](https://github.com/OSGeo/grass/tree/main/raster/r.out.png)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.out.png))  
Latest change: Tuesday May 20 11:33:36 2025 in commit [8efb37c](https://github.com/OSGeo/grass/commit/8efb37cb1f4948e3e157a34b72071bacc35ec8df)
