---
name: r.surf.area
description: Prints estimation of surface area for raster map.
keywords: [ raster, surface, statistics, area estimation ]
---

# r.surf.area

Prints estimation of surface area for raster map.

=== "Command line"

    **r.surf.area**
    **map**=*name*
    [**vscale**=*float*]
    [**units**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.surf.area map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.surf.area***",
        **map**,
        **vscale**=*1.0*,
        **units**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.surf.area", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_surf_area*(**map**,
        **vscale**=*1.0*,
        **units**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_surf_area(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    **vscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: square map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **vscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: square map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **vscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vertical scale  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: square map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *miles, feet, meters, kilometers, acres, hectares*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.surf.area* calculates area of regular 3D triangulated points (centers
of cells) in current region by adding areas of triangles. Therefore,
area of a flat surface will be reported as
(`rows + cols -1) * (area of cell)` less than area of flat region due to
a half row and half column missing around the perimeter.

## NOTES

This calculation is heavily dependent on data resolution (think of it as
a fractal shoreline problem, the more resolution the more detail, the
more area, etc). This module uses the **current region settings**, not
the resolution of the raster map. This is especially important for
surfaces with `NULL` values and highly irregular edges. The module does
not \[currently\] attempt to correct for the error introduced by this
*edge effect*.

This version actually calculates area twice for each triangle pair,
keeping a running minimum and maximum area depending on the direction of
the diagonal used.

Reported totals are:

1. "Plan" area of `NULL` values within the current GRASS region
2. "Plan" area within calculation region (`rows-1 * cols-1 * cellarea`)
3. Average of the minimum and maximum calculated 3d triangle area
    within this region
4. "Plan" area within current computational region
    (`rows * cols * cellarea`)
5. Scaling of calculated area to current region

*r.surf.area* works best when the surface being evaluated extends to the
edges of the current region and the cell resolution is small. Surfaces
which are especially long and thin and have highly irregular boundaries
will tend to have underestimated surface areas. Setting a high cell
resolution (small area) will greatly reduce this impact, but will cause
longer processing times.

## EXAMPLES

```sh
g.region -p raster=elevation

r.surf.area map=elevation units=hectares
Null value area ignored in calculation: 0.000000
Plan area used in calculation: 20221.510000
Surface area calculation(low, high, avg):
        20294.310421 20320.936368 20307.623395
Current region plan area: 20250.000000
Estimated region Surface Area: 20336.234719
```

## SEE ALSO

*[g.region](g.region.md), [r.surf.idw](r.surf.idw.md),
[r.surf.fractal](r.surf.fractal.md), [r.surf.gauss](r.surf.gauss.md),
[r.volume](r.volume.md), [r.slope.aspect](r.slope.aspect.md),
[v.to.rast](v.to.rast.md)*

## AUTHOR

Bill Brown, USACERL December 21, 1994  
Modified for floating point rasters and `NULL` values by Eric G. Miller
(October 17, 2000)  
Updated for GRASS 7, and units option by Martin Landa, Czech Technical
University in Prague, Czech Republic (October 2011)

## SOURCE CODE

Available at: [r.surf.area source code](https://github.com/OSGeo/grass/tree/main/raster/r.surf.area)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.surf.area))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
