---
name: t.rast.neighbors.py
description: Performs a neighborhood analysis for each map in a space time raster dataset.
keywords: [ temporal, aggregation, raster, time ]
---

# t.rast.neighbors.py

Performs a neighborhood analysis for each map in a space time raster dataset.

=== "Command line"

    **t.rast.neighbors.py**
    [**-cenr**]
    **input**=*name*
    **output**=*name*
    [**where**=*sql_query*]
    [**region_relation**=*string*]
    [**selection**=*name*]
    [**size**=*integer*]
    **method**=*string*
    [**weighting_function**=*string*]
    [**weighting_factor**=*float*]
    [**weight**=*name*]
    [**quantile**=*float* [,*float*,...]]
    **basename**=*string*
    [**suffix**=*string*]
    [**semantic_labels**=*string*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.neighbors.py input=name output=name method=average basename=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.neighbors.py***",
        **input**,
        **output**,
        **where**=*None*,
        **region_relation**=*None*,
        **selection**=*None*,
        **size**=*3*,
        **method**=*"average"*,
        **weighting_function**=*"none"*,
        **weighting_factor**=*None*,
        **weight**=*None*,
        **quantile**=*None*,
        **basename**,
        **suffix**=*"gran"*,
        **semantic_labels**=*"input"*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.neighbors.py", input="name", output="name", method="average", basename="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_neighbors_py*(**input**,
        **output**,
        **where**=*None*,
        **region_relation**=*None*,
        **selection**=*None*,
        **size**=*3*,
        **method**=*"average"*,
        **weighting_function**=*"none"*,
        **weighting_factor**=*None*,
        **weight**=*None*,
        **quantile**=*None*,
        **basename**,
        **suffix**=*"gran"*,
        **semantic_labels**=*"input"*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_neighbors_py(input="name", output="name", method="average", basename="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **region_relation**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Process only maps with this spatial relation to the current computational region  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *overlaps,  contains,  is_contained*  
    **selection**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an input raster map to select the cells which should be processed  
    **size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation to be performed on the raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, range, stddev, sum, count, variance, diversity, interspersion, quart1, quart3, perc90, quantile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *average*  
    **weighting_function**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Weighting function  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, gaussian, exponential, file*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    &nbsp;&nbsp;&nbsp;&nbsp;**none**: No weighting  
    &nbsp;&nbsp;&nbsp;&nbsp;**gaussian**: Gaussian weighting function  
    &nbsp;&nbsp;&nbsp;&nbsp;**exponential**: Exponential weighting function  
    &nbsp;&nbsp;&nbsp;&nbsp;**file**: File with a custom weighting matrix  
    **weighting_factor**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor used in the selected weighting function (ignored for weighting_function=none and file)  
    **weight**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file containing weights  
    **quantile**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Quantile to calculate for method=quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    **basename**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **semantic_labels**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set semantic labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, method*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: copy semantic labels from input to output  
    &nbsp;&nbsp;&nbsp;&nbsp;**method**: append method name to input label if existing, otherwise use method name  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.neighbor processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use circular neighborhood  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extend existing space time raster dataset  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Register Null maps  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore the current region settings and use the raster map regions  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **region_relation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Process only maps with this spatial relation to the current computational region  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *overlaps,  contains,  is_contained*  
    **selection** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an input raster map to select the cells which should be processed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation to be performed on the raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, range, stddev, sum, count, variance, diversity, interspersion, quart1, quart3, perc90, quantile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *average*  
    **weighting_function** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Weighting function  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, gaussian, exponential, file*  
    &nbsp;&nbsp;&nbsp;&nbsp;**none**: No weighting  
    &nbsp;&nbsp;&nbsp;&nbsp;**gaussian**: Gaussian weighting function  
    &nbsp;&nbsp;&nbsp;&nbsp;**exponential**: Exponential weighting function  
    &nbsp;&nbsp;&nbsp;&nbsp;**file**: File with a custom weighting matrix  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **weighting_factor** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor used in the selected weighting function (ignored for weighting_function=none and file)  
    **weight** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file containing weights  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **quantile** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quantile to calculate for method=quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **semantic_labels** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set semantic labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, method*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: copy semantic labels from input to output  
    &nbsp;&nbsp;&nbsp;&nbsp;**method**: append method name to input label if existing, otherwise use method name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.neighbor processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *e*, *n*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use circular neighborhood  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend existing space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register Null maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore the current region settings and use the raster map regions  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **region_relation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Process only maps with this spatial relation to the current computational region  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *overlaps,  contains,  is_contained*  
    **selection** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an input raster map to select the cells which should be processed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood size  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation to be performed on the raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, range, stddev, sum, count, variance, diversity, interspersion, quart1, quart3, perc90, quantile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *average*  
    **weighting_function** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Weighting function  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *none, gaussian, exponential, file*  
    &nbsp;&nbsp;&nbsp;&nbsp;**none**: No weighting  
    &nbsp;&nbsp;&nbsp;&nbsp;**gaussian**: Gaussian weighting function  
    &nbsp;&nbsp;&nbsp;&nbsp;**exponential**: Exponential weighting function  
    &nbsp;&nbsp;&nbsp;&nbsp;**file**: File with a custom weighting matrix  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *none*  
    **weighting_factor** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor used in the selected weighting function (ignored for weighting_function=none and file)  
    **weight** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file containing weights  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **quantile** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quantile to calculate for method=quantile  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **semantic_labels** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set semantic labels  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input, method*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**: copy semantic labels from input to output  
    &nbsp;&nbsp;&nbsp;&nbsp;**method**: append method name to input label if existing, otherwise use method name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.neighbor processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *e*, *n*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use circular neighborhood  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extend existing space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register Null maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore the current region settings and use the raster map regions  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast.neighbors* performs [r.neighbors](r.neighbors.md) computations
on the maps of a space time raster dataset (STRDS). This module supports
the options that are available in [r.neighbors](r.neighbors.md).

The user must provide an input and an output space time raster dataset
and the basename of the resulting raster maps. The resulting STRDS will
have the same temporal resolution as the input dataset. With the **-e**
flag, resulting maps can be registered in an existing STRDS, that e.g.
may have been created with a previous run of *t.rast.neighbors*. All
maps will be processed using the current region settings unless the
**-r** flag is selected. In the latter case, the computaional region is
set to each raster map selected from the input STRDS.

The user can select a subset of the input space time raster dataset for
processing using a SQL WHERE statement or using the **region_relation**
for spatial selection of raster maps. For the spatial map selection the
current computational region is used, even when the **-r** flag is
given. The number of CPU's to be used for parallel processing can be
specified with the *nprocs* option to speedup the computation on
multi-core system.

Semantic labels are needed to relate output raster maps to input raster
maps. E.g. with *method=stddev*, the user needs to know the spatial
extent, the time stamp and the semantic label to determine which stddev
map corresponds to which input map.

## EXAMPLE

To smooth the maps contained in a space time dataset run:

```sh
t.rast.neighbors input=tempmean_monthly output=smooth_tempmean_monthly \
                 basename=tmean_smooth size=5 method=average nprocs=4

# show some info about the new space time dataset
t.info smooth_tempmean_monthly
 +-------------------- Space Time Raster Dataset -----------------------------+
 |                                                                            |
 +-------------------- Basic information -------------------------------------+
 | Id: ........................ smooth_tempmean_monthly@climate_2000_2012
 | Name: ...................... smooth_tempmean_monthly
 | Mapset: .................... climate_2000_2012
 | Creator: ................... lucadelu
 | Temporal type: ............. absolute
 | Creation time: ............. 2014-11-27 11:41:36.444579
 | Modification time:.......... 2014-11-27 11:41:39.978232
 | Semantic type:.............. mean
 +-------------------- Absolute time -----------------------------------------+
 | Start time:................. 2009-01-01 00:00:00
 | End time:................... 2013-01-01 00:00:00
 | Granularity:................ 1 month
 | Temporal type of maps:...... interval
 +-------------------- Spatial extent ----------------------------------------+
 | North:...................... 320000.0
 | South:...................... 10000.0
 | East:.. .................... 935000.0
 | West:....................... 120000.0
 | Top:........................ 0.0
 | Bottom:..................... 0.0
 +-------------------- Metadata information ----------------------------------+
 | Raster register table:...... raster_map_register_ea1c9a83524e41a784d72744b08c6107
 | North-South resolution min:. 500.0
 | North-South resolution max:. 500.0
 | East-west resolution min:... 500.0
 | East-west resolution max:... 500.0
 | Minimum value min:.......... -6.428905
 | Minimum value max:.......... 18.867296
 | Maximum value min:.......... 4.247691
 | Maximum value max:.......... 28.767953
 | Aggregation type:........... None
 | Number of registered maps:.. 48
 |
 | Title:
 | Monthly precipitation
 | Description:
 | Dataset with monthly precipitation
 | Command history:
 | # 2014-11-27 11:41:36
 | t.rast.neighbors input="tempmean_monthly"
 |     output="smooth_tempmean_monthly" basename="tmean_smooth" size="5"
 |     method="average" nprocs="4"
 |
 +----------------------------------------------------------------------------+


# now compare the values between the original and the smoothed dataset

t.rast.list input=smooth_tempmean_monthly columns=name,start_time,min,max
name|start_time|min|max
tmean_smooth_1|2009-01-01 00:00:00|-3.361714|7.409861
tmean_smooth_2|2009-02-01 00:00:00|-1.820261|7.986794
tmean_smooth_3|2009-03-01 00:00:00|2.912971|11.799684
...
tmean_smooth_46|2012-10-01 00:00:00|9.38767|18.709297
tmean_smooth_47|2012-11-01 00:00:00|1.785653|10.911189
tmean_smooth_48|2012-12-01 00:00:00|1.784212|11.983857

t.rast.list input=tempmean_monthly columns=name,start_time,min,max
name|start_time|min|max
2009_01_tempmean|2009-01-01 00:00:00|-3.380823|7.426054
2009_02_tempmean|2009-02-01 00:00:00|-1.820261|8.006386
2009_03_tempmean|2009-03-01 00:00:00|2.656992|11.819274
...
2012_10_tempmean|2012-10-01 00:00:00|9.070884|18.709297
2012_11_tempmean|2012-11-01 00:00:00|1.785653|10.911189
2012_12_tempmean|2012-12-01 00:00:00|1.761019|11.983857
```

## SEE ALSO

*[r.neighbors](r.neighbors.md),
[t.rast.aggregate.ds](t.rast.aggregate.ds.md),
[t.rast.extract](t.rast.extract.md), [t.info](t.info.md),
[g.region](g.region.md), [r.mask](r.mask.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.rast.neighbors source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast.neighbors)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast.neighbors))  
Latest change: Thursday Dec 18 07:11:47 2025 in commit [cf870a5](https://github.com/OSGeo/grass/commit/cf870a5e49fd2643a55de543467edf5c2e61d640)
