---
hide:
  - toc
---

# Topic: import

| Tool | Description |
|--------|-------------|
| [db.in.ogr](db.in.ogr.md) | Imports attribute tables in various formats. |
| [i.in.spotvgt](i.in.spotvgt.md) | Imports SPOT VGT NDVI data into a raster map. |
| [r.external](r.external.md) | Links GDAL supported raster data as a pseudo GRASS raster map. |
| [r.import](r.import.md) | Imports raster data into a GRASS raster map using GDAL library and reprojects on the fly. |
| [r.in.ascii](r.in.ascii.md) | Converts a GRASS ASCII raster file to binary raster map. |
| [r.in.aster](r.in.aster.md) | Georeference, rectify, and import Terra-ASTER imagery and relative DEMs using gdalwarp. |
| [r.in.bin](r.in.bin.md) | Import a binary raster file into a GRASS raster map layer. |
| [r.in.gdal](r.in.gdal.md) | Imports raster data into a GRASS raster map using GDAL library. |
| [r.in.gridatb](r.in.gridatb.md) | Imports GRIDATB.FOR map file (TOPMODEL) into a GRASS raster map. |
| [r.in.lidar](r.in.lidar.md) | Creates a raster map from LAS LiDAR points using univariate statistics. |
| [r.in.mat](r.in.mat.md) | Imports a binary MAT-File(v4) to a GRASS raster. |
| [r.in.png](r.in.png.md) | Imports non-georeferenced PNG format image. |
| [r.in.poly](r.in.poly.md) | Creates raster maps from ASCII polygon/line/point data files. |
| [r.in.srtm](r.in.srtm.md) | Imports SRTM HGT files into raster map. |
| [r.in.wms](r.in.wms.md) | Downloads and imports data from OGC WMS and OGC WMTS web mapping servers. |
| [r.in.xyz](r.in.xyz.md) | Creates a raster map from an assemblage of many coordinates using univariate statistics. |
| [r.unpack](r.unpack.md) | Imports a GRASS specific raster archive file (packed with r.pack) as a raster map |
| [r3.in.ascii](r3.in.ascii.md) | Converts a 3D ASCII raster text file into a (binary) 3D raster map. |
| [r3.in.bin](r3.in.bin.md) | Imports a binary raster file into a GRASS 3D raster map. |
| [r3.in.lidar](r3.in.lidar.md) | Creates a 3D raster map from LAS LiDAR points using univariate statistics. |
| [r3.in.v5d](r3.in.v5d.md) | Import 3-dimensional Vis5D files. |
| [r3.in.xyz](r3.in.xyz.md) | Create a 3D raster map from an assemblage of many coordinates using univariate statistics |
| [t.rast.import](t.rast.import.md) | Imports space time raster dataset. |
| [t.vect.import](t.vect.import.md) | Imports a space time vector dataset from a GRASS specific archive file. |
| [v.external](v.external.md) | Creates a new pseudo-vector map as a link to an OGR-supported layer or a PostGIS feature table. |
| [v.import](v.import.md) | Imports vector data into a GRASS vector map using OGR library and reprojects on the fly. |
| [v.in.ascii](v.in.ascii.md) | Creates a vector map from an ASCII points file or ASCII vector file. |
| [v.in.db](v.in.db.md) | Creates new vector (points) map from database table containing coordinates. |
| [v.in.dxf](v.in.dxf.md) | Converts file in DXF format to GRASS vector map. |
| [v.in.e00](v.in.e00.md) | Imports E00 file into a vector map. |
| [v.in.geonames](v.in.geonames.md) | Imports geonames.org country files into a vector points map. |
| [v.in.lidar](v.in.lidar.md) | Converts LAS LiDAR point clouds to a GRASS vector map with libLAS. |
| [v.in.lines](v.in.lines.md) | Imports ASCII x,y[,z] coordinates as a series of lines. |
| [v.in.mapgen](v.in.mapgen.md) | Imports Mapgen or Matlab-ASCII vector maps into GRASS. |
| [v.in.ogr](v.in.ogr.md) | Imports vector data into a GRASS vector map using OGR library. |
| [v.in.wfs](v.in.wfs.md) | Imports GetFeature from a WFS server. |
| [v.unpack](v.unpack.md) | Imports a GRASS specific vector archive file (packed with v.pack) as a vector map |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [import] } -->
