---
name: v.drape
description: Converts 2D vector features to 3D by sampling of elevation raster map.
keywords: [ vector, geometry, sampling, 3D, surface information ]
---

# v.drape

Converts 2D vector features to 3D by sampling of elevation raster map.

=== "Command line"

    **v.drape**
    **input**=*name*
    [**layer**=*string*]
    [**cats**=*range*]
    [**where**=*sql_query*]
    [**type**=*string* [,*string*,...]]
    **output**=*name*
    **elevation**=*name*
    [**method**=*string*]
    [**scale**=*float*]
    [**null_value**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.drape input=name output=name elevation=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.drape***",
        **input**,
        **layer**=*"-1"*,
        **cats**=*None*,
        **where**=*None*,
        **type**=*"point,line,boundary,centroid"*,
        **output**,
        **elevation**,
        **method**=*"nearest"*,
        **scale**=*1.0*,
        **null_value**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.drape", input="name", output="name", elevation="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_drape*(**input**,
        **layer**=*"-1"*,
        **cats**=*None*,
        **where**=*None*,
        **type**=*"point,line,boundary,centroid"*,
        **output**,
        **elevation**,
        **method**=*"nearest"*,
        **scale**=*1.0*,
        **null_value**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_drape(input="name", output="name", elevation="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation raster map for height extraction  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling interpolation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: Nearest-neighbor interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    **scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor sampled raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **null_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for sampled raster NULL values  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation raster map for height extraction  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling interpolation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: Nearest-neighbor interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor sampled raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **null_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for sampled raster NULL values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation raster map for height extraction  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling interpolation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: Nearest-neighbor interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor sampled raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **null_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for sampled raster NULL values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.drape* converts 2D/3D vector data into 3D vector format via sampling
of an elevation surface. Three sampling algorithms adapted from
*[v.sample](v.sample.md)* were incorporated into this module: nearest
neighbor, bilinear, and cubic convultion.

*v.drape* will skip vector features outside of current computational
region or where raster map has NULL value. It's possible to include all
vector features by specifying height value that will be assigned to
verticles whose values can not be determined from raster map.

## NOTES

Additional vertices can be added to the input 2D vector map with
*[v.split](v.split.md)*.

The module can be used in conjunction with *[v.out.pov](v.out.pov.md)*
and *[r.out.pov](r.out.pov.md)* to export a complete set of vector and
raster data for display in [POVRAY](http://www.povray.org/).

## EXAMPLES

Spearfish example:

```sh
v.drape in=roads elevation=elevation.10m method=bilinear out=roads3d
v.info roads3d
```

Create 3D vector roads map containing only "unimproved" roads. Set road
height to 1000 m for all parts without height information.

```sh
v.drape input=roads type=line elevation=elevation.dem output=roads_3d \
        method=nearest scale=1.0 where='cat=5' layer=1 null_value=1000
```

### POVRAY example

```sh
#export the vector data
v.drape in=roads out=roads3d elevation=elevation.10m
v.out.pov roads3d out=roads3d.pov
#export the raster data
r.out.pov elevation.10m tga=elevation.tga
r.out.png landcover.30m out=landcover30m.png

# now write a complete povray-script and launch povray
```

## SEE ALSO

*[v.extrude](v.extrude.md), [v.to.3d](v.to.3d.md),
[r.out.pov](r.out.pov.md), [v.in.region](v.in.region.md),
[v.out.pov](v.out.pov.md), [v.overlay](v.overlay.md),
[v.split](v.split.md), [v.what.rast](v.what.rast.md)*

## AUTHORS

Dylan Beaudette, University of California at Davis.  
Updated for GRASS 7 by Martin Landa, Czech Technical University in
Prague, Czech Republic

## SOURCE CODE

Available at: [v.drape source code](https://github.com/OSGeo/grass/tree/main/vector/v.drape)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.drape))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
