---
name: v.perturb
description: Random location perturbations of vector points.
keywords: [ vector, geometry, statistics, random, point pattern, level1 ]
---

# v.perturb

Random location perturbations of vector points.

=== "Command line"

    **v.perturb**
    [**-sb**]
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    [**distribution**=*string*]
    **parameters**=*float* [,*float*,...]
    [**minimum**=*float*]
    [**seed**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.perturb input=name output=name parameters=0.0 seed=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.perturb***",
        **input**,
        **layer**=*"-1"*,
        **output**,
        **distribution**=*"uniform"*,
        **parameters**,
        **minimum**=*0.0*,
        **seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.perturb", input="name", output="name", parameters=0.0, seed=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_perturb*(**input**,
        **layer**=*"-1"*,
        **output**,
        **distribution**=*"uniform"*,
        **parameters**,
        **minimum**=*0.0*,
        **seed**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_perturb(input="name", output="name", parameters=0.0, seed=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **distribution**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distribution of perturbation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *uniform, normal*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *uniform*  
    **parameters**=*float* [,*float*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Parameter(s) of distribution  
    &nbsp;&nbsp;&nbsp;&nbsp;If the distribution is uniform, only one parameter, the maximum, is needed. For a normal distribution, two parameters, the mean and standard deviation, are required.  
    **minimum**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum deviation in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed value for the random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;Using the same seed ensures identical results, while a randomly generated seed produces different outcomes in each run.  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **distribution** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distribution of perturbation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *uniform, normal*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *uniform*  
    **parameters** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Parameter(s) of distribution  
    &nbsp;&nbsp;&nbsp;&nbsp;If the distribution is uniform, only one parameter, the maximum, is needed. For a normal distribution, two parameters, the mean and standard deviation, are required.  
    **minimum** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum deviation in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed value for the random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;Using the same seed ensures identical results, while a randomly generated seed produces different outcomes in each run.  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **distribution** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distribution of perturbation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *uniform, normal*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *uniform*  
    **parameters** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Parameter(s) of distribution  
    &nbsp;&nbsp;&nbsp;&nbsp;If the distribution is uniform, only one parameter, the maximum, is needed. For a normal distribution, two parameters, the mean and standard deviation, are required.  
    **minimum** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum deviation in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed value for the random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;Using the same seed ensures identical results, while a randomly generated seed produces different outcomes in each run.  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *b*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed (result is non-deterministic)  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.perturb* reads a vector map of points and writes the same points but
*perturbs* the eastings and northings by adding either a uniform or
normal delta value. Perturbation means that a variating spatial
deviation is added to the coordinates.

## NOTES

The uniform distribution is always centered about zero. The associated
*parameter* is constrained to be positive and specifies the maximum of
the distribution; the minimum is the negation of that parameter. Do
perturb into a ring around the center, the *minimum* parameter can be
used.

Usually, the mean (first parameter) of the normal distribution is zero
(i.e., the distribution is centered at zero). The standard deviation
(second parameter) is naturally constrained to be positive.

Output vector points are not guaranteed to be contained within the
current geographic region.

## EXAMPLES

### Random, uniformly distributed selection

To create a random, uniformly distributed selection of possible new
points with a radius of 100,000 map units, use the following command:

```sh
v.perturb input=comm_colleges output=uniform_perturb parameters=100000
```

Your map should look similar to this figure:

![v.perturb uniform distribution example](v_perturb_uniform.png)  
*Figure: Map showing the actual community college points and uniformly
random chosen points.*

### Normal distributed selection

For a normal distribution with a mean of 5000 and standard deviation of
2000, use the following command:

```sh
v.perturb input=comm_colleges output=normal_perturb distribution=normal parameters=5000,2000
```

![v.perturb normal distribution example](v_perturb_normal.png)  
*Figure: Map showing the actual community college points and normally
random chosen and colored points. Notice that each point is closer to
the original point.*

### Normal distributed selection with a minimum value

In order to include a minimum value of 500, use the following command:

```sh
v.perturb input=comm_colleges output=min_perturb distribution=normal parameters=100000,1000 minimum=500
```

## SEE ALSO

*[v.random](v.random.md), [v.univar](v.univar.md)*

## AUTHORS

[James Darrell McCauley](http://mccauley-usa.com/)  
when he was at: [Agricultural
Engineering](http://ABE.www.ecn.purdue.edu/ABE/) [Purdue
University](http://www.purdue.edu/)

Random number generators originally written in FORTRAN by Wes Peterson
and translated to C using *f2c*.

## SOURCE CODE

Available at: [v.perturb source code](https://github.com/OSGeo/grass/tree/main/vector/v.perturb)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.perturb))  
Latest change: Sunday Jul 27 05:53:30 2025 in commit [da40958](https://github.com/OSGeo/grass/commit/da409580ef15011f3bac379c76d41101c9e36347)
