---
name: d.font
description: Selects the font in which text will be displayed on the user's graphics monitor.
keywords: [ display, settings ]
---

# d.font

Selects the font in which text will be displayed on the user's graphics monitor.

=== "Command line"

    **d.font**
    [**-lv**]
    [**font**=*string*]
    [**path**=*name*]
    [**charset**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.font
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.font***",
        **font**=*"romans"*,
        **path**=*None*,
        **charset**=*"UTF-8"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.font")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_font*(**font**=*"romans"*,
        **path**=*None*,
        **charset**=*"UTF-8"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_font()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **font**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose new current font  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *romans*  
    **path**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to Freetype-compatible font including file name  
    **charset**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Character encoding  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UTF-8*  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List fonts  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;List fonts verbosely  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose new current font  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *romans*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to Freetype-compatible font including file name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Character encoding  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UTF-8*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *v*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List fonts  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List fonts verbosely  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **font** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose new current font  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *romans*  
    **path** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to Freetype-compatible font including file name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **charset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Character encoding  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *UTF-8*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l*, *v*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List fonts  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List fonts verbosely  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.font* allows the user to select use of a specific text font for
display of text on the graphics monitor. If the user does not specify a
font when using other GRASS programs that display text, the font type
*romans* is used by default.

The user can run this program either non-interactively or interactively.
If the user specifies a font type name on the command line the program
will run non-interactively. Alternately, the user can simply type
**d.font** on the command line; in this case, the program will prompt
the user for a display text font type.

Font options (italized):

- *cyrilc*: Cyrillic
- *gothgbt*: Gothic Great Britain triplex
- *gothgrt*: Gothic German triplex
- *gothitt*: Gothic Italian triplex
- *greekc*: Greek complex
- *greekcs*: Greek complex script
- *greekp*: Greek plain
- *greeks*: Greek simplex
- *italicc*: Italian complex
- *italiccs*: Italian complex small
- *italict*: Italian triplex
- *romanc*: Roman complex
- *romancs*: Roman complex small
- *romand*: Roman duplex
- *romanp*: Roman plain
- *romans*: Roman simplex
- *romant*: Roman triplex
- *scriptc*: Script complex
- *scripts*: Script simplex

## NOTES

The font type *romans* is the fastest font type to display to the
graphics monitor.

## SEE ALSO

*[d.text](d.text.md)*  
*[d.title](d.title.md)*

## AUTHOR

James Westervelt, U.S. Army Construction Engineering Research Laboratory

*d.font* uses the public domain version of the Hershey Fonts created by
Dr. A.V. Hershey while working at the U.S. National Bureau of Standards.

## SOURCE CODE

Available at: [d.font source code](https://github.com/OSGeo/grass/tree/main/display/d.font)
([history](https://github.com/OSGeo/grass/commits/main/display/d.font))  
Latest change: Monday Feb 24 16:07:55 2025 in commit [4ab71fd](https://github.com/OSGeo/grass/commit/4ab71fd34113b347c3c86c736cd82ca0f6be1d4b)
