---
name: db.univar.py
description: Calculates univariate statistics on selected table column.
keywords: [ database, statistics, attribute table ]
---

# db.univar.py

Calculates univariate statistics on selected table column.

=== "Command line"

    **db.univar.py**
    [**-eg**]
    **table**=*name*
    **column**=*name*
    [**database**=*name*]
    [**driver**=*name*]
    [**where**=*sql_query*]
    [**percentile**=*float* [,*float*,...]]
    **format**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.univar.py table=name column=name format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***db.univar.py***",
        **table**,
        **column**,
        **database**=*None*,
        **driver**=*None*,
        **where**=*None*,
        **percentile**=*90*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("db.univar.py", table="name", column="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_univar_py*(**table**,
        **column**,
        **database**=*None*,
        **driver**=*None*,
        **where**=*None*,
        **percentile**=*90*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_univar_py(table="name", column="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **table**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column on which to calculate statistics (must be numeric)  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, sqlite, pg*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **percentile**=*float* [,*float*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json, shell*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: Shell script style for Bash eval  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extended statistics (quartiles and 90th percentile)  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column on which to calculate statistics (must be numeric)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, sqlite, pg*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **percentile** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json, shell*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: Shell script style for Bash eval  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extended statistics (quartiles and 90th percentile)  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column on which to calculate statistics (must be numeric)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, odbc, ogr, sqlite, pg*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **percentile** : float | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentile to calculate (requires extended statistics flag)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-100*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *90*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, json, shell*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**shell**: Shell script style for Bash eval  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extended statistics (quartiles and 90th percentile)  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print stats in shell script style [deprecated]  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;This flag is deprecated and will be removed in a future release. Use format=shell instead.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.univar* calculates basic univariate statistics for numeric
attributes in a data table. It will calculate minimum, maximum, range,
mean, standard deviation, variance, coefficient of variation, quartiles,
median, and 90th percentile. It uses *db.select* to create list values
for statistical calculations. *NOTES* If the database and driver are not
specified, the default values set in *db.connect* will be used.

## EXAMPLE

In this example, random points are sampled from the elevation map (North
Carolina sample dataset) and univariate statistics performed:

```sh
g.region raster=elevation -p
v.random output=samples n=100
v.db.addtable samples column="heights double precision"
v.what.rast samples raster=elevation column=heights
v.db.select samples

db.univar samples column=heights
```

### Python example with JSON output

Using the example above, print the 90th percentile in Python:

```python
import grass.script as gs

data = gs.parse_command(
    "db.univar", table="samples", column="heights", format="json", flags="e"
)
print(data["percentiles"])
```

Output:

```text
[{'percentile': 90.0, 'value': 139.0807}]
```

The JSON will look like this:

```json
{
    "n": 100,
    "min": 62.71209,
    "max": 147.2162,
    "range": 84.50410999999998,
    "mean": 110.95470289999996,
    "mean_abs": 110.95470289999996,
    "variance": 362.63393287085927,
    "stddev": 19.042949689343278,
    "coeff_var": 0.17162814366242862,
    "sum": 11095.470289999996,
    "first_quartile": 95.56498,
    "median": 107.5519,
    "third_quartile": 125.1526,
    "percentiles": [
        {
            "percentile": 90.0,
            "value": 139.0807
        }
    ]
}
```

## SEE ALSO

*[v.db.univar](v.db.univar.md), [r.univar](r.univar.md),
[v.univar](v.univar.md), [db.select](db.select.md),
[d.vect.thematic](d.vect.thematic.md)*

## AUTHORS

Michael Barton, Arizona State University

and authors of *r.univar.sh*

## SOURCE CODE

Available at: [db.univar source code](https://github.com/OSGeo/grass/tree/main/scripts/db.univar)
([history](https://github.com/OSGeo/grass/commits/main/scripts/db.univar))  
Latest change: Saturday Feb 14 00:16:26 2026 in commit [c9d0784](https://github.com/OSGeo/grass/commit/c9d078496b7ba57d5f9b2120b3304b3c5de38b7d)
