---
name: g.gui.dbmgr
description: Launches graphical attribute table manager.
keywords: [ general, GUI, attribute table, database ]
title: g.gui.dbmgr
description: wxGUI Attribute Table Manager
index: topic_GUI|GUI
---

# g.gui.dbmgr

Launches graphical attribute table manager.

=== "Command line"

    **g.gui.dbmgr**
    **map**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.gui.dbmgr map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.gui.dbmgr***",
        **map**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.gui.dbmgr", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_gui_dbmgr*(**map**,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_gui_dbmgr(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The **Attribute Table Manager** is a *[wxGUI](wxGUI.md)* component to
query, edit, and manage attribute data for vector maps. The attribute
table manager can be launched by clicking on icon
![icon](icons/table.png) in the toolbar. It's also available as a
stand-alone module *g.gui.dbmgr*.

*Attribute table manager* allows you to:

- browse attribute data of vector map, perform SQL select statements;
- modify attribute data, insert new records to attribute table, delete
  existing records;
- highlight selected items in the Map Display Window;
- extract selected items into a new vector map;
- modify attribute table - add, drop, rename columns;
- modify vector map DB connection settings - add, remove or modify
  layers.

![Attribute Table Manager](dbmgr_frame.png)  
*Figure: Simple attribute filtering using Attribute Table Manager.*

### SQL Builder

![Attribute Table Manager and SQL Builder](dbmgr_sql_builder.png)  
*Figure: Attribute filtering using Attribute Table Manager and SQL
Builder.*

## SEE ALSO

*[wxGUI](wxGUI.md), [wxGUI components](wxGUI.components.md)*

*[db.columns](db.columns.md), [db.connect](db.connect.md),
[db.describe](db.describe.md), [db.drivers](db.drivers.md),
[db.execute](db.execute.md), [db.select](db.select.md),
[db.tables](db.tables.md)*

*[v.db.addcolumn](v.db.addcolumn.md), [v.db.connect](v.db.connect.md),
[v.db.dropcolumn](v.db.dropcolumn.md),
[v.db.renamecolumn](v.db.renamecolumn.md), [v.what](v.what.md)*

See also
[wiki](https://grasswiki.osgeo.org/wiki/WxGUI_Attribute_Table_Manager)
page including [video
tutorials](https://grasswiki.osgeo.org/wiki/WxGUI_Attribute_Table_Manager#Video_tutorials).

## AUTHORS

Martin Landa, [FBK-irst](https://www.fbk.eu) (2007-2008), Trento, Italy,
and OSGeoREL at the Czech Technical University in Prague, Czech
Republic  
Michael Barton, Arizona State University, USA  
Jachym Cepicky

## SOURCE CODE

Available at: [g.gui.dbmgr source code](https://github.com/OSGeo/grass/tree/main/gui/wxpython/dbmgr)
([history](https://github.com/OSGeo/grass/commits/main/gui/wxpython/dbmgr))  
Latest change: Wednesday Jan 28 08:16:26 2026 in commit [0a9db34](https://github.com/OSGeo/grass/commit/0a9db34657dc4900ba35d6476b890c13d118c669)
