---
name: i.landsat.acca
description: Performs Landsat TM/ETM+ Automatic Cloud Cover Assessment (ACCA).
keywords: [ imagery, ACCA, cloud detection, satellite, Landsat ]
---

# i.landsat.acca

Performs Landsat TM/ETM+ Automatic Cloud Cover Assessment (ACCA).

=== "Command line"

    **i.landsat.acca**
    [**-5fx2s**]
    **input**=*basename*
    **output**=*name*
    [**b56composite**=*float*]
    [**b45ratio**=*float*]
    [**histogram**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    i.landsat.acca input=basename output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***i.landsat.acca***",
        **input**,
        **output**,
        **b56composite**=*225.*,
        **b45ratio**=*1.*,
        **histogram**=*100*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("i.landsat.acca", input="basename", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.i_landsat_acca*(**input**,
        **output**,
        **b56composite**=*225.*,
        **b45ratio**=*1.*,
        **histogram**=*100*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.i_landsat_acca(input="basename", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*basename* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name of input raster bands  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 'B.' for B.1, B.2, ...  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **b56composite**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;B56composite (step 6)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *225.*  
    **b45ratio**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;B45ratio: Desert detection (step 10)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.*  
    **histogram**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes in the cloud temperature histogram  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **-5**  
    &nbsp;&nbsp;&nbsp;&nbsp;Data is Landsat-5 TM  
    &nbsp;&nbsp;&nbsp;&nbsp;I.e. Thermal band is '.6' not '.61')  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Apply post-processing filter to remove small holes  
    **-x**  
    &nbsp;&nbsp;&nbsp;&nbsp;Always use cloud signature (step 14)  
    **-2**  
    &nbsp;&nbsp;&nbsp;&nbsp;Bypass second-pass processing, and merge warm (not ambiguous) and cold clouds  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Include a category for cloud shadows  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name of input raster bands  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 'B.' for B.1, B.2, ...  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *basename*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **b56composite** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;B56composite (step 6)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *225.*  
    **b45ratio** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;B45ratio: Desert detection (step 10)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.*  
    **histogram** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes in the cloud temperature histogram  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *5*, *f*, *x*, *2*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**5**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Data is Landsat-5 TM  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;I.e. Thermal band is '.6' not '.61')  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Apply post-processing filter to remove small holes  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Always use cloud signature (step 14)  
    &nbsp;&nbsp;&nbsp;&nbsp;**2**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bypass second-pass processing, and merge warm (not ambiguous) and cold clouds  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include a category for cloud shadows  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name of input raster bands  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 'B.' for B.1, B.2, ...  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *basename*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **b56composite** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;B56composite (step 6)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *225.*  
    **b45ratio** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;B45ratio: Desert detection (step 10)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.*  
    **histogram** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes in the cloud temperature histogram  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *5*, *f*, *x*, *2*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**5**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Data is Landsat-5 TM  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;I.e. Thermal band is '.6' not '.61')  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Apply post-processing filter to remove small holes  
    &nbsp;&nbsp;&nbsp;&nbsp;**x**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Always use cloud signature (step 14)  
    &nbsp;&nbsp;&nbsp;&nbsp;**2**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Bypass second-pass processing, and merge warm (not ambiguous) and cold clouds  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Include a category for cloud shadows  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*i.landsat.acca* implements the **Automated Cloud-Cover Assessment**
(ACCA) Algorithm from Irish (2000) with the constant values for pass
filter one from Irish et al. (2006). To do this, it needs Landsat band
numbers 2, 3, 4, 5, and 6 (or band 61 for Landsat-7 ETM+) which have
already been processed from DN into reflectance and band-6 temperature
with *[i.landsat.toar](i.landsat.toar.md)*).

The ACCA algorithm gives good results over most of the planet with the
exception of ice sheets because ACCA operates on the premise that clouds
are colder than the land surface they cover. The algorithm was designed
for Landsat-7 ETM+ but because reflectance is used it is also useful for
Landsat-4/5 TM.

## NOTES

*i.landsat.acca* works in the current region settings.

## EXAMPLES

Run the standard ACCA algorithm with filling of small cloud holes (the
**-f** flag): With per-band reflectance raster maps named
`226_62.toar.1, 226_62.toar.2, ...` and LANDSAT-7 thermal band
`226_62.toar.61`, outputting to a new raster map named `226_62.acca`:

```sh
i.landsat.toar sensor=7 gain=HHHLHLHHL date=2003-04-07 \
  product_date=2008-11-27 band_prefix=226_62 solar_elevation=49.51654

i.landsat.acca -f band_prefix=226_62.toar output=226_62.acca
```

## REFERENCES

- Irish R.R., Barker J.L., Goward S.N., and Arvidson T., 2006.
  Characterization of the Landsat-7 ETM+ Automated Cloud-Cover
  Assessment (ACCA) Algorithm. Photogrammetric Engineering and Remote
  Sensing vol. 72(10): 1179-1188.
- Irish, R.R., 2000. Landsat 7 Automatic Cloud Cover Assessment. In S.S.
  Shen and M.R. Descour (Eds.): Algorithms for Multispectral,
  Hyperspectral, and Ultraspectral Imagery VI. Proceedings of SPIE,
  4049: 348-355.

## SEE ALSO

*[i.atcorr](i.atcorr.md), [i.landsat.toar](i.landsat.toar.md)*

## AUTHOR

E. Jorge Tizado (ej.tizado unileon es), Dept. Biodiversity and
Environmental Management, University of León, Spain

## SOURCE CODE

Available at: [i.landsat.acca source code](https://github.com/OSGeo/grass/tree/main/imagery/i.landsat.acca)
([history](https://github.com/OSGeo/grass/commits/main/imagery/i.landsat.acca))  
Latest change: Sunday Feb 15 15:28:21 2026 in commit [5cee43f](https://github.com/OSGeo/grass/commit/5cee43f83d1d6e0f13eb1bf2a265c2512d8ba7be)
