---
name: r.sim.sediment
description: Sediment transport and erosion/deposition simulation using path sampling method (SIMWE).
keywords: [ raster, hydrology, soil, sediment flow, erosion, deposition, model, parallel ]
---

# r.sim.sediment

Sediment transport and erosion/deposition simulation using path sampling method (SIMWE).

=== "Command line"

    **r.sim.sediment**
    [**-s**]
    **elevation**=*name*
    **water_depth**=*name*
    [**dx**=*name*]
    [**dy**=*name*]
    **detachment_coeff**=*name*
    **transport_coeff**=*name*
    **shear_stress**=*name*
    [**man**=*name*]
    [**man_value**=*float*]
    [**observation**=*name*]
    [**transport_capacity**=*name*]
    [**tlimit_erosion_deposition**=*name*]
    [**sediment_concentration**=*name*]
    [**sediment_flux**=*name*]
    [**erosion_deposition**=*name*]
    [**logfile**=*name*]
    [**walkers_output**=*name*]
    [**nwalkers**=*integer*]
    [**niterations**=*integer*]
    [**mintimestep**=*float*]
    [**output_step**=*integer*]
    [**diffusion_coeff**=*float*]
    [**random_seed**=*integer*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.sim.sediment elevation=name water_depth=name detachment_coeff=name transport_coeff=name shear_stress=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.sim.sediment***",
        **elevation**,
        **water_depth**,
        **dx**=*None*,
        **dy**=*None*,
        **detachment_coeff**,
        **transport_coeff**,
        **shear_stress**,
        **man**=*None*,
        **man_value**=*0.1*,
        **observation**=*None*,
        **transport_capacity**=*None*,
        **tlimit_erosion_deposition**=*None*,
        **sediment_concentration**=*None*,
        **sediment_flux**=*None*,
        **erosion_deposition**=*None*,
        **logfile**=*None*,
        **walkers_output**=*None*,
        **nwalkers**=*None*,
        **niterations**=*10*,
        **mintimestep**=*0.0*,
        **output_step**=*2*,
        **diffusion_coeff**=*0.8*,
        **random_seed**=*None*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.sim.sediment", elevation="name", water_depth="name", detachment_coeff="name", transport_coeff="name", shear_stress="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_sim_sediment*(**elevation**,
        **water_depth**,
        **dx**=*None*,
        **dy**=*None*,
        **detachment_coeff**,
        **transport_coeff**,
        **shear_stress**,
        **man**=*None*,
        **man_value**=*0.1*,
        **observation**=*None*,
        **transport_capacity**=*None*,
        **tlimit_erosion_deposition**=*None*,
        **sediment_concentration**=*None*,
        **sediment_flux**=*None*,
        **erosion_deposition**=*None*,
        **logfile**=*None*,
        **walkers_output**=*None*,
        **nwalkers**=*None*,
        **niterations**=*10*,
        **mintimestep**=*0.0*,
        **output_step**=*2*,
        **diffusion_coeff**=*0.8*,
        **random_seed**=*None*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_sim_sediment(elevation="name", water_depth="name", detachment_coeff="name", transport_coeff="name", shear_stress="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    **water_depth**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of water depth raster map [m]  
    **dx**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of x-derivatives raster map [m/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Computed from elevation map if not given  
    **dy**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of y-derivatives raster map [m/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Computed from elevation map if not given  
    **detachment_coeff**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of detachment capacity coefficient raster map [s/m]  
    **transport_coeff**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of transport capacity coefficient raster map [s]  
    **shear_stress**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of critical shear stress raster map [Pa]  
    **man**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Manning's n raster map  
    **man_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Manning's n unique value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **observation**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sampling locations vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **transport_capacity**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output transport capacity raster map [kg/ms]  
    **tlimit_erosion_deposition**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output transport limited erosion-deposition raster map [kg/m2s]  
    **sediment_concentration**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output sediment concentration raster map [particle/m3]  
    **sediment_flux**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output sediment flux raster map [kg/ms]  
    **erosion_deposition**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output erosion-deposition raster map [kg/m2s]  
    **logfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for sampling points output text file. For each observation vector point the time series of sediment transport is stored.  
    **walkers_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name of the output walkers vector points map  
    **nwalkers**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of walkers  
    **niterations**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time used for iterations [minutes]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **mintimestep**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum time step for the simulation [seconds]  
    &nbsp;&nbsp;&nbsp;&nbsp;A larger minimum time step substantially reduces processing time, but at the cost of accuracy  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **output_step**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time interval for creating output maps [minutes]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **diffusion_coeff**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Water diffusion constant  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.8*  
    **random_seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads which will be used for parallel computation.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generate random seed  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically generates random seed for random number generator (use when you don't want to provide the seed option)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **water_depth** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of water depth raster map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dx** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of x-derivatives raster map [m/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Computed from elevation map if not given  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dy** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of y-derivatives raster map [m/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Computed from elevation map if not given  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **detachment_coeff** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of detachment capacity coefficient raster map [s/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transport_coeff** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of transport capacity coefficient raster map [s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **shear_stress** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of critical shear stress raster map [Pa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **man** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Manning's n raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **man_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Manning's n unique value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **observation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sampling locations vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **transport_capacity** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output transport capacity raster map [kg/ms]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **tlimit_erosion_deposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output transport limited erosion-deposition raster map [kg/m2s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **sediment_concentration** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output sediment concentration raster map [particle/m3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **sediment_flux** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output sediment flux raster map [kg/ms]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **erosion_deposition** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output erosion-deposition raster map [kg/m2s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **logfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for sampling points output text file. For each observation vector point the time series of sediment transport is stored.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **walkers_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name of the output walkers vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **nwalkers** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of walkers  
    **niterations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time used for iterations [minutes]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **mintimestep** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum time step for the simulation [seconds]  
    &nbsp;&nbsp;&nbsp;&nbsp;A larger minimum time step substantially reduces processing time, but at the cost of accuracy  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **output_step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time interval for creating output maps [minutes]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **diffusion_coeff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Water diffusion constant  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.8*  
    **random_seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads which will be used for parallel computation.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Automatically generates random seed for random number generator (use when you don't want to provide the seed option)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **water_depth** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of water depth raster map [m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dx** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of x-derivatives raster map [m/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Computed from elevation map if not given  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dy** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of y-derivatives raster map [m/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Computed from elevation map if not given  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **detachment_coeff** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of detachment capacity coefficient raster map [s/m]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **transport_coeff** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of transport capacity coefficient raster map [s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **shear_stress** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of critical shear stress raster map [Pa]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **man** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of Manning's n raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **man_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Manning's n unique value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **observation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of sampling locations vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **transport_capacity** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output transport capacity raster map [kg/ms]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **tlimit_erosion_deposition** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output transport limited erosion-deposition raster map [kg/m2s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **sediment_concentration** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output sediment concentration raster map [particle/m3]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **sediment_flux** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output sediment flux raster map [kg/ms]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **erosion_deposition** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output erosion-deposition raster map [kg/m2s]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **logfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for sampling points output text file. For each observation vector point the time series of sediment transport is stored.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **walkers_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name of the output walkers vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **nwalkers** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of walkers  
    **niterations** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time used for iterations [minutes]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **mintimestep** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum time step for the simulation [seconds]  
    &nbsp;&nbsp;&nbsp;&nbsp;A larger minimum time step substantially reduces processing time, but at the cost of accuracy  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **output_step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time interval for creating output maps [minutes]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **diffusion_coeff** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Water diffusion constant  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.8*  
    **random_seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    &nbsp;&nbsp;&nbsp;&nbsp;The same seed can be used to obtain same results or random seed can be generated by other means.  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of threads which will be used for parallel computation.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generate random seed  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Automatically generates random seed for random number generator (use when you don't want to provide the seed option)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.sim.sediment* is a landscape scale, simulation model of soil erosion,
sediment transport and deposition caused by flowing water designed for
spatially variable terrain, soil, cover and rainfall excess conditions.
The soil erosion model is based on the theory used in the USDA WEPP
hillslope erosion model, but it has been generalized to 2D flow. The
solution is based on the concept of duality between fields and particles
and the underlying equations are solved by Green's function Monte Carlo
method, to provide robustness necessary for spatially variable
conditions and high resolutions (Mitas and Mitasova 1998). Key inputs of
the model include the following raster maps: elevation (*elevation*
\[m\]), flow gradient given by the first-order partial derivatives of
elevation field (*dx* and *dy* raster maps are optional), overland flow water depth
(*water_depth* \[m\]), detachment capacity coefficient
(*detachment_coeff* \[s/m\]), transport capacity coefficient
(*transport_coeff* \[s\]), critical shear stress (*shear_stress* \[Pa\])
and surface roughness coefficient called Manning's n (*man* raster map).
Partial derivatives can be computed by [v.surf.rst](v.surf.rst.md) or
[r.slope.aspect](r.slope.aspect.md) module. The data are automatically
converted from feet to metric system using database/projection
information, so the elevation always should be in meters. The water
depth file can be computed using [r.sim.water](r.sim.water.md) module.
Other parameters must be determined using field measurements or
reference literature (see suggested values in Notes and References).  

Output includes transport capacity raster map *transport_capacity* in
\[kg/ms\], transport capacity limited erosion/deposition raster map
*tlimit_erosion_deposition* \[kg/m^2s\] that are output
almost immediately and can be viewed while the simulation continues.
Sediment flow rate raster map *sediment_flux* \[kg/ms\], and net
erosion/deposition raster map \[kg/m^2s\] can take longer time
depending on time step and simulation time. Simulation time is
controlled by *niterations* \[minutes\] parameter. If the resulting
erosion/deposition map is noisy, higher number of walkers, given by
*nwalkers* should be used.  

Increasing the number of threads with **nprocs** does not really speed
up the simulation.

## REFERENCES

[Mitasova, H., Thaxton, C., Hofierka, J., McLaughlin, R., Moore, A.,
Mitas L.,
2004,](http://fatra.cnr.ncsu.edu/~hmitaso/gmslab/papers/II.6.8_Mitasova_044.pdf)
Path sampling method for modeling overland water flow, sediment
transport and short term terrain evolution in Open Source GIS. In: C.T.
Miller, M.W. Farthing, V.G. Gray, G.F. Pinder eds., Proceedings of the
XVth International Conference on Computational Methods in Water
Resources (CMWR XV), June 13-17 2004, Chapel Hill, NC, USA, Elsevier,
pp. 1479-1490.

[Mitasova H, Mitas, L., 2000, Modeling spatial processes in multiscale
framework: exploring duality between particles and
fields,](http://fatra.cnr.ncsu.edu/~hmitaso/gmslab/gisc00/duality.html)
plenary talk at GIScience2000 conference, Savannah, GA.

Mitas, L., and Mitasova, H., 1998, Distributed soil erosion simulation
for effective erosion prevention. Water Resources Research, 34(3),
505-516.

[Mitasova, H., Mitas, L., 2001, Multiscale soil erosion simulations for
land use
management,](http://fatra.cnr.ncsu.edu/~hmitaso/gmslab/papers/LLEmiterev1.pdf)
In: Landscape erosion and landscape evolution modeling, Harmon R. and
Doe W. eds., Kluwer Academic/Plenum Publishers, pp. 321-347.

[Neteler, M. and Mitasova, H., 2008, Open Source GIS: A GRASS GIS
Approach. Third Edition.](https://grassbook.org) The International
Series in Engineering and Computer Science: Volume 773. Springer New
York Inc, p. 406.

## SEE ALSO

[v.surf.rst](v.surf.rst.md), [r.slope.aspect](r.slope.aspect.md),
[r.sim.water](r.sim.water.md)

## AUTHORS

Helena Mitasova, Lubos Mitas  
North Carolina State University  
<hmitaso@unity.ncsu.edu>  
  
Jaroslav Hofierka  
GeoModel, s.r.o. Bratislava, Slovakia  

[hofierka@geomodel.sk](mailto:hofi@geomodel.sk)

Chris Thaxton  
North Carolina State University  
<csthaxto@unity.ncsu.edu>  

<csthaxto@unity.ncsu.edu>

## SOURCE CODE

Available at: [r.sim.sediment source code](https://github.com/OSGeo/grass/tree/main/raster/r.sim/r.sim.sediment)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.sim/r.sim.sediment))  
Latest change: Wednesday Feb 04 10:35:18 2026 in commit [017db7e](https://github.com/OSGeo/grass/commit/017db7e1df9b84130ca5b0549ecfed07a848daa8)
