---
name: r.surf.idw
description: Provides surface interpolation from raster point data by Inverse Distance Squared Weighting.
keywords: [ raster, surface, interpolation, IDW ]
---

# r.surf.idw

Provides surface interpolation from raster point data by Inverse Distance Squared Weighting.

=== "Command line"

    **r.surf.idw**
    [**-e**]
    **input**=*name*
    **output**=*name*
    [**npoints**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.surf.idw input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.surf.idw***",
        **input**,
        **output**,
        **npoints**=*12*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.surf.idw", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_surf_idw*(**input**,
        **output**,
        **npoints**=*12*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_surf_idw(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **npoints**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output is the interpolation error  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **npoints** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output is the interpolation error  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **npoints** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output is the interpolation error  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.surf.idw* fills a grid cell (raster) matrix with interpolated values
generated from input raster data points. It uses a numerical
approximation technique based on distance squared weighting of the
values of nearest data points. The number of nearest data points used to
determined the interpolated value of a cell can be specified by the user
(default: 12 nearest data points).

If there is a current working mask, it applies to the output raster map.
Only those cells falling within the mask will be assigned interpolated
values. The search procedure for the selection of nearest neighboring
points will consider all input data, without regard to the mask. The
**-e** flag is the error analysis option that interpolates values only
for those cells of the input raster map which have non-zero values and
outputs the difference (see [NOTES](#surface-generation-error-analysis) below).

The **npoints** parameter defines the number of nearest data points used
to determine the interpolated value of an output raster cell.

## NOTES

*r.surf.idw* is a surface generation utility which uses inverse distance
squared weighting (as described in *Applied Geostatistics* by E. H.
Isaaks and R. M. Srivastava, Oxford University Press, 1989) to assign
interpolated values. The implementation includes a customized data
structure somewhat akin to a sparse matrix which enhances the efficiency
with which nearest data points are selected. For latitude/longitude
projections, distances are calculated from point to point along a
geodesic.

Unlike
*[r.surf.idw2](https://grass.osgeo.org/grass8/manuals/addons/r.surf.idw2.html)*
(addon), which processes all input data points in each interpolation
cycle, *r.surf.idw* attempts to minimize the number of input data for
which distances must be calculated. Execution speed is therefore a
function of the search effort, and does not increase appreciably with
the number of input data points.

*r.surf.idw* will generally outperform *r.surf.idw2* except when the
input data layer contains few non-zero data, i.e. when the cost of the
search exceeds the cost of the additional distance calculations
performed by *r.surf.idw2*. The relative performance of these utilities
will depend on the comparative speed of boolean, integer and floating
point operations on a particular platform.

Worst case search performance by *r.surf.idw* occurs when the
interpolated cell is located outside of the region in which input data
are distributed. It therefore behooves the user to employ a mask when
geographic region boundaries include large areas outside the general
extent of the input data.

The degree of smoothing produced by the interpolation will increase
relative to the number of nearest data points considered. The utility
may be used with regularly or irregularly spaced input data. However,
the output result for the former may include unacceptable
nonconformities in the surface pattern.

### Surface-generation error analysis

The **-e** flag option provides a standard surface-generation error
analysis facility. It produces an output raster map of the difference of
interpolated values minus input values for those cells whose input data
are non-zero. For each interpolation cycle, the known value of the cell
under consideration is ignored, and the remaining input values are used
to interpolate a result. The output raster map may be compared to the
input raster map to analyze the distribution of interpolation error.
This procedure may be helpful in choosing the number of nearest
neighbors considered for surface generation.

## KNOWN ISSUES

Module *r.surf.idw* works only for integer (CELL) raster maps.

## SEE ALSO

*[r.surf.contour](r.surf.contour.md), [r.surf.gauss](r.surf.gauss.md),
[r.surf.fractal](r.surf.fractal.md), [r.surf.random](r.surf.random.md),
[v.surf.idw](v.surf.idw.md), [v.surf.rst](v.surf.rst.md)*

Overview: [Interpolation and
Resampling](https://grasswiki.osgeo.org/wiki/Interpolation) in GRASS

## AUTHOR

Greg Koerper  
Global Climate Research Project  
U.S. EPA Environmental Research Laboratory  
200 S.W. 35th Street, JSB  
Corvallis, OR 97333

## SOURCE CODE

Available at: [r.surf.idw source code](https://github.com/OSGeo/grass/tree/main/raster/r.surf.idw)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.surf.idw))  
Latest change: Tuesday Dec 23 23:30:51 2025 in commit [2550be3](https://github.com/OSGeo/grass/commit/2550be39b3524cf105ce856cb27ac8efaeef1bfb)
